"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var TokenCheckStatus_1 = require("./TokenCheckStatus");
/**
 * Defines the common functionality for the various spelling managers.
 */
var SpellingManager = /** @class */ (function () {
    function SpellingManager() {
    }
    /**
     * Adds a word to the spelling manager.
     */
    SpellingManager.prototype.add = function (token) {
        // We don't have default functionality for adding.
    };
    /**
     * Check to see if a token is correct.
     */
    SpellingManager.prototype.isCorrect = function (token) {
        return this.check(token) === TokenCheckStatus_1.TokenCheckStatus.Correct;
    };
    /**
     * Checks the token to determine if it is correct or incorrect.
     */
    SpellingManager.prototype.check = function (token) {
        return TokenCheckStatus_1.TokenCheckStatus.Unknown;
    };
    /**
     * Gives a suggestion for a token, sorted by likelyhood with the first item
     * in the resulting array being the most likely.
     */
    SpellingManager.prototype.suggest = function (token) {
        return [];
    };
    return SpellingManager;
}());
exports.SpellingManager = SpellingManager;
//# sourceMappingURL=SpellingManager.js.map