(function() {
  var CompositeDisposable, MarkdownPreviewView, fs, isMarkdownPreviewView, renderer,
    indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  fs = require('fs-plus');

  CompositeDisposable = require('atom').CompositeDisposable;

  MarkdownPreviewView = null;

  renderer = null;

  isMarkdownPreviewView = function(object) {
    if (MarkdownPreviewView == null) {
      MarkdownPreviewView = require('./markdown-preview-view');
    }
    return object instanceof MarkdownPreviewView;
  };

  module.exports = {
    activate: function() {
      var extension, i, len, previewFile, ref;
      this.disposables = new CompositeDisposable();
      this.commandSubscriptions = new CompositeDisposable();
      this.disposables.add(atom.config.observe('markdown-preview.grammars', (function(_this) {
        return function(grammars) {
          var grammar, i, len;
          _this.commandSubscriptions.dispose();
          _this.commandSubscriptions = new CompositeDisposable();
          if (grammars == null) {
            grammars = [];
          }
          grammars = grammars.map(function(grammar) {
            return grammar.replace(/\./g, ' ');
          });
          for (i = 0, len = grammars.length; i < len; i++) {
            grammar = grammars[i];
            _this.commandSubscriptions.add(atom.commands.add("atom-text-editor[data-grammar='" + grammar + "']", {
              'markdown-preview:toggle': function() {
                return _this.toggle();
              },
              'markdown-preview:copy-html': {
                displayName: 'Markdown Preview: Copy HTML',
                didDispatch: function() {
                  return _this.copyHTML();
                }
              },
              'markdown-preview:save-as-html': {
                displayName: 'Markdown Preview: Save as HTML',
                didDispatch: function() {
                  return _this.saveAsHTML();
                }
              },
              'markdown-preview:toggle-break-on-single-newline': function() {
                var keyPath;
                keyPath = 'markdown-preview.breakOnSingleNewline';
                return atom.config.set(keyPath, !atom.config.get(keyPath));
              },
              'markdown-preview:toggle-github-style': function() {
                var keyPath;
                keyPath = 'markdown-preview.useGitHubStyle';
                return atom.config.set(keyPath, !atom.config.get(keyPath));
              }
            }));
          }
        };
      })(this)));
      previewFile = this.previewFile.bind(this);
      ref = ['markdown', 'md', 'mdown', 'mkd', 'mkdown', 'ron', 'txt'];
      for (i = 0, len = ref.length; i < len; i++) {
        extension = ref[i];
        this.disposables.add(atom.commands.add(".tree-view .file .name[data-name$=\\." + extension + "]", 'markdown-preview:preview-file', previewFile));
      }
      return this.disposables.add(atom.workspace.addOpener((function(_this) {
        return function(uriToOpen) {
          var path, protocol, ref1;
          ref1 = uriToOpen.split('://'), protocol = ref1[0], path = ref1[1];
          if (protocol !== 'markdown-preview') {
            return;
          }
          try {
            path = decodeURI(path);
          } catch (error1) {
            return;
          }
          if (path.startsWith('editor/')) {
            return _this.createMarkdownPreviewView({
              editorId: path.substring(7)
            });
          } else {
            return _this.createMarkdownPreviewView({
              filePath: path
            });
          }
        };
      })(this)));
    },
    deactivate: function() {
      this.disposables.dispose();
      return this.commandSubscriptions.dispose();
    },
    createMarkdownPreviewView: function(state) {
      if (state.editorId || fs.isFileSync(state.filePath)) {
        if (MarkdownPreviewView == null) {
          MarkdownPreviewView = require('./markdown-preview-view');
        }
        return new MarkdownPreviewView(state);
      }
    },
    toggle: function() {
      var editor, grammars, ref, ref1;
      if (isMarkdownPreviewView(atom.workspace.getActivePaneItem())) {
        atom.workspace.destroyActivePaneItem();
        return;
      }
      editor = atom.workspace.getActiveTextEditor();
      if (editor == null) {
        return;
      }
      grammars = (ref = atom.config.get('markdown-preview.grammars')) != null ? ref : [];
      if (ref1 = editor.getGrammar().scopeName, indexOf.call(grammars, ref1) < 0) {
        return;
      }
      if (!this.removePreviewForEditor(editor)) {
        return this.addPreviewForEditor(editor);
      }
    },
    uriForEditor: function(editor) {
      return "markdown-preview://editor/" + editor.id;
    },
    removePreviewForEditor: function(editor) {
      var previewPane, uri;
      uri = this.uriForEditor(editor);
      previewPane = atom.workspace.paneForURI(uri);
      if (previewPane != null) {
        previewPane.destroyItem(previewPane.itemForURI(uri));
        return true;
      } else {
        return false;
      }
    },
    addPreviewForEditor: function(editor) {
      var options, previousActivePane, uri;
      uri = this.uriForEditor(editor);
      previousActivePane = atom.workspace.getActivePane();
      options = {
        searchAllPanes: true
      };
      if (atom.config.get('markdown-preview.openPreviewInSplitPane')) {
        options.split = 'right';
      }
      return atom.workspace.open(uri, options).then(function(markdownPreviewView) {
        if (isMarkdownPreviewView(markdownPreviewView)) {
          return previousActivePane.activate();
        }
      });
    },
    previewFile: function(arg) {
      var editor, filePath, i, len, ref, target;
      target = arg.target;
      filePath = target.dataset.path;
      if (!filePath) {
        return;
      }
      ref = atom.workspace.getTextEditors();
      for (i = 0, len = ref.length; i < len; i++) {
        editor = ref[i];
        if (!(editor.getPath() === filePath)) {
          continue;
        }
        this.addPreviewForEditor(editor);
        return;
      }
      return atom.workspace.open("markdown-preview://" + (encodeURI(filePath)), {
        searchAllPanes: true
      });
    },
    copyHTML: function() {
      var editor, text;
      editor = atom.workspace.getActiveTextEditor();
      if (editor == null) {
        return;
      }
      if (renderer == null) {
        renderer = require('./renderer');
      }
      text = editor.getSelectedText() || editor.getText();
      return new Promise(function(resolve) {
        return renderer.toHTML(text, editor.getPath(), editor.getGrammar(), function(error, html) {
          if (error) {
            return console.warn('Copying Markdown as HTML failed', error);
          } else {
            atom.clipboard.write(html);
            return resolve();
          }
        });
      });
    },
    saveAsHTML: function() {
      var activePaneItem, editor, grammars, markdownPreviewPane, markdownPreviewPaneItem, ref, ref1, uri;
      activePaneItem = atom.workspace.getActivePaneItem();
      if (isMarkdownPreviewView(activePaneItem)) {
        atom.workspace.getActivePane().saveItemAs(activePaneItem);
        return;
      }
      editor = atom.workspace.getActiveTextEditor();
      if (editor == null) {
        return;
      }
      grammars = (ref = atom.config.get('markdown-preview.grammars')) != null ? ref : [];
      if (ref1 = editor.getGrammar().scopeName, indexOf.call(grammars, ref1) < 0) {
        return;
      }
      uri = this.uriForEditor(editor);
      markdownPreviewPane = atom.workspace.paneForURI(uri);
      markdownPreviewPaneItem = markdownPreviewPane != null ? markdownPreviewPane.itemForURI(uri) : void 0;
      if (isMarkdownPreviewView(markdownPreviewPaneItem)) {
        return markdownPreviewPane.saveItemAs(markdownPreviewPaneItem);
      }
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
