Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

exports.activate = activate;
exports.deactivate = deactivate;
exports.consumeStatusBar = consumeStatusBar;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var _statusBarItem = require('./status-bar-item');

var _statusBarItem2 = _interopRequireDefault(_statusBarItem);

var _helpers = require('./helpers');

var _helpers2 = _interopRequireDefault(_helpers);

'use babel';

var LineEndingRegExp = /\r\n|\n/g;
var LFRegExp = /(\A|[^\r])\n/g;
var CRLFRegExp = /\r\n/g;

var disposables = null;
var modalPanel = null;
var lineEndingListView = null;

function activate() {
  disposables = new _atom.CompositeDisposable();

  disposables.add(atom.commands.add('atom-text-editor', {
    'line-ending-selector:show': function lineEndingSelectorShow(event) {
      if (!modalPanel) {
        lineEndingListView = new _atomSelectList2['default']({
          items: [{ name: 'LF', value: '\n' }, { name: 'CRLF', value: '\r\n' }],
          filterKeyForItem: function filterKeyForItem(lineEnding) {
            return lineEnding.name;
          },
          didConfirmSelection: function didConfirmSelection(lineEnding) {
            setLineEnding(atom.workspace.getActiveTextEditor(), lineEnding.value);
            modalPanel.hide();
          },
          didCancelSelection: function didCancelSelection() {
            modalPanel.hide();
          },
          elementForItem: function elementForItem(lineEnding) {
            var element = document.createElement('li');
            element.textContent = lineEnding.name;
            return element;
          }
        });
        modalPanel = atom.workspace.addModalPanel({ item: lineEndingListView });
        disposables.add(new _atom.Disposable(function () {
          lineEndingListView.destroy();
          modalPanel.destroy();
          modalPanel = null;
        }));
      }

      lineEndingListView.reset();
      modalPanel.show();
      lineEndingListView.focus();
    },

    'line-ending-selector:convert-to-LF': function lineEndingSelectorConvertToLF(event) {
      var editorElement = event.target.closest('atom-text-editor');
      setLineEnding(editorElement.getModel(), '\n');
    },

    'line-ending-selector:convert-to-CRLF': function lineEndingSelectorConvertToCRLF(event) {
      var editorElement = event.target.closest('atom-text-editor');
      setLineEnding(editorElement.getModel(), '\r\n');
    }
  }));
}

function deactivate() {
  disposables.dispose();
}

function consumeStatusBar(statusBar) {
  var statusBarItem = new _statusBarItem2['default']();
  var currentBufferDisposable = null;
  var tooltipDisposable = null;

  var updateTile = _underscorePlus2['default'].debounce(function (buffer) {
    getLineEndings(buffer).then(function (lineEndings) {
      if (lineEndings.size === 0) {
        var defaultLineEnding = getDefaultLineEnding();
        buffer.setPreferredLineEnding(defaultLineEnding);
        lineEndings = new Set().add(defaultLineEnding);
      }
      statusBarItem.setLineEndings(lineEndings);
    });
  }, 0);

  disposables.add(atom.workspace.observeActiveTextEditor(function (editor) {
    if (currentBufferDisposable) currentBufferDisposable.dispose();

    if (editor && editor.getBuffer) {
      (function () {
        var buffer = editor.getBuffer();
        updateTile(buffer);
        currentBufferDisposable = buffer.onDidChange(function (_ref) {
          var oldText = _ref.oldText;
          var newText = _ref.newText;

          if (!statusBarItem.hasLineEnding('\n')) {
            if (newText.indexOf('\n') >= 0) {
              updateTile(buffer);
            }
          } else if (!statusBarItem.hasLineEnding('\r\n')) {
            if (newText.indexOf('\r\n') >= 0) {
              updateTile(buffer);
            }
          } else if (oldText.indexOf('\n')) {
            updateTile(buffer);
          }
        });
      })();
    } else {
      statusBarItem.setLineEndings(new Set());
      currentBufferDisposable = null;
    }

    if (tooltipDisposable) {
      disposables.remove(tooltipDisposable);
      tooltipDisposable.dispose();
    }
    tooltipDisposable = atom.tooltips.add(statusBarItem.element, {
      title: function title() {
        return 'File uses ' + statusBarItem.description() + ' line endings';
      }
    });
    disposables.add(tooltipDisposable);
  }));

  disposables.add(new _atom.Disposable(function () {
    if (currentBufferDisposable) currentBufferDisposable.dispose();
  }));

  statusBarItem.onClick(function () {
    var editor = atom.workspace.getActiveTextEditor();
    atom.commands.dispatch(atom.views.getView(editor), 'line-ending-selector:show');
  });

  var tile = statusBar.addRightTile({ item: statusBarItem, priority: 200 });
  disposables.add(new _atom.Disposable(function () {
    return tile.destroy();
  }));
}

function getDefaultLineEnding() {
  switch (atom.config.get('line-ending-selector.defaultLineEnding')) {
    case 'LF':
      return '\n';
    case 'CRLF':
      return '\r\n';
    case 'OS Default':
    default:
      return _helpers2['default'].getProcessPlatform() === 'win32' ? '\r\n' : '\n';
  }
}

function getLineEndings(buffer) {
  if (typeof buffer.find === 'function') {
    return Promise.all([buffer.find(LFRegExp), buffer.find(CRLFRegExp)]).then(function (_ref2) {
      var _ref22 = _slicedToArray(_ref2, 2);

      var hasLF = _ref22[0];
      var hasCRLF = _ref22[1];

      var result = new Set();
      if (hasLF) result.add('\n');
      if (hasCRLF) result.add('\r\n');
      return result;
    });
  } else {
    return new Promise(function (resolve) {
      var result = new Set();
      for (var i = 0; i < buffer.getLineCount() - 1; i++) {
        result.add(buffer.lineEndingForRow(i));
      }
      resolve(result);
    });
  }
}

function setLineEnding(item, lineEnding) {
  if (item && item.getBuffer) {
    var buffer = item.getBuffer();
    buffer.setPreferredLineEnding(lineEnding);
    buffer.setText(buffer.getText().replace(LineEndingRegExp, lineEnding));
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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