"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BareCrossReferencedEventView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../../atom/octicon"));

var _issueishBadge = _interopRequireDefault(require("../../views/issueish-badge"));

var _issueishLink = _interopRequireDefault(require("../../views/issueish-link"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareCrossReferencedEventView extends _react.default.Component {
  render() {
    const xref = this.props.item;
    const repo = xref.source.repository;
    const repoLabel = `${repo.owner.login}/${repo.name}`;
    return _react.default.createElement("div", {
      className: "cross-referenced-event"
    }, _react.default.createElement("div", {
      className: "cross-referenced-event-label"
    }, _react.default.createElement("span", {
      className: "cross-referenced-event-label-title"
    }, xref.source.title), _react.default.createElement(_issueishLink.default, {
      url: xref.source.url,
      className: "cross-referenced-event-label-number"
    }, this.getIssueishNumberDisplay(xref))), repo.isPrivate ? _react.default.createElement("div", {
      className: "cross-referenced-event-private"
    }, _react.default.createElement(_octicon.default, {
      icon: "lock",
      title: `Only people who can see ${repoLabel} will see this reference.`
    })) : '', _react.default.createElement("div", {
      className: "cross-referenced-event-state"
    }, _react.default.createElement(_issueishBadge.default, {
      type: xref.source.__typename,
      state: xref.source.issueState || xref.source.prState
    })));
  }

  getIssueishNumberDisplay(xref) {
    const {
      source
    } = xref;

    if (!xref.isCrossRepository) {
      return `#${source.number}`;
    } else {
      const {
        repository
      } = source;
      return `${repository.owner.login}/${repository.name}#${source.number}`;
    }
  }

}

exports.BareCrossReferencedEventView = BareCrossReferencedEventView;

_defineProperty(BareCrossReferencedEventView, "propTypes", {
  item: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    isCrossRepository: _propTypes.default.bool.isRequired,
    source: _propTypes.default.shape({
      __typename: _propTypes.default.oneOf(['Issue', 'PullRequest']).isRequired,
      number: _propTypes.default.number.isRequired,
      title: _propTypes.default.string.isRequired,
      url: _propTypes.default.string.isRequired,
      issueState: _propTypes.default.oneOf(['OPEN', 'CLOSED']),
      prState: _propTypes.default.oneOf(['OPEN', 'CLOSED', 'MERGED']),
      repository: _propTypes.default.shape({
        name: _propTypes.default.string.isRequired,
        isPrivate: _propTypes.default.bool.isRequired,
        owner: _propTypes.default.shape({
          login: _propTypes.default.string.isRequired
        }).isRequired
      }).isRequired
    }).isRequired
  }).isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareCrossReferencedEventView, {
  item: function () {
    const node = require("./__generated__/crossReferencedEventView_item.graphql");

    if (node.hash && node.hash !== "b90b8c9f0acee56516e7413263cf7f51") {
      console.error("The definition of 'crossReferencedEventView_item' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/crossReferencedEventView_item.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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