"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BareIssueishListController = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _issueishListView = _interopRequireDefault(require("../views/issueish-list-view"));

var _issueish = _interopRequireDefault(require("../models/issueish"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const StatePropType = _propTypes.default.oneOf(['EXPECTED', 'PENDING', 'SUCCESS', 'ERROR', 'FAILURE']);

class BareIssueishListController extends _react.default.Component {
  constructor(props) {
    super(props);
    this.state = {};
  }

  static getDerivedStateFromProps(props, state) {
    if (props.results === null) {
      return {
        lastResults: null,
        issueishes: []
      };
    }

    if (props.results !== state.lastResults) {
      return {
        lastResults: props.results,
        issueishes: props.results.map(node => new _issueish.default(node)).filter(props.resultFilter)
      };
    }

    return null;
  }

  render() {
    return _react.default.createElement(_issueishListView.default, {
      title: this.props.title,
      isLoading: this.props.isLoading,
      total: this.props.total,
      issueishes: this.state.issueishes,
      error: this.props.error,
      onIssueishClick: this.props.onOpenIssueish,
      onMoreClick: this.props.onOpenMore,
      emptyComponent: this.props.emptyComponent
    });
  }

}

exports.BareIssueishListController = BareIssueishListController;

_defineProperty(BareIssueishListController, "propTypes", {
  results: _propTypes.default.arrayOf(_propTypes.default.shape({
    number: _propTypes.default.number.isRequired,
    title: _propTypes.default.string.isRequired,
    url: _propTypes.default.string.isRequired,
    author: _propTypes.default.shape({
      login: _propTypes.default.string.isRequired,
      avatarUrl: _propTypes.default.string.isRequired
    }).isRequired,
    createdAt: _propTypes.default.string.isRequired,
    headRefName: _propTypes.default.string.isRequired,
    repository: _propTypes.default.shape({
      id: _propTypes.default.string.isRequired
    }).isRequired,
    commits: _propTypes.default.shape({
      nodes: _propTypes.default.arrayOf(_propTypes.default.shape({
        commit: _propTypes.default.shape({
          status: _propTypes.default.shape({
            contexts: _propTypes.default.arrayOf(_propTypes.default.shape({
              state: StatePropType.isRequired
            }).isRequired).isRequired
          })
        })
      }))
    })
  })),
  total: _propTypes.default.number.isRequired,
  isLoading: _propTypes.default.bool.isRequired,
  title: _propTypes.default.string.isRequired,
  error: _propTypes.default.object,
  resultFilter: _propTypes.default.func,
  onOpenIssueish: _propTypes.default.func.isRequired,
  onOpenMore: _propTypes.default.func,
  emptyComponent: _propTypes.default.func
});

_defineProperty(BareIssueishListController, "defaultProps", {
  results: [],
  total: 0,
  resultFilter: () => true
});

var _default = (0, _reactRelay.createFragmentContainer)(BareIssueishListController, {
  results: function () {
    const node = require("./__generated__/issueishListController_results.graphql");

    if (node.hash && node.hash !== "5de45944d2555aea09c239d314a9fefd") {
      console.error("The definition of 'issueishListController_results' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/issueishListController_results.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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