"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Command = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class Commands extends _react.default.Component {
  render() {
    const {
      registry,
      target
    } = this.props;
    return _react.default.createElement("div", null, _react.default.Children.map(this.props.children, child => {
      return child ? _react.default.cloneElement(child, {
        registry,
        target
      }) : null;
    }));
  }

}

exports.default = Commands;

_defineProperty(Commands, "propTypes", {
  registry: _propTypes.default.object.isRequired,
  target: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes2.DOMNodePropType, _propTypes2.RefHolderPropType]).isRequired,
  children: _propTypes.default.oneOfType([_propTypes.default.element, _propTypes.default.arrayOf(_propTypes.default.element)]).isRequired
});

class Command extends _react.default.Component {
  constructor(props, context) {
    super(props, context);
    this.subTarget = new _eventKit.Disposable();
    this.subCommand = new _eventKit.Disposable();
  }

  componentDidMount() {
    this.observeTarget(this.props);
  }

  componentWillReceiveProps(newProps) {
    if (['registry', 'target', 'command', 'callback'].some(p => newProps[p] !== this.props[p])) {
      this.observeTarget(newProps);
    }
  }

  componentWillUnmount() {
    this.subTarget.dispose();
    this.subCommand.dispose();
  }

  observeTarget(props) {
    this.subTarget.dispose();
    this.subTarget = _refHolder.default.on(props.target).observe(t => this.registerCommand(t, props));
  }

  registerCommand(target, {
    registry,
    command,
    callback
  }) {
    this.subCommand.dispose();
    this.subCommand = registry.add(target, command, callback);
  }

  render() {
    return null;
  }

}

exports.Command = Command;

_defineProperty(Command, "propTypes", {
  registry: _propTypes.default.object,
  target: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes2.DOMNodePropType, _propTypes2.RefHolderPropType]),
  command: _propTypes.default.string.isRequired,
  callback: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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