/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.jdbc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.jdbc.JdbcResultsDiff;
import org.netbeans.lib.profiler.results.jdbc.JdbcResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.jdbc.JDBCTreeTableView;
import org.netbeans.lib.profiler.ui.jdbc.JDBCView;
import org.netbeans.lib.profiler.ui.results.DataView;
import org.netbeans.lib.profiler.ui.swing.FilterUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;

public abstract class LiveJDBCView
extends JPanel {
    private JdbcResultsSnapshot snapshot;
    private JdbcResultsSnapshot refSnapshot;
    private DataView lastFocused;
    private JDBCTreeTableView jdbcCallsView;
    private long lastupdate;
    private volatile boolean refreshIsRunning;
    private ExecutorService executor;

    public LiveJDBCView(Set<ClientUtils.SourceCodeSelection> set) {
        this.initUI(set);
        this.registerActions();
    }

    public void setView(boolean bl, boolean bl2, boolean bl3) {
        this.jdbcCallsView.setVisible(bl);
    }

    public boolean isRefreshRunning() {
        return this.refreshIsRunning;
    }

    public long getLastUpdate() {
        return this.lastupdate;
    }

    public void setData(final JdbcResultsSnapshot jdbcResultsSnapshot) {
        if (this.refreshIsRunning) {
            return;
        }
        this.refreshIsRunning = true;
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                LiveJDBCView.this.snapshot = jdbcResultsSnapshot;
                LiveJDBCView.this.setData();
            }
        });
    }

    private void setData() {
        if (this.snapshot == null) {
            this.resetData();
            this.refreshIsRunning = false;
        } else {
            this.getExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    final JdbcResultsSnapshot jdbcResultsSnapshot = LiveJDBCView.this.refSnapshot == null ? LiveJDBCView.this.snapshot : LiveJDBCView.this.refSnapshot.createDiff(LiveJDBCView.this.snapshot);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                boolean bl = jdbcResultsSnapshot instanceof JdbcResultsDiff;
                                LiveJDBCView.this.jdbcCallsView.setData(jdbcResultsSnapshot, null, -1, null, false, false, bl);
                            }
                            finally {
                                LiveJDBCView.this.refreshIsRunning = false;
                                LiveJDBCView.this.lastupdate = System.currentTimeMillis();
                            }
                        }
                    });
                }
            });
        }
    }

    public boolean setDiffView(final boolean bl) {
        if (this.snapshot == null) {
            return false;
        }
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                LiveJDBCView.this.refSnapshot = bl ? LiveJDBCView.this.snapshot : null;
                LiveJDBCView.this.setData();
            }
        });
        return true;
    }

    public void resetData() {
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                LiveJDBCView.this.jdbcCallsView.resetData();
                LiveJDBCView.this.snapshot = null;
                LiveJDBCView.this.refSnapshot = null;
            }
        });
    }

    public void showSelectionColumn() {
        this.jdbcCallsView.showSelectionColumn();
    }

    public void refreshSelection() {
        this.jdbcCallsView.refreshSelection();
    }

    public void cleanup() {
    }

    protected abstract ProfilerClient getProfilerClient();

    protected boolean profileMethodSupported() {
        return true;
    }

    protected boolean profileClassSupported() {
        return true;
    }

    protected abstract boolean showSourceSupported();

    protected abstract void showSource(ClientUtils.SourceCodeSelection var1);

    protected abstract void showSQLQuery(String var1, String var2);

    protected abstract void selectForProfiling(ClientUtils.SourceCodeSelection var1);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    private void profileMethod(ClientUtils.SourceCodeSelection sourceCodeSelection) {
        this.selectForProfiling(sourceCodeSelection);
    }

    private void profileClass(ClientUtils.SourceCodeSelection sourceCodeSelection) {
        this.selectForProfiling(new ClientUtils.SourceCodeSelection(sourceCodeSelection.getClassName(), "*", null));
    }

    private void initUI(Set<ClientUtils.SourceCodeSelection> set) {
        this.setLayout(new BorderLayout(0, 0));
        this.jdbcCallsView = new JDBCTreeTableView(set, false){

            @Override
            protected void installDefaultAction() {
                this.getResultsComponent().setDefaultAction(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n;
                        ProfilerTable profilerTable = this.getResultsComponent();
                        PresoObjAllocCCTNode presoObjAllocCCTNode = (PresoObjAllocCCTNode)profilerTable.getValueForRow(n = profilerTable.getSelectedRow());
                        if (JDBCTreeTableView.isSQL(presoObjAllocCCTNode)) {
                            LiveJDBCView.this.showQueryImpl(presoObjAllocCCTNode);
                        } else {
                            ClientUtils.SourceCodeSelection sourceCodeSelection = this.getUserValueForRow(n);
                            if (sourceCodeSelection != null) {
                                this.performDefaultAction(sourceCodeSelection);
                            }
                        }
                    }
                });
            }

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection sourceCodeSelection) {
                if (LiveJDBCView.this.showSourceSupported()) {
                    LiveJDBCView.this.showSource(sourceCodeSelection);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
                LiveJDBCView.this.populatePopup(LiveJDBCView.this.jdbcCallsView, jPopupMenu, object, sourceCodeSelection);
            }

            @Override
            protected void popupShowing() {
                LiveJDBCView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                LiveJDBCView.this.popupHidden();
            }

            @Override
            protected boolean hasBottomFilterFindMargin() {
                return true;
            }
        };
        this.jdbcCallsView.notifyOnFocus(new Runnable(){

            @Override
            public void run() {
                LiveJDBCView.this.lastFocused = LiveJDBCView.this.jdbcCallsView;
            }
        });
        this.add((Component)this.jdbcCallsView, "Center");
    }

    private void registerActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("filter-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataView dataView = LiveJDBCView.this.getLastFocused();
                if (dataView != null) {
                    dataView.activateFilter();
                }
            }
        });
        actionMap.put("find-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataView dataView = LiveJDBCView.this.getLastFocused();
                if (dataView != null) {
                    dataView.activateSearch();
                }
            }
        });
    }

    private DataView getLastFocused() {
        if (this.lastFocused != null && !this.lastFocused.isShowing()) {
            this.lastFocused = null;
        }
        if (this.lastFocused == null && this.jdbcCallsView.isShowing()) {
            this.lastFocused = this.jdbcCallsView;
        }
        return this.lastFocused;
    }

    private void showQueryImpl(PresoObjAllocCCTNode presoObjAllocCCTNode) {
        this.showSQLQuery(presoObjAllocCCTNode.getNodeName(), ((JDBCTreeTableView.SQLQueryNode)presoObjAllocCCTNode).htmlName);
    }

    private void populatePopup(final DataView dataView, JPopupMenu jPopupMenu, final Object object, final ClientUtils.SourceCodeSelection sourceCodeSelection) {
        JMenuItem[] jMenuItemArray;
        final PresoObjAllocCCTNode presoObjAllocCCTNode = (PresoObjAllocCCTNode)object;
        if (JDBCTreeTableView.isSQL(presoObjAllocCCTNode)) {
            jPopupMenu.add(new JMenuItem(JDBCView.ACTION_VIEWSQLQUERY){
                {
                    super(string);
                    this.setFont(this.getFont().deriveFont(1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    LiveJDBCView.this.showQueryImpl((JDBCTreeTableView.SQLQueryNode)((Object)object));
                }
            });
            jPopupMenu.addSeparator();
        } else if (this.showSourceSupported()) {
            jPopupMenu.add(new JMenuItem(JDBCView.ACTION_GOTOSOURCE){
                {
                    super(string);
                    this.setEnabled(sourceCodeSelection != null);
                    this.setFont(this.getFont().deriveFont(1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    LiveJDBCView.this.showSource(sourceCodeSelection);
                }
            });
            jPopupMenu.addSeparator();
        }
        if (this.profileMethodSupported()) {
            jPopupMenu.add(new JMenuItem(JDBCView.ACTION_PROFILE_METHOD){
                {
                    super(string);
                    this.setEnabled(sourceCodeSelection != null && JDBCTreeTableView.isSelectable(presoObjAllocCCTNode));
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    LiveJDBCView.this.profileMethod(sourceCodeSelection);
                }
            });
        }
        if (this.profileClassSupported()) {
            jPopupMenu.add(new JMenuItem(JDBCView.ACTION_PROFILE_CLASS){
                {
                    super(string);
                    this.setEnabled(sourceCodeSelection != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    LiveJDBCView.this.profileClass(sourceCodeSelection);
                }
            });
        }
        if (this.profileMethodSupported() || this.profileClassSupported()) {
            jPopupMenu.addSeparator();
        }
        if ((jMenuItemArray = dataView.createCustomMenuItems(this, object, sourceCodeSelection)) != null) {
            for (JMenuItem jMenuItem : jMenuItemArray) {
                jPopupMenu.add(jMenuItem);
            }
            jPopupMenu.addSeparator();
        }
        this.customizeNodePopup(dataView, jPopupMenu, object, sourceCodeSelection);
        final ProfilerTreeTable profilerTreeTable = (ProfilerTreeTable)this.jdbcCallsView.getResultsComponent();
        JMenu jMenu = new JMenu(JDBCView.EXPAND_MENU);
        jPopupMenu.add(jMenu);
        jMenu.add(new JMenuItem(JDBCView.EXPAND_PLAIN_ITEM){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                profilerTreeTable.expandPlainPath(profilerTreeTable.getSelectedRow(), 1);
            }
        });
        jMenu.add(new JMenuItem(JDBCView.EXPAND_TOPMOST_ITEM){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                profilerTreeTable.expandFirstPath(profilerTreeTable.getSelectedRow());
            }
        });
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(JDBCView.COLLAPSE_CHILDREN_ITEM){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                profilerTreeTable.collapseChildren(profilerTreeTable.getSelectedRow());
            }
        });
        jMenu.add(new JMenuItem(JDBCView.COLLAPSE_ALL_ITEM){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                profilerTreeTable.collapseAll();
            }
        });
        jPopupMenu.addSeparator();
        jPopupMenu.add(dataView.createCopyMenuItem());
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem(FilterUtils.ACTION_FILTER){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                dataView.activateFilter();
            }
        });
        jPopupMenu.add(new JMenuItem(SearchUtils.ACTION_FIND){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                dataView.activateSearch();
            }
        });
    }

    protected void customizeNodePopup(DataView dataView, JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
    }

    private synchronized ExecutorService getExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
        }
        return this.executor;
    }
}

