/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.CoreEffect;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.state.RenderState;
import com.sun.scenario.effect.impl.state.ZoomRadialBlurState;

public class ZoomRadialBlur
extends CoreEffect<RenderState> {
    private int r;
    private float centerX;
    private float centerY;
    private final ZoomRadialBlurState state = new ZoomRadialBlurState(this);

    public ZoomRadialBlur() {
        this(1);
    }

    public ZoomRadialBlur(int radius) {
        this(radius, DefaultInput);
    }

    public ZoomRadialBlur(int radius, Effect input) {
        super(input);
        this.setRadius(radius);
    }

    @Override
    Object getState() {
        return this.state;
    }

    public final Effect getInput() {
        return this.getInputs().get(0);
    }

    public void setInput(Effect input) {
        this.setInput(0, input);
    }

    public int getRadius() {
        return this.r;
    }

    public void setRadius(int radius) {
        if (radius < 1 || radius > 64) {
            throw new IllegalArgumentException("Radius must be in the range [1,64]");
        }
        int old = this.r;
        this.r = radius;
        this.state.invalidateDeltas();
        this.updatePeer();
    }

    private void updatePeer() {
        int psize = 4 + this.r - this.r % 4;
        this.updatePeerKey("ZoomRadialBlur", psize);
    }

    public float getCenterX() {
        return this.centerX;
    }

    public void setCenterX(float centerX) {
        float old = this.centerX;
        this.centerX = centerX;
    }

    public float getCenterY() {
        return this.centerY;
    }

    public void setCenterY(float centerY) {
        float old = this.centerY;
        this.centerY = centerY;
    }

    @Override
    public ImageData filterImageDatas(FilterContext fctx, BaseTransform transform, Rectangle outputClip, RenderState rstate, ImageData ... inputs) {
        Rectangle bnd = inputs[0].getUntransformedBounds();
        this.state.updateDeltas(1.0f / (float)bnd.width, 1.0f / (float)bnd.height);
        return super.filterImageDatas(fctx, transform, outputClip, rstate, inputs);
    }

    @Override
    public RenderState getRenderState(FilterContext fctx, BaseTransform transform, Rectangle outputClip, Object renderHelper, Effect defaultInput) {
        return RenderState.UserSpaceRenderState;
    }

    @Override
    public boolean reducesOpaquePixels() {
        return true;
    }

    @Override
    public DirtyRegionContainer getDirtyRegions(Effect defaultInput, DirtyRegionPool regionPool) {
        Effect di = this.getDefaultedInput(0, defaultInput);
        DirtyRegionContainer drc = di.getDirtyRegions(defaultInput, regionPool);
        int radius = this.getRadius();
        drc.grow(radius, radius);
        return drc;
    }
}

