/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.ConfigurationException;
import net.sourceforge.jnlp.OptionsDefinitions;
import net.sourceforge.jnlp.config.ConfiguratonValidator;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.config.Setting;
import net.sourceforge.jnlp.controlpanel.ControlPanel;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.docprovider.ItwebSettingsTextsProvider;
import net.sourceforge.jnlp.util.docprovider.formatters.formatters.PlainTextFormatter;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.jnlp.util.optionparser.OptionParser;

public class CommandLine {
    public static final int ERROR = 1;
    public static final int SUCCESS = 0;
    public final String PROGRAM_NAME;
    private OptionParser optionParser;
    DeploymentConfiguration config = null;

    public CommandLine(OptionParser optionParser) {
        this.optionParser = optionParser;
        this.PROGRAM_NAME = System.getProperty("icedtea-web.bin.name");
        this.config = new DeploymentConfiguration();
        try {
            this.config.load(false);
        }
        catch (ConfigurationException e) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("RConfigurationFatal"));
            OutputController.getLogger().log(e);
        }
    }

    public int handleHelpCommand() {
        ItwebSettingsTextsProvider helpMessagesProvider = new ItwebSettingsTextsProvider("utf-8", new PlainTextFormatter(), true, true);
        String helpMessage = "\n";
        helpMessage = JNLPRuntime.isDebug() ? helpMessage + helpMessagesProvider.writeToString() : helpMessage + helpMessagesProvider.prepare().getSynopsis() + helpMessagesProvider.getFormatter().getNewLine() + helpMessagesProvider.prepare().getDescription() + helpMessagesProvider.getFormatter().getNewLine() + helpMessagesProvider.prepare().getCommands() + helpMessagesProvider.getFormatter().getNewLine();
        OutputController.getLogger().printOut(helpMessage);
        return 0;
    }

    public void printListHelp() {
        OutputController.getLogger().printOutLn(Translator.R("Usage"));
        OutputController.getLogger().printOutLn("  " + this.PROGRAM_NAME + " list [--details]");
        OutputController.getLogger().printOutLn(Translator.R("CLListDescription"));
    }

    public int handleListCommand() {
        if (this.optionParser.hasOption(OptionsDefinitions.OPTIONS.HELP2)) {
            this.printListHelp();
            return 0;
        }
        if (this.optionParser.getMainArgs().contains("details") || this.optionParser.getMainArgs().contains("verbose")) {
            JNLPRuntime.setDebug(true);
        }
        Map<String, Setting<String>> all = this.config.getRaw();
        for (String key : all.keySet()) {
            Setting<String> value = all.get(key);
            OutputController.getLogger().printOutLn(key + ": " + value.getValue());
            if (!JNLPRuntime.isDebug()) continue;
            OutputController.getLogger().printOutLn("\t" + Translator.R("CLDescription", value.getDescription()));
        }
        return 0;
    }

    public void printGetHelp() {
        OutputController.getLogger().printOutLn(Translator.R("Usage"));
        OutputController.getLogger().printOutLn("  " + this.PROGRAM_NAME + " get property-name");
        OutputController.getLogger().printOutLn(Translator.R("CLGetDescription"));
    }

    public int handleGetCommand() {
        if (this.optionParser.hasOption(OptionsDefinitions.OPTIONS.HELP2)) {
            this.printGetHelp();
            return 0;
        }
        List<String> args = this.optionParser.getParams(OptionsDefinitions.OPTIONS.GET);
        Map<String, Setting<String>> all = this.config.getRaw();
        ArrayList<String> unknownProperties = new ArrayList<String>(args);
        unknownProperties.removeAll(all.keySet());
        if (unknownProperties.size() > 0) {
            for (String property : unknownProperties) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CLUnknownProperty", property));
            }
            return 1;
        }
        for (String key : args) {
            String value = all.get(key).getValue();
            OutputController.getLogger().printOutLn(key + ": " + value);
        }
        return 0;
    }

    public void printSetHelp() {
        OutputController.getLogger().printOutLn(Translator.R("Usage"));
        OutputController.getLogger().printOutLn("  " + this.PROGRAM_NAME + " set property-name value");
        OutputController.getLogger().printOutLn(Translator.R("CLSetDescription"));
    }

    public int handleSetCommand() {
        if (this.optionParser.hasOption(OptionsDefinitions.OPTIONS.HELP2)) {
            this.printSetHelp();
            return 0;
        }
        List<String> args = this.optionParser.getParams(OptionsDefinitions.OPTIONS.SET);
        String key = null;
        boolean isArgKey = false;
        for (String arg : args) {
            boolean bl = isArgKey = !isArgKey;
            if (isArgKey) {
                key = arg;
                continue;
            }
            String value = arg;
            if (this.configContains(key)) {
                if (this.validateValue(key, value) == 1) {
                    return 1;
                }
                this.config.setProperty(key, value);
                continue;
            }
            OutputController.getLogger().printOutLn(Translator.R("CLWarningUnknownProperty", key));
            this.config.setProperty(key, value);
        }
        try {
            this.config.save();
        }
        catch (IOException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            return 1;
        }
        return 0;
    }

    private boolean configContains(String arg) {
        return this.config.getRaw().containsKey(arg);
    }

    private int validateValue(String key, String value) {
        Setting<String> old = this.config.getRaw().get(key);
        if (old.getValidator() != null) {
            try {
                old.getValidator().validate(value);
            }
            catch (IllegalArgumentException e) {
                OutputController.getLogger().log(OutputController.Level.WARNING_ALL, Translator.R("CLIncorrectValue", old.getName(), value, old.getValidator().getPossibleValues()));
                OutputController.getLogger().log(e);
                return 1;
            }
        }
        return 0;
    }

    public void printResetHelp() {
        OutputController.getLogger().printOutLn(Translator.R("Usage"));
        OutputController.getLogger().printOutLn("  " + this.PROGRAM_NAME + " reset [all|property-name]");
        OutputController.getLogger().printOutLn(Translator.R("CLResetDescription"));
    }

    public int handleResetCommand() {
        if (this.optionParser.hasOption(OptionsDefinitions.OPTIONS.HELP2)) {
            this.printResetHelp();
            return 0;
        }
        List<String> args = this.optionParser.getParams(OptionsDefinitions.OPTIONS.RESET);
        boolean resetAll = false;
        if (args.contains("all")) {
            resetAll = true;
            if (args.size() > 1) {
                for (String string : args) {
                    if (string.equals("all")) continue;
                    OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CLUnknownCommand", string));
                }
            }
        }
        Map<String, Setting<String>> all = this.config.getRaw();
        if (resetAll) {
            for (String aKey : all.keySet()) {
                Setting<String> setting = all.get(aKey);
                setting.setValue(setting.getDefaultValue());
            }
        } else {
            for (String key : args) {
                if (!all.containsKey(key)) {
                    OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CLUnknownProperty", key));
                    return 1;
                }
                Setting<String> setting = all.get(key);
                setting.setValue(setting.getDefaultValue());
            }
        }
        try {
            this.config.save();
        }
        catch (IOException iOException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, iOException);
            return 1;
        }
        return 0;
    }

    public void printInfoHelp() {
        OutputController.getLogger().printOutLn(Translator.R("Usage"));
        OutputController.getLogger().printOutLn("  " + this.PROGRAM_NAME + " info property-name");
        OutputController.getLogger().printOutLn(Translator.R("CLInfoDescription"));
    }

    public int handleInfoCommand() {
        if (this.optionParser.hasOption(OptionsDefinitions.OPTIONS.HELP2)) {
            this.printInfoHelp();
            return 0;
        }
        List<String> args = this.optionParser.getParams(OptionsDefinitions.OPTIONS.INFO);
        Map<String, Setting<String>> all = this.config.getRaw();
        for (String key : args) {
            Setting<String> value = all.get(key);
            if (value == null) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CLNoInfo"));
                continue;
            }
            OutputController.getLogger().printOutLn(Translator.R("CLDescription", value.getDescription()));
            OutputController.getLogger().printOutLn(Translator.R("CLValue", value.getValue()));
            if (value.getValidator() != null) {
                OutputController.getLogger().printOutLn("\t" + Translator.R("VVPossibleValues", value.getValidator().getPossibleValues()));
            }
            OutputController.getLogger().printOutLn(Translator.R("CLValueSource", value.getSource()));
        }
        return 0;
    }

    public void printCheckHelp() {
        OutputController.getLogger().printOutLn(Translator.R("Usage"));
        OutputController.getLogger().printOutLn("  " + this.PROGRAM_NAME + " check");
        OutputController.getLogger().printOutLn(Translator.R("CLCheckDescription"));
    }

    public int handleCheckCommand() {
        if (this.optionParser.hasOption(OptionsDefinitions.OPTIONS.HELP2)) {
            this.printCheckHelp();
            return 0;
        }
        List<String> args = this.optionParser.getParams(OptionsDefinitions.OPTIONS.CHECK);
        if (!args.isEmpty()) {
            this.printCheckHelp();
            return 1;
        }
        Map<String, Setting<String>> all = this.config.getRaw();
        ConfiguratonValidator validator = new ConfiguratonValidator(all);
        validator.validate();
        boolean allValid = true;
        for (Setting<String> setting : validator.getIncorrectSetting()) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CLIncorrectValue", setting.getName(), setting.getValue(), setting.getValidator().getPossibleValues()));
            allValid = false;
        }
        for (Setting<String> setting : validator.getUnrecognizedSetting()) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CLUnknownProperty", setting.getName()));
            allValid = false;
        }
        if (allValid) {
            OutputController.getLogger().printOutLn(Translator.R("CLNoIssuesFound"));
            return 0;
        }
        return 1;
    }

    public int handle() {
        int val;
        if (this.hasUnrecognizedCommands()) {
            for (String unknown : this.optionParser.getMainArgs()) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CLUnknownCommand", unknown));
            }
            this.handleHelpCommand();
            val = 1;
        } else if (this.getNumberOfOptions() > 1) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CLUnexpectedNumberOfCommands"));
            val = this.handleHelpCommand();
        } else if (this.optionParser.hasOption(OptionsDefinitions.OPTIONS.LIST)) {
            val = this.handleListCommand();
        } else if (this.optionParser.hasOption(OptionsDefinitions.OPTIONS.SET)) {
            val = this.handleSetCommand();
        } else if (this.optionParser.hasOption(OptionsDefinitions.OPTIONS.RESET)) {
            val = this.handleResetCommand();
        } else if (this.optionParser.hasOption(OptionsDefinitions.OPTIONS.GET)) {
            val = this.handleGetCommand();
        } else if (this.optionParser.hasOption(OptionsDefinitions.OPTIONS.INFO)) {
            val = this.handleInfoCommand();
        } else if (this.optionParser.hasOption(OptionsDefinitions.OPTIONS.CHECK)) {
            val = this.handleCheckCommand();
        } else if (this.optionParser.hasOption(OptionsDefinitions.OPTIONS.HELP2)) {
            val = this.handleHelpCommand();
        } else {
            this.handleHelpCommand();
            val = 1;
        }
        return val;
    }

    private boolean hasUnrecognizedCommands() {
        int size = this.optionParser.getMainArgs().size();
        return !this.isDetailsValid() && size > 0;
    }

    private boolean isDetailsValid() {
        int size = this.optionParser.getMainArgs().size();
        return this.optionParser.getMainArgs().contains("details") && size == 1 && this.optionParser.hasOption(OptionsDefinitions.OPTIONS.LIST) && this.getNumberOfOptions() == 1;
    }

    private int getNumberOfOptions() {
        int number = this.optionParser.getNumberOfOptions();
        if (this.optionParser.hasOption(OptionsDefinitions.OPTIONS.HELP2)) {
            --number;
        }
        if (this.optionParser.hasOption(OptionsDefinitions.OPTIONS.VERBOSE)) {
            --number;
        }
        if (this.optionParser.hasOption(OptionsDefinitions.OPTIONS.HEADLESS)) {
            --number;
        }
        return number;
    }

    public static void main(String[] args) throws Exception {
        try {
            OptionParser optionParser = new OptionParser(args, OptionsDefinitions.getItwsettingsCommands());
            if (optionParser.hasOption(OptionsDefinitions.OPTIONS.DETAILS) || optionParser.hasOption(OptionsDefinitions.OPTIONS.VERBOSE)) {
                JNLPRuntime.setDebug(true);
            }
            if (optionParser.hasOption(OptionsDefinitions.OPTIONS.HEADLESS)) {
                JNLPRuntime.setHeadless(true);
            }
            DeploymentConfiguration.move14AndOlderFilesTo15StructureCatched();
            if (args.length == 0) {
                ControlPanel.main(new String[0]);
            } else {
                CommandLine cli = new CommandLine(optionParser);
                int result = cli.handle();
                JNLPRuntime.exit(result);
            }
        }
        catch (Exception e) {
            OutputController.getLogger().log(OutputController.Level.WARNING_ALL, e);
            JNLPRuntime.exit(1);
        }
    }
}

