/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class MD5SumWatcher {
    private final File watchedFile;
    private byte[] md5sum;

    public MD5SumWatcher(File watchedFile) {
        this.watchedFile = watchedFile;
        try {
            this.md5sum = this.getSum();
        }
        catch (IOException ioe) {
            OutputController.getLogger().log(ioe);
            this.md5sum = null;
        }
    }

    public byte[] getSum() throws FileNotFoundException, IOException {
        this.update();
        return this.md5sum;
    }

    public boolean update() throws FileNotFoundException, IOException {
        byte[] newSum;
        try {
            newSum = FileUtils.getFileMD5Sum(this.watchedFile, "MD5");
        }
        catch (NoSuchAlgorithmException e) {
            OutputController.getLogger().log(e);
            throw new RuntimeException(e);
        }
        boolean changed = !Arrays.equals(newSum, this.md5sum);
        this.md5sum = newSum;
        return changed;
    }
}

