/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.converters;

import com.sun.javafx.css.ParsedValue;
import com.sun.javafx.css.Size;
import com.sun.javafx.css.SizeUnits;
import com.sun.javafx.css.StyleConverter;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.text.Font;

public final class PaintConverter
extends StyleConverter<ParsedValue<?, Paint>, Paint> {
    public static PaintConverter getInstance() {
        return Holder.INSTANCE;
    }

    private PaintConverter() {
    }

    @Override
    public Paint convert(ParsedValue<ParsedValue<?, Paint>, Paint> parsedValue, Font font) {
        ParsedValue<?, Paint> parsedValue2 = parsedValue.getValue();
        if (parsedValue2 instanceof Paint) {
            return (Paint)((Object)parsedValue2);
        }
        return parsedValue.getValue().convert(font);
    }

    public String toString() {
        return "PaintConverter";
    }

    private static class Holder {
        static PaintConverter INSTANCE = new PaintConverter();
        static SequenceConverter SEQUENCE_INSTANCE = new SequenceConverter();
        static LinearGradientConverter LINEAR_GRADIENT_INSTANCE = new LinearGradientConverter();
        static RadialGradientConverter RADIAL_GRADIENT_INSTANCE = new RadialGradientConverter();

        private Holder() {
        }
    }

    public static final class LinearGradientConverter
    extends StyleConverter<ParsedValue[], Paint> {
        public static LinearGradientConverter getInstance() {
            return Holder.LINEAR_GRADIENT_INSTANCE;
        }

        private LinearGradientConverter() {
        }

        @Override
        public Paint convert(ParsedValue<ParsedValue[], Paint> parsedValue, Font font) {
            ParsedValue[] parsedValueArray = parsedValue.getValue();
            int n = 0;
            Size size = (Size)parsedValueArray[n++].convert(font);
            Size size2 = (Size)parsedValueArray[n++].convert(font);
            Size size3 = (Size)parsedValueArray[n++].convert(font);
            Size size4 = (Size)parsedValueArray[n++].convert(font);
            boolean bl = size.getUnits() == SizeUnits.PERCENT && size.getUnits() == size2.getUnits() && size.getUnits() == size3.getUnits() && size.getUnits() == size4.getUnits();
            CycleMethod cycleMethod = (CycleMethod)((Object)parsedValueArray[n++].convert(font));
            Stop[] stopArray = new Stop[parsedValueArray.length - n];
            for (int i = n; i < parsedValueArray.length; ++i) {
                stopArray[i - n] = (Stop)parsedValueArray[i].convert(font);
            }
            return new LinearGradient(size.pixels(font), size2.pixels(font), size3.pixels(font), size4.pixels(font), bl, cycleMethod, stopArray);
        }

        public String toString() {
            return "LinearGradientConverter";
        }
    }

    public static final class RadialGradientConverter
    extends StyleConverter<ParsedValue[], Paint> {
        public static RadialGradientConverter getInstance() {
            return Holder.RADIAL_GRADIENT_INSTANCE;
        }

        private RadialGradientConverter() {
        }

        @Override
        public Paint convert(ParsedValue<ParsedValue[], Paint> parsedValue, Font font) {
            boolean bl;
            ParsedValue[] parsedValueArray = parsedValue.getValue();
            int n = 0;
            Size size = parsedValueArray[n++] != null ? (Size)parsedValueArray[n - 1].convert(font) : null;
            Size size2 = parsedValueArray[n++] != null ? (Size)parsedValueArray[n - 1].convert(font) : null;
            Size size3 = parsedValueArray[n++] != null ? (Size)parsedValueArray[n - 1].convert(font) : null;
            Size size4 = parsedValueArray[n++] != null ? (Size)parsedValueArray[n - 1].convert(font) : null;
            Size size5 = (Size)parsedValueArray[n++].convert(font);
            boolean bl2 = size5.getUnits().equals((Object)SizeUnits.PERCENT);
            boolean bl3 = size3 != null ? bl2 == size3.getUnits().equals((Object)SizeUnits.PERCENT) : (bl = true);
            boolean bl4 = bl && size4 != null ? bl2 == size4.getUnits().equals((Object)SizeUnits.PERCENT) : (bl = true);
            if (!bl) {
                throw new IllegalArgumentException("units do not agree");
            }
            CycleMethod cycleMethod = (CycleMethod)((Object)parsedValueArray[n++].convert(font));
            Stop[] stopArray = new Stop[parsedValueArray.length - n];
            for (int i = n; i < parsedValueArray.length; ++i) {
                stopArray[i - n] = (Stop)parsedValueArray[i].convert(font);
            }
            double d = 0.0;
            if (size != null) {
                d = size.pixels(font);
                if (size.getUnits().equals((Object)SizeUnits.PERCENT)) {
                    d = d * 360.0 % 360.0;
                }
            }
            return new RadialGradient(d, size2 != null ? size2.pixels() : 0.0, size3 != null ? size3.pixels() : 0.0, size4 != null ? size4.pixels() : 0.0, size5 != null ? size5.pixels() : 1.0, bl2, cycleMethod, stopArray);
        }

        public String toString() {
            return "RadialGradientConverter";
        }
    }

    public static final class SequenceConverter
    extends StyleConverter<ParsedValue<?, Paint>[], Paint[]> {
        public static SequenceConverter getInstance() {
            return Holder.SEQUENCE_INSTANCE;
        }

        private SequenceConverter() {
        }

        @Override
        public Paint[] convert(ParsedValue<ParsedValue<?, Paint>[], Paint[]> parsedValue, Font font) {
            ParsedValue<?, Paint>[] parsedValueArray = parsedValue.getValue();
            Paint[] paintArray = new Paint[parsedValueArray.length];
            for (int i = 0; i < parsedValueArray.length; ++i) {
                paintArray[i] = parsedValueArray[i].convert(font);
            }
            return paintArray;
        }

        public String toString() {
            return "Paint.SequenceConverter";
        }
    }
}

