/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.params;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.parosproxy.paros.db.RecordParam;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httpsessions.ExtensionHttpSessions;
import org.zaproxy.zap.extension.params.ExtensionParams;
import org.zaproxy.zap.extension.params.HtmlParameterStats;
import org.zaproxy.zap.extension.params.ParamsTableModel;

public class SiteParameters {
    private ExtensionParams extension;
    private String site;
    private ParamsTableModel model = new ParamsTableModel();
    private Map<String, HtmlParameterStats> cookieParams = new HashMap<String, HtmlParameterStats>();
    private Map<String, HtmlParameterStats> urlParams = new HashMap<String, HtmlParameterStats>();
    private Map<String, HtmlParameterStats> formParams = new HashMap<String, HtmlParameterStats>();
    private Map<String, HtmlParameterStats> headerParams = new HashMap<String, HtmlParameterStats>();

    public SiteParameters(ExtensionParams extension, String site) {
        this.extension = extension;
        this.site = site;
    }

    public String getSite() {
        return this.site;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public boolean hasParams() {
        return !this.cookieParams.isEmpty() || !this.urlParams.isEmpty() || !this.formParams.isEmpty() || !this.headerParams.isEmpty();
    }

    public HtmlParameterStats getParam(HtmlParameter.Type type, String name) {
        switch (type) {
            case cookie: {
                return this.cookieParams.get(name);
            }
            case url: {
                return this.urlParams.get(name);
            }
            case form: {
                return this.formParams.get(name);
            }
            case header: {
                return this.headerParams.get(name);
            }
        }
        return null;
    }

    public List<HtmlParameterStats> getParams(HtmlParameter.Type type) {
        ArrayList<HtmlParameterStats> params = new ArrayList<HtmlParameterStats>();
        switch (type) {
            case cookie: {
                params.addAll(this.cookieParams.values());
                break;
            }
            case url: {
                params.addAll(this.urlParams.values());
                break;
            }
            case form: {
                params.addAll(this.formParams.values());
                break;
            }
            case header: {
                params.addAll(this.headerParams.values());
            }
        }
        return params;
    }

    public List<HtmlParameterStats> getParams() {
        ArrayList<HtmlParameterStats> params = new ArrayList<HtmlParameterStats>();
        params.addAll(this.cookieParams.values());
        params.addAll(this.urlParams.values());
        params.addAll(this.formParams.values());
        params.addAll(this.headerParams.values());
        return params;
    }

    public HtmlParameterStats addParam(String site, HtmlParameter param, HttpMessage msg) {
        HtmlParameterStats p;
        Map<String, HtmlParameterStats> params = null;
        switch (param.getType()) {
            case cookie: {
                params = this.cookieParams;
                break;
            }
            case url: {
                params = this.urlParams;
                break;
            }
            case form: {
                params = this.formParams;
                break;
            }
            case header: {
                params = this.headerParams;
            }
        }
        if (params != null && params.containsKey(param.getName())) {
            p = params.get(param.getName());
            p.incTimesUsed();
            p.addValue(param.getValue());
        } else {
            p = new HtmlParameterStats(site, param.getName(), param.getType(), param.getValue(), param.getFlags());
            ExtensionHttpSessions extSession = this.extension.getExtensionHttpSessions();
            if (extSession != null && param.getType().equals((Object)HtmlParameter.Type.cookie) && extSession.isSessionToken(site, param.getName())) {
                p.addFlag(HtmlParameter.Flags.session.name());
            }
            if (params == null) {
                params = new HashMap<String, HtmlParameterStats>();
            }
            params.put(param.getName(), p);
            this.model.addHtmlParameterStats(p);
        }
        return p;
    }

    public ParamsTableModel getModel() {
        return this.model;
    }

    private Set<String> stringToSet(String str) {
        String[] array;
        HashSet<String> set = new HashSet<String>();
        for (String s : array = str.split(",")) {
            set.add(s);
        }
        return set;
    }

    public void addParam(String site2, RecordParam param) {
        Map<String, HtmlParameterStats> params = null;
        HtmlParameter.Type type = HtmlParameter.Type.valueOf(param.getType());
        switch (type) {
            case cookie: {
                params = this.cookieParams;
                break;
            }
            case url: {
                params = this.urlParams;
                break;
            }
            case form: {
                params = this.formParams;
                break;
            }
            case header: {
                params = this.headerParams;
            }
        }
        HtmlParameterStats p = new HtmlParameterStats(param.getParamId(), this.site, param.getName(), param.getType(), param.getUsed(), this.stringToSet(param.getValues()), this.stringToSet(param.getFlags()));
        if (params != null) {
            params.put(param.getName(), p);
            this.model.addHtmlParameterStats(p);
        }
    }
}

