/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsLog;

import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperationOnFiles;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.BranchesProvider;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.TagsHelper;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.openapi.vcs.FilePath;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.log.LogCommand;
import org.netbeans.lib.cvsclient.command.log.LogInformation;

public class LogOperation
extends CvsOperationOnFiles
implements BranchesProvider {
    private final Set<String> branches = new THashSet();

    public LogOperation(Collection<? extends FilePath> files) {
        for (FilePath filePath : files) {
            this.addFile(filePath.getIOFile());
        }
    }

    @Override
    protected Command createCommand(CvsRootProvider root, CvsExecutionEnvironment cvsExecutionEnvironment) {
        LogCommand command = new LogCommand();
        this.addFilesToCommand(root, (AbstractCommand)command);
        command.setHeaderOnly(true);
        return command;
    }

    @Override
    public void fileInfoGenerated(Object info) {
        super.fileInfoGenerated(info);
        if (info instanceof LogInformation) {
            TagsHelper.collectBranches((LogInformation)info, this.branches);
        }
    }

    @Override
    public Collection<String> getAllBranches() {
        return this.branches;
    }

    @Override
    public Collection<CvsRevisionNumber> getAllRevisions() {
        return null;
    }

    @Override
    protected String getOperationName() {
        return "log";
    }

    @Override
    public int getFilesToProcessCount() {
        return -1;
    }
}

