/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.notification.context;

import org.sejda.core.context.DefaultSejdaContext;
import org.sejda.core.notification.context.EventListenerHoldingStrategy;
import org.sejda.core.notification.context.NotificationContext;
import org.sejda.core.notification.strategy.NotificationStrategy;
import org.sejda.core.notification.strategy.SyncNotificationStrategy;
import org.sejda.model.notification.EventListener;
import org.sejda.model.notification.event.AbstractNotificationEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractNotificationContext
implements NotificationContext {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNotificationContext.class);
    private final EventListenerHoldingStrategy holder;
    private final NotificationStrategy strategy;

    protected AbstractNotificationContext(EventListenerHoldingStrategy holder) {
        this.holder = holder;
        this.strategy = this.getStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyListeners(AbstractNotificationEvent event) {
        EventListenerHoldingStrategy eventListenerHoldingStrategy = this.holder;
        synchronized (eventListenerHoldingStrategy) {
            if (this.holder.size() > 0) {
                for (EventListener<? extends AbstractNotificationEvent> listener : this.holder.get(event)) {
                    this.strategy.notifyListener(listener, event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends AbstractNotificationEvent> void addListener(EventListener<T> listener) {
        EventListenerHoldingStrategy eventListenerHoldingStrategy = this.holder;
        synchronized (eventListenerHoldingStrategy) {
            LOG.trace("Adding event listener: {}", listener);
            this.holder.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends AbstractNotificationEvent> void addListener(Class<T> eventClass, EventListener<T> listener) {
        EventListenerHoldingStrategy eventListenerHoldingStrategy = this.holder;
        synchronized (eventListenerHoldingStrategy) {
            LOG.trace("Adding event listener {} on event {}", listener, eventClass);
            this.holder.add(eventClass, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends AbstractNotificationEvent> boolean removeListener(EventListener<T> listener) {
        EventListenerHoldingStrategy eventListenerHoldingStrategy = this.holder;
        synchronized (eventListenerHoldingStrategy) {
            LOG.trace("Removing event listener: {}", listener);
            return this.holder.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearListeners() {
        EventListenerHoldingStrategy eventListenerHoldingStrategy = this.holder;
        synchronized (eventListenerHoldingStrategy) {
            this.holder.clear();
        }
    }

    @Override
    public int size() {
        return this.holder.size();
    }

    private NotificationStrategy getStrategy() {
        try {
            return new DefaultSejdaContext().getNotificationStrategy().newInstance();
        }
        catch (InstantiationException e) {
            LOG.warn("An error occur while instantiating a new NotificationStrategy. Default strategy will be used.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.warn("Unable to access constructor for the configured NotificationStrategy. Default strategy will be used.", (Throwable)e);
        }
        return new SyncNotificationStrategy();
    }
}

