/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.image;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.sejda.model.input.FileSource;
import org.sejda.model.input.Source;
import org.sejda.model.input.SourceDispatcher;
import org.sejda.model.input.StreamSource;

public class ExifHelper {
    public static int getRotationBasedOnExifOrientation(Source<?> imageSource) {
        try {
            return (Integer)imageSource.dispatch((SourceDispatcher)new SourceDispatcher<Integer>(){

                public Integer dispatch(FileSource source) {
                    try {
                        int orientation = ExifHelper.readExifOrientation(ImageMetadataReader.readMetadata((File)source.getSource()));
                        return ExifHelper.getRotation(orientation);
                    }
                    catch (ImageProcessingException | MetadataException | IOException e) {
                        return 0;
                    }
                }

                public Integer dispatch(StreamSource source) {
                    try {
                        int orientation = ExifHelper.readExifOrientation(ImageMetadataReader.readMetadata((InputStream)source.getSource()));
                        return ExifHelper.getRotation(orientation);
                    }
                    catch (ImageProcessingException | MetadataException | IOException e) {
                        return 0;
                    }
                }
            });
        }
        catch (Throwable e) {
            return 0;
        }
    }

    private static int readExifOrientation(Metadata metadata) throws MetadataException {
        Directory directory = metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
        return directory.getInt(274);
    }

    private static int getRotation(int orientation) {
        switch (orientation) {
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 180;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
            case 6: {
                return 90;
            }
            case 7: {
                return 0;
            }
            case 8: {
                return 270;
            }
        }
        return 0;
    }
}

