/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.WireFormat;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntLongHashMap;
import gnu.trove.set.hash.TLongHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.osmand.Collator;
import net.osmand.CollatorStringMatcher;
import net.osmand.Location;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryIndexPart;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.Amenity;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.PoiCategory;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class BinaryMapPoiReaderAdapter {
    private static final Log LOG = PlatformUtil.getLog(BinaryMapPoiReaderAdapter.class);
    public static final int SHIFT_BITS_CATEGORY = 7;
    private static final int CATEGORY_MASK = 127;
    private static final int ZOOM_TO_SKIP_FILTER_READ = 6;
    private static final int ZOOM_TO_SKIP_FILTER = 3;
    private static final int BUCKET_SEARCH_BY_NAME = 5;
    private CodedInputStream codedIS;
    private final BinaryMapIndexReader map;
    private MapPoiTypes poiTypes;

    protected BinaryMapPoiReaderAdapter(BinaryMapIndexReader map) {
        this.codedIS = map.codedIS;
        this.map = map;
        this.poiTypes = MapPoiTypes.getDefault();
    }

    private void skipUnknownField(int t) throws IOException {
        this.map.skipUnknownField(t);
    }

    private int readInt() throws IOException {
        return this.map.readInt();
    }

    private void readPoiBoundariesIndex(PoiRegion region) throws IOException {
        block7: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 1: {
                    region.leftLongitude = MapUtils.get31LongitudeX(this.codedIS.readUInt32());
                    continue block7;
                }
                case 2: {
                    region.rightLongitude = MapUtils.get31LongitudeX(this.codedIS.readUInt32());
                    continue block7;
                }
                case 3: {
                    region.topLatitude = MapUtils.get31LatitudeY(this.codedIS.readUInt32());
                    continue block7;
                }
                case 4: {
                    region.bottomLatitude = MapUtils.get31LatitudeY(this.codedIS.readUInt32());
                    continue block7;
                }
            }
            this.skipUnknownField(t);
        }
    }

    protected void readPoiIndex(PoiRegion region, boolean readCategories) throws IOException {
        block8: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 1: {
                    region.name = this.codedIS.readString();
                    continue block8;
                }
                case 2: {
                    int length = this.codedIS.readRawVarint32();
                    int oldLimit = this.codedIS.pushLimit(length);
                    this.readPoiBoundariesIndex(region);
                    this.codedIS.popLimit(oldLimit);
                    continue block8;
                }
                case 3: {
                    if (!readCategories) {
                        this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                        return;
                    }
                    int length = this.codedIS.readRawVarint32();
                    int oldLimit = this.codedIS.pushLimit(length);
                    this.readCategory(region);
                    this.codedIS.popLimit(oldLimit);
                    continue block8;
                }
                case 5: {
                    if (!readCategories) {
                        this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                        return;
                    }
                    int length = this.codedIS.readRawVarint32();
                    int oldLimit = this.codedIS.pushLimit(length);
                    this.readSubtypes(region);
                    this.codedIS.popLimit(oldLimit);
                    continue block8;
                }
                case 6: {
                    this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    return;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private void readCategory(PoiRegion region) throws IOException {
        block5: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 1: {
                    String cat = this.codedIS.readString().intern();
                    region.categories.add(cat);
                    region.categoriesType.add(this.poiTypes.getPoiCategoryByName(cat.toLowerCase()));
                    region.subcategories.add(new ArrayList());
                    continue block5;
                }
                case 3: {
                    region.subcategories.get(region.subcategories.size() - 1).add(this.codedIS.readString().intern());
                    continue block5;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private void readSubtypes(PoiRegion region) throws IOException {
        block10: while (true) {
            int outT = this.codedIS.readTag();
            int outTag = WireFormat.getTagFieldNumber(outT);
            switch (outTag) {
                case 0: {
                    return;
                }
                case 4: {
                    int length = this.codedIS.readRawVarint32();
                    int oldLimit = this.codedIS.pushLimit(length);
                    PoiSubType st = new PoiSubType();
                    block11: while (true) {
                        int inT = this.codedIS.readTag();
                        int inTag = WireFormat.getTagFieldNumber(inT);
                        switch (inTag) {
                            case 0: {
                                break block11;
                            }
                            case 1: {
                                st.name = this.codedIS.readString().intern();
                                continue block11;
                            }
                            case 8: {
                                if (st.possibleValues == null) {
                                    st.possibleValues = new ArrayList<String>();
                                }
                                st.possibleValues.add(this.codedIS.readString().intern());
                                continue block11;
                            }
                            case 3: {
                                st.text = this.codedIS.readBool();
                                continue block11;
                            }
                            default: {
                                this.skipUnknownField(inT);
                                continue block11;
                            }
                        }
                        break;
                    }
                    region.subTypes.add(st);
                    this.codedIS.popLimit(oldLimit);
                    continue block10;
                }
            }
            this.skipUnknownField(outT);
        }
    }

    public void initCategories(PoiRegion region) throws IOException {
        if (region.categories.isEmpty()) {
            this.codedIS.seek(region.filePointer);
            int oldLimit = this.codedIS.pushLimit(region.length);
            this.readPoiIndex(region, true);
            this.codedIS.popLimit(oldLimit);
        }
    }

    protected void searchPoiByName(PoiRegion region, BinaryMapIndexReader.SearchRequest<Amenity> req) throws IOException {
        TIntLongHashMap offsets = new TIntLongHashMap();
        String query = req.nameQuery.toLowerCase();
        CollatorStringMatcher matcher = new CollatorStringMatcher(query, CollatorStringMatcher.StringMatcherMode.CHECK_STARTS_FROM_SPACE);
        long time = System.currentTimeMillis();
        int indexOffset = this.codedIS.getTotalBytesRead();
        block5: while (!req.isCancelled()) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 4: {
                    int length = this.readInt();
                    int oldLimit = this.codedIS.pushLimit(length);
                    offsets = this.readPoiNameIndex(matcher.getCollator(), query, req);
                    this.codedIS.popLimit(oldLimit);
                    continue block5;
                }
                case 9: {
                    Object[] offKeys = new Integer[offsets.size()];
                    if (offsets.size() > 0) {
                        int[] keys = offsets.keys();
                        for (int i = 0; i < keys.length; ++i) {
                            offKeys[i] = keys[i];
                        }
                        final TIntLongHashMap foffsets = offsets;
                        Arrays.sort(offKeys, new Comparator<Integer>(){

                            @Override
                            public int compare(Integer object1, Integer object2) {
                                return Double.compare(foffsets.get(object1.intValue()), foffsets.get(object2.intValue()));
                            }
                        });
                        int p = 15;
                        if (p < offKeys.length) {
                            int i = p + 5;
                            while (true) {
                                if (i > offKeys.length) {
                                    Arrays.sort(offKeys, p, offKeys.length);
                                    break;
                                }
                                Arrays.sort(offKeys, p, i);
                                p = i;
                                i += 5;
                            }
                        }
                    }
                    LOG.debug((Object)("Searched poi structure in " + (System.currentTimeMillis() - time) + "ms. Found " + offKeys.length + " subtrees"));
                    for (int j = 0; j < offKeys.length; ++j) {
                        this.codedIS.seek(offKeys[j] + indexOffset);
                        int len = this.readInt();
                        int oldLim = this.codedIS.pushLimit(len);
                        this.readPoiData(matcher, req, region);
                        this.codedIS.popLimit(oldLim);
                        if (!req.isCancelled() && !req.limitExceeded()) continue;
                        return;
                    }
                    LOG.debug((Object)("Whole poi by name search is done in " + (System.currentTimeMillis() - time) + "ms. Found " + req.getSearchResults().size()));
                    this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    return;
                }
            }
            this.skipUnknownField(t);
        }
        return;
    }

    private TIntLongHashMap readPoiNameIndex(Collator instance, String query, BinaryMapIndexReader.SearchRequest<Amenity> req) throws IOException {
        TIntLongHashMap offsets = new TIntLongHashMap();
        TIntArrayList dataOffsets = null;
        int offset = 0;
        block5: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return offsets;
                }
                case 3: {
                    int length = this.readInt();
                    int oldLimit = this.codedIS.pushLimit(length);
                    dataOffsets = new TIntArrayList();
                    offset = this.codedIS.getTotalBytesRead();
                    this.map.readIndexedStringTable(instance, query, "", dataOffsets, 0);
                    this.codedIS.popLimit(oldLimit);
                    continue block5;
                }
                case 5: {
                    if (dataOffsets != null) {
                        dataOffsets.sort();
                        for (int i = 0; i < dataOffsets.size(); ++i) {
                            this.codedIS.seek(dataOffsets.get(i) + offset);
                            int len = this.codedIS.readRawVarint32();
                            int oldLim = this.codedIS.pushLimit(len);
                            this.readPoiNameIndexData(offsets, req);
                            this.codedIS.popLimit(oldLim);
                            if (!req.isCancelled()) continue;
                            this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                            return offsets;
                        }
                    }
                    this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    return offsets;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private void readPoiNameIndexData(TIntLongHashMap offsets, BinaryMapIndexReader.SearchRequest<Amenity> req) throws IOException {
        block4: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 3: {
                    int len = this.codedIS.readRawVarint32();
                    int oldLim = this.codedIS.pushLimit(len);
                    this.readPoiNameIndexDataAtom(offsets, req);
                    this.codedIS.popLimit(oldLim);
                    continue block4;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private void readPoiNameIndexDataAtom(TIntLongHashMap offsets, BinaryMapIndexReader.SearchRequest<Amenity> req) throws IOException {
        int x = 0;
        int y = 0;
        int zoom = 15;
        block7: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 3: {
                    x = this.codedIS.readUInt32();
                    continue block7;
                }
                case 4: {
                    y = this.codedIS.readUInt32();
                    continue block7;
                }
                case 2: {
                    zoom = this.codedIS.readUInt32();
                    continue block7;
                }
                case 14: {
                    int x31 = x << 31 - zoom;
                    int y31 = y << 31 - zoom;
                    int shift = this.readInt();
                    if (!req.contains(x31, y31, x31, y31)) continue block7;
                    long d = Math.abs(req.x - x31) + Math.abs(req.y - y31);
                    offsets.put(shift, d);
                    continue block7;
                }
            }
            this.skipUnknownField(t);
        }
    }

    protected void searchPoiIndex(int left31, int right31, int top31, int bottom31, BinaryMapIndexReader.SearchRequest<Amenity> req, PoiRegion region) throws IOException {
        int indexOffset = this.codedIS.getTotalBytesRead();
        long time = System.currentTimeMillis();
        TLongHashSet skipTiles = null;
        if (req.zoom >= 0 && req.zoom < 16) {
            skipTiles = new TLongHashSet();
        }
        TIntLongHashMap offsetsMap = new TIntLongHashMap();
        block5: while (!req.isCancelled()) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 6: {
                    int length = this.readInt();
                    int oldLimit = this.codedIS.pushLimit(length);
                    this.readBoxField(left31, right31, top31, bottom31, 0, 0, 0, offsetsMap, skipTiles, req, region);
                    this.codedIS.popLimit(oldLimit);
                    continue block5;
                }
                case 9: {
                    int[] offsets = offsetsMap.keys();
                    Arrays.sort(offsets);
                    if (skipTiles != null) {
                        skipTiles.clear();
                    }
                    LOG.debug((Object)("Searched poi structure in " + (System.currentTimeMillis() - time) + " ms. Found " + offsets.length + " subtrees"));
                    for (int j = 0; j < offsets.length; ++j) {
                        long dy;
                        int dzoom;
                        long dx;
                        long skipVal = offsetsMap.get(offsets[j]);
                        if (skipTiles != null && skipVal != -1L && (skipVal = (dx = skipVal >> 6) >> (dzoom = 3) << 3 | (dy = skipVal - (dx << 6)) >> dzoom) != -1L && skipTiles.contains(skipVal)) continue;
                        this.codedIS.seek(offsets[j] + indexOffset);
                        int len = this.readInt();
                        int oldLim = this.codedIS.pushLimit(len);
                        boolean read = this.readPoiData(left31, right31, top31, bottom31, req, region, skipTiles, req.zoom == -1 ? 31 : req.zoom + 3);
                        if (read && skipVal != -1L && skipTiles != null) {
                            skipTiles.add(skipVal);
                        }
                        this.codedIS.popLimit(oldLim);
                        if (!req.isCancelled()) continue;
                        return;
                    }
                    this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    return;
                }
            }
            this.skipUnknownField(t);
        }
        return;
    }

    private void readPoiData(CollatorStringMatcher matcher, BinaryMapIndexReader.SearchRequest<Amenity> req, PoiRegion region) throws IOException {
        int x = 0;
        int y = 0;
        int zoom = 0;
        block7: while (!req.isCancelled() && !req.limitExceeded()) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 2: {
                    x = this.codedIS.readUInt32();
                    break;
                }
                case 1: {
                    zoom = this.codedIS.readUInt32();
                    break;
                }
                case 3: {
                    y = this.codedIS.readUInt32();
                    break;
                }
                case 5: {
                    boolean matches;
                    int len = this.codedIS.readRawVarint32();
                    int oldLim = this.codedIS.pushLimit(len);
                    Amenity am = this.readPoiPoint(0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, x, y, zoom, req, region, false);
                    this.codedIS.popLimit(oldLim);
                    if (am == null) continue block7;
                    boolean bl = matches = matcher.matches(am.getName().toLowerCase()) || matcher.matches(am.getEnName(true).toLowerCase());
                    if (!matches) {
                        Map.Entry<String, String> e;
                        String s;
                        Iterator<String> iterator = am.getAllNames().iterator();
                        while (iterator.hasNext() && !(matches = matcher.matches((s = iterator.next()).toLowerCase()))) {
                        }
                        Map<String, String> lt = am.getAdditionalInfo();
                        Iterator<Map.Entry<String, String>> iterator2 = lt.entrySet().iterator();
                        while (iterator2.hasNext() && !(matches = matcher.matches((e = iterator2.next()).getValue()))) {
                        }
                    }
                    if (!matches) continue block7;
                    req.publish(am);
                    break;
                }
                default: {
                    this.skipUnknownField(t);
                }
            }
        }
        return;
    }

    private boolean readPoiData(int left31, int right31, int top31, int bottom31, BinaryMapIndexReader.SearchRequest<Amenity> req, PoiRegion region, TLongHashSet toSkip, int zSkip) throws IOException {
        int x = 0;
        int y = 0;
        int zoom = 0;
        boolean read = false;
        block7: while (!req.isCancelled()) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return read;
                }
                case 2: {
                    x = this.codedIS.readUInt32();
                    break;
                }
                case 1: {
                    zoom = this.codedIS.readUInt32();
                    break;
                }
                case 3: {
                    y = this.codedIS.readUInt32();
                    break;
                }
                case 5: {
                    int len = this.codedIS.readRawVarint32();
                    int oldLim = this.codedIS.pushLimit(len);
                    Amenity am = this.readPoiPoint(left31, right31, top31, bottom31, x, y, zoom, req, region, true);
                    this.codedIS.popLimit(oldLim);
                    if (am == null) continue block7;
                    if (toSkip != null) {
                        int yp;
                        int xp = (int)MapUtils.getTileNumberX(zSkip, am.getLocation().getLongitude());
                        long valSkip = (long)xp << zSkip | (long)(yp = (int)MapUtils.getTileNumberY(zSkip, am.getLocation().getLatitude()));
                        if (!toSkip.contains(valSkip)) {
                            boolean publish = req.publish(am);
                            if (!publish) continue block7;
                            read = true;
                            toSkip.add(valSkip);
                            break;
                        }
                        if (zSkip > zoom) continue block7;
                        this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                        return read;
                    }
                    if (!req.publish(am)) continue block7;
                    read = true;
                    break;
                }
                default: {
                    this.skipUnknownField(t);
                }
            }
        }
        return read;
    }

    private Amenity.AmenityRoutePoint dist(LatLon l, List<Location> locations, double radius) {
        float dist = (float)(radius + 0.1);
        Amenity.AmenityRoutePoint arp = null;
        for (int i = 1; i < locations.size(); i += 2) {
            float d = (float)MapUtils.getOrthogonalDistance(l.getLatitude(), l.getLongitude(), locations.get(i - 1).getLatitude(), locations.get(i - 1).getLongitude(), locations.get(i).getLatitude(), locations.get(i).getLongitude());
            if (!(d < dist)) continue;
            arp = new Amenity.AmenityRoutePoint();
            dist = d;
            arp.deviateDistance = dist;
            arp.pointA = locations.get(i - 1);
            arp.pointB = locations.get(i);
        }
        if (arp != null && arp.deviateDistance != 0.0 && arp.pointA != null && arp.pointB != null) {
            arp.deviationDirectionRight = MapUtils.rightSide(l.getLatitude(), l.getLongitude(), arp.pointA.getLatitude(), arp.pointA.getLongitude(), arp.pointB.getLatitude(), arp.pointB.getLongitude());
        }
        return arp;
    }

    private Amenity readPoiPoint(int left31, int right31, int top31, int bottom31, int px, int py, int zoom, BinaryMapIndexReader.SearchRequest<Amenity> req, PoiRegion region, boolean checkBounds) throws IOException {
        MapObject am = null;
        int x = 0;
        int y = 0;
        StringBuilder retValue = new StringBuilder();
        PoiCategory amenityType = null;
        LinkedList<String> textTags = null;
        block16: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            if (amenityType == null && (tag > 4 || tag == 0)) {
                this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                return null;
            }
            switch (tag) {
                case 0: {
                    ++req.numberOfAcceptedObjects;
                    if (req.radius > 0.0) {
                        LatLon loc = am.getLocation();
                        List locs = (List)req.tiles.get(req.getTileHashOnPath(loc.getLatitude(), loc.getLongitude()));
                        if (locs == null) {
                            return null;
                        }
                        Amenity.AmenityRoutePoint arp = this.dist(am.getLocation(), locs, req.radius);
                        if (arp == null) {
                            return null;
                        }
                        ((Amenity)am).setRoutePoint(arp);
                    }
                    return am;
                }
                case 2: {
                    x = this.codedIS.readSInt32() + (px << 24 - zoom) << 7;
                    continue block16;
                }
                case 3: {
                    y = this.codedIS.readSInt32() + (py << 24 - zoom) << 7;
                    ++req.numberOfVisitedObjects;
                    if (checkBounds && (left31 > x || right31 < x || top31 > y || bottom31 < y)) {
                        this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                        return null;
                    }
                    am = new Amenity();
                    am.setLocation(MapUtils.get31LatitudeY(y), MapUtils.get31LongitudeX(x));
                    continue block16;
                }
                case 5: {
                    int subtypev = this.codedIS.readUInt32();
                    retValue.setLength(0);
                    PoiSubType st = region.getSubtypeFromId(subtypev, retValue);
                    if (st == null) continue block16;
                    ((Amenity)am).setAdditionalInfo(st.name, retValue.toString());
                    continue block16;
                }
                case 14: {
                    int texttypev = this.codedIS.readUInt32();
                    retValue.setLength(0);
                    PoiSubType textt = region.getSubtypeFromId(texttypev, retValue);
                    if (textt == null || !textt.text) continue block16;
                    if (textTags == null) {
                        textTags = new LinkedList<String>();
                    }
                    textTags.add(textt.name);
                    continue block16;
                }
                case 15: {
                    String str = this.codedIS.readString();
                    if (textTags == null || textTags.isEmpty()) continue block16;
                    ((Amenity)am).setAdditionalInfo((String)textTags.poll(), str);
                    continue block16;
                }
                case 4: {
                    int cat = this.codedIS.readUInt32();
                    int subcatId = cat >> 7;
                    int catId = cat & 0x7F;
                    PoiCategory type = this.poiTypes.getOtherPoiCategory();
                    String subtype = "";
                    if (catId < region.categoriesType.size()) {
                        type = region.categoriesType.get(catId);
                        List<String> subcats = region.subcategories.get(catId);
                        if (subcatId < subcats.size()) {
                            subtype = subcats.get(subcatId);
                        }
                    }
                    if (req.poiTypeFilter != null && !req.poiTypeFilter.accept(type, subtype)) continue block16;
                    if (amenityType == null) {
                        amenityType = type;
                        ((Amenity)am).setSubType(subtype);
                        ((Amenity)am).setType(amenityType);
                        continue block16;
                    }
                    ((Amenity)am).setSubType(((Amenity)am).getSubType() + ";" + subtype);
                    continue block16;
                }
                case 8: {
                    am.setId(this.codedIS.readUInt64());
                    continue block16;
                }
                case 6: {
                    am.setName(this.codedIS.readString());
                    continue block16;
                }
                case 7: {
                    am.setEnName(this.codedIS.readString());
                    continue block16;
                }
                case 10: {
                    ((Amenity)am).setOpeningHours(this.codedIS.readString());
                    continue block16;
                }
                case 11: {
                    ((Amenity)am).setSite(this.codedIS.readString());
                    continue block16;
                }
                case 12: {
                    ((Amenity)am).setPhone(this.codedIS.readString());
                    continue block16;
                }
                case 13: {
                    ((Amenity)am).setDescription(this.codedIS.readString());
                    continue block16;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private boolean checkCategories(BinaryMapIndexReader.SearchRequest<Amenity> req, PoiRegion region) throws IOException {
        StringBuilder subType = new StringBuilder();
        block4: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return false;
                }
                case 3: {
                    PoiCategory type = this.poiTypes.getOtherPoiCategory();
                    String subcat = "";
                    int cat = this.codedIS.readUInt32();
                    int subcatId = cat >> 7;
                    int catId = cat & 0x7F;
                    if (catId < region.categoriesType.size()) {
                        type = region.categoriesType.get(catId);
                        List<String> subcats = region.subcategories.get(catId);
                        if (subcatId < subcats.size()) {
                            subcat = subcats.get(subcatId);
                        }
                    }
                    if (!req.poiTypeFilter.accept(type, subcat)) continue block4;
                    this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    return true;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private boolean readBoxField(int left31, int right31, int top31, int bottom31, int px, int py, int pzoom, TIntLongHashMap offsetsMap, TLongHashSet skipTiles, BinaryMapIndexReader.SearchRequest<Amenity> req, PoiRegion region) throws IOException {
        ++req.numberOfReadSubtrees;
        int zoomToSkip = req.zoom == -1 ? 31 : req.zoom + 6;
        boolean checkBox = true;
        boolean existsCategories = false;
        int zoom = pzoom;
        int dy = py;
        int dx = px;
        block9: while (!req.isCancelled()) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return existsCategories;
                }
                case 1: {
                    zoom = this.codedIS.readUInt32() + pzoom;
                    break;
                }
                case 2: {
                    dx = this.codedIS.readSInt32();
                    break;
                }
                case 3: {
                    dy = this.codedIS.readSInt32();
                    break;
                }
                case 4: {
                    if (req.poiTypeFilter == null) {
                        this.skipUnknownField(t);
                        break;
                    }
                    int length = this.codedIS.readRawVarint32();
                    int oldLimit = this.codedIS.pushLimit(length);
                    boolean check = this.checkCategories(req, region);
                    this.codedIS.popLimit(oldLimit);
                    if (!check) {
                        this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                        return false;
                    }
                    existsCategories = true;
                    break;
                }
                case 10: {
                    long val;
                    int x = dx + (px << zoom - pzoom);
                    int y = dy + (py << zoom - pzoom);
                    if (checkBox) {
                        int xL = x << 31 - zoom;
                        int xR = (x + 1 << 31 - zoom) - 1;
                        int yT = y << 31 - zoom;
                        int yB = (y + 1 << 31 - zoom) - 1;
                        if (left31 > xR || xL > right31 || bottom31 < yT || yB < top31) {
                            this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                            return false;
                        }
                        ++req.numberOfAcceptedSubtrees;
                        checkBox = false;
                    }
                    int length = this.readInt();
                    int oldLimit = this.codedIS.pushLimit(length);
                    boolean exists = this.readBoxField(left31, right31, top31, bottom31, x, y, zoom, offsetsMap, skipTiles, req, region);
                    this.codedIS.popLimit(oldLimit);
                    if (skipTiles == null || zoom < zoomToSkip || !exists || !skipTiles.contains(val = (long)x >> zoom - zoomToSkip << zoomToSkip | (long)y >> zoom - zoomToSkip)) continue block9;
                    this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    return true;
                }
                case 14: {
                    int x = dx + (px << zoom - pzoom);
                    int y = dy + (py << zoom - pzoom);
                    boolean read = true;
                    if (req.tiles != null) {
                        long zx = x << 16 - zoom;
                        long zy = y << 16 - zoom;
                        read = req.tiles.contains((zx << 16) + zy);
                    }
                    int offset = this.readInt();
                    if (!read) continue block9;
                    if (skipTiles != null && zoom >= zoomToSkip) {
                        long valSkip = (long)x >> zoom - zoomToSkip << zoomToSkip | (long)y >> zoom - zoomToSkip;
                        offsetsMap.put(offset, valSkip);
                        skipTiles.add(valSkip);
                        break;
                    }
                    offsetsMap.put(offset, -1L);
                    break;
                }
                default: {
                    this.skipUnknownField(t);
                }
            }
        }
        return false;
    }

    public static class PoiRegion
    extends BinaryIndexPart {
        List<String> categories = new ArrayList<String>();
        List<PoiCategory> categoriesType = new ArrayList<PoiCategory>();
        List<List<String>> subcategories = new ArrayList<List<String>>();
        List<PoiSubType> subTypes = new ArrayList<PoiSubType>();
        double leftLongitude;
        double rightLongitude;
        double topLatitude;
        double bottomLatitude;

        public double getLeftLongitude() {
            return this.leftLongitude;
        }

        public PoiSubType getSubtypeFromId(int id2, StringBuilder returnValue) {
            int sl;
            int tl;
            if (id2 % 2 == 0) {
                tl = id2 >> 1 & 0x1F;
                sl = id2 >> 6;
            } else {
                tl = id2 >> 1 & 0xFFFF;
                sl = id2 >> 16;
            }
            if (this.subTypes.size() > tl) {
                PoiSubType st = this.subTypes.get(tl);
                if (st.text) {
                    return st;
                }
                if (st.possibleValues != null && st.possibleValues.size() > sl) {
                    returnValue.append(st.possibleValues.get(sl));
                    return st;
                }
            }
            return null;
        }

        public double getRightLongitude() {
            return this.rightLongitude;
        }

        public double getTopLatitude() {
            return this.topLatitude;
        }

        public double getBottomLatitude() {
            return this.bottomLatitude;
        }
    }

    public static class PoiSubType {
        boolean text;
        String name;
        List<String> possibleValues = null;
    }
}

