/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.api.actions.Savable;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.SourceGroupModifier;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.gsf.testrunner.api.SelfResizingPanel;
import org.netbeans.modules.gsf.testrunner.api.UnitTestsUsage;
import org.netbeans.modules.gsf.testrunner.plugin.CommonPlugin;
import org.netbeans.modules.java.testrunner.GuiUtils;
import org.netbeans.modules.junit.JUnitLibraryComparator;
import org.netbeans.modules.junit.JUnitVersion;
import org.netbeans.modules.junit.ProgressIndicator;
import org.netbeans.modules.junit.TestCreator;
import org.netbeans.modules.junit.TestabilityResult;
import org.netbeans.modules.junit.TopClassFinder;
import org.netbeans.modules.junit.api.JUnitSettings;
import org.netbeans.modules.junit.api.JUnitTestUtil;
import org.netbeans.modules.junit.api.JUnitUtils;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class DefaultPlugin
extends JUnitPlugin {
    private static final Logger LOG_JUNIT_VER = Logger.getLogger(DefaultPlugin.class.getName() + "_JUnit_version_handling");
    private static final String JUNIT3_SPECIFIC = "junit/awtui/TestRunner.class";
    private static final String JUNIT4_SPECIFIC = "org/junit/Test.class";
    private static final String JUNIT5_SPECIFIC = "org/junit/platform/commons/annotation/Testable.class";
    private static JUnitVersion junitVer;
    private static final String templatePropBeforeClass = "classSetUp";
    private static final String templatePropAfterClass = "classTearDown";
    private static final String templatePropBefore = "methodSetUp";
    private static final String templatePropAfter = "methodTearDown";
    private static final String templatePropCodeHints = "sourceCodeHint";
    private static final String templatePropMethodPH = "testMethodsPlaceholder";
    private static final String templatePropUseAnnotations = "useAnnotations";
    private static final String templatePropClassNames = "classNames";
    private static final String templatePropClasses = "classes";
    private static ResourceBundle bundle;
    private static boolean generatingIntegrationTest;
    private static final String PROJECT_PROPERTIES_PATH = "nbproject/project.properties";

    public static void logJUnitUsage(URI projectURI) {
        String version = "";
        if (junitVer == null) {
            Project project = FileOwnerQuery.getOwner((URI)projectURI);
            ClassPath classPath = DefaultPlugin.getTestClassPath(project);
            if (classPath != null) {
                if (classPath.findResource(JUNIT5_SPECIFIC) != null) {
                    version = JUnitVersion.JUNIT5.toString();
                } else if (classPath.findResource(JUNIT4_SPECIFIC) != null) {
                    version = JUnitVersion.JUNIT4.toString();
                } else if (classPath.findResource(JUNIT3_SPECIFIC) != null) {
                    version = JUnitVersion.JUNIT3.toString();
                }
            }
        } else {
            version = junitVer.toString();
        }
        UnitTestsUsage.getInstance().logUnitTestUsage(projectURI, version);
    }

    protected boolean canCreateTests(FileObject ... fileObjects) {
        if (fileObjects.length == 0) {
            return false;
        }
        FileObject firstFile = fileObjects[0];
        SourceGroup sourceGroup = DefaultPlugin.findSourceGroup(firstFile);
        if (sourceGroup == null) {
            return false;
        }
        FileObject rootFolder = sourceGroup.getRootFolder();
        if (UnitTestForSourceQuery.findUnitTests((FileObject)rootFolder).length == 0) {
            return false;
        }
        if (fileObjects.length == 1) {
            return true;
        }
        for (int i = 1; i < fileObjects.length; ++i) {
            FileObject fileObj = fileObjects[i];
            if (FileUtil.isParentOf((FileObject)rootFolder, (FileObject)fileObj) && sourceGroup.contains(fileObj)) continue;
            return false;
        }
        return true;
    }

    private static SourceGroup findSourceGroup(FileObject file) {
        SourceGroup[] srcGrps;
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        if (project == null) {
            return null;
        }
        Sources src = ProjectUtils.getSources((Project)project);
        for (SourceGroup srcGrp : srcGrps = src.getSourceGroups("java")) {
            FileObject rootFolder = srcGrp.getRootFolder();
            if (file != rootFolder && !FileUtil.isParentOf((FileObject)rootFolder, (FileObject)file) || !srcGrp.contains(file)) continue;
            return srcGrp;
        }
        return null;
    }

    protected CommonPlugin.Location getTestLocation(CommonPlugin.Location sourceLocation) {
        String testResName;
        FileObject fileObj = sourceLocation.getFileObject();
        ClassPath srcCp = ClassPath.getClassPath((FileObject)fileObj, (String)"classpath/source");
        if (srcCp == null) {
            return null;
        }
        String baseResName = srcCp.getResourceName(fileObj, '/', false);
        if (baseResName == null) {
            return null;
        }
        String string = testResName = !fileObj.isFolder() ? DefaultPlugin.getTestResName(baseResName, fileObj.getExt()) : DefaultPlugin.getSuiteResName(baseResName);
        assert (testResName != null);
        return DefaultPlugin.getOppositeLocation(sourceLocation, srcCp, testResName, true);
    }

    protected CommonPlugin.Location getTestedLocation(CommonPlugin.Location testLocation) {
        ClassPath srcCp;
        FileObject fileObj = testLocation.getFileObject();
        if (fileObj.isFolder() || (srcCp = ClassPath.getClassPath((FileObject)fileObj, (String)"classpath/source")) == null) {
            return null;
        }
        String baseResName = srcCp.getResourceName(fileObj, '/', false);
        if (baseResName == null) {
            return null;
        }
        String srcResName = DefaultPlugin.getSrcResName(baseResName, fileObj.getExt());
        if (srcResName == null) {
            return null;
        }
        return DefaultPlugin.getOppositeLocation(testLocation, srcCp, srcResName, false);
    }

    private static CommonPlugin.Location getOppositeLocation(CommonPlugin.Location sourceLocation, ClassPath fileObjCp, String oppoResourceName, boolean sourceToTest) {
        URL[] oppoRootsURLs;
        FileObject fileObj = sourceLocation.getFileObject();
        FileObject fileObjRoot = fileObjCp.findOwnerRoot(fileObj);
        if (fileObjRoot == null) {
            return null;
        }
        URL[] uRLArray = oppoRootsURLs = sourceToTest ? UnitTestForSourceQuery.findUnitTests((FileObject)fileObjRoot) : UnitTestForSourceQuery.findSources((FileObject)fileObjRoot);
        if (oppoRootsURLs == null || oppoRootsURLs.length == 0) {
            return null;
        }
        ClassPath oppoRootsClassPath = ClassPathSupport.createClassPath((URL[])oppoRootsURLs);
        List oppoFiles = oppoRootsClassPath.findAllResources(oppoResourceName);
        if (oppoFiles.isEmpty()) {
            return null;
        }
        return new CommonPlugin.Location((FileObject)oppoFiles.get(0));
    }

    private static String getTestResName(String baseResName, String ext) {
        StringBuilder buf = new StringBuilder(baseResName.length() + ext.length() + 10);
        buf.append(baseResName).append("Test");
        if (ext.length() != 0) {
            buf.append('.').append(ext);
        }
        return buf.toString();
    }

    private static String getSuiteResName(String baseResName) {
        if (baseResName.length() == 0) {
            return JUnitSettings.getDefault().getRootSuiteClassName();
        }
        String suiteSuffix = "Suite";
        String lastNamePart = baseResName.substring(baseResName.lastIndexOf(47) + 1);
        StringBuilder buf = new StringBuilder(baseResName.length() + lastNamePart.length() + "Suite".length() + 6);
        buf.append(baseResName).append('/');
        buf.append(Character.toUpperCase(lastNamePart.charAt(0))).append(lastNamePart.substring(1));
        buf.append("Suite");
        buf.append(".java");
        return buf.toString();
    }

    private static String getSrcResName(String testResName, String ext) {
        if (!testResName.endsWith("Test")) {
            return null;
        }
        StringBuilder buf = new StringBuilder(testResName.length() + ext.length());
        buf.append(testResName.substring(0, testResName.length() - 4));
        if (ext.length() != 0) {
            buf.append('.').append(ext);
        }
        return buf.toString();
    }

    private static String getTestClassName(String baseClassName) {
        return baseClassName + "Test";
    }

    private static String getIntegrationTestClassName(String baseClassName) {
        return baseClassName + "IT";
    }

    private static String getSourceClassName(String testClassName) {
        String suffix = "Test";
        int suffixLen = "Test".length();
        return testClassName.length() > suffixLen && testClassName.endsWith("Test") ? testClassName.substring(0, testClassName.length() - suffixLen) : null;
    }

    private static String getTestMethodName(String baseMethodName) {
        String prefix = "test";
        int prefixLen = "test".length();
        StringBuffer buf = new StringBuffer(prefixLen + baseMethodName.length());
        buf.append("test").append(baseMethodName);
        buf.setCharAt(prefixLen, Character.toUpperCase(baseMethodName.charAt(0)));
        return buf.toString();
    }

    private static String getSourceMethodName(String testMethodName) {
        String prefix = "test";
        int prefixLen = "test".length();
        return testMethodName.length() > prefixLen && testMethodName.startsWith("test") ? new StringBuilder(testMethodName.length() - prefixLen).append(Character.toLowerCase(testMethodName.charAt(prefixLen))).append(testMethodName.substring(prefixLen + 1)).toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject[] createTests(FileObject[] filesToTest, FileObject targetRoot, Map<CommonPlugin.CreateTestParam, Object> params) {
        FileObject[] createdFiles;
        CreationResults results;
        File projectFile;
        Project project = FileOwnerQuery.getOwner((FileObject)targetRoot);
        if (project != null && (projectFile = FileUtil.toFile((FileObject)project.getProjectDirectory())) != null) {
            DefaultPlugin.logJUnitUsage(Utilities.toURI((File)projectFile));
        }
        ProgressIndicator progress = new ProgressIndicator();
        progress.show();
        String msg = NbBundle.getMessage(DefaultPlugin.class, (String)"MSG_StatusBar_CreateTest_Begin");
        progress.displayStatusText(msg);
        generatingIntegrationTest = Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_GENERATE_INTEGRATION_TEST));
        TestCreator testCreator = new TestCreator(params, junitVer);
        try {
            Object doSuiteTempl;
            DataObject doTestTempl;
            String suiteTemplateId;
            String templateId;
            boolean forTestSuite = filesToTest != null && filesToTest.length != 0 && (filesToTest.length > 1 || !filesToTest[0].isData());
            switch (junitVer) {
                case JUNIT3: {
                    templateId = "PROP_junit3_testClassTemplate";
                    suiteTemplateId = forTestSuite ? "PROP_junit3_testSuiteTemplate" : null;
                    break;
                }
                case JUNIT4: {
                    templateId = "PROP_junit4_testClassTemplate";
                    suiteTemplateId = forTestSuite ? "PROP_junit4_testSuiteTemplate" : null;
                    break;
                }
                case JUNIT5: {
                    templateId = "PROP_junit5_testClassTemplate";
                    suiteTemplateId = null;
                    break;
                }
                default: {
                    assert (false);
                    templateId = null;
                    suiteTemplateId = null;
                }
            }
            DataObject dataObject = doTestTempl = templateId != null ? DefaultPlugin.loadTestTemplate(templateId) : null;
            if (doTestTempl == null) {
                FileObject[] fileObjectArray = null;
                return fileObjectArray;
            }
            Object object = doSuiteTempl = suiteTemplateId != null ? DefaultPlugin.loadTestTemplate(suiteTemplateId) : null;
            if (forTestSuite && doSuiteTempl == null) {
                FileObject[] fileObjectArray = null;
                return fileObjectArray;
            }
            Map<String, Boolean> templateParams = DefaultPlugin.createTemplateParams(params);
            DefaultPlugin.setAnnotationsSupport(targetRoot, junitVer, templateParams);
            if (filesToTest == null || filesToTest.length == 0) {
                DefaultPlugin.addTemplateParamEntry(params, CommonPlugin.CreateTestParam.INC_CODE_HINT, templateParams, templatePropMethodPH);
                String testClassName = (String)params.get(CommonPlugin.CreateTestParam.CLASS_NAME);
                assert (testClassName != null);
                results = new CreationResults(1);
                DataObject testDataObj = this.createEmptyTest(targetRoot, testClassName, testCreator, templateParams, doTestTempl);
                if (testDataObj != null) {
                    results.addCreated(testDataObj);
                }
            } else {
                ClassPath testClassPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{targetRoot});
                if (!forTestSuite) {
                    String testClassName = (String)params.get(CommonPlugin.CreateTestParam.CLASS_NAME);
                    if (testClassName == null) {
                        String srcClassName = ClassPath.getClassPath((FileObject)filesToTest[0], (String)"classpath/source").getResourceName(filesToTest[0], '.', false);
                        testClassName = generatingIntegrationTest ? DefaultPlugin.getIntegrationTestClassName(srcClassName) : DefaultPlugin.getTestClassName(srcClassName);
                    }
                    try {
                        results = DefaultPlugin.createSingleTest(filesToTest[0], testClassName, testCreator, templateParams, doTestTempl, testClassPath, TestabilityResult.NO_TESTEABLE_METHODS.getReasonValue(), null, progress);
                    }
                    catch (CreationError ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                        results = new CreationResults(1);
                    }
                } else {
                    results = new CreationResults();
                    for (FileObject fileToTest : filesToTest) {
                        try {
                            results.combine(DefaultPlugin.createTests(fileToTest, testCreator, templateParams, doTestTempl, (DataObject)doSuiteTempl, testClassPath, null, progress));
                        }
                        catch (CreationError e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                    }
                }
            }
        }
        finally {
            progress.hide();
        }
        Set<TestabilityResult.SkippedClass> skipped = results.getSkipped();
        Set<DataObject> created = results.getCreated();
        if (!skipped.isEmpty() || created.isEmpty()) {
            String finalMessage;
            String message = "";
            if (skipped.size() == 1) {
                TestabilityResult.SkippedClass skippedClass = skipped.iterator().next();
                message = NbBundle.getMessage(DefaultPlugin.class, (String)"MSG_skipped_class", (Object)skippedClass.clsName, (Object)DefaultPlugin.strReason(skippedClass.reason, "COMMA", "AND"));
            } else {
                TestabilityResult reason = TestabilityResult.OK;
                for (TestabilityResult.SkippedClass sc : skipped) {
                    reason = TestabilityResult.combine(reason, sc.reason);
                }
                message = NbBundle.getMessage(DefaultPlugin.class, (String)"MSG_skipped_classes", (Object)DefaultPlugin.strReason(reason, "COMMA", "OR"));
            }
            String noMessage = "";
            if (created.isEmpty()) {
                noMessage = NbBundle.getMessage(DefaultPlugin.class, (String)"MSG_No_test_created");
            }
            String string = finalMessage = message.isEmpty() ? noMessage : message.concat("\n\n").concat(noMessage);
            if (!finalMessage.isEmpty()) {
                Mutex.EVENT.writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        JUnitTestUtil.notifyUser(finalMessage, 1);
                    }
                });
            }
        }
        if (created.isEmpty()) {
            createdFiles = new FileObject[]{};
        } else {
            createdFiles = new FileObject[created.size()];
            int i = 0;
            for (DataObject dObj : created) {
                createdFiles[i++] = dObj.getPrimaryFile();
            }
        }
        return createdFiles;
    }

    public static final Map<String, Boolean> createTemplateParams(Map<CommonPlugin.CreateTestParam, Object> params) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(7);
        DefaultPlugin.addTemplateParamEntry(params, CommonPlugin.CreateTestParam.INC_CLASS_SETUP, result, templatePropBeforeClass);
        DefaultPlugin.addTemplateParamEntry(params, CommonPlugin.CreateTestParam.INC_CLASS_TEAR_DOWN, result, templatePropAfterClass);
        DefaultPlugin.addTemplateParamEntry(params, CommonPlugin.CreateTestParam.INC_SETUP, result, templatePropBefore);
        DefaultPlugin.addTemplateParamEntry(params, CommonPlugin.CreateTestParam.INC_TEAR_DOWN, result, templatePropAfter);
        DefaultPlugin.addTemplateParamEntry(params, CommonPlugin.CreateTestParam.INC_CODE_HINT, result, templatePropCodeHints);
        return result;
    }

    private static void addTemplateParamEntry(Map<CommonPlugin.CreateTestParam, Object> srcParams, CommonPlugin.CreateTestParam srcParamKey, Map<String, Boolean> templParams, String templParamKey) {
        Object value = srcParams.get(srcParamKey);
        if (value instanceof Boolean) {
            templParams.put(templParamKey, (Boolean)Boolean.class.cast(value));
        }
    }

    public boolean setupJUnitVersionByProject(FileObject targetFolder) {
        return this.createTestActionCalled(new FileObject[]{targetFolder});
    }

    protected boolean createTestActionCalled(FileObject[] selectedFiles) {
        boolean storeSettings;
        LOG_JUNIT_VER.finer("createTestActionCalled(...)");
        Project project = FileOwnerQuery.getOwner((FileObject)selectedFiles[0]);
        assert (project != null);
        try {
            try {
                storeSettings = this.readProjectSettingsJUnitVer(project);
            }
            catch (IllegalStateException ex) {
                if (SourceGroupModifier.createSourceGroup((Project)project, (String)"java", (String)"test") != null) {
                    storeSettings = this.readProjectSettingsJUnitVer(project);
                }
                throw ex;
            }
            if (!storeSettings) {
                LOG_JUNIT_VER.finest(" - will not be able to store JUnit version settings");
            }
        }
        catch (IllegalStateException ex) {
            String projectName = ProjectUtils.getInformation((Project)project).getDisplayName();
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_NoTestFolderFoundInProject", (Object)projectName), 2));
            return false;
        }
        if (junitVer != null) {
            switch (junitVer) {
                case JUNIT3: {
                    return true;
                }
                case JUNIT4: {
                    String sourceLevel = JUnitTestUtil.getSourceLevel(selectedFiles[0]);
                    if (sourceLevel == null) {
                        return true;
                    }
                    if (sourceLevel.compareTo("1.5") >= 0) {
                        return true;
                    }
                    if (this.askUserLastWasJUnit4NowSource14(sourceLevel)) {
                        junitVer = JUnitVersion.JUNIT3;
                        if (storeSettings) {
                            return this.storeProjectSettingsJUnitVer(project);
                        }
                        return true;
                    }
                    return false;
                }
                case JUNIT5: {
                    String sourceLevel = JUnitTestUtil.getSourceLevel(selectedFiles[0]);
                    if (sourceLevel == null) {
                        return true;
                    }
                    return sourceLevel.compareTo("1.8") >= 0;
                }
            }
            assert (false);
            return false;
        }
        this.readSystemSettingsJUnitVer();
        if (junitVer != null) {
            switch (junitVer) {
                case JUNIT3: {
                    if (storeSettings) {
                        return this.storeProjectSettingsJUnitVer(project);
                    }
                    return true;
                }
                case JUNIT4: {
                    String sourceLevel = JUnitTestUtil.getSourceLevel(selectedFiles[0]);
                    if (sourceLevel != null && sourceLevel.compareTo("1.5") >= 0) {
                        if (storeSettings) {
                            return this.storeProjectSettingsJUnitVer(project);
                        }
                        return true;
                    }
                    if (sourceLevel == null) {
                        String msgKey = "MSG_select_junit_version_srclvl_unknown";
                        this.loadJUnitToUseFromPropertiesFile(project);
                        if (junitVer != null && storeSettings) {
                            return this.storeProjectSettingsJUnitVer(project);
                        }
                        return junitVer != null;
                    }
                    if (this.informUserOnlyJUnit3Applicable(sourceLevel)) {
                        junitVer = JUnitVersion.JUNIT3;
                        if (storeSettings) {
                            return this.storeProjectSettingsJUnitVer(project);
                        }
                        return true;
                    }
                    return false;
                }
                case JUNIT5: {
                    String sourceLevel = JUnitTestUtil.getSourceLevel(selectedFiles[0]);
                    if (sourceLevel != null && sourceLevel.compareTo("1.8") >= 0) {
                        if (storeSettings) {
                            return this.storeProjectSettingsJUnitVer(project);
                        }
                        return true;
                    }
                    return false;
                }
            }
            assert (false);
            return false;
        }
        boolean defaultToJUnit5 = false;
        String sourceLevel = JUnitTestUtil.getSourceLevel(selectedFiles[0]);
        if (sourceLevel == null) {
            String msgKey = "MSG_select_junit_version_srclvl_unknown";
            boolean offerJUnit4 = true;
            boolean showSourceLevelReqs = true;
        } else {
            String msgKey = "MSG_select_junit_version";
            defaultToJUnit5 = sourceLevel.compareTo("1.8") >= 0;
            boolean offerJUnit4 = sourceLevel.compareTo("1.5") >= 0;
            boolean showSourceLevelReqs = !offerJUnit4;
        }
        this.loadJUnitToUseFromPropertiesFile(project);
        if (junitVer == null) {
            junitVer = defaultToJUnit5 ? JUnitVersion.JUNIT5 : JUnitVersion.JUNIT4;
        }
        if (junitVer != null && storeSettings) {
            return this.storeProjectSettingsJUnitVer(project);
        }
        return junitVer != null;
    }

    private boolean askUserLastWasJUnit4NowSource14(String sourceLevel) {
        JComponent msg = this.createMessageComponent("MSG_last_was_junit4_what_now", sourceLevel);
        String selectOption = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"LBL_create_junit3_tests");
        Object answer = DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)DefaultPlugin.wrapDialogContent(msg), NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"LBL_title_cannot_use_junit4"), true, new Object[]{selectOption, NotifyDescriptor.CANCEL_OPTION}, (Object)selectOption, 0, (HelpCtx)null, (ActionListener)null));
        return answer == selectOption;
    }

    private boolean informUserOnlyJUnit3Applicable(String sourceLevel) {
        JComponent msg = this.createMessageComponent("MSG_cannot_use_default_junit4", sourceLevel);
        JButton button = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)button, (String)bundle.getString("LBL_Select"));
        button.getAccessibleContext().setAccessibleName("AN_create_junit3_tests");
        button.getAccessibleContext().setAccessibleDescription("AD_create_junit3_tests");
        Object answer = DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)DefaultPlugin.wrapDialogContent(msg), NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"LBL_title_cannot_use_junit4"), true, new Object[]{button, NotifyDescriptor.CANCEL_OPTION}, (Object)button, 0, (HelpCtx)null, (ActionListener)null));
        return answer == button;
    }

    private Properties getProjectProperties(FileObject projectDir) throws IOException {
        FileObject projectProperties = FileUtil.createData((FileObject)projectDir, (String)PROJECT_PROPERTIES_PATH);
        InputStream propertiesIS = projectProperties.getInputStream();
        Properties props = new Properties();
        props.load(propertiesIS);
        propertiesIS.close();
        return props;
    }

    private void loadJUnitToUseFromPropertiesFile(Project project) {
        final FileObject projectDir = project.getProjectDirectory();
        ProjectManager.mutex().postReadRequest(new Runnable(){

            @Override
            public void run() {
                try {
                    Properties props = DefaultPlugin.this.getProjectProperties(projectDir);
                    String property = props.getProperty("junit.selected.version");
                    junitVer = property == null ? null : (property.equals("3") ? JUnitVersion.JUNIT3 : (property.equals("4") ? JUnitVersion.JUNIT4 : JUnitVersion.JUNIT5));
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    private JComponent createMessageComponent(String msgKey, String ... args) {
        String message = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)msgKey, (Object[])args);
        return GuiUtils.createMultilineLabel((String)message);
    }

    private static JComponent wrapDialogContent(JComponent comp) {
        return DefaultPlugin.wrapDialogContent(comp, true);
    }

    private static JComponent wrapDialogContent(JComponent comp, boolean selfResizing) {
        JComponent result;
        if (comp.getBorder() != null || selfResizing) {
            result = selfResizing ? new SelfResizingPanel() : new JPanel();
            result.setLayout(new GridLayout());
            result.add(comp);
        } else {
            result = comp;
        }
        result.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        result.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_title_select_generator"));
        return result;
    }

    private boolean readProjectSettingsJUnitVer(Project project) throws IllegalStateException {
        assert (project != null);
        if (LOG_JUNIT_VER.isLoggable(Level.FINER)) {
            LOG_JUNIT_VER.finer("readProjectSettingsJUnitVer(" + ProjectUtils.getInformation((Project)project).getDisplayName() + ')');
        }
        junitVer = null;
        ClassPath classPath = DefaultPlugin.getTestClassPath(project);
        this.loadJUnitToUseFromPropertiesFile(project);
        if (junitVer == null) {
            boolean hasJUnit5;
            boolean hasJUnit4;
            boolean hasJUnit3;
            if (classPath != null) {
                hasJUnit3 = classPath.findResource(JUNIT3_SPECIFIC) != null;
                hasJUnit4 = classPath.findResource(JUNIT4_SPECIFIC) != null;
                hasJUnit5 = classPath.findResource(JUNIT5_SPECIFIC) != null;
            } else {
                hasJUnit3 = false;
                hasJUnit4 = false;
                hasJUnit5 = false;
            }
            if (hasJUnit3 || hasJUnit4 || hasJUnit5) {
                JUnitVersion jUnitVersion = hasJUnit3 ? JUnitVersion.JUNIT3 : (junitVer = hasJUnit4 ? JUnitVersion.JUNIT4 : JUnitVersion.JUNIT5);
                if (LOG_JUNIT_VER.isLoggable(Level.FINEST)) {
                    LOG_JUNIT_VER.finest(" - detected version " + (Object)((Object)junitVer));
                }
            } else {
                LOG_JUNIT_VER.finest(" - no version detected");
            }
        } else if (LOG_JUNIT_VER.isLoggable(Level.FINEST)) {
            LOG_JUNIT_VER.finest(" - detected version " + (Object)((Object)junitVer));
        }
        return classPath != null;
    }

    private static ClassPath getTestClassPath(Project project) throws IllegalStateException {
        ClassPathProvider cpProvider;
        Collection<FileObject> testFolders;
        assert (project != null);
        if (LOG_JUNIT_VER.isLoggable(Level.FINER)) {
            LOG_JUNIT_VER.finer("getTestClassPath(" + ProjectUtils.getInformation((Project)project).getDisplayName() + ')');
        }
        if ((testFolders = JUnitUtils.getTestFolders(project)).isEmpty()) {
            LOG_JUNIT_VER.finest(" - no unit test folders found");
        }
        if ((cpProvider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class)) == null) {
            LOG_JUNIT_VER.finest(" - ClassPathProvider not found");
            return null;
        }
        for (FileObject testRoot : testFolders) {
            ClassPath testClassPath = cpProvider.findClassPath(testRoot, "classpath/compile");
            if (testClassPath == null) continue;
            if (LOG_JUNIT_VER.isLoggable(Level.FINEST)) {
                LOG_JUNIT_VER.finest(" - returning: " + testClassPath);
            }
            return testClassPath;
        }
        LOG_JUNIT_VER.finest(" - no compile classpath for unit tests found");
        return null;
    }

    private boolean storeProjectSettingsJUnitVer(final Project project) {
        Library[] libraries;
        boolean hasJUnit5;
        boolean hasJUnit4;
        boolean hasJUnit3;
        ClassPath classPath;
        assert (junitVer != null);
        if (LOG_JUNIT_VER.isLoggable(Level.FINER)) {
            LOG_JUNIT_VER.finer("storeProjectSettignsJUnitVer(" + ProjectUtils.getInformation((Project)project).getDisplayName() + ')');
        }
        if ((classPath = DefaultPlugin.getTestClassPath(project)) != null) {
            hasJUnit3 = classPath.findResource(JUNIT3_SPECIFIC) != null;
            hasJUnit4 = classPath.findResource(JUNIT4_SPECIFIC) != null;
            hasJUnit5 = classPath.findResource(JUNIT5_SPECIFIC) != null;
        } else {
            hasJUnit3 = false;
            hasJUnit4 = false;
            hasJUnit5 = false;
        }
        Pattern pattern = Pattern.compile("^junit(?:_|\\W)+([345])(?:\\b|_).*");
        JUnitLibraryComparator libraryComparator = null;
        Library libraryToAdd = null;
        ArrayList<Library> librariesToRemove = null;
        Library libraryHamcrest = null;
        LOG_JUNIT_VER.finest(" - checking libraries:");
        for (Library library : libraries = LibraryManager.getDefault().getLibraries()) {
            String name = library.getName().toLowerCase();
            if (LOG_JUNIT_VER.isLoggable(Level.FINEST)) {
                LOG_JUNIT_VER.finest("    " + name);
            }
            if (name.equals("hamcrest")) {
                libraryHamcrest = library;
                continue;
            }
            if (!name.startsWith("junit")) {
                LOG_JUNIT_VER.finest("     - not a JUnit library");
                continue;
            }
            boolean add = false;
            boolean remove = false;
            String verNumToAdd = junitVer == JUnitVersion.JUNIT3 && !hasJUnit3 ? "3" : (junitVer == JUnitVersion.JUNIT4 && !hasJUnit4 ? "4" : (junitVer == JUnitVersion.JUNIT5 && !hasJUnit5 ? "5" : null));
            String verNumToRemove = "3";
            if (name.equals("junit")) {
                add = verNumToAdd == "3";
                remove = verNumToRemove == "3";
            } else {
                Matcher matcher = pattern.matcher(name);
                if (matcher.matches()) {
                    String verNum = matcher.group(1);
                    add = verNum.equals(verNumToAdd);
                    remove = verNum.equals(verNumToRemove);
                }
            }
            if (add) {
                LOG_JUNIT_VER.finest("     - to be added");
                if (libraryToAdd == null) {
                    libraryToAdd = library;
                } else {
                    LOG_JUNIT_VER.finest("        - will be compared:");
                    if (libraryComparator == null) {
                        libraryComparator = new JUnitLibraryComparator();
                    }
                    if (libraryComparator.compare(libraryToAdd, library) > 0) {
                        LOG_JUNIT_VER.finest("        - it won");
                        libraryToAdd = library;
                    } else {
                        LOG_JUNIT_VER.finest("        - it lost");
                    }
                }
            }
            if (!remove) continue;
            LOG_JUNIT_VER.finest("     - to be removed");
            if (librariesToRemove == null) {
                librariesToRemove = new ArrayList<Library>(2);
            }
            librariesToRemove.add(library);
        }
        if (libraryToAdd == null && librariesToRemove == null) {
            return true;
        }
        final List<FileObject> projectArtifacts = DefaultPlugin.getProjectTestArtifacts(project);
        if (projectArtifacts.isEmpty()) {
            DefaultPlugin.displayMessage("MSG_cannot_set_junit_ver", 2);
            return true;
        }
        final Library[] libsToAdd = libraryToAdd != null ? (junitVer == JUnitVersion.JUNIT5 ? new Library[]{libraryToAdd} : new Library[]{libraryToAdd, libraryHamcrest}) : null;
        final Library[] libsToRemove = librariesToRemove != null ? librariesToRemove.toArray(new Library[librariesToRemove.size()]) : null;
        assert (libsToAdd != null || libsToRemove != null);
        class LibrarySetModifier
        implements Runnable {
            LibrarySetModifier() {
            }

            @Override
            public void run() {
                boolean modified = false;
                try {
                    if (libsToAdd != null) {
                        for (FileObject prjArtifact : projectArtifacts) {
                            modified |= ProjectClassPathModifier.addLibraries((Library[])libsToAdd, (FileObject)prjArtifact, (String)"classpath/compile");
                        }
                    }
                    if (libsToRemove != null) {
                        for (FileObject prjArtifact : projectArtifacts) {
                            modified |= ProjectClassPathModifier.removeLibraries((Library[])libsToRemove, (FileObject)prjArtifact, (String)"classpath/compile");
                        }
                    }
                }
                catch (UnsupportedOperationException ex) {
                    String prjName = ProjectUtils.getInformation((Project)project).getDisplayName();
                    ErrorManager.getDefault().log(16, "Project " + prjName + ": Could not modify set of JUnit libraries - operation not supported by the project.");
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(65536, (Throwable)ex);
                }
                if (modified) {
                    try {
                        ProjectManager.getDefault().saveProject(project);
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify(65536, (Throwable)ex);
                    }
                }
            }
        }
        ProjectManager.mutex().writeAccess((Runnable)new LibrarySetModifier());
        return true;
    }

    private static void displayMessage(String bundleKey, int msgType) {
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DefaultPlugin.class, (String)bundleKey), msgType));
    }

    private static List<FileObject> getProjectTestArtifacts(Project project) {
        Collection<FileObject> testFolders;
        assert (project != null);
        ClassPathProvider cpProvider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        if (cpProvider == null) {
            Collections.emptyList();
        }
        if ((testFolders = JUnitUtils.getTestFolders(project)).isEmpty()) {
            Collections.emptyList();
        }
        List<FileObject> result = null;
        for (FileObject testRoot : testFolders) {
            ClassPath testClassPath = cpProvider.findClassPath(testRoot, "classpath/compile");
            if (testClassPath == null) continue;
            if (result == null) {
                if (testFolders.size() == 1) {
                    return Collections.singletonList(testRoot);
                }
                result = new ArrayList<FileObject>(3);
            }
            result.add(testRoot);
        }
        return result != null ? result : Collections.emptyList();
    }

    private void readSystemSettingsJUnitVer() {
        junitVer = null;
    }

    private DataObject createEmptyTest(FileObject targetRoot, String testClassName, TestCreator testCreator, Map<String, ? extends Object> templateParams, DataObject templateDataObj) {
        if (testClassName == null) {
            throw new IllegalArgumentException("testClassName = null");
        }
        DataObject testDataObj = null;
        try {
            DataFolder targetFolderDataObj = DataFolder.findFolder((FileObject)targetRoot);
            testDataObj = templateDataObj.createFromTemplate(targetFolderDataObj, testClassName, templateParams);
            testCreator.createEmptyTest(testDataObj.getPrimaryFile());
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return testDataObj;
    }

    private static CreationResults createSingleTest(FileObject sourceFile, String requestedTestClassName, TestCreator testCreator, Map<String, ? extends Object> templateParams, DataObject templateDataObj, ClassPath testClassPath, long skipTestabilityResultMask, List<String> parentSuite, ProgressIndicator progress) throws CreationError {
        List<ElementHandle<TypeElement>> testable;
        List<TestabilityResult.SkippedClass> nonTestable;
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)sourceFile);
            if (javaSource == null) {
                return CreationResults.EMPTY;
            }
            if (skipTestabilityResultMask != 0L) {
                nonTestable = new ArrayList();
                testable = TopClassFinder.findTestableTopClasses(javaSource, testCreator, nonTestable, skipTestabilityResultMask);
            } else {
                nonTestable = Collections.emptyList();
                testable = TopClassFinder.findTopClasses(javaSource);
            }
        }
        catch (IOException ex) {
            throw new CreationError(ex);
        }
        CreationResults result = new CreationResults(4);
        if (!nonTestable.isEmpty()) {
            result.addSkipped(nonTestable);
        }
        if (!testable.isEmpty()) {
            boolean mainClassProcessed = false;
            try {
                for (ElementHandle<TypeElement> clsToTest : testable) {
                    boolean isNew;
                    String testClassName;
                    String srcClassNameFull = clsToTest.getQualifiedName();
                    if (requestedTestClassName != null && !mainClassProcessed && JUnitTestUtil.getSimpleName(srcClassNameFull).equals(sourceFile.getName())) {
                        testClassName = requestedTestClassName;
                        mainClassProcessed = true;
                    } else {
                        testClassName = generatingIntegrationTest ? JUnitTestUtil.getIntegrationTestClassName(srcClassNameFull) : JUnitTestUtil.getTestClassName(srcClassNameFull);
                    }
                    String testResourceName = testClassName.replace('.', '/');
                    DataObject testDataObj = null;
                    FileObject testFile = testClassPath.findResource(testResourceName + ".java");
                    boolean bl = isNew = testFile == null;
                    if (testFile == null) {
                        testDataObj = DefaultPlugin.createTestClass(testClassPath, null, testResourceName, templateDataObj, templateParams);
                        testFile = testDataObj.getPrimaryFile();
                    }
                    testCreator.createSimpleTest(clsToTest, testFile, isNew);
                    if (testDataObj == null) {
                        testDataObj = DataObject.find((FileObject)testFile);
                    }
                    DefaultPlugin.save(testDataObj);
                    result.addCreated(testDataObj);
                    if (parentSuite == null) continue;
                    parentSuite.add(testClassName);
                }
            }
            catch (IOException ex) {
                throw new CreationError(ex);
            }
        }
        return result;
    }

    private static CreationResults createTests(FileObject srcFileObj, TestCreator testCreator, Map<String, ? extends Object> templateParams, DataObject doTestT, DataObject doSuiteT, ClassPath testClassPath, List<String> parentSuite, ProgressIndicator progress) throws CreationError {
        CreationResults results;
        if (srcFileObj.isFolder()) {
            results = new CreationResults();
            LinkedList<String> mySuite = new LinkedList<String>();
            progress.setMessage(DefaultPlugin.getScanningMsg(srcFileObj.getName()));
            for (FileObject childFileObj : srcFileObj.getChildren()) {
                if (progress.isCanceled()) {
                    results.setAbborted();
                    break;
                }
                if (!VisibilityQuery.getDefault().isVisible(childFileObj)) continue;
                results.combine(DefaultPlugin.createTests(childFileObj, testCreator, templateParams, doTestT, doSuiteT, testClassPath, mySuite, progress));
                if (results.isAbborted()) break;
            }
            if (!results.isAbborted() && JUnitSettings.getDefault().isGenerateSuiteClasses()) {
                DefaultPlugin.createSuiteTest(srcFileObj, null, testCreator, templateParams, doSuiteT, testClassPath, mySuite, parentSuite, progress);
            }
        } else {
            results = srcFileObj.isData() && JUnitTestUtil.isJavaFile((FileObject)srcFileObj) ? DefaultPlugin.createSingleTest(srcFileObj, null, testCreator, templateParams, doTestT, testClassPath, TestabilityResult.NO_TESTEABLE_METHODS.getReasonValue(), parentSuite, progress) : CreationResults.EMPTY;
        }
        return results;
    }

    private static DataObject createSuiteTest(FileObject folder, String suiteName, TestCreator testCreator, Map<String, ? extends Object> templateParams, DataObject templateDataObj, ClassPath testClassPath, List<String> classesToInclude, List<String> parentSuite, ProgressIndicator progress) throws CreationError {
        FileObject rootOwnerFO;
        ClassPath cp = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
        assert (cp != null) : "SOURCE classpath was not found for " + folder;
        if (cp == null) {
            return null;
        }
        String pkg = cp.getResourceName(folder, '/', false);
        String rootFolderName = "";
        if (cp.getRoots().length > 1 && (rootOwnerFO = cp.findOwnerRoot(folder)) != null) {
            rootFolderName = rootOwnerFO.getName() + '/';
        }
        String dotPkg = pkg.replace('/', '.');
        String fullSuiteName = rootFolderName.concat(suiteName != null ? pkg + '/' + suiteName : (generatingIntegrationTest ? JUnitTestUtil.convertPackage2ITSuiteName(pkg) : JUnitTestUtil.convertPackage2SuiteName(pkg)));
        String classNames = DefaultPlugin.makeListOfClasses(classesToInclude, null);
        String classes = DefaultPlugin.makeListOfClasses(classesToInclude, ".class");
        HashMap<String, ? extends Object> suiteTemplParams = new HashMap<String, Object>(templateParams);
        suiteTemplParams.put(templatePropClassNames, classNames);
        suiteTemplParams.put(templatePropClasses, classes);
        try {
            List<String> processedClasses;
            boolean isNew;
            DataObject testDataObj = null;
            FileObject testFile = testClassPath.findResource(fullSuiteName + ".java");
            boolean bl = isNew = testFile == null;
            if (testFile == null) {
                testDataObj = DefaultPlugin.createTestClass(testClassPath, cp, fullSuiteName, templateDataObj, suiteTemplParams);
                testFile = testDataObj.getPrimaryFile();
            }
            try {
                processedClasses = testCreator.createTestSuite(classesToInclude, testFile, isNew);
                if (testDataObj == null) {
                    testDataObj = DataObject.find((FileObject)testFile);
                }
                DefaultPlugin.save(testDataObj);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(65536, (Throwable)ex);
                return null;
            }
            if (parentSuite != null && !processedClasses.isEmpty()) {
                for (String simpleClassName : processedClasses) {
                    parentSuite.add(dotPkg.length() != 0 ? dotPkg + '.' + simpleClassName : simpleClassName);
                }
            }
            return testDataObj;
        }
        catch (IOException ioe) {
            throw new CreationError(ioe);
        }
    }

    private static final String makeListOfClasses(List<String> clsNames, String suffix) {
        if (clsNames.isEmpty()) {
            return "";
        }
        if (clsNames.size() == 1) {
            return suffix == null ? clsNames.get(0) : clsNames.get(0) + suffix;
        }
        StringBuilder buf = new StringBuilder(128);
        boolean first = true;
        for (String clsName : clsNames) {
            if (!first) {
                buf.append(',');
            }
            buf.append(clsName);
            if (suffix != null) {
                buf.append(suffix);
            }
            first = false;
        }
        return buf.toString();
    }

    public DataObject createSuiteTest(FileObject targetRootFolder, FileObject targetFolder, String suiteName, Map<CommonPlugin.CreateTestParam, Object> params) {
        String templateId;
        Map<String, Boolean> templateParams = DefaultPlugin.createTemplateParams(params);
        DefaultPlugin.setAnnotationsSupport(targetFolder, junitVer, templateParams);
        TestCreator testCreator = new TestCreator(params, junitVer);
        ClasspathInfo cpInfo = ClasspathInfo.create((FileObject)targetRootFolder);
        List<String> testClassNames = JUnitTestUtil.getJavaFileNames(targetFolder, cpInfo);
        switch (junitVer) {
            case JUNIT3: {
                templateId = "PROP_junit3_testSuiteTemplate";
                break;
            }
            case JUNIT4: {
                templateId = "PROP_junit4_testSuiteTemplate";
                break;
            }
            case JUNIT5: {
                templateId = "PROP_junit5_testSuiteTemplate";
                break;
            }
            default: {
                assert (false);
                templateId = null;
            }
        }
        DataObject doSuiteTempl = DefaultPlugin.loadTestTemplate(templateId);
        if (doSuiteTempl == null) {
            return null;
        }
        try {
            return DefaultPlugin.createSuiteTest(targetFolder, suiteName, testCreator, templateParams, doSuiteTempl, cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE), new LinkedList<String>(testClassNames), null, null);
        }
        catch (CreationError ex) {
            return null;
        }
    }

    private static DataObject createTestClass(ClassPath testCp, ClassPath cp, String testClassName, DataObject templateDataObj, Map<String, ? extends Object> templateParams) throws DataObjectNotFoundException, IOException {
        String clazz;
        int index;
        FileObject root = testCp.getRoots()[0];
        String rootFolderName = "";
        if (testCp.getRoots().length > 1 || cp != null && cp.getRoots().length > 1) {
            int indexFirst = testClassName.indexOf(47);
            rootFolderName = testClassName.substring(0, indexFirst);
            testClassName = testClassName.substring(indexFirst + 1);
            for (int i = 0; i < testCp.getRoots().length; ++i) {
                FileObject rootFO = testCp.getRoots()[i];
                if (!rootFO.getPath().endsWith(rootFolderName)) continue;
                root = rootFO;
            }
        }
        String pkg = (index = testClassName.lastIndexOf(47)) > -1 ? testClassName.substring(0, index) : "";
        String string = clazz = index > -1 ? testClassName.substring(index + 1) : testClassName;
        if (pkg.length() > 0) {
            root = FileUtil.createFolder((FileObject)root, (String)pkg);
        }
        return templateDataObj.createFromTemplate(DataFolder.findFolder((FileObject)root), clazz, templateParams);
    }

    private static boolean setAnnotationsSupport(FileObject testFolder, JUnitVersion junitVer, Map<String, Boolean> templateParams) {
        boolean supported;
        if (!testFolder.isFolder()) {
            throw new IllegalArgumentException("not a folder");
        }
        switch (junitVer) {
            case JUNIT3: {
                supported = JUnitTestUtil.areAnnotationsSupported(testFolder);
                break;
            }
            case JUNIT4: {
                supported = true;
                break;
            }
            case JUNIT5: {
                supported = true;
                break;
            }
            default: {
                supported = false;
            }
        }
        if (supported) {
            templateParams.put(templatePropUseAnnotations, supported);
        }
        return supported;
    }

    private static void save(DataObject dataObj) throws IOException {
        Savable sc = (Savable)dataObj.getLookup().lookup(Savable.class);
        if (null != sc) {
            sc.save();
        }
    }

    private static DataObject loadTestTemplate(String templateID) {
        String path = NbBundle.getMessage(DefaultPlugin.class, (String)templateID);
        try {
            FileObject fo = FileUtil.getConfigFile((String)path);
            if (fo == null) {
                DefaultPlugin.noTemplateMessage(path);
                return null;
            }
            return DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException e) {
            DefaultPlugin.noTemplateMessage(path);
            return null;
        }
    }

    private static void noTemplateMessage(String temp) {
        String msg = NbBundle.getMessage(DefaultPlugin.class, (String)"MSG_template_not_found", (Object)temp);
        NotifyDescriptor.Message descr = new NotifyDescriptor.Message((Object)msg, 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descr);
    }

    private static String strReason(TestabilityResult reason, String commaKey, String andKey) {
        String strComma = NbBundle.getMessage(DefaultPlugin.class, (String)commaKey);
        String strAnd = NbBundle.getMessage(DefaultPlugin.class, (String)andKey);
        String strReason = reason.getReason(strComma.substring(1, strComma.length() - 1), strAnd.substring(1, strAnd.length() - 1));
        return strReason;
    }

    private static String getCreatingMsg(String className) {
        return NbBundle.getMessage(DefaultPlugin.class, (String)"FMT_generator_status_creating", (Object)className);
    }

    private static String getScanningMsg(String sourceName) {
        return NbBundle.getMessage(DefaultPlugin.class, (String)"FMT_generator_status_scanning", (Object)sourceName);
    }

    private static String getIgnoringMsg(String sourceName, String reason) {
        return NbBundle.getMessage(DefaultPlugin.class, (String)"FMT_generator_status_ignoring", (Object)sourceName);
    }

    static {
        bundle = NbBundle.getBundle(DefaultPlugin.class);
        generatingIntegrationTest = false;
    }

    static final class CreationResults {
        static final CreationResults EMPTY = new CreationResults();
        Set<DataObject> created;
        Set<TestabilityResult.SkippedClass> skipped;
        boolean abborted = false;

        CreationResults() {
            this(20);
        }

        CreationResults(int expectedSize) {
            this.created = new HashSet<DataObject>(expectedSize * 2, 0.5f);
            this.skipped = new HashSet<TestabilityResult.SkippedClass>(expectedSize * 2, 0.5f);
        }

        void setAbborted() {
            this.abborted = true;
        }

        boolean isAbborted() {
            return this.abborted;
        }

        boolean addCreated(DataObject test) {
            return this.created.add(test);
        }

        boolean addSkipped(TestabilityResult.SkippedClass skippedClass) {
            return this.skipped.add(skippedClass);
        }

        void addSkipped(Collection<TestabilityResult.SkippedClass> skippedClasses) {
            if (!skippedClasses.isEmpty()) {
                this.skipped.addAll(skippedClasses);
            }
        }

        Set<TestabilityResult.SkippedClass> getSkipped() {
            return this.skipped;
        }

        Set<DataObject> getCreated() {
            return this.created;
        }

        void combine(CreationResults rhs) {
            if (rhs.abborted) {
                this.abborted = true;
            }
            this.created.addAll(rhs.created);
            this.skipped.addAll(rhs.skipped);
        }
    }

    private static final class CreationError
    extends Exception {
        CreationError() {
        }

        CreationError(Throwable cause) {
            super(cause);
        }
    }
}

