/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.FilterPropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public class ProjectConfigurations {
    private static final Logger LOGGER = Logger.getLogger(ProjectConfigurations.class.getName());
    public static final String CONFIG_PROPS_PATH = "nbproject/private/config.properties";

    private ProjectConfigurations() {
        throw new IllegalStateException("No instance allowed");
    }

    @NonNull
    public static ConfigurationProviderBuilder createConfigurationProviderBuilder(@NonNull Project project, @NonNull PropertyEvaluator eval, @NonNull UpdateHelper updateHelper) {
        return new ConfigurationProviderBuilder(project, eval, updateHelper);
    }

    @NonNull
    public static PropertyEvaluator createPropertyEvaluator(@NonNull Project project, @NonNull AntProjectHelper helper, PropertyProvider ... additionalPropertyProviders) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"helper", (Object)helper);
        Parameters.notNull((CharSequence)"additionalPropertyProviders", (Object)additionalPropertyProviders);
        PropertyEvaluator baseEval1 = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)helper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{helper.getPropertyProvider(CONFIG_PROPS_PATH)});
        PropertyEvaluator baseEval2 = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)helper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{helper.getPropertyProvider("nbproject/private/private.properties")});
        ArrayDeque<Object> providers = new ArrayDeque<Object>(additionalPropertyProviders.length + 7);
        providers.offer(helper.getPropertyProvider(CONFIG_PROPS_PATH));
        providers.offer(new ConfigPropertyProvider(baseEval1, "nbproject/private/configs", helper));
        providers.offer(helper.getPropertyProvider("nbproject/private/private.properties"));
        providers.offer(helper.getProjectLibrariesPropertyProvider());
        providers.offer(PropertyUtils.userPropertiesProvider((PropertyEvaluator)baseEval2, (String)"user.properties.file", (File)FileUtil.toFile((FileObject)project.getProjectDirectory())));
        providers.offer(new ConfigPropertyProvider(baseEval1, "nbproject/configs", helper));
        providers.offer(helper.getPropertyProvider("nbproject/project.properties"));
        Collections.addAll(providers, additionalPropertyProviders);
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)helper.getStockPropertyPreprovider(), (PropertyProvider[])providers.toArray(new PropertyProvider[providers.size()]));
    }

    private static final class ConfigPropertyProvider
    extends FilterPropertyProvider
    implements PropertyChangeListener {
        private final PropertyEvaluator baseEval;
        private final String prefix;
        private final AntProjectHelper helper;

        public ConfigPropertyProvider(PropertyEvaluator baseEval, String prefix, AntProjectHelper helper) {
            super(ConfigPropertyProvider.computeDelegate(baseEval, prefix, helper));
            this.baseEval = baseEval;
            this.prefix = prefix;
            this.helper = helper;
            baseEval.addPropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if ("config".equals(ev.getPropertyName())) {
                this.setDelegate(ConfigPropertyProvider.computeDelegate(this.baseEval, this.prefix, this.helper));
            }
        }

        private static PropertyProvider computeDelegate(PropertyEvaluator baseEval, String prefix, AntProjectHelper helper) {
            String config = baseEval.getProperty("config");
            if (config != null) {
                return helper.getPropertyProvider(prefix + "/" + config + ".properties");
            }
            return PropertyUtils.fixedPropertyProvider(Collections.emptyMap());
        }
    }

    private static final class ConfigurationProviderImpl
    implements ProjectConfigurationProvider<Configuration> {
        private static final Configuration DEFAULT = new Configuration(null, NbBundle.getMessage(ProjectConfigurations.class, (String)"TXT_DefaultConfig"));
        private final Project p;
        private final PropertyEvaluator eval;
        private final UpdateHelper updateHelper;
        private final Set<String> configurationsAffectActions;
        private final Runnable customizerAction;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private final FileChangeListener fcl = new FileChangeAdapter(){

            public void fileFolderCreated(@NonNull FileEvent fe) {
                this.update(fe);
            }

            public void fileDataCreated(@NonNull FileEvent fe) {
                this.update(fe);
            }

            public void fileDeleted(@NonNull FileEvent fe) {
                this.update(fe);
            }

            public void fileRenamed(@NonNull FileRenameEvent fe) {
                this.update((FileEvent)fe);
            }

            private void update(@NonNull FileEvent ev) {
                Parameters.notNull((CharSequence)"ev", (Object)ev);
                LOGGER.log(Level.FINEST, "Received {0}", ev);
                Set oldConfigs = configs != null ? configs.keySet() : Collections.emptySet();
                configDir = p.getProjectDirectory().getFileObject("nbproject/configs");
                if (configDir != null) {
                    configDir.removeFileChangeListener(fclWeak);
                    configDir.addFileChangeListener(fclWeak);
                    LOGGER.log(Level.FINEST, "(Re-)added listener to {0}", configDir);
                } else {
                    LOGGER.log(Level.FINEST, "No nbproject/configs exists");
                }
                this.calculateConfigs();
                Set newConfigs = configs.keySet();
                if (!oldConfigs.equals(newConfigs)) {
                    LOGGER.log(Level.FINER, "Firing configurations: {0} -> {1}", new Object[]{oldConfigs, newConfigs});
                    pcs.firePropertyChange("configurations", null, null);
                }
            }
        };
        private final FileChangeListener fclWeak;
        private FileObject configDir;
        private volatile Map<String, Configuration> configs;
        private FileObject nbp;

        public ConfigurationProviderImpl(@NonNull Project p, @NonNull PropertyEvaluator eval, @NonNull UpdateHelper updateHelper, @NonNull Set<String> configurationsAffectActions, @NullAllowed Runnable customizerAction) {
            Parameters.notNull((CharSequence)"p", (Object)p);
            Parameters.notNull((CharSequence)"eval", (Object)eval);
            Parameters.notNull((CharSequence)"updateHelper", (Object)updateHelper);
            Parameters.notNull((CharSequence)"configurationsAffectActions", configurationsAffectActions);
            this.p = p;
            this.eval = eval;
            this.updateHelper = updateHelper;
            this.configurationsAffectActions = configurationsAffectActions;
            this.customizerAction = customizerAction;
            this.fclWeak = FileUtil.weakFileChangeListener((FileChangeListener)this.fcl, null);
            this.nbp = p.getProjectDirectory().getFileObject("nbproject");
            if (this.nbp != null) {
                this.nbp.addFileChangeListener(this.fclWeak);
                LOGGER.log(Level.FINEST, "Added listener to {0}", this.nbp);
                this.configDir = this.nbp.getFileObject("configs");
                if (this.configDir != null) {
                    this.configDir.addFileChangeListener(this.fclWeak);
                    LOGGER.log(Level.FINEST, "Added listener to {0}", this.configDir);
                }
            }
            eval.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(@NonNull PropertyChangeEvent evt) {
                    if ("config".equals(evt.getPropertyName())) {
                        LOGGER.log(Level.FINER, "Refiring config -> activeConfiguration");
                        Set oldConfigs = configs != null ? configs.keySet() : Collections.emptySet();
                        this.calculateConfigs();
                        Set newConfigs = configs.keySet();
                        if (!oldConfigs.equals(newConfigs)) {
                            LOGGER.log(Level.FINER, "Firing configurations: {0} -> {1}", new Object[]{oldConfigs, newConfigs});
                            pcs.firePropertyChange("configurations", null, null);
                        }
                        pcs.firePropertyChange("activeConfiguration", null, null);
                    }
                }
            });
        }

        @NonNull
        private Map<String, Configuration> calculateConfigs() {
            HashMap<String, Configuration> cfgs = new HashMap<String, Configuration>();
            if (this.configDir != null) {
                for (FileObject kid : this.configDir.getChildren()) {
                    if (!kid.hasExt("properties")) continue;
                    try (InputStream is = kid.getInputStream();){
                        Properties props = new Properties();
                        props.load(is);
                        String name = kid.getName();
                        String label = props.getProperty("$label");
                        cfgs.put(name, new Configuration(name, label != null ? label : name));
                    }
                    catch (IOException x) {
                        LOGGER.log(Level.INFO, null, x);
                    }
                }
            }
            this.configs = cfgs;
            LOGGER.log(Level.FINEST, "Calculated configurations: {0}", cfgs);
            return cfgs;
        }

        @NonNull
        private Map<String, Configuration> getConfigs() {
            Map<String, Configuration> cfgs = this.configs;
            if (cfgs == null) {
                cfgs = this.calculateConfigs();
            }
            return cfgs;
        }

        @NonNull
        public Collection<Configuration> getConfigurations() {
            Map<String, Configuration> cfgs = this.getConfigs();
            ArrayList<Configuration> l = new ArrayList<Configuration>();
            l.addAll(cfgs.values());
            Collections.sort(l, new Comparator<Configuration>(){
                Collator c = Collator.getInstance();

                @Override
                public int compare(Configuration c1, Configuration c2) {
                    return this.c.compare(c1.getDisplayName(), c2.getDisplayName());
                }
            });
            l.add(0, DEFAULT);
            return l;
        }

        @NonNull
        public Configuration getActiveConfiguration() {
            Map<String, Configuration> cfgs = this.getConfigs();
            String config = this.eval.getProperty("config");
            if (config != null && cfgs.containsKey(config)) {
                return cfgs.get(config);
            }
            return DEFAULT;
        }

        public void setActiveConfiguration(@NonNull Configuration c) throws IllegalArgumentException, IOException {
            EditableProperties ep;
            Map<String, Configuration> cfgs = this.getConfigs();
            if (c != DEFAULT && !cfgs.values().contains(c)) {
                throw new IllegalArgumentException(String.format("Configuration: %s, Known Configurations: %s", c, cfgs.values()));
            }
            assert (ProjectManager.mutex().isWriteAccess());
            String n = c.name;
            if (Utilities.compareObjects((Object)n, (Object)(ep = this.updateHelper.getProperties(ProjectConfigurations.CONFIG_PROPS_PATH)).getProperty("config"))) {
                return;
            }
            if (n != null) {
                ep.setProperty("config", n);
            } else {
                ep.remove((Object)"config");
            }
            this.updateHelper.putProperties(ProjectConfigurations.CONFIG_PROPS_PATH, ep);
            this.pcs.firePropertyChange("activeConfiguration", null, null);
            ProjectManager.getDefault().saveProject(this.p);
            assert (ep.isEmpty() || this.p.getProjectDirectory().getFileObject(ProjectConfigurations.CONFIG_PROPS_PATH) != null) : String.format("Setting config to: %s, properties are empty: %b", n, ep.isEmpty());
        }

        public boolean hasCustomizer() {
            return this.customizerAction != null;
        }

        public void customize() {
            if (this.customizerAction != null) {
                this.customizerAction.run();
            }
        }

        public boolean configurationsAffectAction(@NonNull String command) {
            return this.configurationsAffectActions.contains(command);
        }

        public void addPropertyChangeListener(@NonNull PropertyChangeListener lst) {
            Parameters.notNull((CharSequence)"lst", (Object)lst);
            this.pcs.addPropertyChangeListener(lst);
        }

        public void removePropertyChangeListener(@NonNull PropertyChangeListener lst) {
            Parameters.notNull((CharSequence)"lst", (Object)lst);
            this.pcs.removePropertyChangeListener(lst);
        }
    }

    public static final class Configuration
    implements ProjectConfiguration {
        private final String name;
        private final String displayName;

        private Configuration(@NullAllowed String name, @NonNull String displayName) {
            Parameters.notNull((CharSequence)"displayName", (Object)displayName);
            this.name = name;
            this.displayName = displayName;
        }

        @CheckForNull
        public String getName() {
            return this.name;
        }

        public boolean isDefault() {
            return this.name == null;
        }

        @NonNull
        public String getDisplayName() {
            return this.displayName;
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }

        public boolean equals(Object o) {
            return o instanceof Configuration && Objects.equals(this.name, ((Configuration)o).name);
        }

        public String toString() {
            return "Config[" + this.name + "," + this.displayName + "]";
        }
    }

    public static final class ConfigurationProviderBuilder {
        private final Project project;
        private final PropertyEvaluator eval;
        private final UpdateHelper updateHelper;
        private final Set<String> configurationsAffectActions;
        private Runnable customizerAction;

        private ConfigurationProviderBuilder(@NonNull Project project, @NonNull PropertyEvaluator eval, @NonNull UpdateHelper updateHelper) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"eval", (Object)eval);
            Parameters.notNull((CharSequence)"updateHelper", (Object)updateHelper);
            this.project = project;
            this.eval = eval;
            this.updateHelper = updateHelper;
            this.configurationsAffectActions = new HashSet<String>();
        }

        @NonNull
        public ConfigurationProviderBuilder addConfigurationsAffectActions(String ... commands) {
            Parameters.notNull((CharSequence)"commands", (Object)commands);
            Collections.addAll(this.configurationsAffectActions, commands);
            return this;
        }

        @NonNull
        public ConfigurationProviderBuilder setCustomizerAction(@NonNull Runnable action) {
            Parameters.notNull((CharSequence)"action", (Object)action);
            this.customizerAction = action;
            return this;
        }

        @NonNull
        public ProjectConfigurationProvider<? extends ProjectConfiguration> build() {
            return new ConfigurationProviderImpl(this.project, this.eval, this.updateHelper, this.configurationsAffectActions, this.customizerAction);
        }
    }
}

