/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsReader;
import org.netbeans.modules.debugger.jpda.breakpoints.RequestNotSupportedException;
import org.netbeans.modules.debugger.jpda.expr.EvaluatorExpression;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidRequestStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.PrimitiveValueWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ValueWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.EventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.WatchpointEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.StepRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.ExceptionVariableImpl;
import org.netbeans.modules.debugger.jpda.models.FieldReadVariableImpl;
import org.netbeans.modules.debugger.jpda.models.FieldToBeVariableImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.ReturnVariableImpl;
import org.netbeans.modules.debugger.jpda.util.ConditionedExecutor;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;

public abstract class BreakpointImpl
implements ConditionedExecutor,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.breakpoints");
    private final JPDADebuggerImpl debugger;
    private final JPDABreakpoint breakpoint;
    private final BreakpointsReader reader;
    private EvaluatorExpression compiledCondition;
    private List<EventRequest> requests = new LinkedList<EventRequest>();
    private int hitCountFilter = 0;
    private int customHitCount;
    private int customHitCountFilter = 0;
    private List<HitCountListener> hcListeners = new CopyOnWriteArrayList<HitCountListener>();
    private volatile int breakCount = 0;
    private final Map<Event, Variable> processedReturnVariable = new HashMap<Event, Variable>();
    private final Map<Event, Throwable> conditionException = new HashMap<Event, Throwable>();

    protected BreakpointImpl(JPDABreakpoint p, BreakpointsReader reader, JPDADebuggerImpl debugger, Session session) {
        this.debugger = debugger;
        this.reader = reader;
        this.breakpoint = p;
    }

    final void set() {
        this.breakpoint.addPropertyChangeListener((PropertyChangeListener)this);
        this.debugger.addPropertyChangeListener("breakpointsActive", this);
        if (this.breakpoint instanceof PropertyChangeListener && this.isApplicable()) {
            Session s = this.debugger.getSession();
            DebuggerEngine de = s.getEngineForLanguage("Java");
            ((PropertyChangeListener)this.breakpoint).propertyChange(new PropertyChangeEvent(this, DebuggerEngine.class.getName(), null, de));
        }
        this.update();
    }

    void fixed() {
        if (this.reader != null) {
            this.reader.storeCachedClassName(this.breakpoint, null);
        }
        this.update();
    }

    final void update() {
        if (this.getVirtualMachine() == null || this.getDebugger().getState() == 4) {
            return;
        }
        this.removeAllEventRequests();
        if (this.canSetRequests()) {
            this.setRequests();
        }
    }

    protected final boolean canSetRequests() {
        return this.breakpoint.isEnabled() && this.isEnabled() && this.debugger.getBreakpointsActive();
    }

    protected boolean isApplicable() {
        return true;
    }

    protected boolean isEnabled() {
        return true;
    }

    protected final void setValidity(Breakpoint.VALIDITY validity, String reason) {
        if (this.breakpoint instanceof ChangeListener) {
            ((ChangeListener)this.breakpoint).stateChanged(new ValidityChangeEvent(validity, reason));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("disposed".equals(propertyName)) {
            this.remove();
        } else if (!("validity".equals(propertyName) || "groupName".equals(propertyName) || "groupProperties".equals(propertyName))) {
            if (this.reader != null && !"breakpointsActive".equals(propertyName)) {
                this.reader.storeCachedClassName(this.breakpoint, null);
            }
            this.debugger.getRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    BreakpointImpl.this.update();
                }
            });
        }
    }

    protected abstract void setRequests();

    protected void remove() {
        if (Mutex.EVENT.isReadAccess()) {
            this.debugger.getRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    BreakpointImpl.this.removeAllEventRequests();
                }
            });
        } else {
            this.removeAllEventRequests();
        }
        this.breakpoint.removePropertyChangeListener((PropertyChangeListener)this);
        this.debugger.removePropertyChangeListener("breakpointsActive", this);
        this.setValidity(Breakpoint.VALIDITY.UNKNOWN, null);
        if (this.breakpoint instanceof PropertyChangeListener) {
            Session s = this.debugger.getSession();
            DebuggerEngine de = s.getEngineForLanguage("Java");
            ((PropertyChangeListener)this.breakpoint).propertyChange(new PropertyChangeEvent(this, DebuggerEngine.class.getName(), de, null));
        }
        this.compiledCondition = null;
    }

    protected JPDABreakpoint getBreakpoint() {
        return this.breakpoint;
    }

    protected JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    protected VirtualMachine getVirtualMachine() {
        return this.getDebugger().getVirtualMachine();
    }

    protected EventRequestManager getEventRequestManager() throws VMDisconnectedExceptionWrapper, InternalExceptionWrapper {
        VirtualMachine vm = this.getVirtualMachine();
        if (vm == null) {
            throw new VMDisconnectedExceptionWrapper(new VMDisconnectedException());
        }
        return VirtualMachineWrapper.eventRequestManager(vm);
    }

    void addEventRequest(EventRequest r) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, InvalidRequestStateExceptionWrapper, RequestNotSupportedException {
        this.addEventRequest(r, this.customHitCountFilter != 0);
    }

    protected final void setCustomHitCountFilter(int customHitCountFilter) {
        this.customHitCountFilter = customHitCountFilter;
    }

    synchronized void addEventRequest(EventRequest r, boolean ignoreHitCount) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, InvalidRequestStateExceptionWrapper, RequestNotSupportedException {
        logger.log(Level.FINE, "BreakpointImpl addEventRequest: {0}", r);
        this.requests.add(r);
        this.getDebugger().getOperator().register(r, this);
        if (this.getBreakpoint().getSuspend() == 2) {
            EventRequestWrapper.setSuspendPolicy(r, 2);
        } else {
            EventRequestWrapper.setSuspendPolicy(r, 1);
        }
        r.putProperty("brkpSuspend", this.getBreakpoint().getSuspend());
        int hitCountFilter = this.getBreakpoint().getHitCountFilter();
        if (!ignoreHitCount && hitCountFilter > 0) {
            switch (this.getBreakpoint().getHitCountFilteringStyle()) {
                case MULTIPLE: {
                    this.hitCountFilter = hitCountFilter;
                    break;
                }
                case EQUAL: {
                    this.hitCountFilter = 0;
                    break;
                }
                case GREATER: {
                    this.hitCountFilter = -1;
                    ++hitCountFilter;
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getBreakpoint().getHitCountFilteringStyle().name());
                }
            }
            EventRequestWrapper.addCountFilter(r, hitCountFilter);
        } else {
            this.hitCountFilter = 0;
        }
        try {
            EventRequestWrapper.enable(r);
        }
        catch (InternalExceptionWrapper e) {
            this.getDebugger().getOperator().unregister(r);
            throw e;
        }
        catch (ObjectCollectedExceptionWrapper e) {
            this.getDebugger().getOperator().unregister(r);
            throw e;
        }
        catch (VMDisconnectedExceptionWrapper e) {
            this.getDebugger().getOperator().unregister(r);
            throw e;
        }
        catch (InvalidRequestStateExceptionWrapper e) {
            this.getDebugger().getOperator().unregister(r);
            throw e;
        }
        catch (UnsupportedOperationException uoex) {
            throw new RequestNotSupportedException(r);
        }
    }

    protected synchronized void removeAllEventRequests() {
        if (this.requests.isEmpty()) {
            return;
        }
        VirtualMachine vm = this.getDebugger().getVirtualMachine();
        if (vm == null) {
            return;
        }
        int k = this.requests.size();
        try {
            for (int i = 0; i < k; ++i) {
                EventRequest r = this.requests.get(i);
                logger.log(Level.FINE, "BreakpointImpl removeEventRequest: {0}", r);
                try {
                    EventRequestManagerWrapper.deleteEventRequest(VirtualMachineWrapper.eventRequestManager(vm), r);
                }
                catch (InvalidRequestStateExceptionWrapper invalidRequestStateExceptionWrapper) {
                    // empty catch block
                }
                this.getDebugger().getOperator().unregister(r);
            }
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            // empty catch block
        }
        this.requests = new LinkedList<EventRequest>();
    }

    private synchronized void removeEventRequest(EventRequest r) {
        VirtualMachine vm = this.getDebugger().getVirtualMachine();
        if (vm == null) {
            return;
        }
        try {
            logger.log(Level.FINE, "BreakpointImpl removeEventRequest: {0}", r);
            try {
                EventRequestManagerWrapper.deleteEventRequest(VirtualMachineWrapper.eventRequestManager(vm), r);
            }
            catch (InvalidRequestStateExceptionWrapper invalidRequestStateExceptionWrapper) {
                // empty catch block
            }
            this.getDebugger().getOperator().unregister(r);
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            // empty catch block
        }
        this.requests.remove(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final List<EventRequest> getEventRequests() {
        List<EventRequest> ers;
        BreakpointImpl breakpointImpl = this;
        synchronized (breakpointImpl) {
            ers = new LinkedList<EventRequest>(this.requests);
            ers = Collections.unmodifiableList(ers);
        }
        return ers;
    }

    protected abstract EventRequest createEventRequest(EventRequest var1) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper;

    private Boolean processCustomHitCount() {
        ++this.customHitCount;
        this.fireHitCountChanged();
        if (this.customHitCountFilter > 0) {
            switch (this.breakpoint.getHitCountFilteringStyle()) {
                case MULTIPLE: {
                    if (this.customHitCount % this.customHitCountFilter == 0) break;
                    return false;
                }
                case EQUAL: {
                    if (this.customHitCountFilter != this.customHitCount) {
                        return false;
                    }
                    this.removeAllEventRequests();
                    break;
                }
                case GREATER: {
                    if (this.customHitCount > this.customHitCountFilter) break;
                    return false;
                }
                default: {
                    throw new IllegalStateException(this.getBreakpoint().getHitCountFilteringStyle().name());
                }
            }
        }
        return null;
    }

    boolean processCondition(Event event, String condition, ThreadReference threadReference, Value returnValue) {
        return this.processCondition(event, condition, threadReference, returnValue, null);
    }

    boolean processCondition(Event event, String condition, ThreadReference threadReference, Value returnValue, ObjectReference contextValue) {
        Boolean CHCprocessed = this.processCustomHitCount();
        if (CHCprocessed != null) {
            return CHCprocessed;
        }
        try {
            boolean success;
            EventRequest request = EventWrapper.request(event);
            if (this.customHitCountFilter == 0) {
                if (this.hitCountFilter > 0) {
                    EventRequestWrapper.disable(request);
                    EventRequestWrapper.enable(request);
                }
                if (this.hitCountFilter == -1) {
                    EventRequestWrapper.disable(request);
                    this.removeEventRequest(request);
                    try {
                        this.addEventRequest(this.createEventRequest(request), true);
                    }
                    catch (RequestNotSupportedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        return true;
                    }
                }
            }
            ReturnVariableImpl variable = null;
            if (this.getBreakpoint() instanceof MethodBreakpoint && (((MethodBreakpoint)this.getBreakpoint()).getBreakpointType() & 2) != 0 && returnValue != null) {
                JPDAThreadImpl jt = this.getDebugger().getThread(threadReference);
                ReturnVariableImpl retVariable = new ReturnVariableImpl(this.getDebugger(), returnValue, "", jt.getMethodName());
                jt.setReturnVariable(retVariable);
                variable = retVariable;
            }
            if (condition != null && condition.length() > 0) {
                try {
                    this.getDebugger().setAltCSF(ThreadReferenceWrapper.frame(threadReference, 0));
                }
                catch (IncompatibleThreadStateException e) {
                    String msg = JPDAThreadImpl.getThreadStateLog(threadReference);
                    Logger.getLogger(BreakpointImpl.class.getName()).log(Level.INFO, msg, e);
                }
                catch (ObjectCollectedExceptionWrapper e) {
                }
                catch (IllegalThreadStateExceptionWrapper e) {
                    return false;
                }
                catch (IndexOutOfBoundsException e) {
                    // empty catch block
                }
                AbstractObjectVariable contextVar = contextValue != null ? new AbstractObjectVariable(this.getDebugger(), contextValue, null) : null;
                success = this.evaluateCondition(event, condition, threadReference, contextVar);
                this.getDebugger().setAltCSF(null);
            } else {
                this.compiledCondition = null;
                success = true;
            }
            if (success) {
                this.processedReturnVariable.put(event, variable);
            }
            return success;
        }
        catch (InternalExceptionWrapper iex) {
            return true;
        }
        catch (ObjectCollectedExceptionWrapper iex) {
            return true;
        }
        catch (VMDisconnectedExceptionWrapper iex) {
            return false;
        }
        catch (InvalidRequestStateExceptionWrapper irsex) {
            return false;
        }
    }

    protected boolean perform(Event event, ThreadReference threadReference, ReferenceType referenceType, Value value) {
        Throwable cEx;
        Variable variable = this.processedReturnVariable.remove(event);
        if (variable == null) {
            try {
                variable = this.createBreakpointVariable(event, value, referenceType);
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                // empty catch block
            }
        }
        JPDABreakpointEvent e = (cEx = this.conditionException.remove(event)) == null ? new JPDABreakpointEvent(this.getBreakpoint(), (JPDADebugger)this.debugger, this.compiledCondition == null ? 0 : 1, (JPDAThread)this.debugger.getThread(threadReference), referenceType, variable) : new JPDABreakpointEvent(this.getBreakpoint(), (JPDADebugger)this.debugger, cEx, (JPDAThread)this.debugger.getThread(threadReference), referenceType, variable);
        try {
            Field f = e.getClass().getDeclaredField("event");
            f.setAccessible(true);
            f.set(e, event);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        ++this.breakCount;
        this.fireHitCountChanged();
        this.getDebugger().fireBreakpointEvent(this.getBreakpoint(), e);
        this.enableDisableDependentBreakpoints();
        Integer brkpSuspend = (Integer)event.request().getProperty("brkpSuspend");
        if (brkpSuspend == null) {
            brkpSuspend = this.getBreakpoint().getSuspend();
        }
        boolean resume = brkpSuspend == 0 || e.getResume();
        logger.log(Level.FINE, "BreakpointImpl: perform breakpoint: {0} resume: {1}", new Object[]{this, resume});
        if (threadReference != null) {
            if (!resume) {
                try {
                    resume = this.checkWhetherResumeToFinishStep(threadReference);
                }
                catch (InternalExceptionWrapper ex) {
                    return false;
                }
                catch (VMDisconnectedExceptionWrapper ex) {
                    return false;
                }
            }
            if (!resume) {
                this.getDebugger().getThread(threadReference).setCurrentBreakpoint(this.breakpoint, e);
            }
        }
        return resume;
    }

    private Variable createBreakpointVariable(Event event, Value value, ReferenceType referenceType) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        Variable var;
        if (event instanceof ExceptionEvent && value instanceof ObjectReference) {
            String exceptionClassName = ReferenceTypeWrapper.name(ObjectReferenceWrapper.referenceType((ObjectReference)value));
            var = new ExceptionVariableImpl(this.debugger, value, null, exceptionClassName);
        } else if (event instanceof AccessWatchpointEvent) {
            AccessWatchpointEvent aevent = (AccessWatchpointEvent)event;
            com.sun.jdi.Field field = WatchpointEventWrapper.field(aevent);
            ObjectReference or = WatchpointEventWrapper.object(aevent);
            org.netbeans.api.debugger.jpda.Field fieldVar = AbstractObjectVariable.getField(this.debugger, field, or, null);
            var = new FieldReadVariableImpl(this.debugger, value, null, fieldVar);
        } else if (event instanceof ModificationWatchpointEvent) {
            ModificationWatchpointEvent mevent = (ModificationWatchpointEvent)event;
            com.sun.jdi.Field field = WatchpointEventWrapper.field(mevent);
            ObjectReference or = WatchpointEventWrapper.object(mevent);
            org.netbeans.api.debugger.jpda.Field fieldVar = AbstractObjectVariable.getField(this.debugger, field, or, null);
            var = new FieldToBeVariableImpl(this.debugger, value, null, fieldVar);
        } else {
            var = this.debugger.getVariable(value);
        }
        return var;
    }

    private void enableDisableDependentBreakpoints() {
        Set breakpoints = this.breakpoint.getBreakpointsToEnable();
        for (Breakpoint b : breakpoints) {
            b.enable();
        }
        breakpoints = this.breakpoint.getBreakpointsToDisable();
        for (Breakpoint b : breakpoints) {
            b.disable();
        }
    }

    private boolean checkWhetherResumeToFinishStep(ThreadReference thread) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        List<StepRequest> stepRequests = EventRequestManagerWrapper.stepRequests(VirtualMachineWrapper.eventRequestManager(MirrorWrapper.virtualMachine(thread)));
        if (stepRequests.size() > 0) {
            logger.log(Level.FINE, "checkWhetherResumeToFinishStep() stepRequests = {0}", stepRequests);
            int suspendState = this.breakpoint.getSuspend();
            if (suspendState == 2 || suspendState == 1) {
                boolean thisThreadHasStep = false;
                ArrayList<StepRequest> activeStepRequests = new ArrayList<StepRequest>(stepRequests);
                ArrayList<ThreadReference> steppingThreads = new ArrayList<ThreadReference>(stepRequests.size());
                for (int i = 0; i < activeStepRequests.size(); ++i) {
                    int stepThreadStatus;
                    StepRequest step = (StepRequest)activeStepRequests.get(i);
                    ThreadReference stepThread = StepRequestWrapper.thread(step);
                    if (!EventRequestWrapper.isEnabled(step)) {
                        activeStepRequests.remove(i);
                        continue;
                    }
                    try {
                        stepThreadStatus = ThreadReferenceWrapper.status(StepRequestWrapper.thread(step));
                    }
                    catch (ObjectCollectedExceptionWrapper ocex) {
                        stepThreadStatus = 0;
                    }
                    catch (IllegalThreadStateExceptionWrapper ex) {
                        stepThreadStatus = 0;
                    }
                    if (stepThreadStatus == 0) {
                        try {
                            EventRequestManagerWrapper.deleteEventRequest(VirtualMachineWrapper.eventRequestManager(MirrorWrapper.virtualMachine(thread)), step);
                        }
                        catch (InvalidRequestStateExceptionWrapper ex) {
                            // empty catch block
                        }
                        this.debugger.getOperator().unregister(step);
                        activeStepRequests.remove(i);
                        continue;
                    }
                    if (thread.equals(stepThread)) {
                        thisThreadHasStep = true;
                    }
                    steppingThreads.add(stepThread);
                }
                if (thisThreadHasStep) {
                    return false;
                }
                if (activeStepRequests.size() > 0 && (thisThreadHasStep || suspendState == 2)) {
                    Boolean resumeDecision = this.debugger.getStepInterruptByBptResumeDecision();
                    boolean resume = resumeDecision != null ? resumeDecision : false;
                    if (!resume) {
                        ArrayList<JPDAThreadImpl> jsts = new ArrayList<JPDAThreadImpl>(steppingThreads.size());
                        for (ThreadReference tr : steppingThreads) {
                            jsts.add(this.debugger.getThread(tr));
                        }
                        JPDAThreadImpl tr = this.debugger.getThread(thread);
                        tr.setStepSuspendedBy(this.breakpoint, resumeDecision == null, jsts);
                    }
                    return resume;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean evaluateCondition(Event event, String condition, ThreadReference thread, ObjectVariable contextVar) {
        try {
            try {
                boolean success;
                JPDAThreadImpl jtr = this.debugger.getThread(thread);
                jtr.accessLock.writeLock().lock();
                try {
                    CallStackFrame[] csfs = jtr.getCallStack(0, 1);
                    success = csfs.length > 0 ? this.evaluateConditionIn(condition, csfs[0], contextVar) : true;
                }
                finally {
                    jtr.accessLock.writeLock().unlock();
                }
                logger.log(Level.FINE, "BreakpointImpl: perform breakpoint (condition = {0}): {1} resume: {2}", new Object[]{success, this, !success});
                return success;
            }
            catch (InvalidExpressionException ex) {
                this.conditionException.put(event, ex);
                logger.log(Level.FINE, "BreakpointImpl: perform breakpoint (bad condition): ''{0}'', got {1}", new Object[]{condition, ex.getMessage()});
                return true;
            }
        }
        catch (AbsentInformationException abex) {
            logger.log(Level.INFO, condition, abex);
            return true;
        }
    }

    private boolean evaluateConditionIn(String condExpr, CallStackFrame csf, ObjectVariable contextVariable) throws InvalidExpressionException {
        if (this.compiledCondition == null || !this.compiledCondition.getExpression().equals(condExpr)) {
            this.compiledCondition = new EvaluatorExpression(condExpr);
        }
        Value value = this.getDebugger().evaluateIn(this.compiledCondition, csf, contextVariable);
        try {
            return PrimitiveValueWrapper.booleanValue((BooleanValue)value);
        }
        catch (ClassCastException e) {
            try {
                throw new InvalidExpressionException("Expecting boolean value instead of " + ValueWrapper.type(value));
            }
            catch (InternalExceptionWrapper ex) {
                throw new InvalidExpressionException("Expecting boolean value");
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                throw new InvalidExpressionException("Expecting boolean value");
            }
            catch (ObjectCollectedExceptionWrapper ex) {
                throw new InvalidExpressionException("Expecting boolean value");
            }
        }
        catch (NullPointerException npe) {
            throw new InvalidExpressionException((Throwable)npe);
        }
        catch (InternalExceptionWrapper ex) {
            return true;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return true;
        }
    }

    static boolean match(String name, String pattern) {
        if (pattern.startsWith("*")) {
            return name.endsWith(pattern.substring(1));
        }
        if (pattern.endsWith("*")) {
            return name.startsWith(pattern.substring(0, pattern.length() - 1));
        }
        return name.equals(pattern);
    }

    public int getCurrentHitCount() {
        if (this.customHitCountFilter > 0) {
            return this.customHitCount;
        }
        if (this.breakpoint.getHitCountFilter() <= 0) {
            return this.customHitCount;
        }
        return -1;
    }

    public int getCurrentBreakCounts() {
        return this.breakCount;
    }

    public int getHitCountsTillBreak() {
        if (this.customHitCountFilter > 0) {
            switch (this.breakpoint.getHitCountFilteringStyle()) {
                case MULTIPLE: {
                    return this.customHitCountFilter - this.customHitCount % this.customHitCountFilter;
                }
                case EQUAL: {
                    int tb = this.customHitCountFilter - this.customHitCount;
                    if (tb < 0) {
                        tb = 0;
                    }
                    return tb;
                }
                case GREATER: {
                    int tb = this.customHitCountFilter - this.customHitCount;
                    if (tb <= 0) {
                        tb = 1;
                    }
                    return tb;
                }
            }
            throw new IllegalStateException(this.getBreakpoint().getHitCountFilteringStyle().name());
        }
        if (this.breakpoint.getHitCountFilter() <= 0) {
            return 1;
        }
        return -1;
    }

    public void resetHitCounts() {
        if (this.customHitCountFilter > 0) {
            this.customHitCount = 0;
        } else if (this.breakpoint.getHitCountFilter() <= 0) {
            this.customHitCount = 0;
        }
    }

    private void fireHitCountChanged() {
        for (HitCountListener hcl : this.hcListeners) {
            hcl.hitCountChanged(this.breakpoint);
        }
    }

    public void addHitCountListener(HitCountListener hcl) {
        this.hcListeners.add(hcl);
    }

    public void removeHitCountListener(HitCountListener hcl) {
        this.hcListeners.remove(hcl);
    }

    public static interface HitCountListener {
        public void hitCountChanged(JPDABreakpoint var1);
    }

    private static final class EngineChangeEvent
    extends ChangeEvent {
        private final DebuggerEngine newEngine;

        public EngineChangeEvent(DebuggerEngine e, DebuggerEngine newEngine) {
            super(e);
            this.newEngine = newEngine;
        }

        @Override
        public Object getSource() {
            return this.newEngine;
        }
    }

    private static final class ValidityChangeEvent
    extends ChangeEvent {
        private String reason;

        public ValidityChangeEvent(Breakpoint.VALIDITY validity, String reason) {
            super(validity);
            this.reason = reason;
        }

        @Override
        public String toString() {
            return this.reason;
        }
    }
}

