/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.ui.wizards;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.SourceGroupModifier;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.gsf.testrunner.plugin.CommonPlugin;
import org.netbeans.modules.java.testrunner.CommonSettings;
import org.netbeans.modules.java.testrunner.CommonTestUtil;
import org.netbeans.modules.testng.api.TestNGSupport;
import org.netbeans.modules.testng.api.TestNGUtils;
import org.netbeans.modules.testng.spi.TestNGSupportImplementation;
import org.netbeans.modules.testng.ui.wizards.EmptyTestStepLocation;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class NewTestWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;

    private WizardDescriptor.Panel[] createPanels(WizardDescriptor wizardDescriptor) {
        Project project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] groups = this.getTestRoots(sources);
        if (groups.length == 0 && SourceGroupModifier.createSourceGroup((Project)project, (String)"java", (String)"test") != null) {
            groups = this.getTestRoots(sources);
        }
        if (groups.length == 0) {
            groups = sources.getSourceGroups("generic");
            return new WizardDescriptor.Panel[]{Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])groups).create()};
        }
        return new WizardDescriptor.Panel[]{JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])groups, (WizardDescriptor.Panel)new EmptyTestStepLocation())};
    }

    private String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        assert (panels != null);
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    public Set<FileObject> instantiate() throws IOException {
        this.saveSettings(this.wiz);
        String name = Templates.getTargetName((WizardDescriptor)this.wiz);
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        if (targetFolder == null) {
            Logger.getLogger(NewTestWizardIterator.class.getName()).log(Level.INFO, "Target folder was null while creating new TestNG file");
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)targetFolder);
        if (project == null) {
            Logger.getLogger(NewTestWizardIterator.class.getName()).log(Level.INFO, "No project found for target folder: {0}", targetFolder);
            return null;
        }
        TestNGSupportImplementation testNGSupport = TestNGSupport.findTestNGSupport((Project)project);
        if (testNGSupport == null) {
            Logger.getLogger(NewTestWizardIterator.class.getName()).log(Level.INFO, "No TestNGSupportImplementation found for target folder: {0}", targetFolder);
            return null;
        }
        testNGSupport.configureProject(targetFolder);
        Map params = CommonTestUtil.getSettingsMap((boolean)false);
        params.put(CommonPlugin.CreateTestParam.CLASS_NAME, Templates.getTargetName((WizardDescriptor)this.wiz));
        if (!TestNGUtils.createTestActionCalled((FileObject[])new FileObject[]{targetFolder})) {
            return null;
        }
        FileObject[] testFileObjects = TestNGUtils.createTests(null, (FileObject)targetFolder, (Map)params);
        if (testFileObjects == null) {
            throw new IOException();
        }
        FileObject createdFile = testFileObjects[0];
        return Collections.singleton(createdFile);
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels(wiz);
        this.loadSettings(wiz);
        String[] beforeSteps = null;
        Object prop = wiz.getProperty("WizardPanel_contentData");
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    private void loadSettings(WizardDescriptor wizard) {
        CommonSettings settings = TestNGUtils.getTestNGSettings();
        wizard.putProperty("SetUp", (Object)settings.isGenerateSetUp());
        wizard.putProperty("TearDown", (Object)settings.isGenerateTearDown());
        wizard.putProperty("BeforeClass", (Object)settings.isGenerateClassSetUp());
        wizard.putProperty("AfterClass", (Object)settings.isGenerateClassTearDown());
        wizard.putProperty("Comments", (Object)settings.isBodyComments());
    }

    private void saveSettings(WizardDescriptor wizard) {
        CommonSettings settings = TestNGUtils.getTestNGSettings();
        settings.setGenerateSetUp(Boolean.TRUE.equals(wizard.getProperty("SetUp")));
        settings.setGenerateTearDown(Boolean.TRUE.equals(wizard.getProperty("TearDown")));
        settings.setGenerateClassSetUp(Boolean.TRUE.equals(wizard.getProperty("BeforeClass")));
        settings.setGenerateClassTearDown(Boolean.TRUE.equals(wizard.getProperty("AfterClass")));
        settings.setBodyComments(Boolean.TRUE.equals(wizard.getProperty("Comments")));
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    private static String getSelectedPackageName(FileObject targetFolder) {
        Project project = FileOwnerQuery.getOwner((FileObject)targetFolder);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        String packageName = null;
        for (int i = 0; i < groups.length && packageName == null; ++i) {
            packageName = FileUtil.getRelativePath((FileObject)groups[i].getRootFolder(), (FileObject)targetFolder);
        }
        if (packageName != null) {
            packageName = packageName.replaceAll("/", ".");
        }
        return packageName;
    }

    private SourceGroup[] getTestRoots(Sources srcs) {
        SourceGroup[] groups = srcs.getSourceGroups("java");
        assert (groups != null) : "Cannot return null from Sources.getSourceGroups: " + srcs;
        ArrayList<SourceGroup> result = new ArrayList<SourceGroup>(2);
        for (SourceGroup sg : groups) {
            if (!sg.getName().startsWith("${test") && !"2TestSourceRoot".equals(sg.getName())) continue;
            result.add(sg);
        }
        return result.toArray(new SourceGroup[result.size()]);
    }
}

