/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.api.project.Project;

public class ShortcutUtils {
    private static final Logger LOG = Logger.getLogger(ShortcutUtils.class.getName());
    private static ShortcutUtils INSTANCE;
    private final ResourceBundle data;
    private static final Set<String> LANGTOOLS_MODULES;

    public static synchronized ShortcutUtils getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new ShortcutUtils();
        }
        return INSTANCE;
    }

    private ShortcutUtils() {
        ResourceBundle data;
        try (InputStream in = ShortcutUtils.class.getResourceAsStream("shortcut.properties");){
            data = new PropertyResourceBundle(in);
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, null, ex);
            data = new ResourceBundle(){

                @Override
                protected Object handleGetObject(String key) {
                    return null;
                }

                @Override
                public Enumeration<String> getKeys() {
                    return Collections.emptyEnumeration();
                }
            };
        }
        this.data = data;
    }

    public String inferLegacyRepository(Project prj) {
        if (LANGTOOLS_MODULES.contains(prj.getProjectDirectory().getNameExt())) {
            return "langtools";
        }
        return "unknown";
    }

    public boolean shouldUseCustomBuild(String repoName, String pathInRepo) {
        return this.matches(repoName, pathInRepo, "project");
    }

    public boolean shouldUseCustomTest(String repoName, String pathInRepo) {
        return this.matches(repoName, pathInRepo, "test");
    }

    private boolean matches(String repoName, String pathInRepo, String key) {
        String include = null;
        String exclude = null;
        try {
            include = this.data.getString(repoName + "_include_" + key);
            exclude = this.data.getString(repoName + "_exclude_" + key);
        }
        catch (MissingResourceException ex) {
            LOG.log(Level.FINE, null, ex);
        }
        if (include == null || exclude == null) {
            return false;
        }
        try {
            return Pattern.matches(include, pathInRepo) && !Pattern.matches(exclude, pathInRepo);
        }
        catch (PatternSyntaxException ex) {
            LOG.log(Level.FINE, null, ex);
            return false;
        }
    }

    static {
        LANGTOOLS_MODULES = new HashSet<String>(Arrays.asList("java.compiler", "jdk.compiler", "jdk.javadoc", "jdk.jdeps", "jdk.jshell"));
    }
}

