/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.ui;

import java.util.Collection;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.gsf.testrunner.ui.Bundle;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodDebuggerProvider;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.actions.NodeAction;

public class TestMethodDebuggerAction
extends NodeAction {
    private RequestProcessor.Task debugMethodTask;
    private TestMethodDebuggerProvider debugMethodProvider;

    public TestMethodDebuggerAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage(TestMethodDebuggerAction.class, (String)"LBL_Action_DebugTestMethod");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean asynchronous() {
        return false;
    }

    protected void performAction(final Node[] activatedNodes) {
        final Collection providers = Lookup.getDefault().lookupAll(TestMethodDebuggerProvider.class);
        RequestProcessor RP = new RequestProcessor("TestMethodDebuggerAction", 1, true);
        this.debugMethodTask = RP.create(new Runnable(){

            @Override
            public void run() {
                for (TestMethodDebuggerProvider provider : providers) {
                    if (!provider.canHandle(activatedNodes[0])) continue;
                    TestMethodDebuggerAction.this.debugMethodProvider = provider;
                    break;
                }
            }
        });
        final ProgressHandle ph = ProgressHandleFactory.createHandle((String)Bundle.Search_For_Provider(), (Cancellable)this.debugMethodTask);
        this.debugMethodTask.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                ph.finish();
                if (TestMethodDebuggerAction.this.debugMethodProvider == null) {
                    StatusDisplayer.getDefault().setStatusText(Bundle.No_Provider_Found());
                } else {
                    TestMethodDebuggerAction.this.debugMethodProvider.debugTestMethod(activatedNodes[0]);
                }
            }
        });
        ph.start();
        this.debugMethodTask.schedule(0);
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length == 0) {
            return false;
        }
        if (this.debugMethodTask != null && !this.debugMethodTask.isFinished()) {
            return false;
        }
        Collection providers = Lookup.getDefault().lookupAll(TestMethodDebuggerProvider.class);
        for (TestMethodDebuggerProvider provider : providers) {
            if (!provider.isTestClass(activatedNodes[0])) continue;
            return true;
        }
        return false;
    }
}

