/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2semodule.ui.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class PathsCustomizer
extends JPanel {
    private static final String MODULEPATH = NbBundle.getMessage(PathsCustomizer.class, (String)"LBL_CustomizeLibraries_Modulepath_Tab");
    private static final String CLASSPATH = NbBundle.getMessage(PathsCustomizer.class, (String)"LBL_CustomizeLibraries_Classpath_Tab");
    private final JPopupMenu menu = new JPopupMenu();
    private final JMenuItem addProject = new JMenuItem();
    private final JMenuItem addLibrary = new JMenuItem();
    private final JMenuItem addFile = new JMenuItem();
    private JoinModel model;
    private JButton cpAddButton;
    private JTree cpTree;
    private JScrollPane jScrollPane1;
    private JList<String> list;
    private JButton mpAddButton;
    private JTree mpTree;

    public PathsCustomizer() {
        this.initComponents();
        this.mpTree.setUI(new BasicTreeUI(){

            @Override
            protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
            }

            @Override
            protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
            }
        });
        this.cpTree.setUI(new BasicTreeUI(){

            @Override
            protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
            }

            @Override
            protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
            }
        });
        this.setBackground(this.mpTree.getBackground());
        Mnemonics.setLocalizedText((AbstractButton)this.addProject, (String)NbBundle.getMessage(PathsCustomizer.class, (String)"LBL_CustomizeLibraries_AddProject_JButton"));
        Mnemonics.setLocalizedText((AbstractButton)this.addLibrary, (String)NbBundle.getMessage(PathsCustomizer.class, (String)"LBL_CustomizeLibraries_AddLibary_JButton"));
        Mnemonics.setLocalizedText((AbstractButton)this.addFile, (String)NbBundle.getMessage(PathsCustomizer.class, (String)"LBL_CustomizeLibraries_AddJar_JButton"));
        this.menu.add(this.addProject);
        this.menu.add(this.addLibrary);
        this.menu.add(this.addFile);
    }

    public void setModels(DefaultListModel mpModel, DefaultListModel cpModel) {
        this.model = new JoinModel(mpModel, cpModel);
        this.list.setModel(this.model);
        DefaultTreeModel mpTreeModel = PathsCustomizer.toTreeModel(mpModel, MODULEPATH);
        DefaultTreeModel cpTreeModel = PathsCustomizer.toTreeModel(cpModel, CLASSPATH);
        mpModel.addListDataListener(new ListModelListener(mpModel, mpTreeModel, this.mpTree));
        cpModel.addListDataListener(new ListModelListener(cpModel, cpTreeModel, this.cpTree));
        this.mpTree.setModel(mpTreeModel);
        this.cpTree.setModel(cpTreeModel);
        SelectionModel mpTreeSelectionModel = new SelectionModel();
        SelectionModel cpTreeSelectionModel = new SelectionModel();
        mpTreeSelectionModel.addTreeSelectionListener(new SelectionListener(mpTreeModel, this.list, null, cpTreeSelectionModel));
        cpTreeSelectionModel.addTreeSelectionListener(new SelectionListener(cpTreeModel, this.list, mpModel, mpTreeSelectionModel));
        this.mpTree.setSelectionModel(mpTreeSelectionModel);
        this.cpTree.setSelectionModel(cpTreeSelectionModel);
    }

    public void setTreeCellRenderer(TreeCellRenderer renderer) {
        this.mpTree.setCellRenderer(new Renderer(renderer));
        this.cpTree.setCellRenderer(new Renderer(renderer));
    }

    public ButtonModel getAddProjectModel() {
        return this.addProject.getModel();
    }

    public ButtonModel getAddLibraryModel() {
        return this.addLibrary.getModel();
    }

    public ButtonModel getAddFileModel() {
        return this.addFile.getModel();
    }

    public JList getList() {
        return this.list;
    }

    public void setModulesEnabled(boolean enabled) {
    }

    private static DefaultTreeModel toTreeModel(DefaultListModel lm, String rootName) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootName);
        for (int i = 0; i < lm.getSize(); ++i) {
            Object obj = lm.getElementAt(i);
            if (!(obj instanceof ClassPathSupport.Item)) continue;
            root.add(PathsCustomizer.toTreeNode(obj));
        }
        return new DefaultTreeModel(root);
    }

    private static DefaultMutableTreeNode toTreeNode(Object obj) {
        File file;
        DefaultMutableTreeNode node = null;
        ClassPathSupport.Item item = (ClassPathSupport.Item)obj;
        if (item.getType() == 0 && (file = item.getResolvedFile()) != null && file.isDirectory()) {
            node = new DefaultMutableTreeNode(obj);
            for (File f : file.listFiles()) {
                URL url = FileUtil.urlForArchiveOrDir((File)f);
                if (url == null || SourceUtils.getModuleName((URL)url) == null) continue;
                ClassPathSupport.Item child = ClassPathSupport.Item.create((String)f.getName(), (File)file, null, null);
                node.add(new DefaultMutableTreeNode(child, false));
            }
        }
        if (node == null) {
            node = new DefaultMutableTreeNode(obj, false);
        }
        return node;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.list = new JList();
        this.mpTree = new JTree();
        this.mpAddButton = new JButton();
        this.cpTree = new JTree();
        this.cpAddButton = new JButton();
        this.list.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.list);
        this.mpAddButton.setText("+");
        this.mpAddButton.setMargin(new Insets(2, 2, 2, 2));
        this.mpAddButton.setPreferredSize(new Dimension(20, 20));
        this.mpAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathsCustomizer.this.mpAddButtonActionPerformed(evt);
            }
        });
        this.cpAddButton.setText("+");
        this.cpAddButton.setMargin(new Insets(2, 2, 2, 2));
        this.cpAddButton.setPreferredSize(new Dimension(20, 20));
        this.cpAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathsCustomizer.this.cpAddButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cpTree, -2, -1, -2).addComponent(this.mpTree, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cpAddButton, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.mpAddButton, GroupLayout.Alignment.TRAILING, -2, -1, -2))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mpTree, -2, -1, -2).addComponent(this.mpAddButton, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cpTree, -2, -1, -2).addComponent(this.cpAddButton, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void mpAddButtonActionPerformed(ActionEvent evt) {
        this.model.active = (byte)1;
        this.menu.show(this.mpAddButton, 0, this.mpAddButton.getHeight());
    }

    private void cpAddButtonActionPerformed(ActionEvent evt) {
        this.model.active = (byte)2;
        this.menu.show(this.cpAddButton, 0, this.cpAddButton.getHeight());
    }

    private static class JoinModel
    extends DefaultListModel {
        private static final byte MP_ACTIVE = 1;
        private static final byte CP_ACTIVE = 2;
        private final DefaultListModel mpModel;
        private final DefaultListModel cpModel;
        private byte active = 0;
        private byte previousActive = 0;

        public JoinModel(DefaultListModel mpModel, DefaultListModel cpModel) {
            this.mpModel = mpModel;
            this.cpModel = cpModel;
        }

        @Override
        public int getSize() {
            return this.mpModel.getSize() + this.cpModel.getSize() + 1;
        }

        @Override
        public Object getElementAt(int index) {
            return index < this.mpModel.getSize() ? this.mpModel.getElementAt(index) : (index == this.mpModel.getSize() ? null : this.cpModel.getElementAt(index - this.mpModel.getSize() - 1));
        }

        @Override
        public void copyInto(Object[] anArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void trimToSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void ensureCapacity(int minCapacity) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSize(int newSize) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int capacity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.mpModel.size() + this.cpModel.size() + 1;
        }

        @Override
        public boolean isEmpty() {
            return this.mpModel.isEmpty() && this.cpModel.isEmpty();
        }

        public Enumeration elements() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object elem) {
            return this.mpModel.contains(elem) || this.cpModel.contains(elem);
        }

        @Override
        public int indexOf(Object elem) {
            int idx = this.mpModel.indexOf(elem);
            return idx < 0 ? this.cpModel.indexOf(elem) + this.mpModel.getSize() + 1 : idx;
        }

        @Override
        public int indexOf(Object elem, int index) {
            int idx = this.mpModel.indexOf(elem, index);
            return idx < 0 ? this.cpModel.indexOf(elem, index - this.mpModel.getSize()) + this.mpModel.getSize() + 1 : idx;
        }

        @Override
        public int lastIndexOf(Object elem) {
            int idx = this.cpModel.lastIndexOf(elem);
            return idx < 0 ? this.mpModel.lastIndexOf(elem) : idx + this.mpModel.getSize() + 1;
        }

        @Override
        public int lastIndexOf(Object elem, int index) {
            int idx = this.cpModel.lastIndexOf(elem, index - this.mpModel.getSize());
            return idx < 0 ? this.mpModel.lastIndexOf(elem, index) : idx + this.mpModel.getSize() + 1;
        }

        public Object elementAt(int index) {
            return index < this.mpModel.getSize() ? this.mpModel.elementAt(index) : (index == this.mpModel.getSize() ? null : this.cpModel.elementAt(index - this.mpModel.getSize()));
        }

        public Object firstElement() {
            return this.mpModel.isEmpty() ? this.cpModel.firstElement() : this.mpModel.firstElement();
        }

        public Object lastElement() {
            return this.cpModel.isEmpty() ? this.mpModel.lastElement() : this.cpModel.lastElement();
        }

        public void setElementAt(Object element, int index) {
            if (index <= this.mpModel.getSize()) {
                this.mpModel.setElementAt(element, index);
            } else {
                this.cpModel.setElementAt(element, index - this.mpModel.getSize() - 1);
            }
            this.active = 0;
            this.previousActive = 0;
        }

        @Override
        public void removeElementAt(int index) {
            if (index < this.mpModel.getSize()) {
                this.mpModel.removeElementAt(index);
            } else if (index > this.mpModel.getSize()) {
                this.cpModel.removeElementAt(index - this.mpModel.getSize() - 1);
            }
            this.active = 0;
            this.previousActive = 0;
        }

        public void insertElementAt(Object element, int index) {
            if (index <= this.mpModel.getSize()) {
                this.mpModel.insertElementAt(element, index);
            } else {
                this.cpModel.insertElementAt(element, index - this.mpModel.getSize());
            }
            this.active = 0;
            this.previousActive = 0;
        }

        public void addElement(Object element) {
            switch (this.active) {
                case 2: {
                    this.cpModel.addElement(element);
                    this.previousActive = this.active;
                    break;
                }
                case 1: {
                    this.mpModel.addElement(element);
                    this.previousActive = this.active;
                    break;
                }
                default: {
                    if (this.previousActive == 1) {
                        this.mpModel.addElement(element);
                        break;
                    }
                    this.cpModel.addElement(element);
                }
            }
            this.active = 0;
        }

        @Override
        public boolean removeElement(Object obj) {
            this.active = 0;
            this.previousActive = 0;
            return this.mpModel.removeElement(obj) || this.cpModel.removeElement(obj);
        }

        @Override
        public void removeAllElements() {
            this.mpModel.removeAllElements();
            this.cpModel.removeAllElements();
            this.active = 0;
            this.previousActive = 0;
        }

        @Override
        public String toString() {
            return this.mpModel.toString() + this.cpModel.toString();
        }

        @Override
        public Object[] toArray() {
            Object[] arr = new Object[this.mpModel.getSize() + this.cpModel.getSize()];
            System.arraycopy(this.mpModel.toArray(), 0, arr, 0, this.mpModel.getSize());
            System.arraycopy(this.cpModel.toArray(), 0, arr, this.mpModel.getSize(), this.cpModel.getSize());
            return arr;
        }

        public Object get(int index) {
            return index < this.mpModel.getSize() ? this.mpModel.get(index) : (index == this.mpModel.getSize() ? null : this.cpModel.get(index - this.mpModel.getSize() - 1));
        }

        public Object set(int index, Object element) {
            this.active = 0;
            this.previousActive = 0;
            return index <= this.mpModel.getSize() ? this.mpModel.set(index, element) : this.cpModel.set(index - this.mpModel.getSize() - 1, element);
        }

        public void add(int index, Object element) {
            block0 : switch (this.active) {
                case 2: {
                    this.cpModel.add(Math.max(index - this.mpModel.getSize() - 1, 0), element);
                    this.previousActive = this.active;
                    break;
                }
                case 1: {
                    this.mpModel.add(Math.min(index, this.mpModel.getSize()), element);
                    this.previousActive = this.active;
                    break;
                }
                default: {
                    switch (this.previousActive) {
                        case 2: {
                            this.cpModel.add(Math.max(index - this.mpModel.getSize() - 1, 0), element);
                            break block0;
                        }
                        case 1: {
                            this.mpModel.add(Math.min(index, this.mpModel.getSize()), element);
                            break block0;
                        }
                    }
                    if (index <= this.mpModel.getSize()) {
                        this.mpModel.add(index, element);
                        break;
                    }
                    this.cpModel.add(index - this.mpModel.getSize() - 1, element);
                }
            }
            this.active = 0;
        }

        public Object remove(int index) {
            this.active = 0;
            this.previousActive = 0;
            return index < this.mpModel.getSize() ? this.mpModel.remove(index) : (index == this.mpModel.getSize() ? null : this.cpModel.remove(index - this.mpModel.getSize() - 1));
        }

        @Override
        public void clear() {
            this.active = 0;
            this.previousActive = 0;
            this.mpModel.clear();
            this.cpModel.clear();
        }

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ListModelListener
    implements ListDataListener {
        final DefaultListModel listModel;
        final DefaultTreeModel treeModel;
        final JTree tree;

        public ListModelListener(DefaultListModel listModel, DefaultTreeModel treeModel, JTree tree) {
            this.listModel = listModel;
            this.treeModel = treeModel;
            this.tree = tree;
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            for (int i = e.getIndex1(); i >= e.getIndex0(); --i) {
                Object obj = this.listModel.getElementAt(i);
                if (!(obj instanceof ClassPathSupport.Item)) continue;
                DefaultMutableTreeNode node = PathsCustomizer.toTreeNode(obj);
                this.treeModel.insertNodeInto(node, (MutableTreeNode)this.treeModel.getRoot(), e.getIndex0());
                TreePath path = new TreePath(node.getPath());
                this.tree.setSelectionPath(path);
                this.tree.makeVisible(path);
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            for (int i = e.getIndex1(); i >= e.getIndex0(); --i) {
                this.treeModel.removeNodeFromParent((MutableTreeNode)this.treeModel.getChild(this.treeModel.getRoot(), i));
            }
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static final class SelectionListener
    implements TreeSelectionListener {
        final DefaultTreeModel treeModel;
        final JList list;
        final DefaultListModel otherListModel;
        final DefaultTreeSelectionModel otherTreeSelectionModel;

        public SelectionListener(DefaultTreeModel treeModel, JList list, DefaultListModel otherListModel, DefaultTreeSelectionModel otherTreeModel) {
            this.treeModel = treeModel;
            this.list = list;
            this.otherListModel = otherListModel;
            this.otherTreeSelectionModel = otherTreeModel;
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            int idx;
            if (e.isAddedPath()) {
                this.otherTreeSelectionModel.clearSelection();
            }
            if ((idx = this.treeModel.getIndexOfChild(this.treeModel.getRoot(), e.getPath().getLastPathComponent())) >= 0) {
                if (this.otherListModel != null) {
                    idx += this.otherListModel.getSize() + 1;
                }
                if (e.isAddedPath()) {
                    this.list.setSelectionInterval(idx, idx);
                } else {
                    this.list.removeSelectionInterval(idx, idx);
                }
            } else {
                this.list.clearSelection();
            }
        }
    }

    private static final class SelectionModel
    extends DefaultTreeSelectionModel {
        public SelectionModel() {
            this.setSelectionMode(1);
        }

        @Override
        public void setSelectionPaths(TreePath[] treePaths) {
            ArrayList<TreePath> paths = new ArrayList<TreePath>(treePaths.length);
            for (TreePath treePath : treePaths) {
                Object obj;
                Object lastPathComponent = treePath.getLastPathComponent();
                if (!(lastPathComponent instanceof DefaultMutableTreeNode) || (obj = ((DefaultMutableTreeNode)lastPathComponent).getUserObject()) == MODULEPATH || obj == CLASSPATH) continue;
                paths.add(treePath);
            }
            if (treePaths.length > 0 && paths.isEmpty()) {
                paths.addAll(Arrays.asList(this.getSelectionPaths()));
            }
            super.setSelectionPaths(paths.toArray(new TreePath[paths.size()]));
        }
    }

    private static final class Renderer
    implements TreeCellRenderer {
        private final TreeCellRenderer delegate;
        private Font normal = null;
        private Font bold = null;

        public Renderer(TreeCellRenderer renderer) {
            this.delegate = renderer;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object obj;
            JLabel label = (JLabel)this.delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (this.normal == null) {
                this.normal = label.getFont().deriveFont(0);
                this.bold = this.normal.deriveFont(1);
            }
            label.setFont(this.normal);
            if (value instanceof DefaultMutableTreeNode && ((obj = ((DefaultMutableTreeNode)value).getUserObject()) == MODULEPATH || obj == CLASSPATH)) {
                label.setText((String)obj);
                label.setFont(this.bold);
            }
            return label;
        }
    }
}

