/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.languagetool.Experimental;
import org.languagetool.RuleLoggerMessage;

@Experimental
public abstract class RuleLogger {
    private final List<Predicate<RuleLoggerMessage>> filters = new LinkedList<Predicate<RuleLoggerMessage>>();

    public abstract void log(RuleLoggerMessage var1, Level var2);

    public boolean filter(RuleLoggerMessage message) {
        return this.filters.stream().allMatch(filter -> filter.test(message));
    }

    public void addFilter(Predicate<RuleLoggerMessage> filter) {
        this.filters.add(filter);
    }

    public void removeFilter(Predicate<RuleLoggerMessage> filter) {
        this.filters.remove(filter);
    }

    public void clearFilters() {
        this.filters.clear();
    }
}

