/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.gjt.sp.jedit.OptionPane;
import org.gjt.sp.jedit.jEdit;

public class OptionGroup {
    protected final String name;
    protected final String label;
    protected final Vector<Object> members;
    private boolean sort;

    public OptionGroup(String string) {
        this.name = string;
        this.label = jEdit.getProperty("options." + string + ".label");
        this.members = new Vector();
    }

    public OptionGroup(String string, String string2, String string3) {
        this.name = string;
        this.label = string2;
        this.members = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            this.addOptionPane(string4);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public void addOptionGroup(OptionGroup optionGroup) {
        this.insertionSort(optionGroup.getLabel(), optionGroup);
    }

    public void addOptionPane(OptionPane optionPane) {
        String string = jEdit.getProperty("options." + optionPane.getName() + ".label", "NO LABEL PROPERTY: " + optionPane.getName());
        this.insertionSort(string, optionPane);
    }

    public void addOptionPane(String string) {
        String string2 = jEdit.getProperty("options." + string + ".label", "NO LABEL PROPERTY: " + string);
        this.insertionSort(string2, string);
    }

    public Enumeration<Object> getMembers() {
        return this.members.elements();
    }

    public Object getMember(int n) {
        return n >= 0 && n < this.members.size() ? this.members.elementAt(n) : null;
    }

    public int getMemberIndex(Object object) {
        return this.members.indexOf(object);
    }

    public int getMemberCount() {
        return this.members.size();
    }

    public void setSort(boolean bl) {
        this.sort = bl;
    }

    private void insertionSort(String string, Object object) {
        if (this.sort) {
            for (int i = 0; i < this.members.size(); ++i) {
                String string2;
                Object object2 = this.members.elementAt(i);
                if (object2 instanceof OptionPane) {
                    String string3 = ((OptionPane)object2).getName();
                    string2 = jEdit.getProperty("options." + string3 + ".label", "NO LABEL PROPERTY: " + string3);
                } else if (object2 instanceof String) {
                    string2 = jEdit.getProperty("options." + object2 + ".label", "NO LABEL PROPERTY: " + object2);
                } else if (object2 instanceof OptionGroup) {
                    string2 = ((OptionGroup)object2).getLabel();
                } else {
                    throw new InternalError();
                }
                if (string.compareToIgnoreCase(string2) >= 0) continue;
                this.members.insertElementAt(object, i);
                return;
            }
        }
        this.members.addElement(object);
    }
}

