package org.codehaus.plexus.classworlds;

/*
 * Copyright 2001-2006 Codehaus Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Base exception for <code>ClassWorld</code> errors.
 *
 * @author <a href="mailto:bob@eng.werken.com">bob mcwhirter</a>
 * @version $Id: ClassWorldException.java 4813 2006-11-24 14:06:14Z handyande $
 */
public class ClassWorldException
    extends Exception
{
    // ------------------------------------------------------------
    //     Instance members
    // ------------------------------------------------------------

    /**
     * The world.
     */
    private ClassWorld world;

    // ------------------------------------------------------------
    //     Constructors
    // ------------------------------------------------------------

    /**
     * Construct.
     *
     * @param world The world.
     */
    public ClassWorldException( final ClassWorld world )
    {
        this.world = world;
    }

    /**
     * Construct.
     *
     * @param world The world.
     * @param msg   The detail message.
     */
    public ClassWorldException( final ClassWorld world,
                                final String msg )
    {
        super( msg );
        this.world = world;
    }

    // ------------------------------------------------------------
    //     Instance methods
    // ------------------------------------------------------------

    /**
     * Retrieve the world.
     *
     * @return The world.
     */
    public ClassWorld getWorld()
    {
        return this.world;
    }
}
