##  <#GAPDoc Label="SubmoduleGeneratedByHomogeneousPart:example">
#   <Example><![CDATA[
##  gap> R := HomalgFieldOfRationalsInDefaultCAS( ) * "x,y,z";;
##  gap> S := GradedRing( R );;
##  gap> M := HomalgMatrix( "[ x^3, y^2, z,   z, 0, 0 ]", 2, 3, S );;
##  gap> M := LeftPresentationWithDegrees( M, [ -1, 0, 1 ] );
##  <A graded non-torsion left module presented by 2 relations for 3 generators>
##  gap> n := SubmoduleGeneratedByHomogeneousPart( 1, M );
##  <A graded left submodule given by 7 generators>
##  gap> Display( M );
##  z,  0,    0,  
##  0,  y^2*z,z^2,
##  x^3,y^2,  z   
##  
##  Cokernel of the map
##  
##  Q[x,y,z]^(1x3) --> Q[x,y,z]^(1x3),
##  
##  currently represented by the above matrix
##  (graded, degrees of generators: [ -1, 0, 1 ])
##  gap> Display( n );
##  x^2,0,0,
##  x*y,0,0,
##  y^2,0,0,
##  0,  x,0,
##  0,  y,0,
##  0,  z,0,
##  0,  0,1 
##  
##  A left submodule generated by the 7 rows of the above matrix
##  
##  (graded, degrees of generators: [ 1, 1, 1, 1, 1, 1, 1 ])
##  gap> N := UnderlyingObject( n );
##  <A graded left module presented by yet unknown relations for 7 generators>
##  gap> Display( N );
##  z, 0, 0,0,    0,  0,0,   
##  0, z, 0,0,    0,  0,0,   
##  0, 0, z,0,    0,  0,0,   
##  0, 0, 0,0,    -z, y,0,   
##  x, 0, 0,0,    y,  0,z,   
##  -y,x, 0,0,    0,  0,0,   
##  0, -y,x,0,    0,  0,0,   
##  0, 0, 0,-y,   x,  0,0,   
##  0, 0, 0,-z,   0,  x,0,   
##  0, 0, 0,0,    y*z,0,z^2, 
##  0, 0, 0,y^2*z,0,  0,x*z^2
##  
##  Cokernel of the map
##  
##  Q[x,y,z]^(1x11) --> Q[x,y,z]^(1x7),
##  
##  currently represented by the above matrix
##  
##  (graded, degrees of generators: [ 1, 1, 1, 1, 1, 1, 1 ])
##  gap> gens := GeneratorsOfModule( N );
##  <A set of 7 generators of a homalg left module>
##  gap> Display( gens );
##  x^2,0,0,
##  x*y,0,0,
##  y^2,0,0,
##  0,  x,0,
##  0,  y,0,
##  0,  z,0,
##  0,  0,1 
##  
##  a set of 7 generators given by the rows of the above matrix
##  ]]></Example>
##  <#/GAPDoc>

LoadPackage( "GradedModules" );
R := HomalgFieldOfRationalsInDefaultCAS( ) * "x,y,z";;
S := GradedRing( R );;
M := HomalgMatrix( "[ x^3, y^2, z,   z, 0, 0 ]", 2, 3, S );;
M := LeftPresentationWithDegrees( M, [ -1, 0, 1 ] );
n := SubmoduleGeneratedByHomogeneousPart( 1, M );
Display( M );
Display( n );
N := UnderlyingObject( n );
Display( N );
gens := GeneratorsOfModule( N );
Display( gens );
