define(["loading","dom","globalize","humanedate","paper-icon-button-light","cardStyle","emby-linkbutton","emby-button","indicators","flexStyles"],function(loading,dom,globalize,humanedate){"use strict";function deleteUser(page,id){var msg=globalize.translate("DeleteUserConfirmation");require(["confirm"],function(confirm){confirm({title:globalize.translate("DeleteUser"),text:msg,confirmText:globalize.translate("ButtonDelete"),primary:"cancel"}).then(function(){loading.show(),ApiClient.deleteUser(id).then(function(){loadData(page)})})})}function showUserMenu(elem){var card=dom.parentWithClass(elem,"card"),page=dom.parentWithClass(card,"page"),userId=card.getAttribute("data-userid"),menuItems=[];menuItems.push({name:globalize.translate("ButtonOpen"),id:"open",ironIcon:"mode-edit"}),menuItems.push({name:globalize.translate("ButtonLibraryAccess"),id:"access",ironIcon:"lock"}),menuItems.push({name:globalize.translate("ButtonParentalControl"),id:"parentalcontrol",ironIcon:"person"}),menuItems.push({name:globalize.translate("ButtonDelete"),id:"delete",ironIcon:"delete"}),require(["actionsheet"],function(actionsheet){actionsheet.show({items:menuItems,positionTo:card,callback:function(id){switch(id){case"open":Dashboard.navigate("useredit.html?userId="+userId);break;case"access":Dashboard.navigate("userlibraryaccess.html?userId="+userId);break;case"parentalcontrol":Dashboard.navigate("userparentalcontrol.html?userId="+userId);break;case"delete":deleteUser(page,userId)}}})})}function getUserHtml(user,addConnectIndicator){var html="",cssClass="card squareCard scalableCard squareCard-scalable";user.Policy.IsDisabled&&(cssClass+=" grayscale"),html+="<div data-userid='"+user.Id+"' class='"+cssClass+"'>",html+='<div class="cardBox visualCardBox">',html+='<div class="cardScalable visualCardBox-cardScalable">',html+='<div class="cardPadder cardPadder-square"></div>',html+='<a is="emby-linkbutton" class="cardContent" href="useredit.html?userId='+user.Id+'">';var imgUrl;user.PrimaryImageTag&&(imgUrl=ApiClient.getUserImageUrl(user.Id,{width:300,tag:user.PrimaryImageTag,type:"Primary"}));var imageClass="cardImage";user.Policy.IsDisabled&&(imageClass+=" disabledUser"),imgUrl?html+='<div class="'+imageClass+'" style="background-image:url(\''+imgUrl+"');\">":(html+='<div class="'+imageClass+' flex align-items-center justify-content-center">',html+='<i class="md-icon cardImageIcon">person</i>'),user.ConnectLinkType&&addConnectIndicator&&(html+='<div class="cardIndicators squareCardIndicators"><div title="'+globalize.translate("TooltipLinkedToEmbyConnect")+'" class="playedIndicator indicator"><i class="md-icon indicatorIcon">cloud</i></div></div>'),html+="</div>",html+="</a>",html+="</div>",html+='<div class="cardFooter visualCardBox-cardFooter">',html+='<div class="cardText flex align-items-center">',html+='<div class="flex-grow" style="overflow:hidden;text-overflow:ellipsis;">',html+=user.Name,html+="</div>",html+='<button type="button" is="paper-icon-button-light" class="btnUserMenu flex-shrink-zero"><i class="md-icon">more_horiz</i></button>',html+="</div>",html+='<div class="cardText cardText-secondary">';var lastSeen=getLastSeenText(user.LastActivityDate);return html+=""!==lastSeen?lastSeen:"&nbsp;",html+="</div>",html+="</div>",html+="</div>",html+="</div>"}function getLastSeenText(lastActivityDate){return lastActivityDate?"Last seen "+humanedate(lastActivityDate):""}function getUserSectionHtml(users,addConnectIndicator){var html="";return html+=users.map(function(u){return getUserHtml(u,addConnectIndicator)}).join("")}function renderUsers(page,users){page.querySelector(".localUsers").innerHTML=getUserSectionHtml(users,!0)}function loadData(page){loading.show(),ApiClient.getUsers().then(function(users){renderUsers(page,users),loading.hide()})}function showNewUserDialog(e){Dashboard.navigate("usernew.html")}return function(view,params){var page=view;page.querySelector(".btnAddUser").addEventListener("click",showNewUserDialog),page.querySelector(".localUsers").addEventListener("click",function(e){var btnUserMenu=dom.parentWithClass(e.target,"btnUserMenu");btnUserMenu&&showUserMenu(btnUserMenu)}),view.addEventListener("viewshow",function(){loadData(this)})}});