/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IBreakpointsExtension;
import org.eclipse.cdt.dsf.gdb.service.GDBBreakpoints_7_0;
import org.eclipse.cdt.dsf.gdb.service.GDBBreakpoints_7_2;
import org.eclipse.cdt.dsf.gdb.service.GDBBreakpoints_7_4;
import org.eclipse.cdt.dsf.gdb.service.GDBBreakpoints_7_6;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIRunControl;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointDMData;
import org.eclipse.cdt.dsf.mi.service.MIBreakpoints;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsSynchronizer;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakInsertInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakpoint;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class GDBBreakpoints_7_7
extends GDBBreakpoints_7_6 {
    private IMICommandControl fConnection;
    private IMIRunControl fRunControl;
    private CommandFactory fCommandFactory;

    public GDBBreakpoints_7_7(DsfSession session) {
        super(session);
    }

    @Override
    public void initialize(final RequestMonitor rm) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(rm){

            protected void handleSuccess() {
                GDBBreakpoints_7_7.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.fConnection = (IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class);
        this.fRunControl = (IMIRunControl)this.getServicesTracker().getService(IMIRunControl.class);
        if (this.fConnection == null || this.fRunControl == null) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", "Service is not available"));
            return;
        }
        this.fCommandFactory = this.fConnection.getCommandFactory();
        this.register(new String[]{IBreakpoints.class.getName(), IBreakpointsExtension.class.getName(), MIBreakpoints.class.getName(), GDBBreakpoints_7_0.class.getName(), GDBBreakpoints_7_2.class.getName(), GDBBreakpoints_7_4.class.getName(), GDBBreakpoints_7_6.class.getName(), GDBBreakpoints_7_7.class.getName()}, new Hashtable());
        rm.done();
    }

    @Override
    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        super.shutdown(requestMonitor);
    }

    @Override
    protected void addDynamicPrintf(final IBreakpoints.IBreakpointsTargetDMContext context, final Map<String, Object> attributes, final DataRequestMonitor<IBreakpoints.IBreakpointDMContext> drm) {
        final MIBreakpointsSynchronizer bs = (MIBreakpointsSynchronizer)this.getServicesTracker().getService(MIBreakpointsSynchronizer.class);
        if (bs != null) {
            bs.getTargetBreakpoint(context, attributes, new DataRequestMonitor<MIBreakpoint>((Executor)this.getExecutor(), drm){

                @ConfinedToDsfExecutor(value="fExecutor")
                protected void handleSuccess() {
                    MIBreakpoint miBpt = (MIBreakpoint)this.getData();
                    if (miBpt != null) {
                        bs.removeCreatedTargetBreakpoint(context, miBpt);
                        MIBreakpointDMData newBreakpoint = GDBBreakpoints_7_7.this.createMIBreakpointDMData(miBpt);
                        GDBBreakpoints_7_7.this.getBreakpointMap(context).put(newBreakpoint.getNumber(), newBreakpoint);
                        MIBreakpoints.MIBreakpointDMContext dmc = new MIBreakpoints.MIBreakpointDMContext(GDBBreakpoints_7_7.this, new IDMContext[]{context}, newBreakpoint.getNumber());
                        drm.setData((Object)dmc);
                        GDBBreakpoints_7_7.this.getSession().dispatchEvent((Object)new MIBreakpoints.BreakpointAddedEvent(dmc), GDBBreakpoints_7_7.this.getProperties());
                        drm.done();
                    } else {
                        GDBBreakpoints_7_7.this.doAddDynamicPrintf(context, attributes, (DataRequestMonitor<IBreakpoints.IBreakpointDMContext>)drm);
                    }
                }
            });
        } else {
            this.doAddDynamicPrintf(context, attributes, drm);
        }
    }

    protected void doAddDynamicPrintf(final IBreakpoints.IBreakpointsTargetDMContext context, Map<String, Object> attributes, final DataRequestMonitor<IBreakpoints.IBreakpointDMContext> finalRm) {
        final Map<String, MIBreakpointDMData> contextBreakpoints = this.getBreakpointMap(context);
        if (contextBreakpoints == null) {
            finalRm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Unknown breakpoint context", null));
            return;
        }
        final String location = this.formatLocation(attributes);
        if (location.equals("")) {
            finalRm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Unknown breakpoint context", null));
            return;
        }
        final String printfStr = (String)this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.printf_string", "");
        final Boolean enabled = (Boolean)this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.isEnabled", true);
        final Boolean isTemporary = (Boolean)this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.mi.isTemporary", false);
        final String condition = (String)this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.condition", "");
        final Integer ignoreCount = (Integer)this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.ignoreCount", 0);
        String threadId = (String)this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.mi.threadId", "0");
        final int tid = Integer.parseInt(threadId);
        Sequence.Step insertDPrintf = new Sequence.Step(){

            public void execute(final RequestMonitor rm) {
                GDBBreakpoints_7_7.this.fConnection.queueCommand(GDBBreakpoints_7_7.this.fCommandFactory.createMIDPrintfInsert(context, isTemporary, condition, ignoreCount, tid, enabled == false, location, printfStr), (DataRequestMonitor)new DataRequestMonitor<MIBreakInsertInfo>((Executor)GDBBreakpoints_7_7.this.getExecutor(), rm){

                    protected void handleSuccess() {
                        if (((MIBreakInsertInfo)this.getData()).getMIBreakpoints().length == 0) {
                            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Dynamic printf insertion failure", null));
                            return;
                        }
                        MIBreakpointDMData newBreakpoint = GDBBreakpoints_7_7.this.createMIBreakpointDMData(((MIBreakInsertInfo)this.getData()).getMIBreakpoints()[0]);
                        String reference = newBreakpoint.getNumber();
                        if (reference.isEmpty()) {
                            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Dynamic printf insertion failure", null));
                            return;
                        }
                        contextBreakpoints.put(reference, newBreakpoint);
                        MIBreakpoints.MIBreakpointDMContext dmc = new MIBreakpoints.MIBreakpointDMContext(GDBBreakpoints_7_7.this, new IDMContext[]{context}, reference);
                        finalRm.setData((Object)dmc);
                        GDBBreakpoints_7_7.this.getSession().dispatchEvent((Object)new MIBreakpoints.BreakpointAddedEvent(dmc), GDBBreakpoints_7_7.this.getProperties());
                        rm.done();
                    }

                    protected void handleError() {
                        rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Dynamic printf insertion failure", this.getStatus().getException()));
                    }
                });
            }
        };
        this.fRunControl.executeWithTargetAvailable((IDMContext)context, new Sequence.Step[]{insertDPrintf}, (RequestMonitor)finalRm);
    }
}

