/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateAttributeValueCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.AbstractSection;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDSchema;

public class XSDComplexTypeAdvancedSection
extends AbstractSection {
    private static final String EMPTY = "";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    protected CCombo blockCombo;
    protected CCombo finalCombo;
    protected CCombo mixedCombo;
    protected CCombo abstractCombo;
    private String[] finalValues = new String[]{"", "restriction", "extension", "#all"};
    private String[] blockValues = new String[]{"", "restriction", "extension", "#all"};
    private String[] booleanValues = new String[]{"", "true", "false"};

    protected void createContents(Composite parent) {
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.composite.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel abstractLabel = this.getWidgetFactory().createCLabel(this.composite, Messages._UI_LABEL_ABSTRACT);
        abstractLabel.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.abstractCombo = this.getWidgetFactory().createCCombo(this.composite);
        this.abstractCombo.setLayoutData((Object)data);
        this.abstractCombo.setEditable(false);
        this.abstractCombo.setItems(this.booleanValues);
        this.abstractCombo.addSelectionListener((SelectionListener)this);
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel blockLabel = this.getWidgetFactory().createCLabel(this.composite, Messages._UI_LABEL_BLOCK);
        blockLabel.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.blockCombo = this.getWidgetFactory().createCCombo(this.composite);
        this.blockCombo.setLayoutData((Object)data);
        this.blockCombo.setEditable(false);
        this.blockCombo.setItems(this.blockValues);
        this.blockCombo.addSelectionListener((SelectionListener)this);
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel finalLabel = this.getWidgetFactory().createCLabel(this.composite, Messages._UI_LABEL_FINAL);
        finalLabel.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.finalCombo = this.getWidgetFactory().createCCombo(this.composite);
        this.finalCombo.setLayoutData((Object)data);
        this.finalCombo.setEditable(false);
        this.finalCombo.setItems(this.finalValues);
        this.finalCombo.addSelectionListener((SelectionListener)this);
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel mixedLabel = this.getWidgetFactory().createCLabel(this.composite, Messages._UI_LABEL_MIXED);
        mixedLabel.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.mixedCombo = this.getWidgetFactory().createCCombo(this.composite);
        this.mixedCombo.setLayoutData((Object)data);
        this.mixedCombo.setEditable(false);
        this.mixedCombo.setItems(this.booleanValues);
        this.mixedCombo.addSelectionListener((SelectionListener)this);
    }

    public void doWidgetSelected(SelectionEvent e) {
        XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)this.input;
        if (e.widget == this.blockCombo) {
            String value = this.blockCombo.getText();
            UpdateAttributeValueCommand command = new UpdateAttributeValueCommand(complexType.getElement(), "block", value, Messages._UI_LABEL_BLOCK);
            command.setDeleteIfEmpty(true);
            this.getCommandStack().execute((Command)command);
        } else if (e.widget == this.finalCombo) {
            String value = this.finalCombo.getText();
            UpdateAttributeValueCommand command = new UpdateAttributeValueCommand(complexType.getElement(), "final", value, Messages._UI_LABEL_FINAL);
            command.setDeleteIfEmpty(true);
            this.getCommandStack().execute((Command)command);
        } else if (e.widget == this.abstractCombo) {
            String value = this.abstractCombo.getText();
            UpdateAttributeValueCommand command = new UpdateAttributeValueCommand(complexType.getElement(), "abstract", value, Messages._UI_LABEL_ABSTRACT);
            command.setDeleteIfEmpty(true);
            this.getCommandStack().execute((Command)command);
        } else if (e.widget == this.mixedCombo) {
            String value = this.mixedCombo.getText();
            UpdateAttributeValueCommand command = new UpdateAttributeValueCommand(complexType.getElement(), "mixed", value, Messages._UI_LABEL_MIXED);
            command.setDeleteIfEmpty(true);
            this.getCommandStack().execute((Command)command);
        }
    }

    public void refresh() {
        super.refresh();
        this.setListenerEnabled(false);
        try {
            if (this.input instanceof XSDComplexTypeDefinition) {
                XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)this.input;
                boolean enabled = true;
                enabled = complexType.getContainer() instanceof XSDSchema ? !this.isReadOnly : false;
                if (complexType.getElement().hasAttribute("block")) {
                    String blockAttValue = complexType.getElement().getAttribute("block");
                    this.blockCombo.setText(blockAttValue);
                } else {
                    this.blockCombo.setText(EMPTY);
                }
                this.blockCombo.setEnabled(enabled);
                if (complexType.getElement().hasAttribute("final")) {
                    String finalAttValue = complexType.getElement().getAttribute("final");
                    this.finalCombo.setText(finalAttValue);
                } else {
                    this.finalCombo.setText(EMPTY);
                }
                this.finalCombo.setEnabled(enabled);
                if (complexType.getElement().hasAttribute("abstract")) {
                    boolean absAttValue = complexType.isAbstract();
                    if (absAttValue) {
                        this.abstractCombo.setText(TRUE);
                    } else {
                        this.abstractCombo.setText(FALSE);
                    }
                } else {
                    this.abstractCombo.setText(EMPTY);
                }
                this.abstractCombo.setEnabled(enabled);
                if (complexType.getElement().hasAttribute("mixed")) {
                    boolean mixedValue = complexType.isMixed();
                    if (mixedValue) {
                        this.mixedCombo.setText(TRUE);
                    } else {
                        this.mixedCombo.setText(FALSE);
                    }
                } else {
                    this.mixedCombo.setText(EMPTY);
                }
            }
        }
        catch (Exception exception) {}
        this.setListenerEnabled(true);
    }
}

