/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.wip;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.chromium.CallbackSemaphore;
import org.eclipse.wst.jsdt.chromium.JsEvaluateContext;
import org.eclipse.wst.jsdt.chromium.JsObject;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.RemoteValueMapping;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.internal.JsEvaluateContextBase;
import org.eclipse.wst.jsdt.chromium.internal.wip.EvaluateHack;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipCommandProcessor;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipContextBuilder;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipValueBuilder;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipValueLoader;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.runtime.RemoteObjectValue;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.WipParamsWithResponse;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.runtime.CallArgumentParam;
import org.eclipse.wst.jsdt.chromium.util.GenericCallback;
import org.eclipse.wst.jsdt.chromium.util.MethodIsBlockingException;
import org.eclipse.wst.jsdt.chromium.wip.EvaluateToMappingExtension;
import org.json.simple.JSONValue;

abstract class WipEvaluateContextBase<DATA>
extends JsEvaluateContextBase {
    private final WipValueLoader valueLoader;
    private final EvaluateHack.EvaluateCommandHandler<DATA> evaluateHackHelper = new EvaluateHack.EvaluateCommandHandler<DATA>(){

        @Override
        public WipParamsWithResponse<DATA> createRequest(String patchedUserExpression, WipValueLoader destinationValueLoader) {
            return WipEvaluateContextBase.this.createRequestParams(patchedUserExpression, destinationValueLoader);
        }

        @Override
        public JsEvaluateContext.ResultOrException processResult(DATA response, WipValueLoader destinationValueLoader) {
            return WipEvaluateContextBase.this.processResponse(response, destinationValueLoader);
        }

        @Override
        public Exception processFailure(Exception cause) {
            return cause;
        }
    };
    static final EvaluateToMappingExtension EVALUATE_TO_MAPPING_EXTENSION = new EvaluateToMappingExtension(){

        public void evaluateSync(JsEvaluateContext evaluateContext, String expression, Map<String, ? extends JsValue> additionalContext, RemoteValueMapping targetMapping, JsEvaluateContext.EvaluateCallback evaluateCallback) throws MethodIsBlockingException {
            CallbackSemaphore callbackSemaphore = new CallbackSemaphore();
            RelayOk relayOk = this.evaluateAsync(evaluateContext, expression, additionalContext, targetMapping, evaluateCallback, (SyncCallback)callbackSemaphore);
            callbackSemaphore.acquireDefault(relayOk);
        }

        public RelayOk evaluateAsync(JsEvaluateContext evaluateContext, String expression, Map<String, ? extends JsValue> additionalContext, RemoteValueMapping targetMapping, JsEvaluateContext.EvaluateCallback evaluateCallback, SyncCallback syncCallback) {
            WipEvaluateContextBase<?> contextImpl = WipEvaluateContextBase.castArgument(evaluateContext);
            return contextImpl.evaluateAsync(expression, additionalContext, evaluateCallback, syncCallback);
        }
    };
    private static final JsEvaluateContext.PrimitiveValueFactory PRIMITIVE_VALUE_FACTORY = new JsEvaluateContext.PrimitiveValueFactory(){

        public WipValueBuilder.JsValueBase getUndefined() {
            return new JsValueBaseImpl(this, JsValue.Type.TYPE_UNDEFINED){

                public String getValueString() {
                    return "undefined";
                }

                @Override
                public CallArgumentParam createCallArgumentParam() {
                    return new CallArgumentParam(false, null, null, null);
                }
            };
        }

        public WipValueBuilder.JsValueBase getNull() {
            return new JsValueBaseImpl(this, JsValue.Type.TYPE_NULL){

                public String getValueString() {
                    return "null";
                }

                @Override
                public CallArgumentParam createCallArgumentParam() {
                    return new CallArgumentParam(true, null, null, null);
                }
            };
        }

        public WipValueBuilder.JsValueBase createString(String value) {
            return new SimpleValue(JsValue.Type.TYPE_STRING, value);
        }

        public WipValueBuilder.JsValueBase createNumber(double value) {
            return new SimpleValue(JsValue.Type.TYPE_NUMBER, value);
        }

        public WipValueBuilder.JsValueBase createNumber(long value) {
            return new SimpleValue(JsValue.Type.TYPE_NUMBER, value);
        }

        public WipValueBuilder.JsValueBase createNumber(final String stringRepresentation) {
            return new JsValueBaseImpl(this, JsValue.Type.TYPE_STRING){

                public String getValueString() {
                    return stringRepresentation;
                }

                @Override
                public CallArgumentParam createCallArgumentParam() {
                    return new CallArgumentParam(true, JSONValue.parse((String)stringRepresentation), null, null);
                }
            };
        }

        public WipValueBuilder.JsValueBase createBoolean(boolean value) {
            return new SimpleValue(JsValue.Type.TYPE_BOOLEAN, value);
        }

        abstract class JsValueBaseImpl
        extends WipValueBuilder.JsValueBase {
            private final JsValue.Type type;

            JsValueBaseImpl(JsValue.Type type) {
                this.type = type;
            }

            public JsValue.Type getType() {
                return this.type;
            }

            public JsObject asObject() {
                return null;
            }

            public boolean isTruncated() {
                return false;
            }

            public RelayOk reloadHeavyValue(JsValue.ReloadBiggerCallback callback, SyncCallback syncCallback) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getRefId() {
                return null;
            }
        }

        class SimpleValue
        extends JsValueBaseImpl {
            private final Object value;

            SimpleValue(JsValue.Type type, Object value) {
                super(type);
                this.value = value;
            }

            public String getValueString() {
                return this.value.toString();
            }

            @Override
            public CallArgumentParam createCallArgumentParam() {
                return new CallArgumentParam(true, this.value, null, null);
            }
        }
    };

    WipEvaluateContextBase(WipValueLoader valueLoader) {
        this.valueLoader = valueLoader;
    }

    public RelayOk evaluateAsync(String expression, Map<String, ? extends JsValue> additionalContext, JsEvaluateContext.EvaluateCallback callback, SyncCallback syncCallback) {
        return this.evaluateAsync(expression, additionalContext, this.valueLoader, callback, syncCallback);
    }

    public JsEvaluateContext.PrimitiveValueFactory getValueFactory() {
        return PRIMITIVE_VALUE_FACTORY;
    }

    private RelayOk evaluateAsync(String expression, Map<String, ? extends JsValue> additionalContext, WipValueLoader destinationValueLoaderParam, JsEvaluateContext.EvaluateCallback callback, SyncCallback syncCallback) {
        LinkedHashMap<String, WipValueBuilder.JsValueBase> internalAdditionalContext;
        if (additionalContext == null) {
            internalAdditionalContext = null;
        } else {
            internalAdditionalContext = new LinkedHashMap<String, WipValueBuilder.JsValueBase>(additionalContext.size());
            for (Map.Entry<String, ? extends JsValue> en : additionalContext.entrySet()) {
                WipValueBuilder.JsValueBase jsValueBase = WipValueBuilder.JsValueBase.cast(en.getValue());
                internalAdditionalContext.put(en.getKey(), jsValueBase);
            }
        }
        return this.evaluateAsyncImpl(expression, internalAdditionalContext, destinationValueLoaderParam, callback, syncCallback);
    }

    RelayOk evaluateAsyncImpl(String expression, Map<String, ? extends WipValueBuilder.SerializableValue> additionalContext, WipValueLoader destinationValueLoaderParam, final JsEvaluateContext.EvaluateCallback callback, SyncCallback syncCallback) {
        if (destinationValueLoaderParam == null) {
            destinationValueLoaderParam = this.valueLoader;
        }
        final WipValueLoader destinationValueLoader = destinationValueLoaderParam;
        if (additionalContext != null && !additionalContext.isEmpty()) {
            WipContextBuilder contextBuilder = this.valueLoader.getTabImpl().getContextBuilder();
            EvaluateHack evaluateHack = contextBuilder.getEvaluateHack();
            return evaluateHack.evaluateAsync(expression, additionalContext, destinationValueLoader, this.evaluateHackHelper, callback, syncCallback);
        }
        WipParamsWithResponse<DATA> params = this.createRequestParams(expression, destinationValueLoader);
        GenericCallback commandCallback = callback == null ? null : new GenericCallback<DATA>(){

            public void success(DATA data) {
                JsEvaluateContext.ResultOrException valueOrException = WipEvaluateContextBase.this.processResponse(data, destinationValueLoader);
                callback.success(valueOrException);
            }

            public void failure(Exception exception) {
                callback.failure(exception);
            }
        };
        WipCommandProcessor commandProcessor = this.valueLoader.getTabImpl().getCommandProcessor();
        return commandProcessor.send(params, commandCallback, syncCallback);
    }

    private JsEvaluateContext.ResultOrException processResponse(DATA data, WipValueLoader destinationValueLoader) {
        RemoteObjectValue valueData = this.getRemoteObjectValue(data);
        WipValueBuilder valueBuilder = destinationValueLoader.getValueBuilder();
        final JsValue jsValue = valueBuilder.wrap(valueData);
        if (this.getWasThrown(data) == Boolean.TRUE) {
            return new JsEvaluateContext.ResultOrException(){

                public JsValue getResult() {
                    return null;
                }

                public JsValue getException() {
                    return jsValue;
                }

                public <R> R accept(JsEvaluateContext.ResultOrException.Visitor<R> visitor) {
                    return (R)visitor.visitException(jsValue);
                }
            };
        }
        return new JsEvaluateContext.ResultOrException(){

            public JsValue getResult() {
                return jsValue;
            }

            public JsValue getException() {
                return null;
            }

            public <R> R accept(JsEvaluateContext.ResultOrException.Visitor<R> visitor) {
                return (R)visitor.visitResult(jsValue);
            }
        };
    }

    protected abstract WipParamsWithResponse<DATA> createRequestParams(String var1, WipValueLoader var2);

    protected abstract RemoteObjectValue getRemoteObjectValue(DATA var1);

    protected abstract Boolean getWasThrown(DATA var1);

    static WipEvaluateContextBase<?> castArgument(JsEvaluateContext context) {
        try {
            return (WipEvaluateContextBase)context;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Incorrect evaluate context argument", e);
        }
    }
}

