/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.ui.launch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainerConfig;
import org.eclipse.linuxtools.docker.core.IDockerContainerExit;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.docker.core.IDockerHostConfig;
import org.eclipse.linuxtools.docker.core.IDockerImageInfo;
import org.eclipse.linuxtools.docker.core.IDockerPortBinding;
import org.eclipse.linuxtools.docker.core.IDockerVolume;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.docker.ui.launch.IContainerLaunchListener;
import org.eclipse.linuxtools.docker.ui.launch.IErrorMessageHolder;
import org.eclipse.linuxtools.docker.ui.launch.IRunConsoleListener;
import org.eclipse.linuxtools.docker.ui.launch.Messages;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerConsoleOutputStream;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerConfig;
import org.eclipse.linuxtools.internal.docker.core.DockerHostConfig;
import org.eclipse.linuxtools.internal.docker.core.DockerPortBinding;
import org.eclipse.linuxtools.internal.docker.core.IConsoleListener;
import org.eclipse.linuxtools.internal.docker.ui.consoles.ConsoleOutputStream;
import org.eclipse.linuxtools.internal.docker.ui.consoles.RunConsole;
import org.eclipse.linuxtools.internal.docker.ui.launch.ContainerCommandProcess;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchConfigurationUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.wizards.DataVolumeModel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ContainerLauncher {
    private static final String ERROR_CREATING_CONTAINER = "ContainerCreateError.msg";
    private static final String ERROR_LAUNCHING_CONTAINER = "ContainerLaunchError.msg";
    private static final String ERROR_NO_CONNECTIONS = "ContainerNoConnections.msg";
    private static final String ERROR_NO_CONNECTION_WITH_URI = "ContainerNoConnectionWithURI.msg";
    private static final String DIRFILE_NAME = "copiedVolumes";
    private static RunConsole console;
    private static Map<IProject, ID> fidMap;
    private static Object lockObject;
    private static Map<String, Map<String, Set<String>>> copiedVolumesMap;
    private static Map<String, Map<String, Set<String>>> copyingVolumesMap;

    static {
        fidMap = new HashMap<IProject, ID>();
        lockObject = new Object();
        copiedVolumesMap = null;
        copyingVolumesMap = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Object object = lockObject;
        synchronized (object) {
            if (copiedVolumesMap != null) {
                IPath pluginPath = Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.eclipse.linuxtools.docker.ui"));
                IPath path = pluginPath.append(DIRFILE_NAME);
                File dirFile = path.toFile();
                FileOutputStream f = new FileOutputStream(dirFile);
                Throwable throwable = null;
                Object var7_8 = null;
                try (ObjectOutputStream oos = new ObjectOutputStream(f);){
                    oos.writeObject(copiedVolumesMap);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        super.finalize();
    }

    public ContainerLauncher() {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        Object object = lockObject;
        synchronized (object) {
            IPath pluginPath;
            IPath path;
            File dirFile;
            if (copiedVolumesMap == null && (dirFile = (path = (pluginPath = Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.eclipse.linuxtools.docker.ui"))).append(DIRFILE_NAME)).toFile()).exists()) {
                try {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (FileInputStream f = new FileInputStream(dirFile);){
                        try {
                            Throwable throwable2 = null;
                            Object var9_14 = null;
                            try (ObjectInputStream ois = new ObjectInputStream(f);){
                                copiedVolumesMap = (Map)ois.readObject();
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        catch (FileNotFoundException | ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (copiedVolumesMap == null) {
                copiedVolumesMap = new HashMap<String, Map<String, Set<String>>>();
            }
            if (copyingVolumesMap == null) {
                copyingVolumesMap = new HashMap<String, Map<String, Set<String>>>();
            }
        }
    }

    public void launch(String id, IContainerLaunchListener listener, String connectionUri, String image, String command, String commandDir, String workingDir, List<String> additionalDirs, Map<String, String> origEnv, Map<String, String> envMap, List<String> ports, boolean keep, boolean stdinSupport) {
        this.launch(id, listener, connectionUri, image, command, commandDir, workingDir, additionalDirs, origEnv, envMap, ports, keep, stdinSupport, false);
    }

    public void launch(String id, IContainerLaunchListener listener, String connectionUri, String image, String command, String commandDir, String workingDir, List<String> additionalDirs, Map<String, String> origEnv, Map<String, String> envMap, List<String> ports, boolean keep, boolean stdinSupport, boolean privilegedMode) {
        this.launch(id, listener, connectionUri, image, command, commandDir, workingDir, additionalDirs, origEnv, envMap, ports, keep, stdinSupport, privilegedMode, null);
    }

    public void launch(String id, IContainerLaunchListener listener, String connectionUri, String image, String command, String commandDir, String workingDir, List<String> additionalDirs, Map<String, String> origEnv, Map<String, String> envMap, List<String> ports, boolean keep, boolean stdinSupport, boolean privilegedMode, Map<String, String> labels) {
        this.launch(id, listener, connectionUri, image, command, commandDir, workingDir, additionalDirs, origEnv, envMap, ports, keep, stdinSupport, privilegedMode, labels, null);
    }

    public void launch(String id, IContainerLaunchListener listener, String connectionUri, String image, String command, String commandDir, String workingDir, List<String> additionalDirs, Map<String, String> origEnv, Map<String, String> envMap, List<String> ports, boolean keep, boolean stdinSupport, boolean privilegedMode, Map<String, String> labels, String seccomp) {
        List<String> cmdList = this.getCmdList(command);
        this.launch(id, listener, connectionUri, image, cmdList, workingDir, additionalDirs, origEnv, envMap, ports, keep, stdinSupport, privilegedMode, labels, seccomp);
    }

    public void launch(String id, IContainerLaunchListener listener, String connectionUri, String image, List<String> cmdList, String workingDir, List<String> additionalDirs, Map<String, String> origEnv, Map<String, String> envMap, List<String> ports, boolean keep, boolean stdinSupport, boolean privilegedMode, Map<String, String> labels, String seccomp) {
        Cloneable volumes;
        IDockerImageInfo imageInfo;
        String LAUNCH_TITLE = "ContainerLaunch.title";
        String LAUNCH_EXITED_TITLE = "ContainerLaunchExited.title";
        ArrayList<String> env = new ArrayList<String>();
        env.addAll(this.toList(origEnv));
        env.addAll(this.toList(envMap));
        HashSet<String> exposedPorts = new HashSet<String>();
        HashMap<String, List<IDockerPortBinding>> portBindingsMap = new HashMap<String, List<IDockerPortBinding>>();
        if (ports != null) {
            for (String port : ports) {
                if ((port = port.trim()).length() <= 0) continue;
                String[] segments = port.split(":");
                if (segments.length == 1) {
                    exposedPorts.add(segments[0]);
                    portBindingsMap.put(segments[0], Arrays.asList(new DockerPortBinding("", "")));
                    continue;
                }
                if (segments.length == 2) {
                    exposedPorts.add(segments[1]);
                    portBindingsMap.put(segments[1], Arrays.asList(new DockerPortBinding("", segments[0])));
                    continue;
                }
                if (segments.length != 3) continue;
                exposedPorts.add(segments[1]);
                if (segments[1].isEmpty()) {
                    portBindingsMap.put(segments[2], Arrays.asList(new DockerPortBinding("", segments[0])));
                    continue;
                }
                portBindingsMap.put(segments[2], Arrays.asList(new DockerPortBinding(segments[0], segments[1])));
            }
        }
        DockerContainerConfig.Builder builder = new DockerContainerConfig.Builder().env(env).openStdin(Boolean.valueOf(stdinSupport)).cmd(cmdList).image(image).workingDir(workingDir);
        if (listener != null && listener.getClass().getName().equals("org.eclipse.cdt.internal.docker.launcher.ContainerLaunchConfigurationDelegate$StartGdbServerJob")) {
            builder = builder.tty(Boolean.valueOf(true));
        }
        if (exposedPorts.size() > 0) {
            builder = builder.exposedPorts(exposedPorts);
        }
        if (labels != null) {
            builder = builder.labels(labels);
        }
        if (!DockerConnectionManager.getInstance().hasConnections()) {
            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DVMessages.getString(ERROR_LAUNCHING_CONTAINER), (String)DVMessages.getString(ERROR_NO_CONNECTIONS)));
            return;
        }
        IDockerConnection connection = DockerConnectionManager.getInstance().getConnectionByUri(connectionUri);
        if (connection == null) {
            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DVMessages.getString(ERROR_LAUNCHING_CONTAINER), (String)DVMessages.getFormattedString(ERROR_NO_CONNECTION_WITH_URI, connectionUri)));
            return;
        }
        if (!connection.isOpen()) {
            connection.getImages();
        }
        if ((imageInfo = connection.getImageInfo(image)) == null) {
            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DVMessages.getString(ERROR_LAUNCHING_CONTAINER), (String)Messages.getFormattedString("ContainerLaunch.imageNotFound.error", image)));
            return;
        }
        IDockerContainerConfig imageConfig = imageInfo.config();
        if (imageConfig != null && imageConfig.entrypoint() != null) {
            builder = builder.entryPoint(imageConfig.entrypoint());
        }
        DockerHostConfig.Builder hostBuilder = new DockerHostConfig.Builder().privileged(Boolean.valueOf(privilegedMode));
        if (seccomp != null) {
            hostBuilder.securityOpt(new String[]{seccomp});
        }
        HashMap<String, String> remoteVolumes = new HashMap<String, String>();
        if (!((DockerConnection)connection).isLocal()) {
            volumes = new HashMap();
            if (additionalDirs != null) {
                for (String dir : additionalDirs) {
                    remoteVolumes.put(dir, dir);
                    volumes.put(dir, new HashMap());
                }
            }
            if (workingDir != null) {
                remoteVolumes.put(workingDir, workingDir);
                volumes.put(workingDir, new HashMap());
            }
            builder = builder.volumes(volumes);
        } else {
            volumes = new ArrayList();
            if (additionalDirs != null) {
                for (String dir : additionalDirs) {
                    volumes.add(String.valueOf(dir) + ":" + dir + ":Z");
                }
            }
            if (workingDir != null) {
                volumes.add(String.valueOf(workingDir) + ":" + workingDir + ":Z");
            }
            hostBuilder = hostBuilder.binds(volumes);
        }
        DockerContainerConfig config = builder.build();
        if (portBindingsMap.size() > 0) {
            hostBuilder = hostBuilder.portBindings(portBindingsMap);
        }
        IDockerHostConfig hostConfig = hostBuilder.build();
        String imageName = image;
        boolean keepContainer = keep;
        String consoleId = id;
        IContainerLaunchListener containerListener = listener;
        Thread t = new Thread(() -> {
            String containerId = null;
            try {
                OutputStream stream;
                containerId = ((DockerConnection)connection).createContainer((IDockerContainerConfig)config, hostConfig, null);
                if (!((DockerConnection)connection).isLocal() && !remoteVolumes.isEmpty()) {
                    CopyVolumesJob job = new CopyVolumesJob(remoteVolumes, connection, containerId);
                    job.schedule();
                    job.join();
                    if (job.getResult() != Status.OK_STATUS) {
                        return;
                    }
                }
                if (config.tty()) {
                    stream = null;
                    RunConsole oldConsole = this.getConsole();
                    RunConsole rc = RunConsole.findConsole(containerId, consoleId);
                    this.setConsole(rc);
                    rc.clearConsole();
                    if (oldConsole != null) {
                        RunConsole.removeConsole(oldConsole);
                    }
                    Display.getDefault().syncExec(() -> rc.setTitle(Messages.getFormattedString("ContainerLaunch.title", new String[]{(String)cmdList.get(0), imageName})));
                    if (rc != null) {
                        stream = rc.getOutputStream();
                    }
                    DockerConsoleOutputStream out = new DockerConsoleOutputStream(stream);
                    RunConsole.attachToTerminal(connection, containerId, out);
                    if (containerListener != null) {
                        out.addConsoleListener((IConsoleListener)new RunConsoleListenerBridge(containerListener));
                    }
                    ((DockerConnection)connection).startContainer(containerId, null, null);
                    IDockerContainerInfo info = ((DockerConnection)connection).getContainerInfo(containerId);
                    if (containerListener != null) {
                        containerListener.containerInfo(info);
                    }
                    IDockerContainerExit status = ((DockerConnection)connection).waitForContainer(containerId);
                    Display.getDefault().syncExec(() -> {
                        rc.setTitle(Messages.getFormattedString("ContainerLaunchExited.title", new String[]{status.statusCode().toString(), (String)cmdList.get(0), imageName}));
                        rc.showConsole();
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IViewPart terminalView = page.findView("org.eclipse.tm.terminal.view.ui.TerminalsView");
                        CTabFolder ctabfolder = (CTabFolder)terminalView.getAdapter(CTabFolder.class);
                        if (ctabfolder != null) {
                            CTabItem[] items;
                            CTabItem[] cTabItemArray = items = ctabfolder.getItems();
                            int n = items.length;
                            int n2 = 0;
                            while (n2 < n) {
                                CTabItem item = cTabItemArray[n2];
                                if (item.getText().endsWith(info.name())) {
                                    item.dispose();
                                    break;
                                }
                                ++n2;
                            }
                        }
                    });
                    if (containerListener != null) {
                        containerListener.done();
                    }
                    if (!keepContainer) {
                        ((DockerConnection)connection).removeContainer(containerId);
                    }
                } else {
                    stream = null;
                    RunConsole oldConsole = this.getConsole();
                    RunConsole rc = RunConsole.findConsole(containerId, consoleId);
                    this.setConsole(rc);
                    rc.clearConsole();
                    if (oldConsole != null) {
                        RunConsole.removeConsole(oldConsole);
                    }
                    Display.getDefault().syncExec(() -> rc.setTitle(Messages.getFormattedString("ContainerLaunch.title", new String[]{(String)cmdList.get(0), imageName})));
                    rc.attachToConsole(connection, containerId);
                    if (rc != null) {
                        stream = rc.getOutputStream();
                        if (containerListener != null) {
                            ((ConsoleOutputStream)stream).addConsoleListener(containerListener);
                        }
                    }
                    String loggingId = String.valueOf(containerId) + "." + consoleId;
                    ((DockerConnection)connection).startContainer(containerId, loggingId, stream);
                    if (rc != null) {
                        rc.showConsole();
                    }
                    if (containerListener != null) {
                        IDockerContainerInfo info = ((DockerConnection)connection).getContainerInfo(containerId);
                        containerListener.containerInfo(info);
                    }
                    IDockerContainerExit status = ((DockerConnection)connection).waitForContainer(containerId);
                    Display.getDefault().syncExec(() -> {
                        rc.setTitle(Messages.getFormattedString("ContainerLaunchExited.title", new String[]{status.statusCode().toString(), (String)cmdList.get(0), imageName}));
                        rc.showConsole();
                    });
                    if (containerListener != null) {
                        containerListener.done();
                    }
                    if (!keepContainer) {
                        Thread.sleep(1000L);
                        ((DockerConnection)connection).stopLoggingThread(loggingId);
                        RunConsole rc2 = RunConsole.findConsole(((DockerConnection)connection).getContainer(containerId));
                        if (rc2 != null) {
                            RunConsole.removeConsole(rc2);
                        }
                        ((DockerConnection)connection).removeContainer(containerId);
                    }
                }
            }
            catch (DockerException e2) {
                if (!keepContainer && containerId != null) {
                    try {
                        ((DockerConnection)connection).removeContainer(containerId);
                    }
                    catch (InterruptedException | DockerException throwable) {
                        // empty catch block
                    }
                }
                Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DVMessages.getFormattedString(ERROR_CREATING_CONTAINER, imageName), (String)e2.getMessage()));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ((DockerConnection)connection).getContainers(true);
        });
        t.start();
    }

    public int fetchContainerDirs(String connectionUri, String imageName, List<String> containerDirs, IPath hostDir) {
        IDockerConnection connection = DockerConnectionManager.getInstance().getConnectionByUri(connectionUri);
        if (connection == null) {
            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DVMessages.getString(ERROR_LAUNCHING_CONTAINER), (String)DVMessages.getFormattedString(ERROR_NO_CONNECTION_WITH_URI, connectionUri)));
            return -1;
        }
        CopyVolumesFromImageJob job = new CopyVolumesFromImageJob(connection, imageName, containerDirs, new ArrayList<String>(), hostDir);
        job.schedule();
        return 0;
    }

    public int fetchContainerDirs(String connectionUri, String imageName, List<String> containerDirs, List<String> excludedDirs, IPath hostDir) {
        IDockerConnection connection = DockerConnectionManager.getInstance().getConnectionByUri(connectionUri);
        if (connection == null) {
            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DVMessages.getString(ERROR_LAUNCHING_CONTAINER), (String)DVMessages.getFormattedString(ERROR_NO_CONNECTION_WITH_URI, connectionUri)));
            return -1;
        }
        CopyVolumesFromImageJob job = new CopyVolumesFromImageJob(connection, imageName, containerDirs, excludedDirs, hostDir);
        job.schedule();
        return 0;
    }

    public int fetchContainerDirsSync(String connectionUri, String imageName, List<String> containerDirs, IPath hostDir) {
        IDockerConnection connection = DockerConnectionManager.getInstance().getConnectionByUri(connectionUri);
        if (connection == null) {
            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DVMessages.getString(ERROR_LAUNCHING_CONTAINER), (String)DVMessages.getFormattedString(ERROR_NO_CONNECTION_WITH_URI, connectionUri)));
            return -1;
        }
        CopyVolumesFromImageJob job = new CopyVolumesFromImageJob(connection, imageName, containerDirs, new ArrayList<String>(), hostDir);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            return -1;
        }
        return 0;
    }

    public int fetchContainerDirsSync(String connectionUri, String imageName, List<String> containerDirs, List<String> excludedDirs, IPath hostDir) {
        IDockerConnection connection = DockerConnectionManager.getInstance().getConnectionByUri(connectionUri);
        if (connection == null) {
            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DVMessages.getString(ERROR_LAUNCHING_CONTAINER), (String)DVMessages.getFormattedString(ERROR_NO_CONNECTION_WITH_URI, connectionUri)));
            return -1;
        }
        CopyVolumesFromImageJob job = new CopyVolumesFromImageJob(connection, imageName, containerDirs, excludedDirs, hostDir);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            return -1;
        }
        return 0;
    }

    public Process runCommand(String connectionName, String imageName, IProject project, IErrorMessageHolder errMsgHolder, String command, String commandDir, String workingDir, List<String> additionalDirs, Map<String, String> origEnv, Properties envMap, boolean supportStdin, boolean privilegedMode, HashMap<String, String> labels, boolean keepContainer) {
        List<String> cmdList = this.getCmdList(command);
        return this.runCommand(connectionName, imageName, project, errMsgHolder, cmdList, workingDir, additionalDirs, origEnv, envMap, supportStdin, privilegedMode, labels, keepContainer);
    }

    public Process runCommand(String connectionName, String imageName, IProject project, IErrorMessageHolder errMsgHolder, List<String> cmdList, String workingDir, List<String> additionalDirs, Map<String, String> origEnv, Properties envMap, boolean supportStdin, boolean privilegedMode, HashMap<String, String> labels, boolean keepContainer) {
        AbstractCollection volumes;
        IPath p;
        List entrypoint;
        Integer uid = null;
        Integer gid = null;
        String os = System.getProperty("os.name");
        if (os.indexOf("nux") > 0) {
            ID ugid = fidMap.get(project);
            if (ugid == null) {
                try {
                    uid = (Integer)Files.getAttribute(project.getLocation().toFile().toPath(), "unix:uid", new LinkOption[0]);
                    gid = (Integer)Files.getAttribute(project.getLocation().toFile().toPath(), "unix:gid", new LinkOption[0]);
                    ugid = new ID(uid, gid);
                    fidMap.put(project, ugid);
                }
                catch (IOException iOException) {}
            } else {
                uid = ugid.getuid();
                gid = ugid.getgid();
            }
        }
        ArrayList<String> env = new ArrayList<String>();
        env.addAll(this.toList(origEnv));
        env.addAll(this.toList(envMap));
        HashMap portBindingsMap = new HashMap();
        IDockerConnection[] connections = DockerConnectionManager.getInstance().getConnections();
        if (connections == null || connections.length == 0) {
            errMsgHolder.setErrorMessage(Messages.getString("ContainerLaunch.noConnections.error"));
            return null;
        }
        IDockerConnection connection = null;
        IDockerConnection[] iDockerConnectionArray = connections;
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            IDockerConnection c = iDockerConnectionArray[n2];
            if (c.getUri().equals(connectionName)) {
                connection = c;
                break;
            }
            ++n2;
        }
        if (connection == null) {
            errMsgHolder.setErrorMessage(Messages.getFormattedString("ContainerLaunch.connectionNotFound.error", connectionName));
            return null;
        }
        List images = connection.getImages();
        if (images.isEmpty()) {
            errMsgHolder.setErrorMessage(Messages.getString("ContainerLaunch.noImages.error"));
            return null;
        }
        IDockerImageInfo info = connection.getImageInfo(imageName);
        if (info == null) {
            errMsgHolder.setErrorMessage(Messages.getFormattedString("ContainerLaunch.imageNotFound.error", imageName));
            return null;
        }
        DockerContainerConfig.Builder builder = new DockerContainerConfig.Builder().openStdin(Boolean.valueOf(supportStdin)).cmd(cmdList).image(imageName).workingDir(workingDir);
        if (info.containerConfig() != null && (entrypoint = info.containerConfig().entrypoint()) != null && !entrypoint.isEmpty()) {
            builder = builder.entryPoint(entrypoint);
        }
        if (uid != null) {
            builder = builder.user(uid.toString());
        }
        if (labels != null) {
            builder = builder.labels(labels);
        }
        DockerHostConfig.Builder hostBuilder = new DockerHostConfig.Builder().privileged(Boolean.valueOf(privilegedMode));
        HashMap remoteVolumes = new HashMap();
        HashMap<String, String> remoteDataVolumes = new HashMap<String, String>();
        TreeSet<String> readOnlyVolumes = new TreeSet<String>();
        if (!((DockerConnection)connection).isLocal()) {
            if (additionalDirs != null) {
                for (String dir : additionalDirs) {
                    p = new Path(dir).removeTrailingSeparator();
                    remoteVolumes.put(p.toPortableString(), new HashMap());
                    remoteDataVolumes.put(p.toPortableString(), p.toPortableString());
                    if (!dir.contains(":")) continue;
                    DataVolumeModel dvm = DataVolumeModel.parseString(dir);
                    switch (dvm.getMountType()) {
                        case HOST_FILE_SYSTEM: {
                            dir = dvm.getHostPathMount();
                            remoteDataVolumes.put(dir, dvm.getContainerMount());
                            if (!dvm.isReadOnly()) break;
                            readOnlyVolumes.add(dir);
                            break;
                        }
                    }
                }
            }
            if (workingDir != null) {
                IPath p2 = new Path(workingDir).removeTrailingSeparator();
                remoteVolumes.put(p2.toPortableString(), new HashMap());
                remoteDataVolumes.put(p2.toPortableString(), p2.toPortableString());
            }
            try {
                volumes = new ArrayList();
                List volumeList = ((DockerConnection)connection).getVolumes();
                for (IDockerVolume volume : volumeList) {
                    Path working;
                    String name = volume.name();
                    String containerDir = (String)remoteDataVolumes.get(name);
                    if (containerDir == null) continue;
                    if (readOnlyVolumes.contains(name)) {
                        volumes.add(String.valueOf(name) + ":" + containerDir + ":Z,ro");
                        readOnlyVolumes.remove(name);
                    } else {
                        volumes.add(String.valueOf(name) + ":" + containerDir + ":Z");
                    }
                    remoteVolumes.remove(name);
                    remoteDataVolumes.remove(name);
                    Path p3 = new Path(containerDir);
                    if (workingDir == null || !p3.isPrefixOf((IPath)(working = new Path(workingDir)))) continue;
                    String s = working.removeTrailingSeparator().toPortableString();
                    remoteVolumes.remove(s);
                    remoteDataVolumes.remove(s);
                }
                if (!volumes.isEmpty()) {
                    hostBuilder = hostBuilder.binds((List)((Object)volumes));
                }
            }
            catch (DockerException e) {
                Activator.log(e);
            }
            if (!remoteVolumes.isEmpty()) {
                builder = builder.volumes(remoteVolumes);
            }
        } else {
            volumes = new TreeSet();
            ArrayList<String> volumesFrom = new ArrayList<String>();
            if (additionalDirs != null) {
                for (String dir : additionalDirs) {
                    IPath p4 = new Path(dir).removeTrailingSeparator();
                    if (dir.contains(":")) {
                        DataVolumeModel dvm = DataVolumeModel.parseString(dir);
                        switch (dvm.getMountType()) {
                            case HOST_FILE_SYSTEM: {
                                String bind = String.valueOf(LaunchConfigurationUtils.convertToUnixPath(dvm.getHostPathMount())) + ':' + dvm.getContainerPath() + ":Z";
                                if (dvm.isReadOnly()) {
                                    bind = String.valueOf(bind) + ",ro";
                                }
                                volumes.add(bind);
                                break;
                            }
                            case CONTAINER: {
                                volumesFrom.add(dvm.getContainerMount());
                                break;
                            }
                        }
                        continue;
                    }
                    volumes.add(String.valueOf(p4.toPortableString()) + ":" + p4.toPortableString() + ":Z");
                }
            }
            if (workingDir != null) {
                p = new Path(workingDir).removeTrailingSeparator();
                volumes.add(String.valueOf(p.toPortableString()) + ":" + p.toPortableString() + ":Z");
            }
            ArrayList volumeList = new ArrayList(volumes);
            hostBuilder = hostBuilder.binds(volumeList);
            if (!volumesFrom.isEmpty()) {
                hostBuilder = hostBuilder.volumesFrom(volumesFrom);
            }
        }
        DockerContainerConfig config = builder.build();
        if (portBindingsMap.size() > 0) {
            hostBuilder = hostBuilder.portBindings(portBindingsMap);
        }
        IDockerHostConfig hostConfig = hostBuilder.build();
        String containerId = null;
        try {
            containerId = ((DockerConnection)connection).createContainer((IDockerContainerConfig)config, hostConfig, null);
        }
        catch (InterruptedException | DockerException e) {
            errMsgHolder.setErrorMessage(e.getMessage());
            return null;
        }
        String id = containerId;
        IDockerConnection conn = connection;
        if (!((DockerConnection)conn).isLocal() && !remoteVolumes.isEmpty()) {
            CopyVolumesJob job = new CopyVolumesJob(remoteDataVolumes, conn, id);
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        for (String readonly : readOnlyVolumes) {
            remoteDataVolumes.remove(readonly);
        }
        return new ContainerCommandProcess(connection, imageName, containerId, null, remoteDataVolumes, keepContainer);
    }

    public void cleanup(String connectionUri, IDockerContainerInfo info) {
        if (!DockerConnectionManager.getInstance().hasConnections()) {
            return;
        }
        IDockerConnection connection = DockerConnectionManager.getInstance().getConnectionByUri(connectionUri);
        if (connection == null) {
            return;
        }
        try {
            connection.killContainer(info.id());
        }
        catch (InterruptedException | DockerException throwable) {
            // empty catch block
        }
    }

    private RunConsole getConsole() {
        return console;
    }

    private void setConsole(RunConsole cons) {
        console = cons;
    }

    private List<String> getCmdList(String s) {
        ArrayList<String> list = new ArrayList<String>();
        int length = s.length();
        boolean insideQuote1 = false;
        boolean insideQuote2 = false;
        boolean escaped = false;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            if (escaped) {
                buffer.append(c);
                escaped = false;
            }
            switch (c) {
                case '\'': {
                    if (!insideQuote2) {
                        insideQuote1 ^= true;
                        break;
                    }
                    buffer.append(c);
                    break;
                }
                case '\"': {
                    if (!insideQuote1) {
                        insideQuote2 ^= true;
                        break;
                    }
                    buffer.append(c);
                    break;
                }
                case '\\': {
                    escaped = true;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (insideQuote1 || insideQuote2) {
                        buffer.append(c);
                        break;
                    }
                    String item = buffer.toString();
                    buffer.setLength(0);
                    if (item.length() <= 0) break;
                    list.add(item);
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        String item = buffer.toString();
        if (item.length() > 0) {
            list.add(item);
        }
        return list;
    }

    private List<String> toList(Map variables) {
        ArrayList<String> result = new ArrayList<String>();
        if (variables != null) {
            Set entries = variables.entrySet();
            for (Map.Entry entry : entries) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                String envEntry = String.valueOf(key) + "=" + value;
                result.add(envEntry);
            }
        }
        return result;
    }

    public Set<String> getCopiedVolumes(String connectionName, String imageName) {
        Set<String> imageSet;
        Map<String, Set<String>> connectionMap;
        Set<String> copiedSet = new HashSet<String>();
        if (copiedVolumesMap != null && (connectionMap = copiedVolumesMap.get(connectionName)) != null && (imageSet = connectionMap.get(imageName)) != null) {
            copiedSet = imageSet;
        }
        return copiedSet;
    }

    private class BlockingInputStream
    extends InputStream {
        private InputStream in;

        public BlockingInputStream(InputStream in) {
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            return this.in.read();
        }
    }

    private class CopyVolumesFromImageJob
    extends Job {
        private static final String COPY_VOLUMES_FROM_JOB_TITLE = "ContainerLaunch.copyVolumesFromJob.title";
        private static final String COPY_VOLUMES_FROM_DESC = "ContainerLaunch.copyVolumesFromJob.desc";
        private static final String COPY_VOLUMES_FROM_TASK = "ContainerLaunch.copyVolumesFromJob.task";
        private final List<String> volumes;
        private final List<String> excludedDirs;
        private final IDockerConnection connection;
        private final String image;
        private final IPath target;
        private Set<String> dirList;
        private Set<String> copyingList;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CopyVolumesFromImageJob(IDockerConnection connection, String image, List<String> volumes, List<String> excludedDirs, IPath target) {
            super(Messages.getString(COPY_VOLUMES_FROM_JOB_TITLE));
            this.volumes = volumes;
            this.excludedDirs = excludedDirs;
            this.connection = connection;
            this.image = image;
            this.target = target;
            HashMap<String, Set<String>> dirMap = null;
            HashMap<String, Set<String>> copyingMap = null;
            Object object = lockObject;
            synchronized (object) {
                String uri = connection.getUri();
                dirMap = (HashMap<String, Set<String>>)copiedVolumesMap.get(uri);
                if (dirMap == null) {
                    dirMap = new HashMap<String, Set<String>>();
                    copiedVolumesMap.put(uri, dirMap);
                }
                this.dirList = (Set)dirMap.get(image);
                if (this.dirList == null) {
                    this.dirList = new LinkedHashSet<String>();
                    dirMap.put(image, this.dirList);
                }
                if ((copyingMap = (HashMap<String, Set<String>>)copyingVolumesMap.get(uri)) == null) {
                    copyingMap = new HashMap<String, Set<String>>();
                    copyingVolumesMap.put(uri, copyingMap);
                }
                this.copyingList = (Set)copyingMap.get(image);
                if (this.copyingList == null) {
                    this.copyingList = new LinkedHashSet<String>();
                    copyingMap.put(image, this.copyingList);
                }
            }
        }

        /*
         * Exception decompiling
         */
        protected IStatus run(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[TRYBLOCK]], but top level block is 138[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class CopyVolumesJob
    extends Job {
        private static final String COPY_VOLUMES_JOB_TITLE = "ContainerLaunch.copyVolumesJob.title";
        private static final String COPY_VOLUMES_DESC = "ContainerLaunch.copyVolumesJob.desc";
        private static final String COPY_VOLUMES_TASK = "ContainerLaunch.copyVolumesJob.task";
        private static final String ERROR_COPYING_VOLUME = "ContainerLaunch.copyVolumesJob.error";
        private final Map<String, String> volumes;
        private final IDockerConnection connection;
        private final String containerId;

        public CopyVolumesJob(Map<String, String> volumes, IDockerConnection connection, String containerId) {
            super(Messages.getString(COPY_VOLUMES_JOB_TITLE));
            this.volumes = volumes;
            this.connection = connection;
            this.containerId = containerId;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(Messages.getFormattedString(COPY_VOLUMES_DESC, this.containerId), this.volumes.size());
            Iterator<String> iterator = this.volumes.keySet().iterator();
            IStatus status = Status.OK_STATUS;
            while (iterator.hasNext()) {
                if (monitor.isCanceled()) {
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                String hostDirectory = iterator.next();
                String containerDirectory = this.volumes.get(hostDirectory);
                if (!containerDirectory.endsWith("/")) {
                    containerDirectory = String.valueOf(containerDirectory) + "/";
                }
                if (!hostDirectory.endsWith("/")) {
                    hostDirectory = String.valueOf(hostDirectory) + "/";
                }
                monitor.setTaskName(Messages.getFormattedString(COPY_VOLUMES_TASK, hostDirectory));
                try {
                    try {
                        ((DockerConnection)this.connection).copyToContainer(hostDirectory, this.containerId, containerDirectory);
                        monitor.worked(1);
                    }
                    catch (IOException | InterruptedException | DockerException e) {
                        monitor.done();
                        String dir = hostDirectory;
                        Display.getDefault().syncExec(() -> this.lambda$0(dir, (Exception)e));
                        status = new Status(4, "org.eclipse.linuxtools.docker.ui", e.getMessage());
                        monitor.done();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
            return status;
        }

        private /* synthetic */ void lambda$0(String string, Exception exception) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getFormattedString(ERROR_COPYING_VOLUME, new String[]{string, this.containerId}), (String)exception.getMessage());
        }
    }

    private class ID {
        private Integer uid;
        private Integer gid;

        public ID(Integer uid, Integer gid) {
            this.uid = uid;
            this.gid = gid;
        }

        public Integer getuid() {
            return this.uid;
        }

        public Integer getgid() {
            return this.gid;
        }
    }

    private class RunConsoleListenerBridge
    implements IConsoleListener {
        private IRunConsoleListener listener;

        public RunConsoleListenerBridge(IRunConsoleListener listener) {
            this.listener = listener;
        }

        public void newOutput(String output) {
            this.listener.newOutput(output);
        }
    }
}

