/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.themes;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.tm4e.ui.internal.preferences.PreferenceHelper;
import org.eclipse.tm4e.ui.internal.themes.AbstractThemeManager;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.IThemeAssociation;
import org.eclipse.tm4e.ui.themes.Theme;
import org.eclipse.tm4e.ui.themes.ThemeAssociation;
import org.eclipse.tm4e.ui.utils.PreferenceUtils;
import org.osgi.service.prefs.BackingStoreException;

public class ThemeManager
extends AbstractThemeManager {
    private static final String EXTENSION_THEMES = "themes";
    private static final String THEME_ELT = "theme";
    private static final String THEME_ASSOCIATION_ELT = "themeAssociation";
    private static ThemeManager INSTANCE;

    public static ThemeManager getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = ThemeManager.createInstance();
        return INSTANCE;
    }

    private static synchronized ThemeManager createInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        ThemeManager manager = new ThemeManager();
        manager.load();
        return manager;
    }

    private ThemeManager() {
    }

    private void load() {
        this.loadThemesFromExtensionPoints();
        this.loadThemesFromPreferences();
    }

    private void loadThemesFromExtensionPoints() {
        IConfigurationElement[] cf;
        IConfigurationElement[] iConfigurationElementArray = cf = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.tm4e.ui", EXTENSION_THEMES);
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            String name = ce.getName();
            if (THEME_ELT.equals(name)) {
                Theme theme = new Theme(ce);
                super.registerTheme(theme);
            } else if (THEME_ASSOCIATION_ELT.equals(name)) {
                super.registerThemeAssociation(new ThemeAssociation(ce));
            }
            ++n2;
        }
    }

    private void loadThemesFromPreferences() {
        int n;
        int n2;
        Object[] objectArray;
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.tm4e.ui");
        String json = prefs.get("org.eclipse.tm4e.ui.themes", null);
        if (json != null) {
            ITheme[] themes = PreferenceHelper.loadThemes(json);
            objectArray = themes;
            n2 = themes.length;
            n = 0;
            while (n < n2) {
                Object theme = objectArray[n];
                super.registerTheme((ITheme)theme);
                ++n;
            }
        }
        if ((json = prefs.get("org.eclipse.tm4e.ui.themeAssociations", null)) != null) {
            IThemeAssociation[] themeAssociations = PreferenceHelper.loadThemeAssociations(json);
            objectArray = themeAssociations;
            n2 = themeAssociations.length;
            n = 0;
            while (n < n2) {
                Object association = objectArray[n];
                super.registerThemeAssociation((IThemeAssociation)association);
                ++n;
            }
        }
    }

    @Override
    public void save() throws BackingStoreException {
        String json = PreferenceHelper.toJsonThemes(Arrays.stream(this.getThemes()).filter(t -> t.getPluginId() == null).collect(Collectors.toList()));
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.tm4e.ui");
        prefs.put("org.eclipse.tm4e.ui.themes", json);
        json = PreferenceHelper.toJsonThemeAssociations(Arrays.stream(this.getAllThemeAssociations()).filter(t -> t.getPluginId() == null).collect(Collectors.toList()));
        prefs.put("org.eclipse.tm4e.ui.themeAssociations", json);
        prefs.flush();
    }

    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener themeChangeListener) {
        IEclipsePreferences preferences = PreferenceUtils.getE4PreferenceStore();
        if (preferences != null) {
            preferences.addPreferenceChangeListener(themeChangeListener);
        }
        if ((preferences = InstanceScope.INSTANCE.getNode("org.eclipse.tm4e.ui")) != null) {
            preferences.addPreferenceChangeListener(themeChangeListener);
        }
    }

    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener themeChangeListener) {
        IEclipsePreferences preferences = PreferenceUtils.getE4PreferenceStore();
        if (preferences != null) {
            preferences.removePreferenceChangeListener(themeChangeListener);
        }
        if ((preferences = InstanceScope.INSTANCE.getNode("org.eclipse.tm4e.ui")) != null) {
            preferences.removePreferenceChangeListener(themeChangeListener);
        }
    }
}

