/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineInfo;

public class ManagedCommandLineGenerator
implements IManagedCommandLineGenerator {
    public final String AT = "@";
    public final String COLON = ":";
    public final String DOT = ".";
    public final String ECHO = "echo";
    public final String IN_MACRO = "$<";
    public final String LINEBREAK = "\\\n";
    public final String NEWLINE = System.getProperty("line.separator");
    public final String OUT_MACRO = "$@";
    public final String SEPARATOR = "/";
    public final String SINGLE_QUOTE = "'";
    public final String DOUBLE_QUOTE = "\"";
    public final String TAB = "\t";
    public final String WHITESPACE = " ";
    public final String WILDCARD = "%";
    public final String UNDERLINE = "_";
    public final String EMPTY = "";
    public final String VAR_FIRST_CHAR = "$";
    public final char VAR_SECOND_CHAR = (char)123;
    public final String VAR_FINAL_CHAR = "}";
    public final String CLASS_PROPERTY_PREFIX = "get";
    public final String CMD_LINE_PRM_NAME = "COMMAND";
    public final String FLAGS_PRM_NAME = "FLAGS";
    public final String OUTPUT_FLAG_PRM_NAME = "OUTPUT_FLAG";
    public final String OUTPUT_PREFIX_PRM_NAME = "OUTPUT_PREFIX";
    public final String OUTPUT_PRM_NAME = "OUTPUT";
    public final String INPUTS_PRM_NAME = "INPUTS";
    private static ManagedCommandLineGenerator cmdLineGen;

    protected ManagedCommandLineGenerator() {
        cmdLineGen = null;
    }

    public static ManagedCommandLineGenerator getCommandLineGenerator() {
        if (cmdLineGen == null) {
            cmdLineGen = new ManagedCommandLineGenerator();
        }
        return cmdLineGen;
    }

    private String makeVariable(String variableName) {
        return "${" + variableName + "}";
    }

    @Override
    public IManagedCommandLineInfo generateCommandLineInfo(ITool tool, String commandName, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, String commandLinePattern) {
        if (commandLinePattern == null || commandLinePattern.length() <= 0) {
            commandLinePattern = "${COMMAND} ${FLAGS} ${OUTPUT_FLAG} ${OUTPUT_PREFIX}${OUTPUT} ${INPUTS}";
        }
        if (outputName.length() > 0 && outputName.indexOf("$(") != 0) {
            outputName = "\"" + outputName + "\"";
        }
        String inputsStr = "";
        if (inputResources != null) {
            String[] stringArray = inputResources;
            int n = inputResources.length;
            int n2 = 0;
            while (n2 < n) {
                String inp = stringArray[n2];
                if (inp != null && inp.length() > 0) {
                    if (inp.indexOf("$(") != 0) {
                        inp = "\"" + inp + "\"";
                    }
                    inputsStr = String.valueOf(inputsStr) + inp + " ";
                }
                ++n2;
            }
            inputsStr = inputsStr.trim();
        }
        String flagsStr = this.stringArrayToString(flags);
        String command = commandLinePattern;
        command = command.replace(this.makeVariable("COMMAND"), commandName);
        command = command.replace(this.makeVariable("FLAGS"), flagsStr);
        command = command.replace(this.makeVariable("OUTPUT_FLAG"), outputFlag);
        command = command.replace(this.makeVariable("OUTPUT_PREFIX"), outputPrefix);
        command = command.replace(this.makeVariable("OUTPUT"), outputName);
        command = command.replace(this.makeVariable("INPUTS"), inputsStr);
        command = command.replace(this.makeVariable("COMMAND".toLowerCase()), commandName);
        command = command.replace(this.makeVariable("FLAGS".toLowerCase()), flagsStr);
        command = command.replace(this.makeVariable("OUTPUT_FLAG".toLowerCase()), outputFlag);
        command = command.replace(this.makeVariable("OUTPUT_PREFIX".toLowerCase()), outputPrefix);
        command = command.replace(this.makeVariable("OUTPUT".toLowerCase()), outputName);
        command = command.replace(this.makeVariable("INPUTS".toLowerCase()), inputsStr);
        return new ManagedCommandLineInfo(command.trim(), commandLinePattern, commandName, this.stringArrayToString(flags), outputFlag, outputPrefix, outputName, this.stringArrayToString(inputResources));
    }

    private String stringArrayToString(String[] array) {
        if (array == null || array.length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < array.length) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(array[i]);
            ++i;
        }
        return sb.toString().trim();
    }
}

