/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.List;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.preferences.HeaderSubstitutionMapEditDialog;
import org.eclipse.cdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.refactoring.includes.HeaderSubstitutionMap;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class HeaderSubstitutionBlock
extends OptionsConfigurationBlock {
    static final OptionsConfigurationBlock.Key KEY_HEADER_SUBSTITUTION = HeaderSubstitutionBlock.getCDTUIKey("organizeIncludes.headerSubstitution");
    private static OptionsConfigurationBlock.Key[] ALL_KEYS = new OptionsConfigurationBlock.Key[]{KEY_HEADER_SUBSTITUTION};
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private static final int IDX_UP = 3;
    private static final int IDX_DOWN = 4;
    private final ListDialogField<HeaderSubstitutionMap> fHeaderMapsList;
    private IStatus fStatus;

    public HeaderSubstitutionBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, ALL_KEYS, container);
        ListAdapter adapter = new ListAdapter();
        String[] buttons = new String[]{PreferencesMessages.HeaderSubstitutionBlock_add_button, PreferencesMessages.HeaderSubstitutionBlock_edit_button, PreferencesMessages.HeaderSubstitutionBlock_remove_button, PreferencesMessages.HeaderSubstitutionBlock_up_button, PreferencesMessages.HeaderSubstitutionBlock_down_button};
        this.fHeaderMapsList = new ListDialogField<HeaderSubstitutionMap>(adapter, buttons, (IBaseLabelProvider)new HeaderMapLabelProvider());
        this.fHeaderMapsList.setLabelText(PreferencesMessages.HeaderSubstitutionBlock_header_substitution_maps);
        this.fHeaderMapsList.setDialogFieldListener(adapter);
        this.fHeaderMapsList.setRemoveButtonIndex(2);
        this.fHeaderMapsList.setUpButtonIndex(3);
        this.fHeaderMapsList.setDownButtonIndex(4);
        String[] columnsHeaders = new String[]{PreferencesMessages.HeaderSubstitutionBlock_name_column_title, PreferencesMessages.HeaderSubstitutionBlock_languages_column_title};
        ColumnLayoutData[] columnData = new ColumnLayoutData[]{new ColumnWeightData(5), new ColumnWeightData(2)};
        this.fHeaderMapsList.setTableColumns(new ListDialogField.ColumnsDescription(columnData, columnsHeaders, true));
        this.loadHeaderMaps();
        if (this.fHeaderMapsList.getSize() > 0) {
            this.fHeaderMapsList.selectFirstElement();
        } else {
            this.fHeaderMapsList.enableButton(1, false);
        }
        this.fStatus = new StatusInfo();
    }

    private void loadHeaderMaps() {
        String str = this.getValue(KEY_HEADER_SUBSTITUTION);
        if (str == null) {
            return;
        }
        List<HeaderSubstitutionMap> maps = HeaderSubstitutionMap.deserializeMaps(str);
        this.fHeaderMapsList.setElements(maps);
    }

    @Override
    protected boolean processChanges(IWorkbenchPreferenceContainer container) {
        boolean result = super.processChanges(container);
        List<HeaderSubstitutionMap> maps = this.fHeaderMapsList.getElements();
        String str = HeaderSubstitutionMap.serializeMaps(maps);
        this.setValue(KEY_HEADER_SUBSTITUTION, str);
        return result;
    }

    @Override
    protected void settingsUpdated() {
        if (this.fHeaderMapsList != null) {
            this.loadHeaderMaps();
        }
        super.settingsUpdated();
    }

    @Override
    protected Control createContents(Composite parent) {
        this.setShell(parent.getShell());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        PixelConverter conv = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        LayoutUtil.setHorizontalSpan((Control)this.fHeaderMapsList.getLabelControl(composite), 2);
        GridData data = new GridData(1808);
        data.widthHint = conv.convertWidthInCharsToPixels(50);
        Control listControl = this.fHeaderMapsList.getListControl(composite);
        listControl.setLayoutData((Object)data);
        Composite buttonsControl = this.fHeaderMapsList.getButtonBox(composite);
        buttonsControl.setLayoutData((Object)new GridData(258));
        this.validateSettings(null, null, null);
        return composite;
    }

    @Override
    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        if (!this.areSettingsEnabled()) {
            return;
        }
        this.fStatus = new StatusInfo();
        this.fContext.statusChanged(this.fStatus);
    }

    private void onButtonPressed(ListDialogField<HeaderSubstitutionMap> field, int index) {
        HeaderSubstitutionMapEditDialog dialog;
        HeaderSubstitutionMap edited = null;
        if (index != 0) {
            edited = field.getSelectedElements().get(0);
        }
        if ((index == 0 || index == 1) && (dialog = new HeaderSubstitutionMapEditDialog(this.getShell(), edited, field.getElements())).open() == 0) {
            if (edited != null) {
                field.replaceElement(edited, dialog.getResult());
            } else {
                field.addElement(dialog.getResult());
            }
        }
    }

    private class HeaderMapLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            HeaderSubstitutionMap map = (HeaderSubstitutionMap)element;
            if (columnIndex == 0) {
                return map.getName();
            }
            return map.isCppOnly() ? PreferencesMessages.HeaderSubstitutionBlock_cpp_only : PreferencesMessages.HeaderSubstitutionBlock_c_and_cpp;
        }

        public Font getFont(Object element) {
            return null;
        }
    }

    public class ListAdapter
    implements IListAdapter<HeaderSubstitutionMap>,
    IDialogFieldListener {
        private boolean canEdit(List<HeaderSubstitutionMap> selectedElements) {
            return selectedElements.size() == 1;
        }

        @Override
        public void customButtonPressed(ListDialogField<HeaderSubstitutionMap> field, int index) {
            HeaderSubstitutionBlock.this.onButtonPressed(field, index);
        }

        @Override
        public void selectionChanged(ListDialogField<HeaderSubstitutionMap> field) {
            List<HeaderSubstitutionMap> selectedElements = field.getSelectedElements();
            field.enableButton(1, this.canEdit(selectedElements));
        }

        @Override
        public void doubleClicked(ListDialogField<HeaderSubstitutionMap> field) {
            if (this.canEdit(field.getSelectedElements())) {
                HeaderSubstitutionBlock.this.onButtonPressed(field, 1);
            }
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
        }
    }
}

