/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchedulerProgramArgument;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchemaObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class OracleSchedulerProgram
extends OracleSchemaObject {
    private static final String CAT_ADVANCED = "Advanced";
    private String owner;
    private String programName;
    private String programType;
    private String programAction;
    private long numberOfArguments;
    private String enabled;
    private String detached;
    private String scheduleLimit;
    private String priority;
    private String weight;
    private long maxRuns;
    private long maxFailures;
    private String maxRunDuration;
    private String nlsEnv;
    private String comments;
    private final ArgumentsCache argumentsCache = new ArgumentsCache();

    OracleSchedulerProgram(OracleSchema schema, ResultSet dbResult) {
        super(schema, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PROGRAM_NAME"), true);
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
        this.programName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PROGRAM_NAME");
        this.programType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PROGRAM_TYPE");
        this.programAction = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PROGRAM_ACTION");
        this.numberOfArguments = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"NUMBER_OF_ARGUMENTS");
        this.enabled = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ENABLED");
        this.detached = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DETACHED");
        this.maxRuns = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MAX_RUNS");
        this.maxFailures = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MAX_FAILURES");
        this.scheduleLimit = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCHEDULE_LIMIT");
        this.priority = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PRIORITY");
        this.weight = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"WEIGHT");
        this.maxRunDuration = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"MAX_RUN_DURATION");
        this.nlsEnv = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"NLS_ENV");
        this.comments = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COMMENTS");
    }

    @Property(viewable=false, order=10)
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=true, order=16)
    public String getProgramName() {
        return this.programName;
    }

    @Property(viewable=true, order=17)
    public String getProgramType() {
        return this.programType;
    }

    @Property(viewable=false, order=18)
    public String getProgramAction() {
        return this.programAction;
    }

    @Property(viewable=false, order=19)
    public long getNumberOfArguments() {
        return this.numberOfArguments;
    }

    @Property(viewable=true, order=34)
    public String getEnabled() {
        return this.enabled;
    }

    @Property(viewable=true, order=35)
    public String getDetached() {
        return this.detached;
    }

    @Property(viewable=false, order=40)
    public long getMaxRuns() {
        return this.maxRuns;
    }

    @Property(viewable=false, order=42)
    public long getMaxFailures() {
        return this.maxFailures;
    }

    @Property(viewable=false, order=47)
    public String getScheduleLimit() {
        return this.scheduleLimit;
    }

    @Property(viewable=true, order=48)
    public String getPriority() {
        return this.priority;
    }

    @Property(viewable=false, order=49)
    public String getWeight() {
        return this.weight;
    }

    @Property(category="Advanced", viewable=false, order=48)
    public String getMaxRunDuration() {
        return this.maxRunDuration;
    }

    @Property(category="Advanced", viewable=false, order=55)
    public String getNlsEnv() {
        return this.nlsEnv;
    }

    @Override
    @Property(viewable=true, order=200)
    @Nullable
    public String getDescription() {
        return this.comments;
    }

    @Association
    public Collection<OracleSchedulerProgramArgument> getArguments(DBRProgressMonitor monitor) throws DBException {
        return this.argumentsCache.getAllObjects(monitor, this);
    }

    static class ArgumentsCache
    extends JDBCObjectCache<OracleSchedulerProgram, OracleSchedulerProgramArgument> {
        ArgumentsCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleSchedulerProgram program) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM ALL_SCHEDULER_PROGRAM_ARGS WHERE OWNER=? AND PROGRAM_NAME=? ORDER BY ARGUMENT_POSITION");
            dbStat.setString(1, program.getSchema().getName());
            dbStat.setString(2, program.getName());
            return dbStat;
        }

        protected OracleSchedulerProgramArgument fetchObject(@NotNull JDBCSession session, @NotNull OracleSchedulerProgram program, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleSchedulerProgramArgument(program, (ResultSet)resultSet);
        }
    }
}

