/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericScriptObject;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTrigger;

public class GenericTrigger
implements DBSTrigger,
GenericScriptObject {
    @NotNull
    private final GenericStructContainer container;
    @Nullable
    private final GenericTable table;
    private String name;
    private String description;
    protected String source;

    public GenericTrigger(@NotNull GenericStructContainer container, @Nullable GenericTable table, String name, String description) {
        this.container = container;
        this.table = table;
        this.name = name;
        this.description = description;
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, multiline=true, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    public boolean isPersisted() {
        return true;
    }

    @Property(viewable=true, order=4)
    @Nullable
    public GenericTable getTable() {
        return this.table;
    }

    @NotNull
    public GenericStructContainer getContainer() {
        return this.container;
    }

    public DBSObject getParentObject() {
        return this.table == null ? this.container : this.table;
    }

    @NotNull
    public GenericDataSource getDataSource() {
        return this.container.getDataSource();
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (this.source == null) {
            this.source = this.getDataSource().getMetaModel().getTriggerDDL(monitor, this);
        }
        return this.source;
    }

    public void setSource(String sourceText) throws DBException {
        this.source = sourceText;
    }
}

