#!/bin/bash
#
# Copyright 2016 The Bazel Authors. All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# This script handles interface library generation for dynamic library
# link action.
#
# Bazel can be configured to generate external interface library script
# to generate interface libraries in CppLinkAction for dynamic libraries.
# This is not needed on Windows (as the "interface" libraries are
# generated by default). This script therefore handles the cases when
# external script is provided, or when no script should be used.

set -eu

E_LINKER_COMMAND_NOT_FOUND=12
E_INTERFACE_BUILDER_NOT_FOUND=13

# Should generate interface library switch (<yes|no>); if the value is "no",
# following 3 args are ignored (but must be present)
GENERATE_INTERFACE_LIBRARY="$1"
# Tool which can generate interface library from dynamic library file
INTERFACE_LIBRARY_BUILDER="$2"
# Dynamic library from which we want to generate interface library
DYNAMIC_LIBRARY="$3"
# Resulting interface library
INTERFACE_LIBRARY="$4"
# The command used to generate the dynamic library
LINKER_COMMAND="$5"

shift 5

if [ ! -e "$LINKER_COMMAND" ]; then
  echo "Linker command ($LINKER_COMMAND) not found." 1>&2;
  exit "$E_LINKER_COMMAND_NOT_FOUND"
fi

if [ "no" == "$GENERATE_INTERFACE_LIBRARY" ]; then
    INTERFACE_GENERATION=:
else
    if [ ! -e "$INTERFACE_LIBRARY_BUILDER" ]; then
      echo "Interface library builder ($INTERFACE_LIBRARY_BUILDER) not found." 1>&2;
      exit "$E_INTERFACE_BUILDER_NOT_FOUND"
    fi
    INTERFACE_GENERATION="${INTERFACE_LIBRARY_BUILDER} ${DYNAMIC_LIBRARY} ${INTERFACE_LIBRARY}"
fi

${LINKER_COMMAND} "$@" && ${INTERFACE_GENERATION}
