/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Joiner;
import com.google.common.io.Files;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import java.net.URI;
import java.util.ArrayList;
import javax.lang.model.element.Modifier;

@BugPattern(name="ClassName", summary="The source file name should match the name of the top-level class it contains", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, documentSuppression=false, linkType=BugPattern.LinkType.CUSTOM, link="https://google.github.io/styleguide/javaguide.html#s2.1-file-name")
public class ClassName
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        if (tree.getTypeDecls().isEmpty() || tree.getPackageName() == null) {
            return Description.NO_MATCH;
        }
        String filename = Files.getNameWithoutExtension((String)ASTHelpers.getFileNameFromUri((URI)tree.getSourceFile().toUri()));
        ArrayList<String> names = new ArrayList<String>();
        for (Tree tree2 : tree.getTypeDecls()) {
            if (!(tree2 instanceof ClassTree)) continue;
            ClassTree classMember = (ClassTree)tree2;
            if (this.isSuppressed(classMember)) {
                return Description.NO_MATCH;
            }
            if (classMember.getSimpleName().contentEquals(filename)) {
                return Description.NO_MATCH;
            }
            if (classMember.getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) {
                return Description.NO_MATCH;
            }
            names.add(classMember.getSimpleName().toString());
        }
        String message = String.format("Expected a class declaration named %s inside %s.java, instead found: %s", filename, filename, Joiner.on((String)", ").join(names));
        return this.buildDescription(tree.getPackageName()).setMessage(message).build();
    }
}

