/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.ide.common.res2.AssetFile;
import com.android.ide.common.res2.AssetItem;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.MergeWriter;
import com.google.common.io.Files;
import java.io.File;
import java.util.concurrent.Callable;

public class MergedAssetWriter
extends MergeWriter<AssetItem> {
    public MergedAssetWriter(File rootFolder) {
        super(rootFolder);
    }

    @Override
    public void addItem(final AssetItem item) throws MergeConsumer.ConsumerException {
        if (item.isTouched()) {
            this.getExecutor().execute(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    AssetFile assetFile = (AssetFile)item.getSource();
                    File fromFile = assetFile.getFile();
                    File toFile = new File(MergedAssetWriter.this.getRootFolder(), item.getKey().replace('/', File.separatorChar));
                    toFile.getParentFile().mkdirs();
                    Files.copy((File)fromFile, (File)toFile);
                    return null;
                }
            });
        }
    }

    @Override
    public void removeItem(AssetItem removedItem, AssetItem replacedBy) throws MergeConsumer.ConsumerException {
        if (replacedBy == null) {
            File removedFile = new File(this.getRootFolder(), removedItem.getName());
            removedFile.delete();
        }
    }

    @Override
    public boolean ignoreItemInMerge(AssetItem item) {
        return false;
    }
}

