(function() {
  var KnownWordsChecker;

  KnownWordsChecker = (function() {
    KnownWordsChecker.prototype.enableAdd = false;

    KnownWordsChecker.prototype.spelling = null;

    KnownWordsChecker.prototype.checker = null;

    function KnownWordsChecker(knownWords) {
      var spellingManager;
      spellingManager = require("spelling-manager");
      this.spelling = new spellingManager.TokenSpellingManager;
      this.checker = new spellingManager.BufferSpellingChecker(this.spelling);
      this.setKnownWords(knownWords);
    }

    KnownWordsChecker.prototype.deactivate = function() {};

    KnownWordsChecker.prototype.getId = function() {
      return "spell-check:known-words";
    };

    KnownWordsChecker.prototype.getName = function() {
      return "Known Words";
    };

    KnownWordsChecker.prototype.getPriority = function() {
      return 10;
    };

    KnownWordsChecker.prototype.isEnabled = function() {
      return this.spelling.sensitive || this.spelling.insensitive;
    };

    KnownWordsChecker.prototype.getStatus = function() {
      return "Working correctly.";
    };

    KnownWordsChecker.prototype.providesSpelling = function(args) {
      return true;
    };

    KnownWordsChecker.prototype.providesSuggestions = function(args) {
      return true;
    };

    KnownWordsChecker.prototype.providesAdding = function(args) {
      return this.enableAdd;
    };

    KnownWordsChecker.prototype.check = function(args, text) {
      var checked, i, len, ranges, token;
      ranges = [];
      checked = this.checker.check(text);
      for (i = 0, len = checked.length; i < len; i++) {
        token = checked[i];
        if (token.status === 1) {
          ranges.push({
            start: token.start,
            end: token.end
          });
        }
      }
      return {
        correct: ranges
      };
    };

    KnownWordsChecker.prototype.suggest = function(args, word) {
      return this.spelling.suggest(word);
    };

    KnownWordsChecker.prototype.getAddingTargets = function(args) {
      if (this.enableAdd) {
        return [
          {
            sensitive: false,
            label: "Add to " + this.getName()
          }
        ];
      } else {
        return [];
      }
    };

    KnownWordsChecker.prototype.add = function(args, target) {
      var c;
      c = atom.config.get('spell-check.knownWords');
      c.push(target.word);
      return atom.config.set('spell-check.knownWords', c);
    };

    KnownWordsChecker.prototype.setAddKnownWords = function(newValue) {
      return this.enableAdd = newValue;
    };

    KnownWordsChecker.prototype.setKnownWords = function(knownWords) {
      var i, ignore, len, results;
      this.spelling.sensitive = {};
      this.spelling.insensitive = {};
      if (knownWords) {
        results = [];
        for (i = 0, len = knownWords.length; i < len; i++) {
          ignore = knownWords[i];
          results.push(this.spelling.add(ignore));
        }
        return results;
      }
    };

    return KnownWordsChecker;

  })();

  module.exports = KnownWordsChecker;

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
