Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _atom = require('atom');

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var KeyBindingResolverView = (function () {
  function KeyBindingResolverView() {
    _classCallCheck(this, KeyBindingResolverView);

    this.keystrokes = null;
    this.usedKeyBinding = null;
    this.unusedKeyBindings = [];
    this.unmatchedKeyBindings = [];
    this.partiallyMatchedBindings = [];
    _etch2['default'].initialize(this);
  }

  _createClass(KeyBindingResolverView, [{
    key: 'serialize',
    value: function serialize() {
      return this.panel ? { attached: this.panel.isVisible() } : { attached: false };
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.detach();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'toggle',
    value: function toggle() {
      if (this.panel && this.panel.isVisible()) {
        this.detach();
      } else {
        this.attach();
      }
    }
  }, {
    key: 'attach',
    value: function attach() {
      var _this = this;

      this.disposables = new _atom.CompositeDisposable();
      this.panel = atom.workspace.addBottomPanel({ item: this });
      this.disposables.add(new _atom.Disposable(function () {
        _this.panel.destroy();
        _this.panel = null;
      }));

      this.disposables.add(atom.keymaps.onDidMatchBinding(function (_ref) {
        var keystrokes = _ref.keystrokes;
        var binding = _ref.binding;
        var keyboardEventTarget = _ref.keyboardEventTarget;
        var eventType = _ref.eventType;

        if (eventType === 'keyup' && binding == null) {
          return;
        }

        var unusedKeyBindings = atom.keymaps.findKeyBindings({ keystrokes: keystrokes, target: keyboardEventTarget }).filter(function (b) {
          return b !== binding;
        });

        var unmatchedKeyBindings = atom.keymaps.findKeyBindings({ keystrokes: keystrokes }).filter(function (b) {
          return b !== binding && !unusedKeyBindings.includes(b);
        });

        _this.update({ usedKeyBinding: binding, unusedKeyBindings: unusedKeyBindings, unmatchedKeyBindings: unmatchedKeyBindings, keystrokes: keystrokes });
      }));

      this.disposables.add(atom.keymaps.onDidPartiallyMatchBindings(function (_ref2) {
        var keystrokes = _ref2.keystrokes;
        var partiallyMatchedBindings = _ref2.partiallyMatchedBindings;

        _this.update({ keystrokes: keystrokes, partiallyMatchedBindings: partiallyMatchedBindings });
      }));

      this.disposables.add(atom.keymaps.onDidFailToMatchBinding(function (_ref3) {
        var keystrokes = _ref3.keystrokes;
        var keyboardEventTarget = _ref3.keyboardEventTarget;
        var eventType = _ref3.eventType;

        if (eventType === 'keyup') {
          return;
        }

        var unusedKeyBindings = atom.keymaps.findKeyBindings({ keystrokes: keystrokes, target: keyboardEventTarget });
        var unmatchedKeyBindings = atom.keymaps.findKeyBindings({ keystrokes: keystrokes }).filter(function (b) {
          return !unusedKeyBindings.includes(b);
        });

        _this.update({ unusedKeyBindings: unusedKeyBindings, unmatchedKeyBindings: unmatchedKeyBindings, keystrokes: keystrokes });
      }));
    }
  }, {
    key: 'detach',
    value: function detach() {
      if (this.disposables) {
        this.disposables.dispose();
      }
    }
  }, {
    key: 'update',
    value: function update(props) {
      this.keystrokes = props.keystrokes;
      this.usedKeyBinding = props.usedKeyBinding;
      this.unusedKeyBindings = props.unusedKeyBindings || [];
      this.unmatchedKeyBindings = props.unmatchedKeyBindings || [];
      this.partiallyMatchedBindings = props.partiallyMatchedBindings || [];
      return _etch2['default'].update(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'key-binding-resolver' },
        _etch2['default'].dom(
          'div',
          { className: 'panel-heading padded' },
          _etch2['default'].dom(
            'span',
            null,
            'Key Binding Resolver: '
          ),
          this.renderKeystrokes()
        ),
        _etch2['default'].dom(
          'div',
          { className: 'panel-body padded' },
          this.renderKeyBindings()
        )
      );
    }
  }, {
    key: 'renderKeystrokes',
    value: function renderKeystrokes() {
      if (this.keystrokes) {
        if (this.partiallyMatchedBindings.length > 0) {
          return _etch2['default'].dom(
            'span',
            { className: 'keystroke' },
            this.keystrokes,
            ' (partial)'
          );
        } else {
          return _etch2['default'].dom(
            'span',
            { className: 'keystroke' },
            this.keystrokes
          );
        }
      } else {
        return _etch2['default'].dom(
          'span',
          null,
          'Press any key: '
        );
      }
    }
  }, {
    key: 'renderKeyBindings',
    value: function renderKeyBindings() {
      var _this2 = this;

      if (this.partiallyMatchedBindings.length > 0) {
        return _etch2['default'].dom(
          'table',
          { className: 'table-condensed' },
          _etch2['default'].dom(
            'tbody',
            null,
            this.partiallyMatchedBindings.map(function (binding) {
              return _etch2['default'].dom(
                'tr',
                { className: 'unused' },
                _etch2['default'].dom(
                  'td',
                  { className: 'copy', onclick: function () {
                      return _this2.copyKeybinding(binding);
                    } },
                  _etch2['default'].dom('span', { className: 'icon icon-clippy' })
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'command' },
                  binding.command
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'keystrokes' },
                  binding.keystrokes
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'selector' },
                  binding.selector
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'source', onclick: function () {
                      return _this2.openKeybindingFile(binding.source);
                    } },
                  binding.source
                )
              );
            })
          )
        );
      } else {
        var usedKeyBinding = '';
        if (this.usedKeyBinding) {
          usedKeyBinding = _etch2['default'].dom(
            'tr',
            { className: 'used' },
            _etch2['default'].dom(
              'td',
              { className: 'copy', onclick: function () {
                  return _this2.copyKeybinding(_this2.usedKeyBinding);
                } },
              _etch2['default'].dom('span', { className: 'icon icon-clippy' })
            ),
            _etch2['default'].dom(
              'td',
              { className: 'command' },
              this.usedKeyBinding.command
            ),
            _etch2['default'].dom(
              'td',
              { className: 'selector' },
              this.usedKeyBinding.selector
            ),
            _etch2['default'].dom(
              'td',
              { className: 'source', onclick: function () {
                  return _this2.openKeybindingFile(_this2.usedKeyBinding.source);
                } },
              this.usedKeyBinding.source
            )
          );
        }
        return _etch2['default'].dom(
          'table',
          { className: 'table-condensed' },
          _etch2['default'].dom(
            'tbody',
            null,
            usedKeyBinding,
            this.unusedKeyBindings.map(function (binding) {
              return _etch2['default'].dom(
                'tr',
                { className: 'unused' },
                _etch2['default'].dom(
                  'td',
                  { className: 'copy', onclick: function () {
                      return _this2.copyKeybinding(binding);
                    } },
                  _etch2['default'].dom('span', { className: 'icon icon-clippy' })
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'command' },
                  binding.command
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'selector' },
                  binding.selector
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'source', onclick: function () {
                      return _this2.openKeybindingFile(binding.source);
                    } },
                  binding.source
                )
              );
            }),
            this.unmatchedKeyBindings.map(function (binding) {
              return _etch2['default'].dom(
                'tr',
                { className: 'unmatched' },
                _etch2['default'].dom(
                  'td',
                  { className: 'copy', onclick: function () {
                      return _this2.copyKeybinding(binding);
                    } },
                  _etch2['default'].dom('span', { className: 'icon icon-clippy' })
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'command' },
                  binding.command
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'selector' },
                  binding.selector
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'source', onclick: function () {
                      return _this2.openKeybindingFile(binding.source);
                    } },
                  binding.source
                )
              );
            })
          )
        );
      }
    }
  }, {
    key: 'isInAsarArchive',
    value: function isInAsarArchive(pathToCheck) {
      var _atom$getLoadSettings = atom.getLoadSettings();

      var resourcePath = _atom$getLoadSettings.resourcePath;

      return pathToCheck.startsWith('' + resourcePath + _path2['default'].sep) && _path2['default'].extname(resourcePath) === '.asar';
    }
  }, {
    key: 'extractBundledKeymap',
    value: function extractBundledKeymap(bundledKeymapPath) {
      var metadata = require(_path2['default'].join(atom.getLoadSettings().resourcePath, 'package.json'));
      var bundledKeymaps = metadata ? metadata._atomKeymaps : {};
      var keymapName = _path2['default'].basename(bundledKeymapPath);
      var extractedKeymapPath = _path2['default'].join(require('temp').mkdirSync('atom-bundled-keymap-'), keymapName);
      _fsPlus2['default'].writeFileSync(extractedKeymapPath, JSON.stringify(bundledKeymaps[keymapName] || {}, null, 2));
      return extractedKeymapPath;
    }
  }, {
    key: 'extractBundledPackageKeymap',
    value: function extractBundledPackageKeymap(keymapRelativePath) {
      var packageName = keymapRelativePath.split(_path2['default'].sep)[1];
      var keymapName = _path2['default'].basename(keymapRelativePath);
      var metadata = atom.packages.packagesCache[packageName] || {};
      var keymaps = metadata.keymaps || {};
      var extractedKeymapPath = _path2['default'].join(require('temp').mkdirSync('atom-bundled-keymap-'), keymapName);
      _fsPlus2['default'].writeFileSync(extractedKeymapPath, JSON.stringify(keymaps[keymapRelativePath] || {}, null, 2));
      return extractedKeymapPath;
    }
  }, {
    key: 'openKeybindingFile',
    value: function openKeybindingFile(keymapPath) {
      if (this.isInAsarArchive(keymapPath)) {
        keymapPath = this.extractBundledKeymap(keymapPath);
      } else if (keymapPath.startsWith('core:node_modules')) {
        keymapPath = this.extractBundledPackageKeymap(keymapPath.replace('core:', ''));
      } else if (keymapPath.startsWith('core:')) {
        keymapPath = this.extractBundledKeymap(keymapPath.replace('core:', ''));
      }

      atom.workspace.open(keymapPath);
    }
  }, {
    key: 'copyKeybinding',
    value: function copyKeybinding(binding) {
      var content = undefined;
      var keymapExtension = _path2['default'].extname(atom.keymaps.getUserKeymapPath());
      var escapedKeystrokes = binding.keystrokes.replace(/\\/g, '\\\\'); // Escape backslashes
      if (keymapExtension === '.cson') {
        content = '\'' + binding.selector + '\':\n  \'' + escapedKeystrokes + '\': \'' + binding.command + '\'\n';
      } else {
        content = '"' + binding.selector + '": {\n  "' + escapedKeystrokes + '": "' + binding.command + '"\n}\n';
      }

      atom.notifications.addInfo('Keybinding Copied');
      return atom.clipboard.write(content);
    }
  }]);

  return KeyBindingResolverView;
})();

exports['default'] = KeyBindingResolverView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzYuMS9vdXQvYXBwL25vZGVfbW9kdWxlcy9rZXliaW5kaW5nLXJlc29sdmVyL2xpYi9rZXliaW5kaW5nLXJlc29sdmVyLXZpZXcuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7OztzQkFHZSxTQUFTOzs7O29CQUNQLE1BQU07Ozs7b0JBQ3VCLE1BQU07O29CQUNuQyxNQUFNOzs7O0lBRUYsc0JBQXNCO0FBQzdCLFdBRE8sc0JBQXNCLEdBQzFCOzBCQURJLHNCQUFzQjs7QUFFdkMsUUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUE7QUFDdEIsUUFBSSxDQUFDLGNBQWMsR0FBRyxJQUFJLENBQUE7QUFDMUIsUUFBSSxDQUFDLGlCQUFpQixHQUFHLEVBQUUsQ0FBQTtBQUMzQixRQUFJLENBQUMsb0JBQW9CLEdBQUcsRUFBRSxDQUFBO0FBQzlCLFFBQUksQ0FBQyx3QkFBd0IsR0FBRyxFQUFFLENBQUE7QUFDbEMsc0JBQUssVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFBO0dBQ3RCOztlQVJrQixzQkFBc0I7O1dBVS9CLHFCQUFHO0FBQ1gsYUFBTyxJQUFJLENBQUMsS0FBSyxHQUFHLEVBQUMsUUFBUSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUyxFQUFFLEVBQUMsR0FBRyxFQUFDLFFBQVEsRUFBRSxLQUFLLEVBQUMsQ0FBQTtLQUMzRTs7O1dBRU8sbUJBQUc7QUFDVCxVQUFJLENBQUMsTUFBTSxFQUFFLENBQUE7QUFDYixhQUFPLGtCQUFLLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQTtLQUMxQjs7O1dBRU0sa0JBQUc7QUFDUixVQUFJLElBQUksQ0FBQyxLQUFLLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxTQUFTLEVBQUUsRUFBRTtBQUN4QyxZQUFJLENBQUMsTUFBTSxFQUFFLENBQUE7T0FDZCxNQUFNO0FBQ0wsWUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFBO09BQ2Q7S0FDRjs7O1dBRU0sa0JBQUc7OztBQUNSLFVBQUksQ0FBQyxXQUFXLEdBQUcsK0JBQXlCLENBQUE7QUFDNUMsVUFBSSxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLGNBQWMsQ0FBQyxFQUFDLElBQUksRUFBRSxJQUFJLEVBQUMsQ0FBQyxDQUFBO0FBQ3hELFVBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLHFCQUFlLFlBQU07QUFDeEMsY0FBSyxLQUFLLENBQUMsT0FBTyxFQUFFLENBQUE7QUFDcEIsY0FBSyxLQUFLLEdBQUcsSUFBSSxDQUFBO09BQ2xCLENBQUMsQ0FBQyxDQUFBOztBQUVILFVBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsaUJBQWlCLENBQUMsVUFBQyxJQUFxRCxFQUFLO1lBQXpELFVBQVUsR0FBWCxJQUFxRCxDQUFwRCxVQUFVO1lBQUUsT0FBTyxHQUFwQixJQUFxRCxDQUF4QyxPQUFPO1lBQUUsbUJBQW1CLEdBQXpDLElBQXFELENBQS9CLG1CQUFtQjtZQUFFLFNBQVMsR0FBcEQsSUFBcUQsQ0FBVixTQUFTOztBQUN2RyxZQUFJLFNBQVMsS0FBSyxPQUFPLElBQUksT0FBTyxJQUFJLElBQUksRUFBRTtBQUM1QyxpQkFBTTtTQUNQOztBQUVELFlBQU0saUJBQWlCLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FDbkMsZUFBZSxDQUFDLEVBQUMsVUFBVSxFQUFWLFVBQVUsRUFBRSxNQUFNLEVBQUUsbUJBQW1CLEVBQUMsQ0FBQyxDQUMxRCxNQUFNLENBQUMsVUFBQyxDQUFDO2lCQUFLLENBQUMsS0FBSyxPQUFPO1NBQUEsQ0FBQyxDQUFBOztBQUUvQixZQUFNLG9CQUFvQixHQUFHLElBQUksQ0FBQyxPQUFPLENBQ3RDLGVBQWUsQ0FBQyxFQUFDLFVBQVUsRUFBVixVQUFVLEVBQUMsQ0FBQyxDQUM3QixNQUFNLENBQUMsVUFBQyxDQUFDO2lCQUFLLENBQUMsS0FBSyxPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO1NBQUEsQ0FBQyxDQUFBOztBQUVqRSxjQUFLLE1BQU0sQ0FBQyxFQUFDLGNBQWMsRUFBRSxPQUFPLEVBQUUsaUJBQWlCLEVBQWpCLGlCQUFpQixFQUFFLG9CQUFvQixFQUFwQixvQkFBb0IsRUFBRSxVQUFVLEVBQVYsVUFBVSxFQUFDLENBQUMsQ0FBQTtPQUM1RixDQUFDLENBQUMsQ0FBQTs7QUFFSCxVQUFJLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLDJCQUEyQixDQUFDLFVBQUMsS0FBc0MsRUFBSztZQUExQyxVQUFVLEdBQVgsS0FBc0MsQ0FBckMsVUFBVTtZQUFFLHdCQUF3QixHQUFyQyxLQUFzQyxDQUF6Qix3QkFBd0I7O0FBQ2xHLGNBQUssTUFBTSxDQUFDLEVBQUMsVUFBVSxFQUFWLFVBQVUsRUFBRSx3QkFBd0IsRUFBeEIsd0JBQXdCLEVBQUMsQ0FBQyxDQUFBO09BQ3BELENBQUMsQ0FBQyxDQUFBOztBQUVILFVBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsdUJBQXVCLENBQUMsVUFBQyxLQUE0QyxFQUFLO1lBQWhELFVBQVUsR0FBWCxLQUE0QyxDQUEzQyxVQUFVO1lBQUUsbUJBQW1CLEdBQWhDLEtBQTRDLENBQS9CLG1CQUFtQjtZQUFFLFNBQVMsR0FBM0MsS0FBNEMsQ0FBVixTQUFTOztBQUNwRyxZQUFJLFNBQVMsS0FBSyxPQUFPLEVBQUU7QUFDekIsaUJBQU07U0FDUDs7QUFFRCxZQUFNLGlCQUFpQixHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsZUFBZSxDQUFDLEVBQUMsVUFBVSxFQUFWLFVBQVUsRUFBRSxNQUFNLEVBQUUsbUJBQW1CLEVBQUMsQ0FBQyxDQUFBO0FBQ2pHLFlBQU0sb0JBQW9CLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FDdEMsZUFBZSxDQUFDLEVBQUMsVUFBVSxFQUFWLFVBQVUsRUFBQyxDQUFDLENBQzdCLE1BQU0sQ0FBQyxVQUFDLENBQUM7aUJBQUssQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO1NBQUEsQ0FBQyxDQUFBOztBQUVoRCxjQUFLLE1BQU0sQ0FBQyxFQUFDLGlCQUFpQixFQUFqQixpQkFBaUIsRUFBRSxvQkFBb0IsRUFBcEIsb0JBQW9CLEVBQUUsVUFBVSxFQUFWLFVBQVUsRUFBQyxDQUFDLENBQUE7T0FDbkUsQ0FBQyxDQUFDLENBQUE7S0FDSjs7O1dBRU0sa0JBQUc7QUFDUixVQUFJLElBQUksQ0FBQyxXQUFXLEVBQUU7QUFDcEIsWUFBSSxDQUFDLFdBQVcsQ0FBQyxPQUFPLEVBQUUsQ0FBQTtPQUMzQjtLQUNGOzs7V0FFTSxnQkFBQyxLQUFLLEVBQUU7QUFDYixVQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUE7QUFDbEMsVUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFBO0FBQzFDLFVBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUMsaUJBQWlCLElBQUksRUFBRSxDQUFBO0FBQ3RELFVBQUksQ0FBQyxvQkFBb0IsR0FBRyxLQUFLLENBQUMsb0JBQW9CLElBQUksRUFBRSxDQUFBO0FBQzVELFVBQUksQ0FBQyx3QkFBd0IsR0FBRyxLQUFLLENBQUMsd0JBQXdCLElBQUksRUFBRSxDQUFBO0FBQ3BFLGFBQU8sa0JBQUssTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFBO0tBQ3pCOzs7V0FFTSxrQkFBRztBQUNSLGFBQ0U7O1VBQUssU0FBUyxFQUFDLHNCQUFzQjtRQUNuQzs7WUFBSyxTQUFTLEVBQUMsc0JBQXNCO1VBQ25DOzs7O1dBQW1DO1VBQ2xDLElBQUksQ0FBQyxnQkFBZ0IsRUFBRTtTQUNwQjtRQUNOOztZQUFLLFNBQVMsRUFBQyxtQkFBbUI7VUFBRSxJQUFJLENBQUMsaUJBQWlCLEVBQUU7U0FBTztPQUMvRCxDQUNQO0tBQ0Y7OztXQUVnQiw0QkFBRztBQUNsQixVQUFJLElBQUksQ0FBQyxVQUFVLEVBQUU7QUFDbkIsWUFBSSxJQUFJLENBQUMsd0JBQXdCLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRTtBQUM1QyxpQkFBTzs7Y0FBTSxTQUFTLEVBQUMsV0FBVztZQUFFLElBQUksQ0FBQyxVQUFVOztXQUFrQixDQUFBO1NBQ3RFLE1BQU07QUFDTCxpQkFBTzs7Y0FBTSxTQUFTLEVBQUMsV0FBVztZQUFFLElBQUksQ0FBQyxVQUFVO1dBQVEsQ0FBQTtTQUM1RDtPQUNGLE1BQU07QUFDTCxlQUFPOzs7O1NBQTRCLENBQUE7T0FDcEM7S0FDRjs7O1dBRWlCLDZCQUFHOzs7QUFDbkIsVUFBSSxJQUFJLENBQUMsd0JBQXdCLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRTtBQUM1QyxlQUNFOztZQUFPLFNBQVMsRUFBQyxpQkFBaUI7VUFDaEM7OztZQUNHLElBQUksQ0FBQyx3QkFBd0IsQ0FBQyxHQUFHLENBQUMsVUFBQyxPQUFPO3FCQUN6Qzs7a0JBQUksU0FBUyxFQUFDLFFBQVE7Z0JBQ3BCOztvQkFBSSxTQUFTLEVBQUMsTUFBTSxFQUFDLE9BQU8sRUFBRTs2QkFBTSxPQUFLLGNBQWMsQ0FBQyxPQUFPLENBQUM7cUJBQUEsQUFBQztrQkFBQyxnQ0FBTSxTQUFTLEVBQUMsa0JBQWtCLEdBQUc7aUJBQUs7Z0JBQzVHOztvQkFBSSxTQUFTLEVBQUMsU0FBUztrQkFBRSxPQUFPLENBQUMsT0FBTztpQkFBTTtnQkFDOUM7O29CQUFJLFNBQVMsRUFBQyxZQUFZO2tCQUFFLE9BQU8sQ0FBQyxVQUFVO2lCQUFNO2dCQUNwRDs7b0JBQUksU0FBUyxFQUFDLFVBQVU7a0JBQUUsT0FBTyxDQUFDLFFBQVE7aUJBQU07Z0JBQ2hEOztvQkFBSSxTQUFTLEVBQUMsUUFBUSxFQUFDLE9BQU8sRUFBRTs2QkFBTSxPQUFLLGtCQUFrQixDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUM7cUJBQUEsQUFBQztrQkFBRSxPQUFPLENBQUMsTUFBTTtpQkFBTTtlQUNqRzthQUNSLENBQUM7V0FDTTtTQUNGLENBQ1Q7T0FDRixNQUFNO0FBQ0wsWUFBSSxjQUFjLEdBQUcsRUFBRSxDQUFBO0FBQ3ZCLFlBQUksSUFBSSxDQUFDLGNBQWMsRUFBRTtBQUN2Qix3QkFBYyxHQUNaOztjQUFJLFNBQVMsRUFBQyxNQUFNO1lBQ2xCOztnQkFBSSxTQUFTLEVBQUMsTUFBTSxFQUFDLE9BQU8sRUFBRTt5QkFBTSxPQUFLLGNBQWMsQ0FBQyxPQUFLLGNBQWMsQ0FBQztpQkFBQSxBQUFDO2NBQUMsZ0NBQU0sU0FBUyxFQUFDLGtCQUFrQixHQUFHO2FBQUs7WUFDeEg7O2dCQUFJLFNBQVMsRUFBQyxTQUFTO2NBQUUsSUFBSSxDQUFDLGNBQWMsQ0FBQyxPQUFPO2FBQU07WUFDMUQ7O2dCQUFJLFNBQVMsRUFBQyxVQUFVO2NBQUUsSUFBSSxDQUFDLGNBQWMsQ0FBQyxRQUFRO2FBQU07WUFDNUQ7O2dCQUFJLFNBQVMsRUFBQyxRQUFRLEVBQUMsT0FBTyxFQUFFO3lCQUFNLE9BQUssa0JBQWtCLENBQUMsT0FBSyxjQUFjLENBQUMsTUFBTSxDQUFDO2lCQUFBLEFBQUM7Y0FBRSxJQUFJLENBQUMsY0FBYyxDQUFDLE1BQU07YUFBTTtXQUN6SCxBQUNOLENBQUE7U0FDRjtBQUNELGVBQ0U7O1lBQU8sU0FBUyxFQUFDLGlCQUFpQjtVQUNoQzs7O1lBQ0csY0FBYztZQUNkLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxHQUFHLENBQUMsVUFBQyxPQUFPO3FCQUNsQzs7a0JBQUksU0FBUyxFQUFDLFFBQVE7Z0JBQ3BCOztvQkFBSSxTQUFTLEVBQUMsTUFBTSxFQUFDLE9BQU8sRUFBRTs2QkFBTSxPQUFLLGNBQWMsQ0FBQyxPQUFPLENBQUM7cUJBQUEsQUFBQztrQkFBQyxnQ0FBTSxTQUFTLEVBQUMsa0JBQWtCLEdBQUc7aUJBQUs7Z0JBQzVHOztvQkFBSSxTQUFTLEVBQUMsU0FBUztrQkFBRSxPQUFPLENBQUMsT0FBTztpQkFBTTtnQkFDOUM7O29CQUFJLFNBQVMsRUFBQyxVQUFVO2tCQUFFLE9BQU8sQ0FBQyxRQUFRO2lCQUFNO2dCQUNoRDs7b0JBQUksU0FBUyxFQUFDLFFBQVEsRUFBQyxPQUFPLEVBQUU7NkJBQU0sT0FBSyxrQkFBa0IsQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDO3FCQUFBLEFBQUM7a0JBQUUsT0FBTyxDQUFDLE1BQU07aUJBQU07ZUFDakc7YUFDTixDQUFDO1lBQ0QsSUFBSSxDQUFDLG9CQUFvQixDQUFDLEdBQUcsQ0FBQyxVQUFDLE9BQU87cUJBQ3JDOztrQkFBSSxTQUFTLEVBQUMsV0FBVztnQkFDdkI7O29CQUFJLFNBQVMsRUFBQyxNQUFNLEVBQUMsT0FBTyxFQUFFOzZCQUFNLE9BQUssY0FBYyxDQUFDLE9BQU8sQ0FBQztxQkFBQSxBQUFDO2tCQUFDLGdDQUFNLFNBQVMsRUFBQyxrQkFBa0IsR0FBRztpQkFBSztnQkFDNUc7O29CQUFJLFNBQVMsRUFBQyxTQUFTO2tCQUFFLE9BQU8sQ0FBQyxPQUFPO2lCQUFNO2dCQUM5Qzs7b0JBQUksU0FBUyxFQUFDLFVBQVU7a0JBQUUsT0FBTyxDQUFDLFFBQVE7aUJBQU07Z0JBQ2hEOztvQkFBSSxTQUFTLEVBQUMsUUFBUSxFQUFDLE9BQU8sRUFBRTs2QkFBTSxPQUFLLGtCQUFrQixDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUM7cUJBQUEsQUFBQztrQkFBRSxPQUFPLENBQUMsTUFBTTtpQkFBTTtlQUNqRzthQUNSLENBQUM7V0FDTTtTQUNGLENBQ1Q7T0FDRjtLQUNGOzs7V0FFZSx5QkFBQyxXQUFXLEVBQUU7a0NBQ0wsSUFBSSxDQUFDLGVBQWUsRUFBRTs7VUFBdEMsWUFBWSx5QkFBWixZQUFZOztBQUNuQixhQUFPLFdBQVcsQ0FBQyxVQUFVLE1BQUksWUFBWSxHQUFHLGtCQUFLLEdBQUcsQ0FBRyxJQUFJLGtCQUFLLE9BQU8sQ0FBQyxZQUFZLENBQUMsS0FBSyxPQUFPLENBQUE7S0FDdEc7OztXQUVvQiw4QkFBQyxpQkFBaUIsRUFBRTtBQUN2QyxVQUFNLFFBQVEsR0FBRyxPQUFPLENBQUMsa0JBQUssSUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLEVBQUUsQ0FBQyxZQUFZLEVBQUUsY0FBYyxDQUFDLENBQUMsQ0FBQTtBQUN4RixVQUFNLGNBQWMsR0FBRyxRQUFRLEdBQUcsUUFBUSxDQUFDLFlBQVksR0FBRyxFQUFFLENBQUE7QUFDNUQsVUFBTSxVQUFVLEdBQUcsa0JBQUssUUFBUSxDQUFDLGlCQUFpQixDQUFDLENBQUE7QUFDbkQsVUFBTSxtQkFBbUIsR0FBRyxrQkFBSyxJQUFJLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDLFNBQVMsQ0FBQyxzQkFBc0IsQ0FBQyxFQUFFLFVBQVUsQ0FBQyxDQUFBO0FBQ3BHLDBCQUFHLGFBQWEsQ0FDZCxtQkFBbUIsRUFDbkIsSUFBSSxDQUFDLFNBQVMsQ0FBQyxjQUFjLENBQUMsVUFBVSxDQUFDLElBQUksRUFBRSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUMsQ0FDMUQsQ0FBQTtBQUNELGFBQU8sbUJBQW1CLENBQUE7S0FDM0I7OztXQUUyQixxQ0FBQyxrQkFBa0IsRUFBRTtBQUMvQyxVQUFNLFdBQVcsR0FBRyxrQkFBa0IsQ0FBQyxLQUFLLENBQUMsa0JBQUssR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUE7QUFDekQsVUFBTSxVQUFVLEdBQUcsa0JBQUssUUFBUSxDQUFDLGtCQUFrQixDQUFDLENBQUE7QUFDcEQsVUFBTSxRQUFRLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxhQUFhLENBQUMsV0FBVyxDQUFDLElBQUksRUFBRSxDQUFBO0FBQy9ELFVBQU0sT0FBTyxHQUFHLFFBQVEsQ0FBQyxPQUFPLElBQUksRUFBRSxDQUFBO0FBQ3RDLFVBQU0sbUJBQW1CLEdBQUcsa0JBQUssSUFBSSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxTQUFTLENBQUMsc0JBQXNCLENBQUMsRUFBRSxVQUFVLENBQUMsQ0FBQTtBQUNwRywwQkFBRyxhQUFhLENBQ2QsbUJBQW1CLEVBQ25CLElBQUksQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFDLGtCQUFrQixDQUFDLElBQUksRUFBRSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUMsQ0FDM0QsQ0FBQTtBQUNELGFBQU8sbUJBQW1CLENBQUE7S0FDM0I7OztXQUVrQiw0QkFBQyxVQUFVLEVBQUU7QUFDOUIsVUFBSSxJQUFJLENBQUMsZUFBZSxDQUFDLFVBQVUsQ0FBQyxFQUFFO0FBQ3BDLGtCQUFVLEdBQUcsSUFBSSxDQUFDLG9CQUFvQixDQUFDLFVBQVUsQ0FBQyxDQUFBO09BQ25ELE1BQU0sSUFBSSxVQUFVLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLEVBQUU7QUFDckQsa0JBQVUsR0FBRyxJQUFJLENBQUMsMkJBQTJCLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxPQUFPLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQTtPQUMvRSxNQUFNLElBQUksVUFBVSxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsRUFBRTtBQUN6QyxrQkFBVSxHQUFHLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLE9BQU8sRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFBO09BQ3hFOztBQUVELFVBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFBO0tBQ2hDOzs7V0FFYyx3QkFBQyxPQUFPLEVBQUU7QUFDdkIsVUFBSSxPQUFPLFlBQUEsQ0FBQTtBQUNYLFVBQU0sZUFBZSxHQUFHLGtCQUFLLE9BQU8sQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLGlCQUFpQixFQUFFLENBQUMsQ0FBQTtBQUN0RSxVQUFJLGlCQUFpQixHQUFHLE9BQU8sQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLEtBQUssRUFBRSxNQUFNLENBQUMsQ0FBQTtBQUNqRSxVQUFJLGVBQWUsS0FBSyxPQUFPLEVBQUU7QUFDL0IsZUFBTyxVQUNWLE9BQU8sQ0FBQyxRQUFRLGlCQUNkLGlCQUFpQixjQUFPLE9BQU8sQ0FBQyxPQUFPLFNBQzNDLENBQUE7T0FDSSxNQUFNO0FBQ0wsZUFBTyxTQUNWLE9BQU8sQ0FBQyxRQUFRLGlCQUNkLGlCQUFpQixZQUFPLE9BQU8sQ0FBQyxPQUFPLFdBRTNDLENBQUE7T0FDSTs7QUFFRCxVQUFJLENBQUMsYUFBYSxDQUFDLE9BQU8sQ0FBQyxtQkFBbUIsQ0FBQyxDQUFBO0FBQy9DLGFBQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUE7S0FDckM7OztTQWhPa0Isc0JBQXNCOzs7cUJBQXRCLHNCQUFzQiIsImZpbGUiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS0xLjM2LjEvb3V0L2FwcC9ub2RlX21vZHVsZXMva2V5YmluZGluZy1yZXNvbHZlci9saWIva2V5YmluZGluZy1yZXNvbHZlci12aWV3LmpzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqIEBiYWJlbCAqL1xuLyoqIEBqc3ggZXRjaC5kb20gKi9cblxuaW1wb3J0IGZzIGZyb20gJ2ZzLXBsdXMnXG5pbXBvcnQgZXRjaCBmcm9tICdldGNoJ1xuaW1wb3J0IHtEaXNwb3NhYmxlLCBDb21wb3NpdGVEaXNwb3NhYmxlfSBmcm9tICdhdG9tJ1xuaW1wb3J0IHBhdGggZnJvbSAncGF0aCdcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgS2V5QmluZGluZ1Jlc29sdmVyVmlldyB7XG4gIGNvbnN0cnVjdG9yICgpIHtcbiAgICB0aGlzLmtleXN0cm9rZXMgPSBudWxsXG4gICAgdGhpcy51c2VkS2V5QmluZGluZyA9IG51bGxcbiAgICB0aGlzLnVudXNlZEtleUJpbmRpbmdzID0gW11cbiAgICB0aGlzLnVubWF0Y2hlZEtleUJpbmRpbmdzID0gW11cbiAgICB0aGlzLnBhcnRpYWxseU1hdGNoZWRCaW5kaW5ncyA9IFtdXG4gICAgZXRjaC5pbml0aWFsaXplKHRoaXMpXG4gIH1cblxuICBzZXJpYWxpemUgKCkge1xuICAgIHJldHVybiB0aGlzLnBhbmVsID8ge2F0dGFjaGVkOiB0aGlzLnBhbmVsLmlzVmlzaWJsZSgpfSA6IHthdHRhY2hlZDogZmFsc2V9XG4gIH1cblxuICBkZXN0cm95ICgpIHtcbiAgICB0aGlzLmRldGFjaCgpXG4gICAgcmV0dXJuIGV0Y2guZGVzdHJveSh0aGlzKVxuICB9XG5cbiAgdG9nZ2xlICgpIHtcbiAgICBpZiAodGhpcy5wYW5lbCAmJiB0aGlzLnBhbmVsLmlzVmlzaWJsZSgpKSB7XG4gICAgICB0aGlzLmRldGFjaCgpXG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMuYXR0YWNoKClcbiAgICB9XG4gIH1cblxuICBhdHRhY2ggKCkge1xuICAgIHRoaXMuZGlzcG9zYWJsZXMgPSBuZXcgQ29tcG9zaXRlRGlzcG9zYWJsZSgpXG4gICAgdGhpcy5wYW5lbCA9IGF0b20ud29ya3NwYWNlLmFkZEJvdHRvbVBhbmVsKHtpdGVtOiB0aGlzfSlcbiAgICB0aGlzLmRpc3Bvc2FibGVzLmFkZChuZXcgRGlzcG9zYWJsZSgoKSA9PiB7XG4gICAgICB0aGlzLnBhbmVsLmRlc3Ryb3koKVxuICAgICAgdGhpcy5wYW5lbCA9IG51bGxcbiAgICB9KSlcblxuICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKGF0b20ua2V5bWFwcy5vbkRpZE1hdGNoQmluZGluZygoe2tleXN0cm9rZXMsIGJpbmRpbmcsIGtleWJvYXJkRXZlbnRUYXJnZXQsIGV2ZW50VHlwZX0pID0+IHtcbiAgICAgIGlmIChldmVudFR5cGUgPT09ICdrZXl1cCcgJiYgYmluZGluZyA9PSBudWxsKSB7XG4gICAgICAgIHJldHVyblxuICAgICAgfVxuXG4gICAgICBjb25zdCB1bnVzZWRLZXlCaW5kaW5ncyA9IGF0b20ua2V5bWFwc1xuICAgICAgICAuZmluZEtleUJpbmRpbmdzKHtrZXlzdHJva2VzLCB0YXJnZXQ6IGtleWJvYXJkRXZlbnRUYXJnZXR9KVxuICAgICAgICAuZmlsdGVyKChiKSA9PiBiICE9PSBiaW5kaW5nKVxuXG4gICAgICBjb25zdCB1bm1hdGNoZWRLZXlCaW5kaW5ncyA9IGF0b20ua2V5bWFwc1xuICAgICAgICAuZmluZEtleUJpbmRpbmdzKHtrZXlzdHJva2VzfSlcbiAgICAgICAgLmZpbHRlcigoYikgPT4gYiAhPT0gYmluZGluZyAmJiAhdW51c2VkS2V5QmluZGluZ3MuaW5jbHVkZXMoYikpXG5cbiAgICAgIHRoaXMudXBkYXRlKHt1c2VkS2V5QmluZGluZzogYmluZGluZywgdW51c2VkS2V5QmluZGluZ3MsIHVubWF0Y2hlZEtleUJpbmRpbmdzLCBrZXlzdHJva2VzfSlcbiAgICB9KSlcblxuICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKGF0b20ua2V5bWFwcy5vbkRpZFBhcnRpYWxseU1hdGNoQmluZGluZ3MoKHtrZXlzdHJva2VzLCBwYXJ0aWFsbHlNYXRjaGVkQmluZGluZ3N9KSA9PiB7XG4gICAgICB0aGlzLnVwZGF0ZSh7a2V5c3Ryb2tlcywgcGFydGlhbGx5TWF0Y2hlZEJpbmRpbmdzfSlcbiAgICB9KSlcblxuICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKGF0b20ua2V5bWFwcy5vbkRpZEZhaWxUb01hdGNoQmluZGluZygoe2tleXN0cm9rZXMsIGtleWJvYXJkRXZlbnRUYXJnZXQsIGV2ZW50VHlwZX0pID0+IHtcbiAgICAgIGlmIChldmVudFR5cGUgPT09ICdrZXl1cCcpIHtcbiAgICAgICAgcmV0dXJuXG4gICAgICB9XG5cbiAgICAgIGNvbnN0IHVudXNlZEtleUJpbmRpbmdzID0gYXRvbS5rZXltYXBzLmZpbmRLZXlCaW5kaW5ncyh7a2V5c3Ryb2tlcywgdGFyZ2V0OiBrZXlib2FyZEV2ZW50VGFyZ2V0fSlcbiAgICAgIGNvbnN0IHVubWF0Y2hlZEtleUJpbmRpbmdzID0gYXRvbS5rZXltYXBzXG4gICAgICAgIC5maW5kS2V5QmluZGluZ3Moe2tleXN0cm9rZXN9KVxuICAgICAgICAuZmlsdGVyKChiKSA9PiAhdW51c2VkS2V5QmluZGluZ3MuaW5jbHVkZXMoYikpXG5cbiAgICAgIHRoaXMudXBkYXRlKHt1bnVzZWRLZXlCaW5kaW5ncywgdW5tYXRjaGVkS2V5QmluZGluZ3MsIGtleXN0cm9rZXN9KVxuICAgIH0pKVxuICB9XG5cbiAgZGV0YWNoICgpIHtcbiAgICBpZiAodGhpcy5kaXNwb3NhYmxlcykge1xuICAgICAgdGhpcy5kaXNwb3NhYmxlcy5kaXNwb3NlKClcbiAgICB9XG4gIH1cblxuICB1cGRhdGUgKHByb3BzKSB7XG4gICAgdGhpcy5rZXlzdHJva2VzID0gcHJvcHMua2V5c3Ryb2tlc1xuICAgIHRoaXMudXNlZEtleUJpbmRpbmcgPSBwcm9wcy51c2VkS2V5QmluZGluZ1xuICAgIHRoaXMudW51c2VkS2V5QmluZGluZ3MgPSBwcm9wcy51bnVzZWRLZXlCaW5kaW5ncyB8fCBbXVxuICAgIHRoaXMudW5tYXRjaGVkS2V5QmluZGluZ3MgPSBwcm9wcy51bm1hdGNoZWRLZXlCaW5kaW5ncyB8fCBbXVxuICAgIHRoaXMucGFydGlhbGx5TWF0Y2hlZEJpbmRpbmdzID0gcHJvcHMucGFydGlhbGx5TWF0Y2hlZEJpbmRpbmdzIHx8IFtdXG4gICAgcmV0dXJuIGV0Y2gudXBkYXRlKHRoaXMpXG4gIH1cblxuICByZW5kZXIgKCkge1xuICAgIHJldHVybiAoXG4gICAgICA8ZGl2IGNsYXNzTmFtZT0na2V5LWJpbmRpbmctcmVzb2x2ZXInPlxuICAgICAgICA8ZGl2IGNsYXNzTmFtZT0ncGFuZWwtaGVhZGluZyBwYWRkZWQnPlxuICAgICAgICAgIDxzcGFuPktleSBCaW5kaW5nIFJlc29sdmVyOiA8L3NwYW4+XG4gICAgICAgICAge3RoaXMucmVuZGVyS2V5c3Ryb2tlcygpfVxuICAgICAgICA8L2Rpdj5cbiAgICAgICAgPGRpdiBjbGFzc05hbWU9J3BhbmVsLWJvZHkgcGFkZGVkJz57dGhpcy5yZW5kZXJLZXlCaW5kaW5ncygpfTwvZGl2PlxuICAgICAgPC9kaXY+XG4gICAgKVxuICB9XG5cbiAgcmVuZGVyS2V5c3Ryb2tlcyAoKSB7XG4gICAgaWYgKHRoaXMua2V5c3Ryb2tlcykge1xuICAgICAgaWYgKHRoaXMucGFydGlhbGx5TWF0Y2hlZEJpbmRpbmdzLmxlbmd0aCA+IDApIHtcbiAgICAgICAgcmV0dXJuIDxzcGFuIGNsYXNzTmFtZT0na2V5c3Ryb2tlJz57dGhpcy5rZXlzdHJva2VzfSAocGFydGlhbCk8L3NwYW4+XG4gICAgICB9IGVsc2Uge1xuICAgICAgICByZXR1cm4gPHNwYW4gY2xhc3NOYW1lPSdrZXlzdHJva2UnPnt0aGlzLmtleXN0cm9rZXN9PC9zcGFuPlxuICAgICAgfVxuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gPHNwYW4+UHJlc3MgYW55IGtleTogPC9zcGFuPlxuICAgIH1cbiAgfVxuXG4gIHJlbmRlcktleUJpbmRpbmdzICgpIHtcbiAgICBpZiAodGhpcy5wYXJ0aWFsbHlNYXRjaGVkQmluZGluZ3MubGVuZ3RoID4gMCkge1xuICAgICAgcmV0dXJuIChcbiAgICAgICAgPHRhYmxlIGNsYXNzTmFtZT0ndGFibGUtY29uZGVuc2VkJz5cbiAgICAgICAgICA8dGJvZHk+XG4gICAgICAgICAgICB7dGhpcy5wYXJ0aWFsbHlNYXRjaGVkQmluZGluZ3MubWFwKChiaW5kaW5nKSA9PiAoXG4gICAgICAgICAgICAgIDx0ciBjbGFzc05hbWU9J3VudXNlZCc+XG4gICAgICAgICAgICAgICAgPHRkIGNsYXNzTmFtZT0nY29weScgb25jbGljaz17KCkgPT4gdGhpcy5jb3B5S2V5YmluZGluZyhiaW5kaW5nKX0+PHNwYW4gY2xhc3NOYW1lPSdpY29uIGljb24tY2xpcHB5JyAvPjwvdGQ+XG4gICAgICAgICAgICAgICAgPHRkIGNsYXNzTmFtZT0nY29tbWFuZCc+e2JpbmRpbmcuY29tbWFuZH08L3RkPlxuICAgICAgICAgICAgICAgIDx0ZCBjbGFzc05hbWU9J2tleXN0cm9rZXMnPntiaW5kaW5nLmtleXN0cm9rZXN9PC90ZD5cbiAgICAgICAgICAgICAgICA8dGQgY2xhc3NOYW1lPSdzZWxlY3Rvcic+e2JpbmRpbmcuc2VsZWN0b3J9PC90ZD5cbiAgICAgICAgICAgICAgICA8dGQgY2xhc3NOYW1lPSdzb3VyY2UnIG9uY2xpY2s9eygpID0+IHRoaXMub3BlbktleWJpbmRpbmdGaWxlKGJpbmRpbmcuc291cmNlKX0+e2JpbmRpbmcuc291cmNlfTwvdGQ+XG4gICAgICAgICAgICAgIDwvdHI+XG4gICAgICAgICAgKSl9XG4gICAgICAgICAgPC90Ym9keT5cbiAgICAgICAgPC90YWJsZT5cbiAgICAgIClcbiAgICB9IGVsc2Uge1xuICAgICAgbGV0IHVzZWRLZXlCaW5kaW5nID0gJydcbiAgICAgIGlmICh0aGlzLnVzZWRLZXlCaW5kaW5nKSB7XG4gICAgICAgIHVzZWRLZXlCaW5kaW5nID0gKFxuICAgICAgICAgIDx0ciBjbGFzc05hbWU9J3VzZWQnPlxuICAgICAgICAgICAgPHRkIGNsYXNzTmFtZT0nY29weScgb25jbGljaz17KCkgPT4gdGhpcy5jb3B5S2V5YmluZGluZyh0aGlzLnVzZWRLZXlCaW5kaW5nKX0+PHNwYW4gY2xhc3NOYW1lPSdpY29uIGljb24tY2xpcHB5JyAvPjwvdGQ+XG4gICAgICAgICAgICA8dGQgY2xhc3NOYW1lPSdjb21tYW5kJz57dGhpcy51c2VkS2V5QmluZGluZy5jb21tYW5kfTwvdGQ+XG4gICAgICAgICAgICA8dGQgY2xhc3NOYW1lPSdzZWxlY3Rvcic+e3RoaXMudXNlZEtleUJpbmRpbmcuc2VsZWN0b3J9PC90ZD5cbiAgICAgICAgICAgIDx0ZCBjbGFzc05hbWU9J3NvdXJjZScgb25jbGljaz17KCkgPT4gdGhpcy5vcGVuS2V5YmluZGluZ0ZpbGUodGhpcy51c2VkS2V5QmluZGluZy5zb3VyY2UpfT57dGhpcy51c2VkS2V5QmluZGluZy5zb3VyY2V9PC90ZD5cbiAgICAgICAgICA8L3RyPlxuICAgICAgICApXG4gICAgICB9XG4gICAgICByZXR1cm4gKFxuICAgICAgICA8dGFibGUgY2xhc3NOYW1lPSd0YWJsZS1jb25kZW5zZWQnPlxuICAgICAgICAgIDx0Ym9keT5cbiAgICAgICAgICAgIHt1c2VkS2V5QmluZGluZ31cbiAgICAgICAgICAgIHt0aGlzLnVudXNlZEtleUJpbmRpbmdzLm1hcCgoYmluZGluZykgPT4gKFxuICAgICAgICAgICAgICA8dHIgY2xhc3NOYW1lPSd1bnVzZWQnPlxuICAgICAgICAgICAgICAgIDx0ZCBjbGFzc05hbWU9J2NvcHknIG9uY2xpY2s9eygpID0+IHRoaXMuY29weUtleWJpbmRpbmcoYmluZGluZyl9PjxzcGFuIGNsYXNzTmFtZT0naWNvbiBpY29uLWNsaXBweScgLz48L3RkPlxuICAgICAgICAgICAgICAgIDx0ZCBjbGFzc05hbWU9J2NvbW1hbmQnPntiaW5kaW5nLmNvbW1hbmR9PC90ZD5cbiAgICAgICAgICAgICAgICA8dGQgY2xhc3NOYW1lPSdzZWxlY3Rvcic+e2JpbmRpbmcuc2VsZWN0b3J9PC90ZD5cbiAgICAgICAgICAgICAgICA8dGQgY2xhc3NOYW1lPSdzb3VyY2UnIG9uY2xpY2s9eygpID0+IHRoaXMub3BlbktleWJpbmRpbmdGaWxlKGJpbmRpbmcuc291cmNlKX0+e2JpbmRpbmcuc291cmNlfTwvdGQ+XG4gICAgICAgICAgICAgIDwvdHI+XG4gICAgICAgICAgICApKX1cbiAgICAgICAgICAgIHt0aGlzLnVubWF0Y2hlZEtleUJpbmRpbmdzLm1hcCgoYmluZGluZykgPT4gKFxuICAgICAgICAgICAgICA8dHIgY2xhc3NOYW1lPSd1bm1hdGNoZWQnPlxuICAgICAgICAgICAgICAgIDx0ZCBjbGFzc05hbWU9J2NvcHknIG9uY2xpY2s9eygpID0+IHRoaXMuY29weUtleWJpbmRpbmcoYmluZGluZyl9PjxzcGFuIGNsYXNzTmFtZT0naWNvbiBpY29uLWNsaXBweScgLz48L3RkPlxuICAgICAgICAgICAgICAgIDx0ZCBjbGFzc05hbWU9J2NvbW1hbmQnPntiaW5kaW5nLmNvbW1hbmR9PC90ZD5cbiAgICAgICAgICAgICAgICA8dGQgY2xhc3NOYW1lPSdzZWxlY3Rvcic+e2JpbmRpbmcuc2VsZWN0b3J9PC90ZD5cbiAgICAgICAgICAgICAgICA8dGQgY2xhc3NOYW1lPSdzb3VyY2UnIG9uY2xpY2s9eygpID0+IHRoaXMub3BlbktleWJpbmRpbmdGaWxlKGJpbmRpbmcuc291cmNlKX0+e2JpbmRpbmcuc291cmNlfTwvdGQ+XG4gICAgICAgICAgICAgIDwvdHI+XG4gICAgICAgICAgKSl9XG4gICAgICAgICAgPC90Ym9keT5cbiAgICAgICAgPC90YWJsZT5cbiAgICAgIClcbiAgICB9XG4gIH1cblxuICBpc0luQXNhckFyY2hpdmUgKHBhdGhUb0NoZWNrKSB7XG4gICAgY29uc3Qge3Jlc291cmNlUGF0aH0gPSBhdG9tLmdldExvYWRTZXR0aW5ncygpXG4gICAgcmV0dXJuIHBhdGhUb0NoZWNrLnN0YXJ0c1dpdGgoYCR7cmVzb3VyY2VQYXRofSR7cGF0aC5zZXB9YCkgJiYgcGF0aC5leHRuYW1lKHJlc291cmNlUGF0aCkgPT09ICcuYXNhcidcbiAgfVxuXG4gIGV4dHJhY3RCdW5kbGVkS2V5bWFwIChidW5kbGVkS2V5bWFwUGF0aCkge1xuICAgIGNvbnN0IG1ldGFkYXRhID0gcmVxdWlyZShwYXRoLmpvaW4oYXRvbS5nZXRMb2FkU2V0dGluZ3MoKS5yZXNvdXJjZVBhdGgsICdwYWNrYWdlLmpzb24nKSlcbiAgICBjb25zdCBidW5kbGVkS2V5bWFwcyA9IG1ldGFkYXRhID8gbWV0YWRhdGEuX2F0b21LZXltYXBzIDoge31cbiAgICBjb25zdCBrZXltYXBOYW1lID0gcGF0aC5iYXNlbmFtZShidW5kbGVkS2V5bWFwUGF0aClcbiAgICBjb25zdCBleHRyYWN0ZWRLZXltYXBQYXRoID0gcGF0aC5qb2luKHJlcXVpcmUoJ3RlbXAnKS5ta2RpclN5bmMoJ2F0b20tYnVuZGxlZC1rZXltYXAtJyksIGtleW1hcE5hbWUpXG4gICAgZnMud3JpdGVGaWxlU3luYyhcbiAgICAgIGV4dHJhY3RlZEtleW1hcFBhdGgsXG4gICAgICBKU09OLnN0cmluZ2lmeShidW5kbGVkS2V5bWFwc1trZXltYXBOYW1lXSB8fCB7fSwgbnVsbCwgMilcbiAgICApXG4gICAgcmV0dXJuIGV4dHJhY3RlZEtleW1hcFBhdGhcbiAgfVxuXG4gIGV4dHJhY3RCdW5kbGVkUGFja2FnZUtleW1hcCAoa2V5bWFwUmVsYXRpdmVQYXRoKSB7XG4gICAgY29uc3QgcGFja2FnZU5hbWUgPSBrZXltYXBSZWxhdGl2ZVBhdGguc3BsaXQocGF0aC5zZXApWzFdXG4gICAgY29uc3Qga2V5bWFwTmFtZSA9IHBhdGguYmFzZW5hbWUoa2V5bWFwUmVsYXRpdmVQYXRoKVxuICAgIGNvbnN0IG1ldGFkYXRhID0gYXRvbS5wYWNrYWdlcy5wYWNrYWdlc0NhY2hlW3BhY2thZ2VOYW1lXSB8fCB7fVxuICAgIGNvbnN0IGtleW1hcHMgPSBtZXRhZGF0YS5rZXltYXBzIHx8IHt9XG4gICAgY29uc3QgZXh0cmFjdGVkS2V5bWFwUGF0aCA9IHBhdGguam9pbihyZXF1aXJlKCd0ZW1wJykubWtkaXJTeW5jKCdhdG9tLWJ1bmRsZWQta2V5bWFwLScpLCBrZXltYXBOYW1lKVxuICAgIGZzLndyaXRlRmlsZVN5bmMoXG4gICAgICBleHRyYWN0ZWRLZXltYXBQYXRoLFxuICAgICAgSlNPTi5zdHJpbmdpZnkoa2V5bWFwc1trZXltYXBSZWxhdGl2ZVBhdGhdIHx8IHt9LCBudWxsLCAyKVxuICAgIClcbiAgICByZXR1cm4gZXh0cmFjdGVkS2V5bWFwUGF0aFxuICB9XG5cbiAgb3BlbktleWJpbmRpbmdGaWxlIChrZXltYXBQYXRoKSB7XG4gICAgaWYgKHRoaXMuaXNJbkFzYXJBcmNoaXZlKGtleW1hcFBhdGgpKSB7XG4gICAgICBrZXltYXBQYXRoID0gdGhpcy5leHRyYWN0QnVuZGxlZEtleW1hcChrZXltYXBQYXRoKVxuICAgIH0gZWxzZSBpZiAoa2V5bWFwUGF0aC5zdGFydHNXaXRoKCdjb3JlOm5vZGVfbW9kdWxlcycpKSB7XG4gICAgICBrZXltYXBQYXRoID0gdGhpcy5leHRyYWN0QnVuZGxlZFBhY2thZ2VLZXltYXAoa2V5bWFwUGF0aC5yZXBsYWNlKCdjb3JlOicsICcnKSlcbiAgICB9IGVsc2UgaWYgKGtleW1hcFBhdGguc3RhcnRzV2l0aCgnY29yZTonKSkge1xuICAgICAga2V5bWFwUGF0aCA9IHRoaXMuZXh0cmFjdEJ1bmRsZWRLZXltYXAoa2V5bWFwUGF0aC5yZXBsYWNlKCdjb3JlOicsICcnKSlcbiAgICB9XG5cbiAgICBhdG9tLndvcmtzcGFjZS5vcGVuKGtleW1hcFBhdGgpXG4gIH1cblxuICBjb3B5S2V5YmluZGluZyAoYmluZGluZykge1xuICAgIGxldCBjb250ZW50XG4gICAgY29uc3Qga2V5bWFwRXh0ZW5zaW9uID0gcGF0aC5leHRuYW1lKGF0b20ua2V5bWFwcy5nZXRVc2VyS2V5bWFwUGF0aCgpKVxuICAgIGxldCBlc2NhcGVkS2V5c3Ryb2tlcyA9IGJpbmRpbmcua2V5c3Ryb2tlcy5yZXBsYWNlKC9cXFxcL2csICdcXFxcXFxcXCcpIC8vIEVzY2FwZSBiYWNrc2xhc2hlc1xuICAgIGlmIChrZXltYXBFeHRlbnNpb24gPT09ICcuY3NvbicpIHtcbiAgICAgIGNvbnRlbnQgPSBgXFxcbicke2JpbmRpbmcuc2VsZWN0b3J9JzpcbiAgJyR7ZXNjYXBlZEtleXN0cm9rZXN9JzogJyR7YmluZGluZy5jb21tYW5kfSdcbmBcbiAgICB9IGVsc2Uge1xuICAgICAgY29udGVudCA9IGBcXFxuXCIke2JpbmRpbmcuc2VsZWN0b3J9XCI6IHtcbiAgXCIke2VzY2FwZWRLZXlzdHJva2VzfVwiOiBcIiR7YmluZGluZy5jb21tYW5kfVwiXG59XG5gXG4gICAgfVxuXG4gICAgYXRvbS5ub3RpZmljYXRpb25zLmFkZEluZm8oJ0tleWJpbmRpbmcgQ29waWVkJylcbiAgICByZXR1cm4gYXRvbS5jbGlwYm9hcmQud3JpdGUoY29udGVudClcbiAgfVxufVxuIl19