"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _moment = _interopRequireDefault(require("moment"));

var _classnames = _interopRequireDefault(require("classnames"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

_moment.default.defineLocale('en-shortdiff', {
  parentLocale: 'en',
  relativeTime: {
    future: 'in %s',
    past: '%s ago',
    s: 'Now',
    ss: '<1m',
    m: '1m',
    mm: '%dm',
    h: '1h',
    hh: '%dh',
    d: '1d',
    dd: '%dd',
    M: '1M',
    MM: '%dM',
    y: '1y',
    yy: '%dy'
  }
});

_moment.default.locale('en');

class Timeago extends _react.default.Component {
  static getTimeDisplay(time, now, style) {
    const m = (0, _moment.default)(time);

    if (style === 'short') {
      m.locale('en-shortdiff');
      return m.from(now, true);
    } else {
      const diff = m.diff(now, 'months', true);

      if (Math.abs(diff) <= 1) {
        m.locale('en');
        return m.from(now);
      } else {
        const format = m.format('MMM Do, YYYY');
        return `on ${format}`;
      }
    }
  }

  componentDidMount() {
    this.timer = setInterval(() => this.forceUpdate(), 60000);
  }

  componentWillUnmount() {
    clearInterval(this.timer);
  }

  render() {
    const _this$props = this.props,
          {
      type,
      time,
      displayStyle
    } = _this$props,
          others = _objectWithoutProperties(_this$props, ["type", "time", "displayStyle"]);

    const display = Timeago.getTimeDisplay(time, (0, _moment.default)(), displayStyle);
    const Type = type;
    const className = (0, _classnames.default)('timeago', others.className);
    return _react.default.createElement(Type, _extends({}, others, {
      className: className
    }), display);
  }

}

exports.default = Timeago;

_defineProperty(Timeago, "propTypes", {
  time: _propTypes.default.any.isRequired,
  type: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.func]),
  displayStyle: _propTypes.default.oneOf(['short', 'long'])
});

_defineProperty(Timeago, "defaultProps", {
  type: 'span',
  displayStyle: 'long'
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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