"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PullRequestCommentView = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _atom = require("atom");

var _helpers = require("../helpers");

var _marker = _interopRequireDefault(require("../atom/marker"));

var _decoration = _interopRequireDefault(require("../atom/decoration"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _githubDotcomMarkdown = _interopRequireDefault(require("./github-dotcom-markdown"));

var _timeago = _interopRequireDefault(require("./timeago"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class PullRequestCommentsView extends _react.default.Component {
  render() {
    return [...this.props.commentThreads].map(({
      rootCommentId,
      comments
    }) => {
      const rootComment = comments[0];

      if (!rootComment.position) {
        return null;
      } // if file patch is collapsed or too large, do not render the comments


      if (!this.props.isPatchVisible(rootComment.path)) {
        return null;
      }

      const nativePath = (0, _helpers.toNativePathSep)(rootComment.path);
      const row = this.props.getBufferRowForDiffPosition(nativePath, rootComment.position);
      const point = new _atom.Point(row, 0);
      const range = new _atom.Range(point, point);
      return _react.default.createElement(_marker.default, {
        key: `pr-comment-${rootCommentId}`,
        bufferRange: range,
        invalidate: "never"
      }, _react.default.createElement(_decoration.default, {
        type: "block",
        position: "after",
        className: "github-PrCommentThread"
      }, comments.map(comment => {
        return _react.default.createElement(PullRequestCommentView, {
          key: comment.id,
          comment: comment,
          switchToIssueish: this.props.switchToIssueish
        });
      })));
    });
  }

}

exports.default = PullRequestCommentsView;

_defineProperty(PullRequestCommentsView, "propTypes", {
  commentThreads: _propTypes.default.arrayOf(_propTypes.default.shape({
    rootCommentId: _propTypes.default.string.isRequired,
    comments: _propTypes.default.arrayOf(_propTypes.default.object).isRequired
  })),
  getBufferRowForDiffPosition: _propTypes.default.func.isRequired,
  switchToIssueish: _propTypes.default.func.isRequired,
  isPatchVisible: _propTypes.default.func.isRequired
});

class PullRequestCommentView extends _react.default.Component {
  render() {
    if (this.props.comment.isMinimized) {
      return _react.default.createElement("div", {
        className: "github-PrComment"
      }, _react.default.createElement("span", {
        className: "github-PrComment-hidden"
      }, _react.default.createElement(_octicon.default, {
        icon: 'fold',
        className: "github-PrComment-icon"
      }), _react.default.createElement("em", null, "This comment was hidden")));
    } else {
      const author = this.props.comment.author;
      const login = author ? author.login : 'someone';
      return _react.default.createElement("div", {
        className: "github-PrComment"
      }, _react.default.createElement("header", {
        className: "github-PrComment-header"
      }, _react.default.createElement("img", {
        className: "github-PrComment-avatar",
        src: author ? author.avatarUrl : '',
        alt: login
      }), login, " commented", ' ', _react.default.createElement("a", {
        className: "github-PrComment-timeAgo",
        href: this.props.comment.url
      }, _react.default.createElement(_timeago.default, {
        time: this.props.comment.createdAt
      }))), _react.default.createElement("main", {
        className: "github-PrComment-body"
      }, _react.default.createElement(_githubDotcomMarkdown.default, {
        html: this.props.comment.bodyHTML,
        switchToIssueish: this.props.switchToIssueish
      })));
    }
  }

}

exports.PullRequestCommentView = PullRequestCommentView;

_defineProperty(PullRequestCommentView, "propTypes", {
  switchToIssueish: _propTypes.default.func.isRequired,
  comment: _propTypes.default.shape({
    author: _propTypes.default.shape({
      avatarUrl: _propTypes.default.string,
      login: _propTypes.default.string
    }),
    bodyHTML: _propTypes.default.string,
    url: _propTypes.default.string,
    createdAt: _propTypes.default.string.isRequired,
    isMinimized: _propTypes.default.bool.isRequired
  }).isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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