"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reporterProxy = require("../reporter-proxy");

var _eventKit = require("event-kit");

var _commitDetailItem = _interopRequireDefault(require("../items/commit-detail-item"));

var _uriPattern = _interopRequireDefault(require("../atom/uri-pattern"));

var _recentCommitsView = _interopRequireDefault(require("../views/recent-commits-view"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class RecentCommitsController extends _react.default.Component {
  constructor(props, context) {
    super(props, context);

    _defineProperty(this, "updateSelectedCommit", () => {
      const activeItem = this.props.workspace.getActivePaneItem();
      const pattern = new _uriPattern.default(decodeURIComponent(_commitDetailItem.default.buildURI(this.props.repository.getWorkingDirectoryPath(), '{sha}')));

      if (activeItem && activeItem.getURI) {
        const match = pattern.matches(activeItem.getURI());
        const {
          sha
        } = match.getParams();

        if (match.ok() && sha && sha !== this.state.selectedCommitSha) {
          return new Promise(resolve => this.setState({
            selectedCommitSha: sha
          }, resolve));
        }
      }

      return Promise.resolve();
    });

    _defineProperty(this, "openCommit", async ({
      sha,
      preserveFocus
    }) => {
      const workdir = this.props.repository.getWorkingDirectoryPath();

      const uri = _commitDetailItem.default.buildURI(workdir, sha);

      const item = await this.props.workspace.open(uri, {
        pending: true
      });

      if (preserveFocus) {
        item.preventFocus();
        this.setFocus(this.constructor.focus.RECENT_COMMIT);
      }

      (0, _reporterProxy.addEvent)('open-commit-in-pane', {
        package: 'github',
        from: this.constructor.name
      });
    });

    _defineProperty(this, "selectNextCommit", () => this.setSelectedCommitIndex(this.getSelectedCommitIndex() + 1));

    _defineProperty(this, "selectPreviousCommit", () => this.setSelectedCommitIndex(Math.max(this.getSelectedCommitIndex() - 1, 0)));

    this.subscriptions = new _eventKit.CompositeDisposable(this.props.workspace.onDidChangeActivePaneItem(this.updateSelectedCommit));
    this.refView = new _refHolder.default();
    this.state = {
      selectedCommitSha: ''
    };
  }

  render() {
    return _react.default.createElement(_recentCommitsView.default, {
      ref: this.refView.setter,
      commits: this.props.commits,
      isLoading: this.props.isLoading,
      undoLastCommit: this.props.undoLastCommit,
      openCommit: this.openCommit,
      selectNextCommit: this.selectNextCommit,
      selectPreviousCommit: this.selectPreviousCommit,
      selectedCommitSha: this.state.selectedCommitSha,
      commandRegistry: this.props.commandRegistry
    });
  }

  getSelectedCommitIndex() {
    return this.props.commits.findIndex(commit => commit.getSha() === this.state.selectedCommitSha);
  }

  setSelectedCommitIndex(ind) {
    const commit = this.props.commits[ind];

    if (commit) {
      return new Promise(resolve => this.setState({
        selectedCommitSha: commit.getSha()
      }, resolve));
    } else {
      return Promise.resolve();
    }
  }

  getFocus(element) {
    return this.refView.map(view => view.getFocus(element)).getOr(null);
  }

  setFocus(focus) {
    return this.refView.map(view => {
      const wasFocused = view.setFocus(focus);

      if (wasFocused && this.getSelectedCommitIndex() === -1) {
        this.setSelectedCommitIndex(0);
      }

      return wasFocused;
    }).getOr(false);
  }

  advanceFocusFrom(focus) {
    return this.refView.map(view => view.advanceFocusFrom(focus)).getOr(Promise.resolve(null));
  }

  retreatFocusFrom(focus) {
    return this.refView.map(view => view.retreatFocusFrom(focus)).getOr(Promise.resolve(null));
  }

}

exports.default = RecentCommitsController;

_defineProperty(RecentCommitsController, "propTypes", {
  commits: _propTypes.default.arrayOf(_propTypes.default.object).isRequired,
  isLoading: _propTypes.default.bool.isRequired,
  undoLastCommit: _propTypes.default.func.isRequired,
  workspace: _propTypes.default.object.isRequired,
  repository: _propTypes.default.object.isRequired,
  commandRegistry: _propTypes.default.object.isRequired
});

_defineProperty(RecentCommitsController, "focus", _recentCommitsView.default.focus);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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