"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const typeAndStateToIcon = {
  Issue: {
    OPEN: 'issue-opened',
    CLOSED: 'issue-closed'
  },
  PullRequest: {
    OPEN: 'git-pull-request',
    CLOSED: 'git-pull-request',
    MERGED: 'git-merge'
  }
};

class IssueishTooltip extends _react.default.Component {
  render() {
    const resource = this.props.resource;
    const {
      repository,
      state,
      number,
      title,
      author,
      __typename
    } = resource;
    const icons = typeAndStateToIcon[__typename] || {};
    const icon = icons[state] || '';
    return _react.default.createElement("div", {
      className: "github-IssueishTooltip"
    }, _react.default.createElement("div", {
      className: "issueish-avatar-and-title"
    }, _react.default.createElement("img", {
      className: "author-avatar",
      src: author.avatarUrl,
      title: author.login,
      alt: author.login
    }), _react.default.createElement("h3", {
      className: "issueish-title"
    }, title)), _react.default.createElement("div", {
      className: "issueish-badge-and-link"
    }, _react.default.createElement("span", {
      className: (0, _classnames.default)('issueish-badge', 'badge', state.toLowerCase())
    }, _react.default.createElement(_octicon.default, {
      icon: icon
    }), state.toLowerCase()), _react.default.createElement("span", {
      className: "issueish-link"
    }, repository.owner.login, "/", repository.name, "#", number)));
  }

}

_defineProperty(IssueishTooltip, "propTypes", {
  resource: _propTypes.default.shape({
    issue: _propTypes.default.shape({}),
    pullRequest: _propTypes.default.shape({})
  }).isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(IssueishTooltip, {
  resource: function () {
    const node = require("./__generated__/issueishTooltipContainer_resource.graphql");

    if (node.hash && node.hash !== "8980fc73c7ed3f632f0612ce14f2f0d1") {
      console.error("The definition of 'issueishTooltipContainer_resource' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/issueishTooltipContainer_resource.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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