"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

var _reactRelay = require("react-relay");

var _helpers = require("../helpers");

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _propTypes2 = require("../prop-types");

var _keytarStrategy = require("../shared/keytar-strategy");

var _githubLoginView = _interopRequireDefault(require("../views/github-login-view"));

var _loadingView = _interopRequireDefault(require("../views/loading-view"));

var _queryErrorView = _interopRequireDefault(require("../views/query-error-view"));

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _relayEnvironment = _interopRequireDefault(require("../views/relay-environment"));

var _issueishDetailController = _interopRequireDefault(require("../controllers/issueish-detail-controller"));

var _graphql;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class IssueishDetailContainer extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'fetchToken', 'renderWithToken', 'fetchRepositoryData', 'renderWithRepositoryData', 'renderWithResult', 'handleLogin', 'handleLogout');
  }

  fetchToken(loginModel) {
    return (0, _yubikiri.default)({
      token: loginModel.getToken(this.props.endpoint.getLoginAccount())
    });
  }

  render() {
    return _react.default.createElement(_observeModel.default, {
      model: this.props.loginModel,
      fetchData: this.fetchToken
    }, this.renderWithToken);
  }

  fetchRepositoryData(repository) {
    return (0, _yubikiri.default)({
      branches: repository.getBranches(),
      remotes: repository.getRemotes(),
      isMerging: repository.isMerging(),
      isRebasing: repository.isRebasing(),
      isAbsent: repository.isAbsent(),
      isLoading: repository.isLoading(),
      isPresent: repository.isPresent()
    });
  }

  renderWithToken(tokenData) {
    if (!tokenData) {
      return _react.default.createElement(_loadingView.default, null);
    }

    if (tokenData.token === _keytarStrategy.UNAUTHENTICATED) {
      return _react.default.createElement(_githubLoginView.default, {
        onLogin: this.handleLogin
      });
    }

    if (tokenData.token === _keytarStrategy.INSUFFICIENT) {
      return _react.default.createElement(_githubLoginView.default, {
        onLogin: this.handleLogin
      }, _react.default.createElement("p", null, "Your token no longer has sufficient authorizations. Please re-authenticate and generate a new one."));
    }

    return _react.default.createElement(_observeModel.default, {
      model: this.props.repository,
      fetchData: this.fetchRepositoryData
    }, repoData => this.renderWithRepositoryData(repoData, tokenData.token));
  }

  renderWithRepositoryData(repoData, token) {
    if (!repoData) {
      return _react.default.createElement(_loadingView.default, null);
    }

    const environment = _relayNetworkLayerManager.default.getEnvironmentForHost(this.props.endpoint, token);

    const query = _graphql || (_graphql = function () {
      const node = require("./__generated__/issueishDetailContainerQuery.graphql");

      if (node.hash && node.hash !== "6a16db513a3cd8bf14fafb3c8b269643") {
        console.error("The definition of 'issueishDetailContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
      }

      return require("./__generated__/issueishDetailContainerQuery.graphql");
    });

    const variables = {
      repoOwner: this.props.owner,
      repoName: this.props.repo,
      issueishNumber: this.props.issueishNumber,
      timelineCount: _helpers.PAGE_SIZE,
      timelineCursor: null,
      commitCount: _helpers.PAGE_SIZE,
      commitCursor: null,
      reviewCount: _helpers.PAGE_SIZE,
      reviewCursor: null,
      commentCount: _helpers.PAGE_SIZE,
      commentCursor: null
    };
    return _react.default.createElement(_relayEnvironment.default.Provider, {
      value: environment
    }, _react.default.createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      query: query,
      variables: variables,
      render: queryResult => this.renderWithResult(queryResult, repoData, token)
    }));
  }

  renderWithResult({
    error,
    props,
    retry
  }, repoData, token) {
    if (error) {
      return _react.default.createElement(_queryErrorView.default, {
        error: error,
        login: this.handleLogin,
        retry: retry,
        logout: this.handleLogout
      });
    }

    if (!props) {
      return _react.default.createElement(_loadingView.default, null);
    }

    const {
      repository
    } = this.props;
    return _react.default.createElement(_issueishDetailController.default, _extends({}, props, repoData, {
      localRepository: this.props.repository,
      issueishNumber: this.props.issueishNumber,
      fetch: repository.fetch.bind(repository),
      checkout: repository.checkout.bind(repository),
      pull: repository.pull.bind(repository),
      addRemote: repository.addRemote.bind(repository),
      onTitleChange: this.props.onTitleChange,
      switchToIssueish: this.props.switchToIssueish,
      workdirPath: repository.getWorkingDirectoryPath(),
      endpoint: this.props.endpoint,
      token: token,
      workspace: this.props.workspace,
      commands: this.props.commands,
      keymaps: this.props.keymaps,
      tooltips: this.props.tooltips,
      config: this.props.config,
      itemType: this.props.itemType,
      destroy: this.props.destroy,
      refEditor: this.props.refEditor
    }));
  }

  handleLogin(token) {
    return this.props.loginModel.setToken(this.props.endpoint.getLoginAccount(), token);
  }

  handleLogout() {
    return this.props.loginModel.removeToken(this.props.endpoint.getLoginAccount());
  }

}

exports.default = IssueishDetailContainer;

_defineProperty(IssueishDetailContainer, "propTypes", {
  // Connection
  endpoint: _propTypes2.EndpointPropType.isRequired,
  // Issueish selection criteria
  owner: _propTypes.default.string.isRequired,
  repo: _propTypes.default.string.isRequired,
  issueishNumber: _propTypes.default.number.isRequired,
  // Package models
  repository: _propTypes.default.object.isRequired,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  // Atom environment
  workspace: _propTypes.default.object.isRequired,
  commands: _propTypes.default.object.isRequired,
  keymaps: _propTypes.default.object.isRequired,
  tooltips: _propTypes.default.object.isRequired,
  config: _propTypes.default.object.isRequired,
  // Action methods
  switchToIssueish: _propTypes.default.func.isRequired,
  onTitleChange: _propTypes.default.func.isRequired,
  destroy: _propTypes.default.func.isRequired,
  // Item context
  itemType: _propTypes2.ItemTypePropType.isRequired,
  refEditor: _propTypes2.RefHolderPropType.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImlzc3VlaXNoLWRldGFpbC1jb250YWluZXIuanMiXSwibmFtZXMiOlsiSXNzdWVpc2hEZXRhaWxDb250YWluZXIiLCJSZWFjdCIsIkNvbXBvbmVudCIsImNvbnN0cnVjdG9yIiwicHJvcHMiLCJmZXRjaFRva2VuIiwibG9naW5Nb2RlbCIsInRva2VuIiwiZ2V0VG9rZW4iLCJlbmRwb2ludCIsImdldExvZ2luQWNjb3VudCIsInJlbmRlciIsInJlbmRlcldpdGhUb2tlbiIsImZldGNoUmVwb3NpdG9yeURhdGEiLCJyZXBvc2l0b3J5IiwiYnJhbmNoZXMiLCJnZXRCcmFuY2hlcyIsInJlbW90ZXMiLCJnZXRSZW1vdGVzIiwiaXNNZXJnaW5nIiwiaXNSZWJhc2luZyIsImlzQWJzZW50IiwiaXNMb2FkaW5nIiwiaXNQcmVzZW50IiwidG9rZW5EYXRhIiwiVU5BVVRIRU5USUNBVEVEIiwiaGFuZGxlTG9naW4iLCJJTlNVRkZJQ0lFTlQiLCJyZXBvRGF0YSIsInJlbmRlcldpdGhSZXBvc2l0b3J5RGF0YSIsImVudmlyb25tZW50IiwiUmVsYXlOZXR3b3JrTGF5ZXJNYW5hZ2VyIiwiZ2V0RW52aXJvbm1lbnRGb3JIb3N0IiwicXVlcnkiLCJ2YXJpYWJsZXMiLCJyZXBvT3duZXIiLCJvd25lciIsInJlcG9OYW1lIiwicmVwbyIsImlzc3VlaXNoTnVtYmVyIiwidGltZWxpbmVDb3VudCIsIlBBR0VfU0laRSIsInRpbWVsaW5lQ3Vyc29yIiwiY29tbWl0Q291bnQiLCJjb21taXRDdXJzb3IiLCJyZXZpZXdDb3VudCIsInJldmlld0N1cnNvciIsImNvbW1lbnRDb3VudCIsImNvbW1lbnRDdXJzb3IiLCJxdWVyeVJlc3VsdCIsInJlbmRlcldpdGhSZXN1bHQiLCJlcnJvciIsInJldHJ5IiwiaGFuZGxlTG9nb3V0IiwiZmV0Y2giLCJiaW5kIiwiY2hlY2tvdXQiLCJwdWxsIiwiYWRkUmVtb3RlIiwib25UaXRsZUNoYW5nZSIsInN3aXRjaFRvSXNzdWVpc2giLCJnZXRXb3JraW5nRGlyZWN0b3J5UGF0aCIsIndvcmtzcGFjZSIsImNvbW1hbmRzIiwia2V5bWFwcyIsInRvb2x0aXBzIiwiY29uZmlnIiwiaXRlbVR5cGUiLCJkZXN0cm95IiwicmVmRWRpdG9yIiwic2V0VG9rZW4iLCJyZW1vdmVUb2tlbiIsIkVuZHBvaW50UHJvcFR5cGUiLCJpc1JlcXVpcmVkIiwiUHJvcFR5cGVzIiwic3RyaW5nIiwibnVtYmVyIiwib2JqZWN0IiwiR2l0aHViTG9naW5Nb2RlbFByb3BUeXBlIiwiZnVuYyIsIkl0ZW1UeXBlUHJvcFR5cGUiLCJSZWZIb2xkZXJQcm9wVHlwZSJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOztBQUNBOztBQUNBOztBQUNBOztBQUVBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOzs7Ozs7Ozs7O0FBRWUsTUFBTUEsdUJBQU4sU0FBc0NDLGVBQU1DLFNBQTVDLENBQXNEO0FBK0JuRUMsRUFBQUEsV0FBVyxDQUFDQyxLQUFELEVBQVE7QUFDakIsVUFBTUEsS0FBTjtBQUNBLDJCQUFTLElBQVQsRUFDRSxZQURGLEVBQ2dCLGlCQURoQixFQUVFLHFCQUZGLEVBRXlCLDBCQUZ6QixFQUdFLGtCQUhGLEVBSUUsYUFKRixFQUlpQixjQUpqQjtBQU1EOztBQUVEQyxFQUFBQSxVQUFVLENBQUNDLFVBQUQsRUFBYTtBQUNyQixXQUFPLHVCQUFTO0FBQ2RDLE1BQUFBLEtBQUssRUFBRUQsVUFBVSxDQUFDRSxRQUFYLENBQW9CLEtBQUtKLEtBQUwsQ0FBV0ssUUFBWCxDQUFvQkMsZUFBcEIsRUFBcEI7QUFETyxLQUFULENBQVA7QUFHRDs7QUFFREMsRUFBQUEsTUFBTSxHQUFHO0FBQ1AsV0FDRSw2QkFBQyxxQkFBRDtBQUFjLE1BQUEsS0FBSyxFQUFFLEtBQUtQLEtBQUwsQ0FBV0UsVUFBaEM7QUFBNEMsTUFBQSxTQUFTLEVBQUUsS0FBS0Q7QUFBNUQsT0FDRyxLQUFLTyxlQURSLENBREY7QUFLRDs7QUFFREMsRUFBQUEsbUJBQW1CLENBQUNDLFVBQUQsRUFBYTtBQUM5QixXQUFPLHVCQUFTO0FBQ2RDLE1BQUFBLFFBQVEsRUFBRUQsVUFBVSxDQUFDRSxXQUFYLEVBREk7QUFFZEMsTUFBQUEsT0FBTyxFQUFFSCxVQUFVLENBQUNJLFVBQVgsRUFGSztBQUdkQyxNQUFBQSxTQUFTLEVBQUVMLFVBQVUsQ0FBQ0ssU0FBWCxFQUhHO0FBSWRDLE1BQUFBLFVBQVUsRUFBRU4sVUFBVSxDQUFDTSxVQUFYLEVBSkU7QUFLZEMsTUFBQUEsUUFBUSxFQUFFUCxVQUFVLENBQUNPLFFBQVgsRUFMSTtBQU1kQyxNQUFBQSxTQUFTLEVBQUVSLFVBQVUsQ0FBQ1EsU0FBWCxFQU5HO0FBT2RDLE1BQUFBLFNBQVMsRUFBRVQsVUFBVSxDQUFDUyxTQUFYO0FBUEcsS0FBVCxDQUFQO0FBU0Q7O0FBRURYLEVBQUFBLGVBQWUsQ0FBQ1ksU0FBRCxFQUFZO0FBQ3pCLFFBQUksQ0FBQ0EsU0FBTCxFQUFnQjtBQUNkLGFBQU8sNkJBQUMsb0JBQUQsT0FBUDtBQUNEOztBQUVELFFBQUlBLFNBQVMsQ0FBQ2pCLEtBQVYsS0FBb0JrQiwrQkFBeEIsRUFBeUM7QUFDdkMsYUFBTyw2QkFBQyx3QkFBRDtBQUFpQixRQUFBLE9BQU8sRUFBRSxLQUFLQztBQUEvQixRQUFQO0FBQ0Q7O0FBRUQsUUFBSUYsU0FBUyxDQUFDakIsS0FBVixLQUFvQm9CLDRCQUF4QixFQUFzQztBQUNwQyxhQUNFLDZCQUFDLHdCQUFEO0FBQWlCLFFBQUEsT0FBTyxFQUFFLEtBQUtEO0FBQS9CLFNBQ0UsNklBREYsQ0FERjtBQU9EOztBQUVELFdBQ0UsNkJBQUMscUJBQUQ7QUFBYyxNQUFBLEtBQUssRUFBRSxLQUFLdEIsS0FBTCxDQUFXVSxVQUFoQztBQUE0QyxNQUFBLFNBQVMsRUFBRSxLQUFLRDtBQUE1RCxPQUNHZSxRQUFRLElBQUksS0FBS0Msd0JBQUwsQ0FBOEJELFFBQTlCLEVBQXdDSixTQUFTLENBQUNqQixLQUFsRCxDQURmLENBREY7QUFLRDs7QUFFRHNCLEVBQUFBLHdCQUF3QixDQUFDRCxRQUFELEVBQVdyQixLQUFYLEVBQWtCO0FBQ3hDLFFBQUksQ0FBQ3FCLFFBQUwsRUFBZTtBQUNiLGFBQU8sNkJBQUMsb0JBQUQsT0FBUDtBQUNEOztBQUVELFVBQU1FLFdBQVcsR0FBR0Msa0NBQXlCQyxxQkFBekIsQ0FBK0MsS0FBSzVCLEtBQUwsQ0FBV0ssUUFBMUQsRUFBb0VGLEtBQXBFLENBQXBCOztBQUNBLFVBQU0wQixLQUFLO0FBQUE7O0FBQUE7QUFBQTtBQUFBOztBQUFBO0FBQUEsTUFBWDs7QUE4QkEsVUFBTUMsU0FBUyxHQUFHO0FBQ2hCQyxNQUFBQSxTQUFTLEVBQUUsS0FBSy9CLEtBQUwsQ0FBV2dDLEtBRE47QUFFaEJDLE1BQUFBLFFBQVEsRUFBRSxLQUFLakMsS0FBTCxDQUFXa0MsSUFGTDtBQUdoQkMsTUFBQUEsY0FBYyxFQUFFLEtBQUtuQyxLQUFMLENBQVdtQyxjQUhYO0FBSWhCQyxNQUFBQSxhQUFhLEVBQUVDLGtCQUpDO0FBS2hCQyxNQUFBQSxjQUFjLEVBQUUsSUFMQTtBQU1oQkMsTUFBQUEsV0FBVyxFQUFFRixrQkFORztBQU9oQkcsTUFBQUEsWUFBWSxFQUFFLElBUEU7QUFRaEJDLE1BQUFBLFdBQVcsRUFBRUosa0JBUkc7QUFTaEJLLE1BQUFBLFlBQVksRUFBRSxJQVRFO0FBVWhCQyxNQUFBQSxZQUFZLEVBQUVOLGtCQVZFO0FBV2hCTyxNQUFBQSxhQUFhLEVBQUU7QUFYQyxLQUFsQjtBQWNBLFdBQ0UsNkJBQUMseUJBQUQsQ0FBa0IsUUFBbEI7QUFBMkIsTUFBQSxLQUFLLEVBQUVsQjtBQUFsQyxPQUNFLDZCQUFDLHlCQUFEO0FBQ0UsTUFBQSxXQUFXLEVBQUVBLFdBRGY7QUFFRSxNQUFBLEtBQUssRUFBRUcsS0FGVDtBQUdFLE1BQUEsU0FBUyxFQUFFQyxTQUhiO0FBSUUsTUFBQSxNQUFNLEVBQUVlLFdBQVcsSUFBSSxLQUFLQyxnQkFBTCxDQUFzQkQsV0FBdEIsRUFBbUNyQixRQUFuQyxFQUE2Q3JCLEtBQTdDO0FBSnpCLE1BREYsQ0FERjtBQVVEOztBQUVEMkMsRUFBQUEsZ0JBQWdCLENBQUM7QUFBQ0MsSUFBQUEsS0FBRDtBQUFRL0MsSUFBQUEsS0FBUjtBQUFlZ0QsSUFBQUE7QUFBZixHQUFELEVBQXdCeEIsUUFBeEIsRUFBa0NyQixLQUFsQyxFQUF5QztBQUN2RCxRQUFJNEMsS0FBSixFQUFXO0FBQ1QsYUFDRSw2QkFBQyx1QkFBRDtBQUNFLFFBQUEsS0FBSyxFQUFFQSxLQURUO0FBRUUsUUFBQSxLQUFLLEVBQUUsS0FBS3pCLFdBRmQ7QUFHRSxRQUFBLEtBQUssRUFBRTBCLEtBSFQ7QUFJRSxRQUFBLE1BQU0sRUFBRSxLQUFLQztBQUpmLFFBREY7QUFRRDs7QUFFRCxRQUFJLENBQUNqRCxLQUFMLEVBQVk7QUFDVixhQUFPLDZCQUFDLG9CQUFELE9BQVA7QUFDRDs7QUFFRCxVQUFNO0FBQUNVLE1BQUFBO0FBQUQsUUFBZSxLQUFLVixLQUExQjtBQUVBLFdBQ0UsNkJBQUMsaUNBQUQsZUFDTUEsS0FETixFQUVNd0IsUUFGTjtBQUdFLE1BQUEsZUFBZSxFQUFFLEtBQUt4QixLQUFMLENBQVdVLFVBSDlCO0FBSUUsTUFBQSxjQUFjLEVBQUUsS0FBS1YsS0FBTCxDQUFXbUMsY0FKN0I7QUFLRSxNQUFBLEtBQUssRUFBRXpCLFVBQVUsQ0FBQ3dDLEtBQVgsQ0FBaUJDLElBQWpCLENBQXNCekMsVUFBdEIsQ0FMVDtBQU1FLE1BQUEsUUFBUSxFQUFFQSxVQUFVLENBQUMwQyxRQUFYLENBQW9CRCxJQUFwQixDQUF5QnpDLFVBQXpCLENBTlo7QUFPRSxNQUFBLElBQUksRUFBRUEsVUFBVSxDQUFDMkMsSUFBWCxDQUFnQkYsSUFBaEIsQ0FBcUJ6QyxVQUFyQixDQVBSO0FBUUUsTUFBQSxTQUFTLEVBQUVBLFVBQVUsQ0FBQzRDLFNBQVgsQ0FBcUJILElBQXJCLENBQTBCekMsVUFBMUIsQ0FSYjtBQVNFLE1BQUEsYUFBYSxFQUFFLEtBQUtWLEtBQUwsQ0FBV3VELGFBVDVCO0FBVUUsTUFBQSxnQkFBZ0IsRUFBRSxLQUFLdkQsS0FBTCxDQUFXd0QsZ0JBVi9CO0FBV0UsTUFBQSxXQUFXLEVBQUU5QyxVQUFVLENBQUMrQyx1QkFBWCxFQVhmO0FBYUUsTUFBQSxRQUFRLEVBQUUsS0FBS3pELEtBQUwsQ0FBV0ssUUFidkI7QUFjRSxNQUFBLEtBQUssRUFBRUYsS0FkVDtBQWdCRSxNQUFBLFNBQVMsRUFBRSxLQUFLSCxLQUFMLENBQVcwRCxTQWhCeEI7QUFpQkUsTUFBQSxRQUFRLEVBQUUsS0FBSzFELEtBQUwsQ0FBVzJELFFBakJ2QjtBQWtCRSxNQUFBLE9BQU8sRUFBRSxLQUFLM0QsS0FBTCxDQUFXNEQsT0FsQnRCO0FBbUJFLE1BQUEsUUFBUSxFQUFFLEtBQUs1RCxLQUFMLENBQVc2RCxRQW5CdkI7QUFvQkUsTUFBQSxNQUFNLEVBQUUsS0FBSzdELEtBQUwsQ0FBVzhELE1BcEJyQjtBQXNCRSxNQUFBLFFBQVEsRUFBRSxLQUFLOUQsS0FBTCxDQUFXK0QsUUF0QnZCO0FBdUJFLE1BQUEsT0FBTyxFQUFFLEtBQUsvRCxLQUFMLENBQVdnRSxPQXZCdEI7QUF3QkUsTUFBQSxTQUFTLEVBQUUsS0FBS2hFLEtBQUwsQ0FBV2lFO0FBeEJ4QixPQURGO0FBNEJEOztBQUVEM0MsRUFBQUEsV0FBVyxDQUFDbkIsS0FBRCxFQUFRO0FBQ2pCLFdBQU8sS0FBS0gsS0FBTCxDQUFXRSxVQUFYLENBQXNCZ0UsUUFBdEIsQ0FBK0IsS0FBS2xFLEtBQUwsQ0FBV0ssUUFBWCxDQUFvQkMsZUFBcEIsRUFBL0IsRUFBc0VILEtBQXRFLENBQVA7QUFDRDs7QUFFRDhDLEVBQUFBLFlBQVksR0FBRztBQUNiLFdBQU8sS0FBS2pELEtBQUwsQ0FBV0UsVUFBWCxDQUFzQmlFLFdBQXRCLENBQWtDLEtBQUtuRSxLQUFMLENBQVdLLFFBQVgsQ0FBb0JDLGVBQXBCLEVBQWxDLENBQVA7QUFDRDs7QUFqTmtFOzs7O2dCQUFoRFYsdUIsZUFDQTtBQUNqQjtBQUNBUyxFQUFBQSxRQUFRLEVBQUUrRCw2QkFBaUJDLFVBRlY7QUFJakI7QUFDQXJDLEVBQUFBLEtBQUssRUFBRXNDLG1CQUFVQyxNQUFWLENBQWlCRixVQUxQO0FBTWpCbkMsRUFBQUEsSUFBSSxFQUFFb0MsbUJBQVVDLE1BQVYsQ0FBaUJGLFVBTk47QUFPakJsQyxFQUFBQSxjQUFjLEVBQUVtQyxtQkFBVUUsTUFBVixDQUFpQkgsVUFQaEI7QUFTakI7QUFDQTNELEVBQUFBLFVBQVUsRUFBRTRELG1CQUFVRyxNQUFWLENBQWlCSixVQVZaO0FBV2pCbkUsRUFBQUEsVUFBVSxFQUFFd0UscUNBQXlCTCxVQVhwQjtBQWFqQjtBQUNBWCxFQUFBQSxTQUFTLEVBQUVZLG1CQUFVRyxNQUFWLENBQWlCSixVQWRYO0FBZWpCVixFQUFBQSxRQUFRLEVBQUVXLG1CQUFVRyxNQUFWLENBQWlCSixVQWZWO0FBZ0JqQlQsRUFBQUEsT0FBTyxFQUFFVSxtQkFBVUcsTUFBVixDQUFpQkosVUFoQlQ7QUFpQmpCUixFQUFBQSxRQUFRLEVBQUVTLG1CQUFVRyxNQUFWLENBQWlCSixVQWpCVjtBQWtCakJQLEVBQUFBLE1BQU0sRUFBRVEsbUJBQVVHLE1BQVYsQ0FBaUJKLFVBbEJSO0FBb0JqQjtBQUNBYixFQUFBQSxnQkFBZ0IsRUFBRWMsbUJBQVVLLElBQVYsQ0FBZU4sVUFyQmhCO0FBc0JqQmQsRUFBQUEsYUFBYSxFQUFFZSxtQkFBVUssSUFBVixDQUFlTixVQXRCYjtBQXVCakJMLEVBQUFBLE9BQU8sRUFBRU0sbUJBQVVLLElBQVYsQ0FBZU4sVUF2QlA7QUF5QmpCO0FBQ0FOLEVBQUFBLFFBQVEsRUFBRWEsNkJBQWlCUCxVQTFCVjtBQTJCakJKLEVBQUFBLFNBQVMsRUFBRVksOEJBQWtCUjtBQTNCWixDIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzYuMS9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCB5dWJpa2lyaSBmcm9tICd5dWJpa2lyaSc7XG5pbXBvcnQge1F1ZXJ5UmVuZGVyZXIsIGdyYXBocWx9IGZyb20gJ3JlYWN0LXJlbGF5JztcblxuaW1wb3J0IHthdXRvYmluZCwgUEFHRV9TSVpFfSBmcm9tICcuLi9oZWxwZXJzJztcbmltcG9ydCBSZWxheU5ldHdvcmtMYXllck1hbmFnZXIgZnJvbSAnLi4vcmVsYXktbmV0d29yay1sYXllci1tYW5hZ2VyJztcbmltcG9ydCB7R2l0aHViTG9naW5Nb2RlbFByb3BUeXBlLCBJdGVtVHlwZVByb3BUeXBlLCBFbmRwb2ludFByb3BUeXBlLCBSZWZIb2xkZXJQcm9wVHlwZX0gZnJvbSAnLi4vcHJvcC10eXBlcyc7XG5pbXBvcnQge1VOQVVUSEVOVElDQVRFRCwgSU5TVUZGSUNJRU5UfSBmcm9tICcuLi9zaGFyZWQva2V5dGFyLXN0cmF0ZWd5JztcbmltcG9ydCBHaXRodWJMb2dpblZpZXcgZnJvbSAnLi4vdmlld3MvZ2l0aHViLWxvZ2luLXZpZXcnO1xuaW1wb3J0IExvYWRpbmdWaWV3IGZyb20gJy4uL3ZpZXdzL2xvYWRpbmctdmlldyc7XG5pbXBvcnQgUXVlcnlFcnJvclZpZXcgZnJvbSAnLi4vdmlld3MvcXVlcnktZXJyb3Itdmlldyc7XG5pbXBvcnQgT2JzZXJ2ZU1vZGVsIGZyb20gJy4uL3ZpZXdzL29ic2VydmUtbW9kZWwnO1xuaW1wb3J0IFJlbGF5RW52aXJvbm1lbnQgZnJvbSAnLi4vdmlld3MvcmVsYXktZW52aXJvbm1lbnQnO1xuaW1wb3J0IElzc3VlaXNoRGV0YWlsQ29udHJvbGxlciBmcm9tICcuLi9jb250cm9sbGVycy9pc3N1ZWlzaC1kZXRhaWwtY29udHJvbGxlcic7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIElzc3VlaXNoRGV0YWlsQ29udGFpbmVyIGV4dGVuZHMgUmVhY3QuQ29tcG9uZW50IHtcbiAgc3RhdGljIHByb3BUeXBlcyA9IHtcbiAgICAvLyBDb25uZWN0aW9uXG4gICAgZW5kcG9pbnQ6IEVuZHBvaW50UHJvcFR5cGUuaXNSZXF1aXJlZCxcblxuICAgIC8vIElzc3VlaXNoIHNlbGVjdGlvbiBjcml0ZXJpYVxuICAgIG93bmVyOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgcmVwbzogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxuICAgIGlzc3VlaXNoTnVtYmVyOiBQcm9wVHlwZXMubnVtYmVyLmlzUmVxdWlyZWQsXG5cbiAgICAvLyBQYWNrYWdlIG1vZGVsc1xuICAgIHJlcG9zaXRvcnk6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgICBsb2dpbk1vZGVsOiBHaXRodWJMb2dpbk1vZGVsUHJvcFR5cGUuaXNSZXF1aXJlZCxcblxuICAgIC8vIEF0b20gZW52aXJvbm1lbnRcbiAgICB3b3Jrc3BhY2U6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgICBjb21tYW5kczogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIGtleW1hcHM6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgICB0b29sdGlwczogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIGNvbmZpZzogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuXG4gICAgLy8gQWN0aW9uIG1ldGhvZHNcbiAgICBzd2l0Y2hUb0lzc3VlaXNoOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgIG9uVGl0bGVDaGFuZ2U6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgZGVzdHJveTogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcblxuICAgIC8vIEl0ZW0gY29udGV4dFxuICAgIGl0ZW1UeXBlOiBJdGVtVHlwZVByb3BUeXBlLmlzUmVxdWlyZWQsXG4gICAgcmVmRWRpdG9yOiBSZWZIb2xkZXJQcm9wVHlwZS5pc1JlcXVpcmVkLFxuICB9XG5cbiAgY29uc3RydWN0b3IocHJvcHMpIHtcbiAgICBzdXBlcihwcm9wcyk7XG4gICAgYXV0b2JpbmQodGhpcyxcbiAgICAgICdmZXRjaFRva2VuJywgJ3JlbmRlcldpdGhUb2tlbicsXG4gICAgICAnZmV0Y2hSZXBvc2l0b3J5RGF0YScsICdyZW5kZXJXaXRoUmVwb3NpdG9yeURhdGEnLFxuICAgICAgJ3JlbmRlcldpdGhSZXN1bHQnLFxuICAgICAgJ2hhbmRsZUxvZ2luJywgJ2hhbmRsZUxvZ291dCcsXG4gICAgKTtcbiAgfVxuXG4gIGZldGNoVG9rZW4obG9naW5Nb2RlbCkge1xuICAgIHJldHVybiB5dWJpa2lyaSh7XG4gICAgICB0b2tlbjogbG9naW5Nb2RlbC5nZXRUb2tlbih0aGlzLnByb3BzLmVuZHBvaW50LmdldExvZ2luQWNjb3VudCgpKSxcbiAgICB9KTtcbiAgfVxuXG4gIHJlbmRlcigpIHtcbiAgICByZXR1cm4gKFxuICAgICAgPE9ic2VydmVNb2RlbCBtb2RlbD17dGhpcy5wcm9wcy5sb2dpbk1vZGVsfSBmZXRjaERhdGE9e3RoaXMuZmV0Y2hUb2tlbn0+XG4gICAgICAgIHt0aGlzLnJlbmRlcldpdGhUb2tlbn1cbiAgICAgIDwvT2JzZXJ2ZU1vZGVsPlxuICAgICk7XG4gIH1cblxuICBmZXRjaFJlcG9zaXRvcnlEYXRhKHJlcG9zaXRvcnkpIHtcbiAgICByZXR1cm4geXViaWtpcmkoe1xuICAgICAgYnJhbmNoZXM6IHJlcG9zaXRvcnkuZ2V0QnJhbmNoZXMoKSxcbiAgICAgIHJlbW90ZXM6IHJlcG9zaXRvcnkuZ2V0UmVtb3RlcygpLFxuICAgICAgaXNNZXJnaW5nOiByZXBvc2l0b3J5LmlzTWVyZ2luZygpLFxuICAgICAgaXNSZWJhc2luZzogcmVwb3NpdG9yeS5pc1JlYmFzaW5nKCksXG4gICAgICBpc0Fic2VudDogcmVwb3NpdG9yeS5pc0Fic2VudCgpLFxuICAgICAgaXNMb2FkaW5nOiByZXBvc2l0b3J5LmlzTG9hZGluZygpLFxuICAgICAgaXNQcmVzZW50OiByZXBvc2l0b3J5LmlzUHJlc2VudCgpLFxuICAgIH0pO1xuICB9XG5cbiAgcmVuZGVyV2l0aFRva2VuKHRva2VuRGF0YSkge1xuICAgIGlmICghdG9rZW5EYXRhKSB7XG4gICAgICByZXR1cm4gPExvYWRpbmdWaWV3IC8+O1xuICAgIH1cblxuICAgIGlmICh0b2tlbkRhdGEudG9rZW4gPT09IFVOQVVUSEVOVElDQVRFRCkge1xuICAgICAgcmV0dXJuIDxHaXRodWJMb2dpblZpZXcgb25Mb2dpbj17dGhpcy5oYW5kbGVMb2dpbn0gLz47XG4gICAgfVxuXG4gICAgaWYgKHRva2VuRGF0YS50b2tlbiA9PT0gSU5TVUZGSUNJRU5UKSB7XG4gICAgICByZXR1cm4gKFxuICAgICAgICA8R2l0aHViTG9naW5WaWV3IG9uTG9naW49e3RoaXMuaGFuZGxlTG9naW59PlxuICAgICAgICAgIDxwPlxuICAgICAgICAgICAgWW91ciB0b2tlbiBubyBsb25nZXIgaGFzIHN1ZmZpY2llbnQgYXV0aG9yaXphdGlvbnMuIFBsZWFzZSByZS1hdXRoZW50aWNhdGUgYW5kIGdlbmVyYXRlIGEgbmV3IG9uZS5cbiAgICAgICAgICA8L3A+XG4gICAgICAgIDwvR2l0aHViTG9naW5WaWV3PlxuICAgICAgKTtcbiAgICB9XG5cbiAgICByZXR1cm4gKFxuICAgICAgPE9ic2VydmVNb2RlbCBtb2RlbD17dGhpcy5wcm9wcy5yZXBvc2l0b3J5fSBmZXRjaERhdGE9e3RoaXMuZmV0Y2hSZXBvc2l0b3J5RGF0YX0+XG4gICAgICAgIHtyZXBvRGF0YSA9PiB0aGlzLnJlbmRlcldpdGhSZXBvc2l0b3J5RGF0YShyZXBvRGF0YSwgdG9rZW5EYXRhLnRva2VuKX1cbiAgICAgIDwvT2JzZXJ2ZU1vZGVsPlxuICAgICk7XG4gIH1cblxuICByZW5kZXJXaXRoUmVwb3NpdG9yeURhdGEocmVwb0RhdGEsIHRva2VuKSB7XG4gICAgaWYgKCFyZXBvRGF0YSkge1xuICAgICAgcmV0dXJuIDxMb2FkaW5nVmlldyAvPjtcbiAgICB9XG5cbiAgICBjb25zdCBlbnZpcm9ubWVudCA9IFJlbGF5TmV0d29ya0xheWVyTWFuYWdlci5nZXRFbnZpcm9ubWVudEZvckhvc3QodGhpcy5wcm9wcy5lbmRwb2ludCwgdG9rZW4pO1xuICAgIGNvbnN0IHF1ZXJ5ID0gZ3JhcGhxbGBcbiAgICAgIHF1ZXJ5IGlzc3VlaXNoRGV0YWlsQ29udGFpbmVyUXVlcnlcbiAgICAgIChcbiAgICAgICAgJHJlcG9Pd25lcjogU3RyaW5nIVxuICAgICAgICAkcmVwb05hbWU6IFN0cmluZyFcbiAgICAgICAgJGlzc3VlaXNoTnVtYmVyOiBJbnQhXG4gICAgICAgICR0aW1lbGluZUNvdW50OiBJbnQhXG4gICAgICAgICR0aW1lbGluZUN1cnNvcjogU3RyaW5nXG4gICAgICAgICRjb21taXRDb3VudDogSW50IVxuICAgICAgICAkY29tbWl0Q3Vyc29yOiBTdHJpbmcsXG4gICAgICAgICRyZXZpZXdDb3VudDogSW50ISxcbiAgICAgICAgJHJldmlld0N1cnNvcjogU3RyaW5nLFxuICAgICAgICAkY29tbWVudENvdW50OiBJbnQhLFxuICAgICAgICAkY29tbWVudEN1cnNvcjogU3RyaW5nLFxuICAgICAgKSB7XG4gICAgICAgIHJlcG9zaXRvcnkob3duZXI6ICRyZXBvT3duZXIsIG5hbWU6ICRyZXBvTmFtZSkge1xuICAgICAgICAgIC4uLmlzc3VlaXNoRGV0YWlsQ29udHJvbGxlcl9yZXBvc2l0b3J5IEBhcmd1bWVudHMoXG4gICAgICAgICAgICBpc3N1ZWlzaE51bWJlcjogJGlzc3VlaXNoTnVtYmVyLFxuICAgICAgICAgICAgdGltZWxpbmVDb3VudDogJHRpbWVsaW5lQ291bnQsXG4gICAgICAgICAgICB0aW1lbGluZUN1cnNvcjogJHRpbWVsaW5lQ3Vyc29yLFxuICAgICAgICAgICAgY29tbWl0Q291bnQ6ICRjb21taXRDb3VudCxcbiAgICAgICAgICAgIGNvbW1pdEN1cnNvcjogJGNvbW1pdEN1cnNvcixcbiAgICAgICAgICAgIHJldmlld0NvdW50OiAkcmV2aWV3Q291bnQsXG4gICAgICAgICAgICByZXZpZXdDdXJzb3I6ICRyZXZpZXdDdXJzb3IsXG4gICAgICAgICAgICBjb21tZW50Q291bnQ6ICRjb21tZW50Q291bnQsXG4gICAgICAgICAgICBjb21tZW50Q3Vyc29yOiAkY29tbWVudEN1cnNvcixcbiAgICAgICAgICApXG4gICAgICAgIH1cbiAgICAgIH1cbiAgICBgO1xuICAgIGNvbnN0IHZhcmlhYmxlcyA9IHtcbiAgICAgIHJlcG9Pd25lcjogdGhpcy5wcm9wcy5vd25lcixcbiAgICAgIHJlcG9OYW1lOiB0aGlzLnByb3BzLnJlcG8sXG4gICAgICBpc3N1ZWlzaE51bWJlcjogdGhpcy5wcm9wcy5pc3N1ZWlzaE51bWJlcixcbiAgICAgIHRpbWVsaW5lQ291bnQ6IFBBR0VfU0laRSxcbiAgICAgIHRpbWVsaW5lQ3Vyc29yOiBudWxsLFxuICAgICAgY29tbWl0Q291bnQ6IFBBR0VfU0laRSxcbiAgICAgIGNvbW1pdEN1cnNvcjogbnVsbCxcbiAgICAgIHJldmlld0NvdW50OiBQQUdFX1NJWkUsXG4gICAgICByZXZpZXdDdXJzb3I6IG51bGwsXG4gICAgICBjb21tZW50Q291bnQ6IFBBR0VfU0laRSxcbiAgICAgIGNvbW1lbnRDdXJzb3I6IG51bGwsXG4gICAgfTtcblxuICAgIHJldHVybiAoXG4gICAgICA8UmVsYXlFbnZpcm9ubWVudC5Qcm92aWRlciB2YWx1ZT17ZW52aXJvbm1lbnR9PlxuICAgICAgICA8UXVlcnlSZW5kZXJlclxuICAgICAgICAgIGVudmlyb25tZW50PXtlbnZpcm9ubWVudH1cbiAgICAgICAgICBxdWVyeT17cXVlcnl9XG4gICAgICAgICAgdmFyaWFibGVzPXt2YXJpYWJsZXN9XG4gICAgICAgICAgcmVuZGVyPXtxdWVyeVJlc3VsdCA9PiB0aGlzLnJlbmRlcldpdGhSZXN1bHQocXVlcnlSZXN1bHQsIHJlcG9EYXRhLCB0b2tlbil9XG4gICAgICAgIC8+XG4gICAgICA8L1JlbGF5RW52aXJvbm1lbnQuUHJvdmlkZXI+XG4gICAgKTtcbiAgfVxuXG4gIHJlbmRlcldpdGhSZXN1bHQoe2Vycm9yLCBwcm9wcywgcmV0cnl9LCByZXBvRGF0YSwgdG9rZW4pIHtcbiAgICBpZiAoZXJyb3IpIHtcbiAgICAgIHJldHVybiAoXG4gICAgICAgIDxRdWVyeUVycm9yVmlld1xuICAgICAgICAgIGVycm9yPXtlcnJvcn1cbiAgICAgICAgICBsb2dpbj17dGhpcy5oYW5kbGVMb2dpbn1cbiAgICAgICAgICByZXRyeT17cmV0cnl9XG4gICAgICAgICAgbG9nb3V0PXt0aGlzLmhhbmRsZUxvZ291dH1cbiAgICAgICAgLz5cbiAgICAgICk7XG4gICAgfVxuXG4gICAgaWYgKCFwcm9wcykge1xuICAgICAgcmV0dXJuIDxMb2FkaW5nVmlldyAvPjtcbiAgICB9XG5cbiAgICBjb25zdCB7cmVwb3NpdG9yeX0gPSB0aGlzLnByb3BzO1xuXG4gICAgcmV0dXJuIChcbiAgICAgIDxJc3N1ZWlzaERldGFpbENvbnRyb2xsZXJcbiAgICAgICAgey4uLnByb3BzfVxuICAgICAgICB7Li4ucmVwb0RhdGF9XG4gICAgICAgIGxvY2FsUmVwb3NpdG9yeT17dGhpcy5wcm9wcy5yZXBvc2l0b3J5fVxuICAgICAgICBpc3N1ZWlzaE51bWJlcj17dGhpcy5wcm9wcy5pc3N1ZWlzaE51bWJlcn1cbiAgICAgICAgZmV0Y2g9e3JlcG9zaXRvcnkuZmV0Y2guYmluZChyZXBvc2l0b3J5KX1cbiAgICAgICAgY2hlY2tvdXQ9e3JlcG9zaXRvcnkuY2hlY2tvdXQuYmluZChyZXBvc2l0b3J5KX1cbiAgICAgICAgcHVsbD17cmVwb3NpdG9yeS5wdWxsLmJpbmQocmVwb3NpdG9yeSl9XG4gICAgICAgIGFkZFJlbW90ZT17cmVwb3NpdG9yeS5hZGRSZW1vdGUuYmluZChyZXBvc2l0b3J5KX1cbiAgICAgICAgb25UaXRsZUNoYW5nZT17dGhpcy5wcm9wcy5vblRpdGxlQ2hhbmdlfVxuICAgICAgICBzd2l0Y2hUb0lzc3VlaXNoPXt0aGlzLnByb3BzLnN3aXRjaFRvSXNzdWVpc2h9XG4gICAgICAgIHdvcmtkaXJQYXRoPXtyZXBvc2l0b3J5LmdldFdvcmtpbmdEaXJlY3RvcnlQYXRoKCl9XG5cbiAgICAgICAgZW5kcG9pbnQ9e3RoaXMucHJvcHMuZW5kcG9pbnR9XG4gICAgICAgIHRva2VuPXt0b2tlbn1cblxuICAgICAgICB3b3Jrc3BhY2U9e3RoaXMucHJvcHMud29ya3NwYWNlfVxuICAgICAgICBjb21tYW5kcz17dGhpcy5wcm9wcy5jb21tYW5kc31cbiAgICAgICAga2V5bWFwcz17dGhpcy5wcm9wcy5rZXltYXBzfVxuICAgICAgICB0b29sdGlwcz17dGhpcy5wcm9wcy50b29sdGlwc31cbiAgICAgICAgY29uZmlnPXt0aGlzLnByb3BzLmNvbmZpZ31cblxuICAgICAgICBpdGVtVHlwZT17dGhpcy5wcm9wcy5pdGVtVHlwZX1cbiAgICAgICAgZGVzdHJveT17dGhpcy5wcm9wcy5kZXN0cm95fVxuICAgICAgICByZWZFZGl0b3I9e3RoaXMucHJvcHMucmVmRWRpdG9yfVxuICAgICAgLz5cbiAgICApO1xuICB9XG5cbiAgaGFuZGxlTG9naW4odG9rZW4pIHtcbiAgICByZXR1cm4gdGhpcy5wcm9wcy5sb2dpbk1vZGVsLnNldFRva2VuKHRoaXMucHJvcHMuZW5kcG9pbnQuZ2V0TG9naW5BY2NvdW50KCksIHRva2VuKTtcbiAgfVxuXG4gIGhhbmRsZUxvZ291dCgpIHtcbiAgICByZXR1cm4gdGhpcy5wcm9wcy5sb2dpbk1vZGVsLnJlbW92ZVRva2VuKHRoaXMucHJvcHMuZW5kcG9pbnQuZ2V0TG9naW5BY2NvdW50KCkpO1xuICB9XG59XG4iXX0=