"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _classnames = _interopRequireDefault(require("classnames"));

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _atomTextEditor = require("./atom-text-editor");

var _marker = require("./marker");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const decorationPropTypes = {
  type: _propTypes.default.oneOf(['line', 'line-number', 'highlight', 'overlay', 'gutter', 'block']).isRequired,
  className: _propTypes.default.string,
  style: _propTypes.default.string,
  onlyHead: _propTypes.default.bool,
  onlyEmpty: _propTypes.default.bool,
  onlyNonEmpty: _propTypes.default.bool,
  omitEmptyLastRow: _propTypes.default.bool,
  position: _propTypes.default.oneOf(['head', 'tail', 'before', 'after']),
  order: _propTypes.default.number,
  avoidOverflow: _propTypes.default.bool,
  gutterName: _propTypes.default.string
};

class BareDecoration extends _react.default.Component {
  constructor(props, context) {
    super(props, context);

    _defineProperty(this, "observeParents", () => {
      this.decorationHolder.map(decoration => decoration.destroy());
      const editorValid = this.props.editorHolder.map(editor => !editor.isDestroyed()).getOr(false);
      const decorableValid = this.props.decorableHolder.map(decorable => !decorable.isDestroyed()).getOr(false); // Ensure the Marker or MarkerLayer corresponds to the context's TextEditor

      const decorableMatches = this.props.decorableHolder.map(decorable => this.props.editorHolder.map(editor => {
        const layer = decorable.layer || decorable;
        const displayLayer = editor.getMarkerLayer(layer.id);

        if (!displayLayer) {
          return false;
        }

        if (displayLayer !== layer && displayLayer.bufferMarkerLayer !== layer) {
          return false;
        }

        return true;
      }).getOr(false)).getOr(false);

      if (!editorValid || !decorableValid || !decorableMatches) {
        return;
      }

      this.createDecoration();
    });

    this.decorationHolder = new _refHolder.default();
    this.editorSub = new _eventKit.Disposable();
    this.decorableSub = new _eventKit.Disposable();
    this.domNode = null;
    this.item = null;

    if (['gutter', 'overlay', 'block'].includes(this.props.type)) {
      this.domNode = document.createElement('div');
      this.domNode.className = (0, _classnames.default)('react-atom-decoration', this.props.className);
    }
  }

  usesItem() {
    return this.domNode !== null;
  }

  componentDidMount() {
    this.editorSub = this.props.editorHolder.observe(this.observeParents);
    this.decorableSub = this.props.decorableHolder.observe(this.observeParents);
  }

  componentDidUpdate(prevProps) {
    if (this.props.editorHolder !== prevProps.editorHolder) {
      this.editorSub.dispose();
      this.editorSub = this.props.editorHolder.observe(this.observeParents);
    }

    if (this.props.decorableHolder !== prevProps.decorableHolder) {
      this.decorableSub.dispose();
      this.decorableSub = this.props.decorableHolder.observe(this.observeParents);
    }

    if (Object.keys(decorationPropTypes).some(key => this.props[key] !== prevProps[key])) {
      this.decorationHolder.map(decoration => decoration.destroy());
      this.createDecoration();
    }
  }

  render() {
    if (this.usesItem()) {
      return _reactDom.default.createPortal(this.props.children, this.domNode);
    } else {
      return null;
    }
  }

  createDecoration() {
    if (this.usesItem() && !this.item) {
      this.item = (0, _helpers.createItem)(this.domNode, this.props.itemHolder);
    }

    const opts = this.getDecorationOpts(this.props);
    const editor = this.props.editorHolder.get();
    const decorable = this.props.decorableHolder.get();
    this.decorationHolder.setter(editor[this.props.decorateMethod](decorable, opts));
  }

  componentWillUnmount() {
    this.decorationHolder.map(decoration => decoration.destroy());
    this.editorSub.dispose();
    this.decorableSub.dispose();
  }

  getDecorationOpts(props) {
    return _objectSpread({}, (0, _helpers.extractProps)(props, decorationPropTypes, {
      className: 'class'
    }), {
      item: this.item
    });
  }

}

_defineProperty(BareDecoration, "propTypes", _objectSpread({
  editorHolder: _propTypes2.RefHolderPropType.isRequired,
  decorableHolder: _propTypes2.RefHolderPropType.isRequired,
  decorateMethod: _propTypes.default.oneOf(['decorateMarker', 'decorateMarkerLayer']),
  itemHolder: _propTypes2.RefHolderPropType,
  children: _propTypes.default.node
}, decorationPropTypes));

_defineProperty(BareDecoration, "defaultProps", {
  decorateMethod: 'decorateMarker'
});

class Decoration extends _react.default.Component {
  constructor(props) {
    super(props);
    this.state = {
      editorHolder: _refHolder.default.on(this.props.editor),
      decorableHolder: _refHolder.default.on(this.props.decorable)
    };
  }

  static getDerivedStateFromProps(props, state) {
    const editorChanged = state.editorHolder.map(editor => editor !== props.editor).getOr(props.editor !== undefined);
    const decorableChanged = state.decorableHolder.map(decorable => decorable !== props.decorable).getOr(props.decorable !== undefined);

    if (!editorChanged && !decorableChanged) {
      return null;
    }

    const nextState = {};

    if (editorChanged) {
      nextState.editorHolder = _refHolder.default.on(props.editor);
    }

    if (decorableChanged) {
      nextState.decorableHolder = _refHolder.default.on(props.decorable);
    }

    return nextState;
  }

  render() {
    if (!this.state.editorHolder.isEmpty() && !this.state.decorableHolder.isEmpty()) {
      return _react.default.createElement(BareDecoration, _extends({}, this.props, {
        editorHolder: this.state.editorHolder,
        decorableHolder: this.state.decorableHolder
      }));
    }

    return _react.default.createElement(_atomTextEditor.TextEditorContext.Consumer, null, editorHolder => _react.default.createElement(_marker.DecorableContext.Consumer, null, ({
      holder,
      decorateMethod
    }) => _react.default.createElement(BareDecoration, _extends({
      editorHolder: editorHolder,
      decorableHolder: holder,
      decorateMethod: decorateMethod
    }, this.props))));
  }

}

exports.default = Decoration;

_defineProperty(Decoration, "propTypes", {
  editor: _propTypes.default.object,
  decorable: _propTypes.default.object
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImRlY29yYXRpb24uanMiXSwibmFtZXMiOlsiZGVjb3JhdGlvblByb3BUeXBlcyIsInR5cGUiLCJQcm9wVHlwZXMiLCJvbmVPZiIsImlzUmVxdWlyZWQiLCJjbGFzc05hbWUiLCJzdHJpbmciLCJzdHlsZSIsIm9ubHlIZWFkIiwiYm9vbCIsIm9ubHlFbXB0eSIsIm9ubHlOb25FbXB0eSIsIm9taXRFbXB0eUxhc3RSb3ciLCJwb3NpdGlvbiIsIm9yZGVyIiwibnVtYmVyIiwiYXZvaWRPdmVyZmxvdyIsImd1dHRlck5hbWUiLCJCYXJlRGVjb3JhdGlvbiIsIlJlYWN0IiwiQ29tcG9uZW50IiwiY29uc3RydWN0b3IiLCJwcm9wcyIsImNvbnRleHQiLCJkZWNvcmF0aW9uSG9sZGVyIiwibWFwIiwiZGVjb3JhdGlvbiIsImRlc3Ryb3kiLCJlZGl0b3JWYWxpZCIsImVkaXRvckhvbGRlciIsImVkaXRvciIsImlzRGVzdHJveWVkIiwiZ2V0T3IiLCJkZWNvcmFibGVWYWxpZCIsImRlY29yYWJsZUhvbGRlciIsImRlY29yYWJsZSIsImRlY29yYWJsZU1hdGNoZXMiLCJsYXllciIsImRpc3BsYXlMYXllciIsImdldE1hcmtlckxheWVyIiwiaWQiLCJidWZmZXJNYXJrZXJMYXllciIsImNyZWF0ZURlY29yYXRpb24iLCJSZWZIb2xkZXIiLCJlZGl0b3JTdWIiLCJEaXNwb3NhYmxlIiwiZGVjb3JhYmxlU3ViIiwiZG9tTm9kZSIsIml0ZW0iLCJpbmNsdWRlcyIsImRvY3VtZW50IiwiY3JlYXRlRWxlbWVudCIsInVzZXNJdGVtIiwiY29tcG9uZW50RGlkTW91bnQiLCJvYnNlcnZlIiwib2JzZXJ2ZVBhcmVudHMiLCJjb21wb25lbnREaWRVcGRhdGUiLCJwcmV2UHJvcHMiLCJkaXNwb3NlIiwiT2JqZWN0Iiwia2V5cyIsInNvbWUiLCJrZXkiLCJyZW5kZXIiLCJSZWFjdERPTSIsImNyZWF0ZVBvcnRhbCIsImNoaWxkcmVuIiwiaXRlbUhvbGRlciIsIm9wdHMiLCJnZXREZWNvcmF0aW9uT3B0cyIsImdldCIsInNldHRlciIsImRlY29yYXRlTWV0aG9kIiwiY29tcG9uZW50V2lsbFVubW91bnQiLCJSZWZIb2xkZXJQcm9wVHlwZSIsIm5vZGUiLCJEZWNvcmF0aW9uIiwic3RhdGUiLCJvbiIsImdldERlcml2ZWRTdGF0ZUZyb21Qcm9wcyIsImVkaXRvckNoYW5nZWQiLCJ1bmRlZmluZWQiLCJkZWNvcmFibGVDaGFuZ2VkIiwibmV4dFN0YXRlIiwiaXNFbXB0eSIsImhvbGRlciIsIm9iamVjdCJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOztBQUVBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOzs7Ozs7Ozs7O0FBRUEsTUFBTUEsbUJBQW1CLEdBQUc7QUFDMUJDLEVBQUFBLElBQUksRUFBRUMsbUJBQVVDLEtBQVYsQ0FBZ0IsQ0FBQyxNQUFELEVBQVMsYUFBVCxFQUF3QixXQUF4QixFQUFxQyxTQUFyQyxFQUFnRCxRQUFoRCxFQUEwRCxPQUExRCxDQUFoQixFQUFvRkMsVUFEaEU7QUFFMUJDLEVBQUFBLFNBQVMsRUFBRUgsbUJBQVVJLE1BRks7QUFHMUJDLEVBQUFBLEtBQUssRUFBRUwsbUJBQVVJLE1BSFM7QUFJMUJFLEVBQUFBLFFBQVEsRUFBRU4sbUJBQVVPLElBSk07QUFLMUJDLEVBQUFBLFNBQVMsRUFBRVIsbUJBQVVPLElBTEs7QUFNMUJFLEVBQUFBLFlBQVksRUFBRVQsbUJBQVVPLElBTkU7QUFPMUJHLEVBQUFBLGdCQUFnQixFQUFFVixtQkFBVU8sSUFQRjtBQVExQkksRUFBQUEsUUFBUSxFQUFFWCxtQkFBVUMsS0FBVixDQUFnQixDQUFDLE1BQUQsRUFBUyxNQUFULEVBQWlCLFFBQWpCLEVBQTJCLE9BQTNCLENBQWhCLENBUmdCO0FBUzFCVyxFQUFBQSxLQUFLLEVBQUVaLG1CQUFVYSxNQVRTO0FBVTFCQyxFQUFBQSxhQUFhLEVBQUVkLG1CQUFVTyxJQVZDO0FBVzFCUSxFQUFBQSxVQUFVLEVBQUVmLG1CQUFVSTtBQVhJLENBQTVCOztBQWNBLE1BQU1ZLGNBQU4sU0FBNkJDLGVBQU1DLFNBQW5DLENBQTZDO0FBYzNDQyxFQUFBQSxXQUFXLENBQUNDLEtBQUQsRUFBUUMsT0FBUixFQUFpQjtBQUMxQixVQUFNRCxLQUFOLEVBQWFDLE9BQWI7O0FBRDBCLDRDQXNEWCxNQUFNO0FBQ3JCLFdBQUtDLGdCQUFMLENBQXNCQyxHQUF0QixDQUEwQkMsVUFBVSxJQUFJQSxVQUFVLENBQUNDLE9BQVgsRUFBeEM7QUFFQSxZQUFNQyxXQUFXLEdBQUcsS0FBS04sS0FBTCxDQUFXTyxZQUFYLENBQXdCSixHQUF4QixDQUE0QkssTUFBTSxJQUFJLENBQUNBLE1BQU0sQ0FBQ0MsV0FBUCxFQUF2QyxFQUE2REMsS0FBN0QsQ0FBbUUsS0FBbkUsQ0FBcEI7QUFDQSxZQUFNQyxjQUFjLEdBQUcsS0FBS1gsS0FBTCxDQUFXWSxlQUFYLENBQTJCVCxHQUEzQixDQUErQlUsU0FBUyxJQUFJLENBQUNBLFNBQVMsQ0FBQ0osV0FBVixFQUE3QyxFQUFzRUMsS0FBdEUsQ0FBNEUsS0FBNUUsQ0FBdkIsQ0FKcUIsQ0FNckI7O0FBQ0EsWUFBTUksZ0JBQWdCLEdBQUcsS0FBS2QsS0FBTCxDQUFXWSxlQUFYLENBQTJCVCxHQUEzQixDQUErQlUsU0FBUyxJQUFJLEtBQUtiLEtBQUwsQ0FBV08sWUFBWCxDQUF3QkosR0FBeEIsQ0FBNEJLLE1BQU0sSUFBSTtBQUN6RyxjQUFNTyxLQUFLLEdBQUdGLFNBQVMsQ0FBQ0UsS0FBVixJQUFtQkYsU0FBakM7QUFDQSxjQUFNRyxZQUFZLEdBQUdSLE1BQU0sQ0FBQ1MsY0FBUCxDQUFzQkYsS0FBSyxDQUFDRyxFQUE1QixDQUFyQjs7QUFDQSxZQUFJLENBQUNGLFlBQUwsRUFBbUI7QUFDakIsaUJBQU8sS0FBUDtBQUNEOztBQUNELFlBQUlBLFlBQVksS0FBS0QsS0FBakIsSUFBMEJDLFlBQVksQ0FBQ0csaUJBQWIsS0FBbUNKLEtBQWpFLEVBQXdFO0FBQ3RFLGlCQUFPLEtBQVA7QUFDRDs7QUFDRCxlQUFPLElBQVA7QUFDRCxPQVZvRSxFQVVsRUwsS0FWa0UsQ0FVNUQsS0FWNEQsQ0FBNUMsRUFVUkEsS0FWUSxDQVVGLEtBVkUsQ0FBekI7O0FBWUEsVUFBSSxDQUFDSixXQUFELElBQWdCLENBQUNLLGNBQWpCLElBQW1DLENBQUNHLGdCQUF4QyxFQUEwRDtBQUN4RDtBQUNEOztBQUVELFdBQUtNLGdCQUFMO0FBQ0QsS0E5RTJCOztBQUcxQixTQUFLbEIsZ0JBQUwsR0FBd0IsSUFBSW1CLGtCQUFKLEVBQXhCO0FBQ0EsU0FBS0MsU0FBTCxHQUFpQixJQUFJQyxvQkFBSixFQUFqQjtBQUNBLFNBQUtDLFlBQUwsR0FBb0IsSUFBSUQsb0JBQUosRUFBcEI7QUFFQSxTQUFLRSxPQUFMLEdBQWUsSUFBZjtBQUNBLFNBQUtDLElBQUwsR0FBWSxJQUFaOztBQUNBLFFBQUksQ0FBQyxRQUFELEVBQVcsU0FBWCxFQUFzQixPQUF0QixFQUErQkMsUUFBL0IsQ0FBd0MsS0FBSzNCLEtBQUwsQ0FBV3JCLElBQW5ELENBQUosRUFBOEQ7QUFDNUQsV0FBSzhDLE9BQUwsR0FBZUcsUUFBUSxDQUFDQyxhQUFULENBQXVCLEtBQXZCLENBQWY7QUFDQSxXQUFLSixPQUFMLENBQWExQyxTQUFiLEdBQXlCLHlCQUFHLHVCQUFILEVBQTRCLEtBQUtpQixLQUFMLENBQVdqQixTQUF2QyxDQUF6QjtBQUNEO0FBQ0Y7O0FBRUQrQyxFQUFBQSxRQUFRLEdBQUc7QUFDVCxXQUFPLEtBQUtMLE9BQUwsS0FBaUIsSUFBeEI7QUFDRDs7QUFFRE0sRUFBQUEsaUJBQWlCLEdBQUc7QUFDbEIsU0FBS1QsU0FBTCxHQUFpQixLQUFLdEIsS0FBTCxDQUFXTyxZQUFYLENBQXdCeUIsT0FBeEIsQ0FBZ0MsS0FBS0MsY0FBckMsQ0FBakI7QUFDQSxTQUFLVCxZQUFMLEdBQW9CLEtBQUt4QixLQUFMLENBQVdZLGVBQVgsQ0FBMkJvQixPQUEzQixDQUFtQyxLQUFLQyxjQUF4QyxDQUFwQjtBQUNEOztBQUVEQyxFQUFBQSxrQkFBa0IsQ0FBQ0MsU0FBRCxFQUFZO0FBQzVCLFFBQUksS0FBS25DLEtBQUwsQ0FBV08sWUFBWCxLQUE0QjRCLFNBQVMsQ0FBQzVCLFlBQTFDLEVBQXdEO0FBQ3RELFdBQUtlLFNBQUwsQ0FBZWMsT0FBZjtBQUNBLFdBQUtkLFNBQUwsR0FBaUIsS0FBS3RCLEtBQUwsQ0FBV08sWUFBWCxDQUF3QnlCLE9BQXhCLENBQWdDLEtBQUtDLGNBQXJDLENBQWpCO0FBQ0Q7O0FBRUQsUUFBSSxLQUFLakMsS0FBTCxDQUFXWSxlQUFYLEtBQStCdUIsU0FBUyxDQUFDdkIsZUFBN0MsRUFBOEQ7QUFDNUQsV0FBS1ksWUFBTCxDQUFrQlksT0FBbEI7QUFDQSxXQUFLWixZQUFMLEdBQW9CLEtBQUt4QixLQUFMLENBQVdZLGVBQVgsQ0FBMkJvQixPQUEzQixDQUFtQyxLQUFLQyxjQUF4QyxDQUFwQjtBQUNEOztBQUVELFFBQ0VJLE1BQU0sQ0FBQ0MsSUFBUCxDQUFZNUQsbUJBQVosRUFBaUM2RCxJQUFqQyxDQUFzQ0MsR0FBRyxJQUFJLEtBQUt4QyxLQUFMLENBQVd3QyxHQUFYLE1BQW9CTCxTQUFTLENBQUNLLEdBQUQsQ0FBMUUsQ0FERixFQUVFO0FBQ0EsV0FBS3RDLGdCQUFMLENBQXNCQyxHQUF0QixDQUEwQkMsVUFBVSxJQUFJQSxVQUFVLENBQUNDLE9BQVgsRUFBeEM7QUFDQSxXQUFLZSxnQkFBTDtBQUNEO0FBQ0Y7O0FBRURxQixFQUFBQSxNQUFNLEdBQUc7QUFDUCxRQUFJLEtBQUtYLFFBQUwsRUFBSixFQUFxQjtBQUNuQixhQUFPWSxrQkFBU0MsWUFBVCxDQUNMLEtBQUszQyxLQUFMLENBQVc0QyxRQUROLEVBRUwsS0FBS25CLE9BRkEsQ0FBUDtBQUlELEtBTEQsTUFLTztBQUNMLGFBQU8sSUFBUDtBQUNEO0FBQ0Y7O0FBNEJETCxFQUFBQSxnQkFBZ0IsR0FBRztBQUNqQixRQUFJLEtBQUtVLFFBQUwsTUFBbUIsQ0FBQyxLQUFLSixJQUE3QixFQUFtQztBQUNqQyxXQUFLQSxJQUFMLEdBQVkseUJBQVcsS0FBS0QsT0FBaEIsRUFBeUIsS0FBS3pCLEtBQUwsQ0FBVzZDLFVBQXBDLENBQVo7QUFDRDs7QUFFRCxVQUFNQyxJQUFJLEdBQUcsS0FBS0MsaUJBQUwsQ0FBdUIsS0FBSy9DLEtBQTVCLENBQWI7QUFDQSxVQUFNUSxNQUFNLEdBQUcsS0FBS1IsS0FBTCxDQUFXTyxZQUFYLENBQXdCeUMsR0FBeEIsRUFBZjtBQUNBLFVBQU1uQyxTQUFTLEdBQUcsS0FBS2IsS0FBTCxDQUFXWSxlQUFYLENBQTJCb0MsR0FBM0IsRUFBbEI7QUFFQSxTQUFLOUMsZ0JBQUwsQ0FBc0IrQyxNQUF0QixDQUNFekMsTUFBTSxDQUFDLEtBQUtSLEtBQUwsQ0FBV2tELGNBQVosQ0FBTixDQUFrQ3JDLFNBQWxDLEVBQTZDaUMsSUFBN0MsQ0FERjtBQUdEOztBQUVESyxFQUFBQSxvQkFBb0IsR0FBRztBQUNyQixTQUFLakQsZ0JBQUwsQ0FBc0JDLEdBQXRCLENBQTBCQyxVQUFVLElBQUlBLFVBQVUsQ0FBQ0MsT0FBWCxFQUF4QztBQUNBLFNBQUtpQixTQUFMLENBQWVjLE9BQWY7QUFDQSxTQUFLWixZQUFMLENBQWtCWSxPQUFsQjtBQUNEOztBQUVEVyxFQUFBQSxpQkFBaUIsQ0FBQy9DLEtBQUQsRUFBUTtBQUN2Qiw2QkFDSywyQkFBYUEsS0FBYixFQUFvQnRCLG1CQUFwQixFQUF5QztBQUFDSyxNQUFBQSxTQUFTLEVBQUU7QUFBWixLQUF6QyxDQURMO0FBRUUyQyxNQUFBQSxJQUFJLEVBQUUsS0FBS0E7QUFGYjtBQUlEOztBQXZIMEM7O2dCQUF2QzlCLGM7QUFFRlcsRUFBQUEsWUFBWSxFQUFFNkMsOEJBQWtCdEUsVTtBQUNoQzhCLEVBQUFBLGVBQWUsRUFBRXdDLDhCQUFrQnRFLFU7QUFDbkNvRSxFQUFBQSxjQUFjLEVBQUV0RSxtQkFBVUMsS0FBVixDQUFnQixDQUFDLGdCQUFELEVBQW1CLHFCQUFuQixDQUFoQixDO0FBQ2hCZ0UsRUFBQUEsVUFBVSxFQUFFTyw2QjtBQUNaUixFQUFBQSxRQUFRLEVBQUVoRSxtQkFBVXlFO0dBQ2pCM0UsbUI7O2dCQVBEa0IsYyxrQkFVa0I7QUFDcEJzRCxFQUFBQSxjQUFjLEVBQUU7QUFESSxDOztBQWdIVCxNQUFNSSxVQUFOLFNBQXlCekQsZUFBTUMsU0FBL0IsQ0FBeUM7QUFNdERDLEVBQUFBLFdBQVcsQ0FBQ0MsS0FBRCxFQUFRO0FBQ2pCLFVBQU1BLEtBQU47QUFFQSxTQUFLdUQsS0FBTCxHQUFhO0FBQ1hoRCxNQUFBQSxZQUFZLEVBQUVjLG1CQUFVbUMsRUFBVixDQUFhLEtBQUt4RCxLQUFMLENBQVdRLE1BQXhCLENBREg7QUFFWEksTUFBQUEsZUFBZSxFQUFFUyxtQkFBVW1DLEVBQVYsQ0FBYSxLQUFLeEQsS0FBTCxDQUFXYSxTQUF4QjtBQUZOLEtBQWI7QUFJRDs7QUFFRCxTQUFPNEMsd0JBQVAsQ0FBZ0N6RCxLQUFoQyxFQUF1Q3VELEtBQXZDLEVBQThDO0FBQzVDLFVBQU1HLGFBQWEsR0FBR0gsS0FBSyxDQUFDaEQsWUFBTixDQUNuQkosR0FEbUIsQ0FDZkssTUFBTSxJQUFJQSxNQUFNLEtBQUtSLEtBQUssQ0FBQ1EsTUFEWixFQUVuQkUsS0FGbUIsQ0FFYlYsS0FBSyxDQUFDUSxNQUFOLEtBQWlCbUQsU0FGSixDQUF0QjtBQUdBLFVBQU1DLGdCQUFnQixHQUFHTCxLQUFLLENBQUMzQyxlQUFOLENBQ3RCVCxHQURzQixDQUNsQlUsU0FBUyxJQUFJQSxTQUFTLEtBQUtiLEtBQUssQ0FBQ2EsU0FEZixFQUV0QkgsS0FGc0IsQ0FFaEJWLEtBQUssQ0FBQ2EsU0FBTixLQUFvQjhDLFNBRkosQ0FBekI7O0FBSUEsUUFBSSxDQUFDRCxhQUFELElBQWtCLENBQUNFLGdCQUF2QixFQUF5QztBQUN2QyxhQUFPLElBQVA7QUFDRDs7QUFFRCxVQUFNQyxTQUFTLEdBQUcsRUFBbEI7O0FBQ0EsUUFBSUgsYUFBSixFQUFtQjtBQUNqQkcsTUFBQUEsU0FBUyxDQUFDdEQsWUFBVixHQUF5QmMsbUJBQVVtQyxFQUFWLENBQWF4RCxLQUFLLENBQUNRLE1BQW5CLENBQXpCO0FBQ0Q7O0FBQ0QsUUFBSW9ELGdCQUFKLEVBQXNCO0FBQ3BCQyxNQUFBQSxTQUFTLENBQUNqRCxlQUFWLEdBQTRCUyxtQkFBVW1DLEVBQVYsQ0FBYXhELEtBQUssQ0FBQ2EsU0FBbkIsQ0FBNUI7QUFDRDs7QUFDRCxXQUFPZ0QsU0FBUDtBQUNEOztBQUVEcEIsRUFBQUEsTUFBTSxHQUFHO0FBQ1AsUUFBSSxDQUFDLEtBQUtjLEtBQUwsQ0FBV2hELFlBQVgsQ0FBd0J1RCxPQUF4QixFQUFELElBQXNDLENBQUMsS0FBS1AsS0FBTCxDQUFXM0MsZUFBWCxDQUEyQmtELE9BQTNCLEVBQTNDLEVBQWlGO0FBQy9FLGFBQ0UsNkJBQUMsY0FBRCxlQUNNLEtBQUs5RCxLQURYO0FBRUUsUUFBQSxZQUFZLEVBQUUsS0FBS3VELEtBQUwsQ0FBV2hELFlBRjNCO0FBR0UsUUFBQSxlQUFlLEVBQUUsS0FBS2dELEtBQUwsQ0FBVzNDO0FBSDlCLFNBREY7QUFPRDs7QUFFRCxXQUNFLDZCQUFDLGlDQUFELENBQW1CLFFBQW5CLFFBQ0dMLFlBQVksSUFDWCw2QkFBQyx3QkFBRCxDQUFrQixRQUFsQixRQUNHLENBQUM7QUFBQ3dELE1BQUFBLE1BQUQ7QUFBU2IsTUFBQUE7QUFBVCxLQUFELEtBQ0MsNkJBQUMsY0FBRDtBQUNFLE1BQUEsWUFBWSxFQUFFM0MsWUFEaEI7QUFFRSxNQUFBLGVBQWUsRUFBRXdELE1BRm5CO0FBR0UsTUFBQSxjQUFjLEVBQUViO0FBSGxCLE9BSU0sS0FBS2xELEtBSlgsRUFGSixDQUZKLENBREY7QUFnQkQ7O0FBaEVxRDs7OztnQkFBbkNzRCxVLGVBQ0E7QUFDakI5QyxFQUFBQSxNQUFNLEVBQUU1QixtQkFBVW9GLE1BREQ7QUFFakJuRCxFQUFBQSxTQUFTLEVBQUVqQyxtQkFBVW9GO0FBRkosQyIsInNvdXJjZVJvb3QiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS0xLjM2LjEvb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0IGZyb20gJ3JlYWN0JztcbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCB7RGlzcG9zYWJsZX0gZnJvbSAnZXZlbnQta2l0JztcbmltcG9ydCBjeCBmcm9tICdjbGFzc25hbWVzJztcblxuaW1wb3J0IHtjcmVhdGVJdGVtLCBleHRyYWN0UHJvcHN9IGZyb20gJy4uL2hlbHBlcnMnO1xuaW1wb3J0IHtSZWZIb2xkZXJQcm9wVHlwZX0gZnJvbSAnLi4vcHJvcC10eXBlcyc7XG5pbXBvcnQge1RleHRFZGl0b3JDb250ZXh0fSBmcm9tICcuL2F0b20tdGV4dC1lZGl0b3InO1xuaW1wb3J0IHtEZWNvcmFibGVDb250ZXh0fSBmcm9tICcuL21hcmtlcic7XG5pbXBvcnQgUmVmSG9sZGVyIGZyb20gJy4uL21vZGVscy9yZWYtaG9sZGVyJztcblxuY29uc3QgZGVjb3JhdGlvblByb3BUeXBlcyA9IHtcbiAgdHlwZTogUHJvcFR5cGVzLm9uZU9mKFsnbGluZScsICdsaW5lLW51bWJlcicsICdoaWdobGlnaHQnLCAnb3ZlcmxheScsICdndXR0ZXInLCAnYmxvY2snXSkuaXNSZXF1aXJlZCxcbiAgY2xhc3NOYW1lOiBQcm9wVHlwZXMuc3RyaW5nLFxuICBzdHlsZTogUHJvcFR5cGVzLnN0cmluZyxcbiAgb25seUhlYWQ6IFByb3BUeXBlcy5ib29sLFxuICBvbmx5RW1wdHk6IFByb3BUeXBlcy5ib29sLFxuICBvbmx5Tm9uRW1wdHk6IFByb3BUeXBlcy5ib29sLFxuICBvbWl0RW1wdHlMYXN0Um93OiBQcm9wVHlwZXMuYm9vbCxcbiAgcG9zaXRpb246IFByb3BUeXBlcy5vbmVPZihbJ2hlYWQnLCAndGFpbCcsICdiZWZvcmUnLCAnYWZ0ZXInXSksXG4gIG9yZGVyOiBQcm9wVHlwZXMubnVtYmVyLFxuICBhdm9pZE92ZXJmbG93OiBQcm9wVHlwZXMuYm9vbCxcbiAgZ3V0dGVyTmFtZTogUHJvcFR5cGVzLnN0cmluZyxcbn07XG5cbmNsYXNzIEJhcmVEZWNvcmF0aW9uIGV4dGVuZHMgUmVhY3QuQ29tcG9uZW50IHtcbiAgc3RhdGljIHByb3BUeXBlcyA9IHtcbiAgICBlZGl0b3JIb2xkZXI6IFJlZkhvbGRlclByb3BUeXBlLmlzUmVxdWlyZWQsXG4gICAgZGVjb3JhYmxlSG9sZGVyOiBSZWZIb2xkZXJQcm9wVHlwZS5pc1JlcXVpcmVkLFxuICAgIGRlY29yYXRlTWV0aG9kOiBQcm9wVHlwZXMub25lT2YoWydkZWNvcmF0ZU1hcmtlcicsICdkZWNvcmF0ZU1hcmtlckxheWVyJ10pLFxuICAgIGl0ZW1Ib2xkZXI6IFJlZkhvbGRlclByb3BUeXBlLFxuICAgIGNoaWxkcmVuOiBQcm9wVHlwZXMubm9kZSxcbiAgICAuLi5kZWNvcmF0aW9uUHJvcFR5cGVzLFxuICB9XG5cbiAgc3RhdGljIGRlZmF1bHRQcm9wcyA9IHtcbiAgICBkZWNvcmF0ZU1ldGhvZDogJ2RlY29yYXRlTWFya2VyJyxcbiAgfVxuXG4gIGNvbnN0cnVjdG9yKHByb3BzLCBjb250ZXh0KSB7XG4gICAgc3VwZXIocHJvcHMsIGNvbnRleHQpO1xuXG4gICAgdGhpcy5kZWNvcmF0aW9uSG9sZGVyID0gbmV3IFJlZkhvbGRlcigpO1xuICAgIHRoaXMuZWRpdG9yU3ViID0gbmV3IERpc3Bvc2FibGUoKTtcbiAgICB0aGlzLmRlY29yYWJsZVN1YiA9IG5ldyBEaXNwb3NhYmxlKCk7XG5cbiAgICB0aGlzLmRvbU5vZGUgPSBudWxsO1xuICAgIHRoaXMuaXRlbSA9IG51bGw7XG4gICAgaWYgKFsnZ3V0dGVyJywgJ292ZXJsYXknLCAnYmxvY2snXS5pbmNsdWRlcyh0aGlzLnByb3BzLnR5cGUpKSB7XG4gICAgICB0aGlzLmRvbU5vZGUgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKTtcbiAgICAgIHRoaXMuZG9tTm9kZS5jbGFzc05hbWUgPSBjeCgncmVhY3QtYXRvbS1kZWNvcmF0aW9uJywgdGhpcy5wcm9wcy5jbGFzc05hbWUpO1xuICAgIH1cbiAgfVxuXG4gIHVzZXNJdGVtKCkge1xuICAgIHJldHVybiB0aGlzLmRvbU5vZGUgIT09IG51bGw7XG4gIH1cblxuICBjb21wb25lbnREaWRNb3VudCgpIHtcbiAgICB0aGlzLmVkaXRvclN1YiA9IHRoaXMucHJvcHMuZWRpdG9ySG9sZGVyLm9ic2VydmUodGhpcy5vYnNlcnZlUGFyZW50cyk7XG4gICAgdGhpcy5kZWNvcmFibGVTdWIgPSB0aGlzLnByb3BzLmRlY29yYWJsZUhvbGRlci5vYnNlcnZlKHRoaXMub2JzZXJ2ZVBhcmVudHMpO1xuICB9XG5cbiAgY29tcG9uZW50RGlkVXBkYXRlKHByZXZQcm9wcykge1xuICAgIGlmICh0aGlzLnByb3BzLmVkaXRvckhvbGRlciAhPT0gcHJldlByb3BzLmVkaXRvckhvbGRlcikge1xuICAgICAgdGhpcy5lZGl0b3JTdWIuZGlzcG9zZSgpO1xuICAgICAgdGhpcy5lZGl0b3JTdWIgPSB0aGlzLnByb3BzLmVkaXRvckhvbGRlci5vYnNlcnZlKHRoaXMub2JzZXJ2ZVBhcmVudHMpO1xuICAgIH1cblxuICAgIGlmICh0aGlzLnByb3BzLmRlY29yYWJsZUhvbGRlciAhPT0gcHJldlByb3BzLmRlY29yYWJsZUhvbGRlcikge1xuICAgICAgdGhpcy5kZWNvcmFibGVTdWIuZGlzcG9zZSgpO1xuICAgICAgdGhpcy5kZWNvcmFibGVTdWIgPSB0aGlzLnByb3BzLmRlY29yYWJsZUhvbGRlci5vYnNlcnZlKHRoaXMub2JzZXJ2ZVBhcmVudHMpO1xuICAgIH1cblxuICAgIGlmIChcbiAgICAgIE9iamVjdC5rZXlzKGRlY29yYXRpb25Qcm9wVHlwZXMpLnNvbWUoa2V5ID0+IHRoaXMucHJvcHNba2V5XSAhPT0gcHJldlByb3BzW2tleV0pXG4gICAgKSB7XG4gICAgICB0aGlzLmRlY29yYXRpb25Ib2xkZXIubWFwKGRlY29yYXRpb24gPT4gZGVjb3JhdGlvbi5kZXN0cm95KCkpO1xuICAgICAgdGhpcy5jcmVhdGVEZWNvcmF0aW9uKCk7XG4gICAgfVxuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIGlmICh0aGlzLnVzZXNJdGVtKCkpIHtcbiAgICAgIHJldHVybiBSZWFjdERPTS5jcmVhdGVQb3J0YWwoXG4gICAgICAgIHRoaXMucHJvcHMuY2hpbGRyZW4sXG4gICAgICAgIHRoaXMuZG9tTm9kZSxcbiAgICAgICk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiBudWxsO1xuICAgIH1cbiAgfVxuXG4gIG9ic2VydmVQYXJlbnRzID0gKCkgPT4ge1xuICAgIHRoaXMuZGVjb3JhdGlvbkhvbGRlci5tYXAoZGVjb3JhdGlvbiA9PiBkZWNvcmF0aW9uLmRlc3Ryb3koKSk7XG5cbiAgICBjb25zdCBlZGl0b3JWYWxpZCA9IHRoaXMucHJvcHMuZWRpdG9ySG9sZGVyLm1hcChlZGl0b3IgPT4gIWVkaXRvci5pc0Rlc3Ryb3llZCgpKS5nZXRPcihmYWxzZSk7XG4gICAgY29uc3QgZGVjb3JhYmxlVmFsaWQgPSB0aGlzLnByb3BzLmRlY29yYWJsZUhvbGRlci5tYXAoZGVjb3JhYmxlID0+ICFkZWNvcmFibGUuaXNEZXN0cm95ZWQoKSkuZ2V0T3IoZmFsc2UpO1xuXG4gICAgLy8gRW5zdXJlIHRoZSBNYXJrZXIgb3IgTWFya2VyTGF5ZXIgY29ycmVzcG9uZHMgdG8gdGhlIGNvbnRleHQncyBUZXh0RWRpdG9yXG4gICAgY29uc3QgZGVjb3JhYmxlTWF0Y2hlcyA9IHRoaXMucHJvcHMuZGVjb3JhYmxlSG9sZGVyLm1hcChkZWNvcmFibGUgPT4gdGhpcy5wcm9wcy5lZGl0b3JIb2xkZXIubWFwKGVkaXRvciA9PiB7XG4gICAgICBjb25zdCBsYXllciA9IGRlY29yYWJsZS5sYXllciB8fCBkZWNvcmFibGU7XG4gICAgICBjb25zdCBkaXNwbGF5TGF5ZXIgPSBlZGl0b3IuZ2V0TWFya2VyTGF5ZXIobGF5ZXIuaWQpO1xuICAgICAgaWYgKCFkaXNwbGF5TGF5ZXIpIHtcbiAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgfVxuICAgICAgaWYgKGRpc3BsYXlMYXllciAhPT0gbGF5ZXIgJiYgZGlzcGxheUxheWVyLmJ1ZmZlck1hcmtlckxheWVyICE9PSBsYXllcikge1xuICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICB9XG4gICAgICByZXR1cm4gdHJ1ZTtcbiAgICB9KS5nZXRPcihmYWxzZSkpLmdldE9yKGZhbHNlKTtcblxuICAgIGlmICghZWRpdG9yVmFsaWQgfHwgIWRlY29yYWJsZVZhbGlkIHx8ICFkZWNvcmFibGVNYXRjaGVzKSB7XG4gICAgICByZXR1cm47XG4gICAgfVxuXG4gICAgdGhpcy5jcmVhdGVEZWNvcmF0aW9uKCk7XG4gIH1cblxuICBjcmVhdGVEZWNvcmF0aW9uKCkge1xuICAgIGlmICh0aGlzLnVzZXNJdGVtKCkgJiYgIXRoaXMuaXRlbSkge1xuICAgICAgdGhpcy5pdGVtID0gY3JlYXRlSXRlbSh0aGlzLmRvbU5vZGUsIHRoaXMucHJvcHMuaXRlbUhvbGRlcik7XG4gICAgfVxuXG4gICAgY29uc3Qgb3B0cyA9IHRoaXMuZ2V0RGVjb3JhdGlvbk9wdHModGhpcy5wcm9wcyk7XG4gICAgY29uc3QgZWRpdG9yID0gdGhpcy5wcm9wcy5lZGl0b3JIb2xkZXIuZ2V0KCk7XG4gICAgY29uc3QgZGVjb3JhYmxlID0gdGhpcy5wcm9wcy5kZWNvcmFibGVIb2xkZXIuZ2V0KCk7XG5cbiAgICB0aGlzLmRlY29yYXRpb25Ib2xkZXIuc2V0dGVyKFxuICAgICAgZWRpdG9yW3RoaXMucHJvcHMuZGVjb3JhdGVNZXRob2RdKGRlY29yYWJsZSwgb3B0cyksXG4gICAgKTtcbiAgfVxuXG4gIGNvbXBvbmVudFdpbGxVbm1vdW50KCkge1xuICAgIHRoaXMuZGVjb3JhdGlvbkhvbGRlci5tYXAoZGVjb3JhdGlvbiA9PiBkZWNvcmF0aW9uLmRlc3Ryb3koKSk7XG4gICAgdGhpcy5lZGl0b3JTdWIuZGlzcG9zZSgpO1xuICAgIHRoaXMuZGVjb3JhYmxlU3ViLmRpc3Bvc2UoKTtcbiAgfVxuXG4gIGdldERlY29yYXRpb25PcHRzKHByb3BzKSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIC4uLmV4dHJhY3RQcm9wcyhwcm9wcywgZGVjb3JhdGlvblByb3BUeXBlcywge2NsYXNzTmFtZTogJ2NsYXNzJ30pLFxuICAgICAgaXRlbTogdGhpcy5pdGVtLFxuICAgIH07XG4gIH1cbn1cblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgRGVjb3JhdGlvbiBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgZWRpdG9yOiBQcm9wVHlwZXMub2JqZWN0LFxuICAgIGRlY29yYWJsZTogUHJvcFR5cGVzLm9iamVjdCxcbiAgfVxuXG4gIGNvbnN0cnVjdG9yKHByb3BzKSB7XG4gICAgc3VwZXIocHJvcHMpO1xuXG4gICAgdGhpcy5zdGF0ZSA9IHtcbiAgICAgIGVkaXRvckhvbGRlcjogUmVmSG9sZGVyLm9uKHRoaXMucHJvcHMuZWRpdG9yKSxcbiAgICAgIGRlY29yYWJsZUhvbGRlcjogUmVmSG9sZGVyLm9uKHRoaXMucHJvcHMuZGVjb3JhYmxlKSxcbiAgICB9O1xuICB9XG5cbiAgc3RhdGljIGdldERlcml2ZWRTdGF0ZUZyb21Qcm9wcyhwcm9wcywgc3RhdGUpIHtcbiAgICBjb25zdCBlZGl0b3JDaGFuZ2VkID0gc3RhdGUuZWRpdG9ySG9sZGVyXG4gICAgICAubWFwKGVkaXRvciA9PiBlZGl0b3IgIT09IHByb3BzLmVkaXRvcilcbiAgICAgIC5nZXRPcihwcm9wcy5lZGl0b3IgIT09IHVuZGVmaW5lZCk7XG4gICAgY29uc3QgZGVjb3JhYmxlQ2hhbmdlZCA9IHN0YXRlLmRlY29yYWJsZUhvbGRlclxuICAgICAgLm1hcChkZWNvcmFibGUgPT4gZGVjb3JhYmxlICE9PSBwcm9wcy5kZWNvcmFibGUpXG4gICAgICAuZ2V0T3IocHJvcHMuZGVjb3JhYmxlICE9PSB1bmRlZmluZWQpO1xuXG4gICAgaWYgKCFlZGl0b3JDaGFuZ2VkICYmICFkZWNvcmFibGVDaGFuZ2VkKSB7XG4gICAgICByZXR1cm4gbnVsbDtcbiAgICB9XG5cbiAgICBjb25zdCBuZXh0U3RhdGUgPSB7fTtcbiAgICBpZiAoZWRpdG9yQ2hhbmdlZCkge1xuICAgICAgbmV4dFN0YXRlLmVkaXRvckhvbGRlciA9IFJlZkhvbGRlci5vbihwcm9wcy5lZGl0b3IpO1xuICAgIH1cbiAgICBpZiAoZGVjb3JhYmxlQ2hhbmdlZCkge1xuICAgICAgbmV4dFN0YXRlLmRlY29yYWJsZUhvbGRlciA9IFJlZkhvbGRlci5vbihwcm9wcy5kZWNvcmFibGUpO1xuICAgIH1cbiAgICByZXR1cm4gbmV4dFN0YXRlO1xuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIGlmICghdGhpcy5zdGF0ZS5lZGl0b3JIb2xkZXIuaXNFbXB0eSgpICYmICF0aGlzLnN0YXRlLmRlY29yYWJsZUhvbGRlci5pc0VtcHR5KCkpIHtcbiAgICAgIHJldHVybiAoXG4gICAgICAgIDxCYXJlRGVjb3JhdGlvblxuICAgICAgICAgIHsuLi50aGlzLnByb3BzfVxuICAgICAgICAgIGVkaXRvckhvbGRlcj17dGhpcy5zdGF0ZS5lZGl0b3JIb2xkZXJ9XG4gICAgICAgICAgZGVjb3JhYmxlSG9sZGVyPXt0aGlzLnN0YXRlLmRlY29yYWJsZUhvbGRlcn1cbiAgICAgICAgLz5cbiAgICAgICk7XG4gICAgfVxuXG4gICAgcmV0dXJuIChcbiAgICAgIDxUZXh0RWRpdG9yQ29udGV4dC5Db25zdW1lcj5cbiAgICAgICAge2VkaXRvckhvbGRlciA9PiAoXG4gICAgICAgICAgPERlY29yYWJsZUNvbnRleHQuQ29uc3VtZXI+XG4gICAgICAgICAgICB7KHtob2xkZXIsIGRlY29yYXRlTWV0aG9kfSkgPT4gKFxuICAgICAgICAgICAgICA8QmFyZURlY29yYXRpb25cbiAgICAgICAgICAgICAgICBlZGl0b3JIb2xkZXI9e2VkaXRvckhvbGRlcn1cbiAgICAgICAgICAgICAgICBkZWNvcmFibGVIb2xkZXI9e2hvbGRlcn1cbiAgICAgICAgICAgICAgICBkZWNvcmF0ZU1ldGhvZD17ZGVjb3JhdGVNZXRob2R9XG4gICAgICAgICAgICAgICAgey4uLnRoaXMucHJvcHN9XG4gICAgICAgICAgICAgIC8+XG4gICAgICAgICAgICApfVxuICAgICAgICAgIDwvRGVjb3JhYmxlQ29udGV4dC5Db25zdW1lcj5cbiAgICAgICAgKX1cbiAgICAgIDwvVGV4dEVkaXRvckNvbnRleHQuQ29uc3VtZXI+XG4gICAgKTtcbiAgfVxufVxuIl19