"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TextEditorContext = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _atom = require("atom");

var _eventKit = require("event-kit");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _propTypes2 = require("../prop-types");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const editorUpdateProps = {
  mini: _propTypes.default.bool,
  readOnly: _propTypes.default.bool,
  placeholderText: _propTypes.default.string,
  lineNumberGutterVisible: _propTypes.default.bool,
  autoHeight: _propTypes.default.bool,
  autoWidth: _propTypes.default.bool,
  softWrapped: _propTypes.default.bool
};

const editorCreationProps = _objectSpread({
  buffer: _propTypes.default.object
}, editorUpdateProps);

const EMPTY_CLASS = 'github-AtomTextEditor-empty';

const TextEditorContext = _react.default.createContext();

exports.TextEditorContext = TextEditorContext;

class AtomTextEditor extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "observeSelections", selection => {
      const selectionSubs = new _eventKit.CompositeDisposable(selection.onDidChangeRange(this.props.didChangeSelectionRange), selection.onDidDestroy(() => {
        selectionSubs.dispose();
        this.subs.remove(selectionSubs);
        this.props.didDestroySelection(selection);
      }));
      this.subs.add(selectionSubs);
      this.props.didAddSelection(selection);
    });

    _defineProperty(this, "observeEmptiness", () => {
      this.getRefModel().map(editor => {
        if (editor.isEmpty() && this.props.hideEmptiness) {
          this.refElement.map(element => element.classList.add(EMPTY_CLASS));
        } else {
          this.refElement.map(element => element.classList.remove(EMPTY_CLASS));
        }

        return null;
      });
    });

    this.subs = new _eventKit.CompositeDisposable();
    this.refParent = new _refHolder.default();
    this.refElement = new _refHolder.default();
    this.refModel = null;
  }

  render() {
    return _react.default.createElement(_react.Fragment, null, _react.default.createElement("div", {
      className: "github-AtomTextEditor-container",
      ref: this.refParent.setter
    }), _react.default.createElement(TextEditorContext.Provider, {
      value: this.getRefModel()
    }, this.props.children));
  }

  componentDidMount() {
    const modelProps = (0, _helpers.extractProps)(this.props, editorCreationProps);
    this.refParent.map(element => {
      const editor = new _atom.TextEditor(modelProps);
      element.appendChild(editor.getElement());
      this.getRefModel().setter(editor);
      this.refElement.setter(editor.getElement());
      this.subs.add(editor.onDidChangeCursorPosition(this.props.didChangeCursorPosition), editor.observeSelections(this.observeSelections), editor.onDidChange(this.observeEmptiness));

      if (editor.isEmpty() && this.props.hideEmptiness) {
        editor.getElement().classList.add(EMPTY_CLASS);
      }

      return null;
    });
  }

  componentDidUpdate() {
    const modelProps = (0, _helpers.extractProps)(this.props, editorUpdateProps);
    this.getRefModel().map(editor => editor.update(modelProps)); // When you look into the abyss, the abyss also looks into you

    this.observeEmptiness();
  }

  componentWillUnmount() {
    this.getRefModel().map(editor => editor.destroy());
    this.subs.dispose();
  }

  contains(element) {
    return this.refElement.map(e => e.contains(element)).getOr(false);
  }

  focus() {
    this.refElement.map(e => e.focus());
  }

  getRefModel() {
    if (this.props.refModel) {
      return this.props.refModel;
    }

    if (!this.refModel) {
      this.refModel = new _refHolder.default();
    }

    return this.refModel;
  }

  getModel() {
    return this.getRefModel().getOr(undefined);
  }

}

exports.default = AtomTextEditor;

_defineProperty(AtomTextEditor, "propTypes", _objectSpread({}, editorCreationProps, {
  workspace: _propTypes.default.object.isRequired,
  didChangeCursorPosition: _propTypes.default.func,
  didAddSelection: _propTypes.default.func,
  didChangeSelectionRange: _propTypes.default.func,
  didDestroySelection: _propTypes.default.func,
  hideEmptiness: _propTypes.default.bool,
  refModel: _propTypes2.RefHolderPropType,
  children: _propTypes.default.node
}));

_defineProperty(AtomTextEditor, "defaultProps", {
  didChangeCursorPosition: () => {},
  didAddSelection: () => {},
  didChangeSelectionRange: () => {},
  didDestroySelection: () => {},
  hideEmptiness: false
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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