Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _os = require('os');

var _os2 = _interopRequireDefault(_os);

var _stackTrace = require('stack-trace');

var _stackTrace2 = _interopRequireDefault(_stackTrace);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var API_KEY = '7ddca14cb60cbd1cd12d1b252473b076';
var LIB_VERSION = require('../package.json')['version'];
var StackTraceCache = new WeakMap();

var Reporter = (function () {
  function Reporter() {
    var params = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

    _classCallCheck(this, Reporter);

    this.request = params.request || window.fetch;
    this.alwaysReport = params.hasOwnProperty('alwaysReport') ? params.alwaysReport : false;
    this.reportPreviousErrors = params.hasOwnProperty('reportPreviousErrors') ? params.reportPreviousErrors : true;
    this.resourcePath = this.normalizePath(params.resourcePath || process.resourcesPath);
    this.reportedErrors = [];
    this.reportedAssertionFailures = [];
  }

  _createClass(Reporter, [{
    key: 'buildNotificationJSON',
    value: function buildNotificationJSON(error, params) {
      return {
        apiKey: API_KEY,
        notifier: {
          name: 'Atom',
          version: LIB_VERSION,
          url: 'https://www.atom.io'
        },
        events: [{
          payloadVersion: "2",
          exceptions: [this.buildExceptionJSON(error, params.projectRoot)],
          severity: params.severity,
          user: {
            id: params.userId
          },
          app: {
            version: params.appVersion,
            releaseStage: params.releaseStage
          },
          device: {
            osVersion: params.osVersion
          },
          metaData: error.metadata
        }]
      };
    }
  }, {
    key: 'buildExceptionJSON',
    value: function buildExceptionJSON(error, projectRoot) {
      return {
        errorClass: error.constructor.name,
        message: error.message,
        stacktrace: this.buildStackTraceJSON(error, projectRoot)
      };
    }
  }, {
    key: 'buildStackTraceJSON',
    value: function buildStackTraceJSON(error, projectRoot) {
      var _this = this;

      return this.parseStackTrace(error).map(function (callSite) {
        return {
          file: _this.scrubPath(callSite.getFileName()),
          method: callSite.getMethodName() || callSite.getFunctionName() || "none",
          lineNumber: callSite.getLineNumber(),
          columnNumber: callSite.getColumnNumber(),
          inProject: !/node_modules/.test(callSite.getFileName())
        };
      });
    }
  }, {
    key: 'normalizePath',
    value: function normalizePath(pathToNormalize) {
      return pathToNormalize.replace('file:///', '') // Sometimes it's a uri
      .replace(/\\/g, '/'); // Unify path separators across Win/macOS/Linux
    }
  }, {
    key: 'scrubPath',
    value: function scrubPath(pathToScrub) {
      var absolutePath = this.normalizePath(pathToScrub);

      if (this.isBundledFile(absolutePath)) {
        return this.normalizePath(_path2['default'].relative(this.resourcePath, absolutePath));
      } else {
        return absolutePath.replace(this.normalizePath(_fsPlus2['default'].getHomeDirectory()), '~') // Remove users home dir
        .replace(/.*(\/packages\/.*)/, '$1'); // Remove everything before app.asar or packages
      }
    }
  }, {
    key: 'getDefaultNotificationParams',
    value: function getDefaultNotificationParams() {
      return {
        userId: atom.config.get('exception-reporting.userId'),
        appVersion: atom.getVersion(),
        releaseStage: this.getReleaseChannel(atom.getVersion()),
        projectRoot: atom.getLoadSettings().resourcePath,
        osVersion: _os2['default'].platform() + '-' + _os2['default'].arch() + '-' + _os2['default'].release()
      };
    }
  }, {
    key: 'getReleaseChannel',
    value: function getReleaseChannel(version) {
      return version.indexOf('beta') > -1 ? 'beta' : version.indexOf('dev') > -1 ? 'dev' : 'stable';
    }
  }, {
    key: 'performRequest',
    value: function performRequest(json) {
      this.request.call(null, 'https://notify.bugsnag.com', {
        method: 'POST',
        headers: new Headers({ 'Content-Type': 'application/json' }),
        body: JSON.stringify(json)
      });
    }
  }, {
    key: 'shouldReport',
    value: function shouldReport(error) {
      if (this.alwaysReport) return true; // Used in specs
      if (atom.config.get('core.telemetryConsent') !== 'limited') return false;
      if (atom.inDevMode()) return false;

      var topFrame = this.parseStackTrace(error)[0];
      var fileName = topFrame ? topFrame.getFileName() : null;
      return fileName && (this.isBundledFile(fileName) || this.isTeletypeFile(fileName));
    }
  }, {
    key: 'parseStackTrace',
    value: function parseStackTrace(error) {
      var callSites = StackTraceCache.get(error);
      if (callSites) {
        return callSites;
      } else {
        callSites = _stackTrace2['default'].parse(error);
        StackTraceCache.set(error, callSites);
        return callSites;
      }
    }
  }, {
    key: 'requestPrivateMetadataConsent',
    value: function requestPrivateMetadataConsent(error, message, reportFn) {
      var notification = undefined,
          dismissSubscription = undefined;

      function reportWithoutPrivateMetadata() {
        if (dismissSubscription) {
          dismissSubscription.dispose();
        }
        delete error.privateMetadata;
        delete error.privateMetadataDescription;
        reportFn(error);
        if (notification) {
          notification.dismiss();
        }
      }

      function reportWithPrivateMetadata() {
        if (error.metadata == null) {
          error.metadata = {};
        }
        for (var key in error.privateMetadata) {
          var value = error.privateMetadata[key];
          error.metadata[key] = value;
        }
        reportWithoutPrivateMetadata();
      }

      var name = error.privateMetadataRequestName;
      if (name != null) {
        if (localStorage.getItem('private-metadata-request:' + name)) {
          return reportWithoutPrivateMetadata(error);
        } else {
          localStorage.setItem('private-metadata-request:' + name, true);
        }
      }

      notification = atom.notifications.addInfo(message, {
        detail: error.privateMetadataDescription,
        description: "Are you willing to submit this information to a private server for debugging purposes?",
        dismissable: true,
        buttons: [{
          text: "No",
          onDidClick: reportWithoutPrivateMetadata
        }, {
          text: "Yes, Submit for Debugging",
          onDidClick: reportWithPrivateMetadata
        }]
      });

      dismissSubscription = notification.onDidDismiss(reportWithoutPrivateMetadata);
    }
  }, {
    key: 'addPackageMetadata',
    value: function addPackageMetadata(error) {
      var activePackages = atom.packages.getActivePackages();
      var availablePackagePaths = atom.packages.getPackageDirPaths();
      if (activePackages.length > 0) {
        var userPackages = {};
        var bundledPackages = {};
        for (var pack of atom.packages.getActivePackages()) {
          if (availablePackagePaths.includes(_path2['default'].dirname(pack.path))) {
            userPackages[pack.name] = pack.metadata.version;
          } else {
            bundledPackages[pack.name] = pack.metadata.version;
          }
        }

        if (error.metadata == null) {
          error.metadata = {};
        }
        error.metadata.bundledPackages = bundledPackages;
        error.metadata.userPackages = userPackages;
      }
    }
  }, {
    key: 'addPreviousErrorsMetadata',
    value: function addPreviousErrorsMetadata(error) {
      if (!this.reportPreviousErrors) return;
      if (!error.metadata) error.metadata = {};
      error.metadata.previousErrors = this.reportedErrors.map(function (error) {
        return error.message;
      });
      error.metadata.previousAssertionFailures = this.reportedAssertionFailures.map(function (error) {
        return error.message;
      });
    }
  }, {
    key: 'reportUncaughtException',
    value: function reportUncaughtException(error) {
      var _this2 = this;

      if (!this.shouldReport(error)) return;

      this.addPackageMetadata(error);
      this.addPreviousErrorsMetadata(error);

      if (error.privateMetadata != null && error.privateMetadataDescription != null) {
        this.requestPrivateMetadataConsent(error, "The Atom team would like to collect the following information to resolve this error:", function (error) {
          return _this2.reportUncaughtException(error);
        });
        return;
      }

      var params = this.getDefaultNotificationParams();
      params.severity = "error";
      this.performRequest(this.buildNotificationJSON(error, params));
      this.reportedErrors.push(error);
    }
  }, {
    key: 'reportFailedAssertion',
    value: function reportFailedAssertion(error) {
      var _this3 = this;

      if (!this.shouldReport(error)) return;

      this.addPackageMetadata(error);
      this.addPreviousErrorsMetadata(error);

      if (error.privateMetadata != null && error.privateMetadataDescription != null) {
        this.requestPrivateMetadataConsent(error, "The Atom team would like to collect some information to resolve an unexpected condition:", function (error) {
          return _this3.reportFailedAssertion(error);
        });
        return;
      }

      var params = this.getDefaultNotificationParams();
      params.severity = "warning";
      this.performRequest(this.buildNotificationJSON(error, params));
      this.reportedAssertionFailures.push(error);
    }

    // Used in specs
  }, {
    key: 'setRequestFunction',
    value: function setRequestFunction(requestFunction) {
      this.request = requestFunction;
    }
  }, {
    key: 'isBundledFile',
    value: function isBundledFile(fileName) {
      return this.normalizePath(fileName).indexOf(this.resourcePath) === 0;
    }
  }, {
    key: 'isTeletypeFile',
    value: function isTeletypeFile(fileName) {
      var teletypePath = atom.packages.resolvePackagePath('teletype');
      return teletypePath && this.normalizePath(fileName).indexOf(teletypePath) === 0;
    }
  }]);

  return Reporter;
})();

exports['default'] = Reporter;

Reporter.API_KEY = API_KEY;
Reporter.LIB_VERSION = LIB_VERSION;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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